package software.amazon.awscdk.services.lambda;

/**
 * Lambda code from an S3 archive.
 * <p>
 * With option to set KMSKey for encryption.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.kms.*;
 * import software.amazon.awscdk.services.lambda.*;
 * import software.amazon.awscdk.services.s3.*;
 * Bucket bucket;
 * Key key;
 * S3CodeV2 s3CodeV2 = S3CodeV2.Builder.create(bucket, "key")
 *         .objectVersion("objectVersion")
 *         .sourceKMSKey(key)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:42.361Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.S3CodeV2")
public class S3CodeV2 extends software.amazon.awscdk.services.lambda.Code {

    protected S3CodeV2(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected S3CodeV2(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param bucket This parameter is required.
     * @param key This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public S3CodeV2(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.BucketOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(key, "key is required"), options });
    }

    /**
     * @param bucket This parameter is required.
     * @param key This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public S3CodeV2(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String key) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(key, "key is required") });
    }

    /**
     * Called when the lambda or layer is initialized to allow this object to bind to the stack, add resources and have fun.
     * <p>
     * @param _scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.CodeConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.CodeConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required") });
    }

    /**
     * Determines whether this Code is inline code or not.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsInline() {
        return software.amazon.jsii.Kernel.get(this, "isInline", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.S3CodeV2}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lambda.S3CodeV2> {
        /**
         * @return a new instance of {@link Builder}.
         * @param bucket This parameter is required.
         * @param key This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.s3.IBucket bucket, final java.lang.String key) {
            return new Builder(bucket, key);
        }

        private final software.amazon.awscdk.services.s3.IBucket bucket;
        private final java.lang.String key;
        private software.amazon.awscdk.services.lambda.BucketOptions.Builder options;

        private Builder(final software.amazon.awscdk.services.s3.IBucket bucket, final java.lang.String key) {
            this.bucket = bucket;
            this.key = key;
        }

        /**
         * Optional S3 object version.
         * <p>
         * @return {@code this}
         * @param objectVersion Optional S3 object version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectVersion(final java.lang.String objectVersion) {
            this.options().objectVersion(objectVersion);
            return this;
        }

        /**
         * The ARN of the KMS key used to encrypt the handler code.
         * <p>
         * Default: - the default server-side encryption with Amazon S3 managed keys(SSE-S3) key will be used.
         * <p>
         * @return {@code this}
         * @param sourceKmsKey The ARN of the KMS key used to encrypt the handler code. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceKmsKey(final software.amazon.awscdk.services.kms.IKey sourceKmsKey) {
            this.options().sourceKmsKey(sourceKmsKey);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.lambda.S3CodeV2}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lambda.S3CodeV2 build() {
            return new software.amazon.awscdk.services.lambda.S3CodeV2(
                this.bucket,
                this.key,
                this.options != null ? this.options.build() : null
            );
        }

        private software.amazon.awscdk.services.lambda.BucketOptions.Builder options() {
            if (this.options == null) {
                this.options = new software.amazon.awscdk.services.lambda.BucketOptions.Builder();
            }
            return this.options;
        }
    }
}
