package software.amazon.awscdk.services.lambda;

/**
 * The position in the DynamoDB, Kinesis or MSK stream where AWS Lambda should start reading.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.kinesis.*;
 * import software.amazon.awscdk.services.lambda.eventsources.KinesisConsumerEventSource;
 * Function myFunction;
 * Stream stream = new Stream(this, "MyStream");
 * StreamConsumer streamConsumer = StreamConsumer.Builder.create(this, "MyStreamConsumer")
 *         .stream(stream)
 *         .streamConsumerName("MyStreamConsumer")
 *         .build();
 * myFunction.addEventSource(KinesisConsumerEventSource.Builder.create(streamConsumer)
 *         .batchSize(100) // default
 *         .startingPosition(StartingPosition.TRIM_HORIZON)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:42.368Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.StartingPosition")
public enum StartingPosition {
    /**
     * Start reading at the last untrimmed record in the shard in the system, which is the oldest data record in the shard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TRIM_HORIZON,
    /**
     * Start reading just after the most recent record in the shard, so that you always read the most recent data in the shard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LATEST,
    /**
     * Start reading from a position defined by a time stamp.
     * <p>
     * Only supported for Amazon Kinesis streams, otherwise an error will occur.
     * If supplied, <code>startingPositionTimestamp</code> must also be set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AT_TIMESTAMP,
}
