package software.amazon.awscdk.services.lambda.eventsources;

/**
 * (Amazon MSK and self-managed Apache Kafka only) The provisioned mode configuration for the event source.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.eventsources.ManagedKafkaEventSource;
 * // Your MSK cluster arn
 * String clusterArn;
 * Function myFunction;
 * // The Kafka topic you want to subscribe to
 * String topic = "some-cool-topic";
 * myFunction.addEventSource(ManagedKafkaEventSource.Builder.create()
 *         .clusterArn(clusterArn)
 *         .topic(topic)
 *         .startingPosition(StartingPosition.TRIM_HORIZON)
 *         .provisionedPollerConfig(ProvisionedPollerConfig.builder()
 *                 .minimumPollers(1)
 *                 .maximumPollers(3)
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:42.402Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda_event_sources.ProvisionedPollerConfig")
@software.amazon.jsii.Jsii.Proxy(ProvisionedPollerConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ProvisionedPollerConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The maximum number of pollers that can be provisioned.
     * <p>
     * Default: 200
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMaximumPollers();

    /**
     * The minimum number of pollers that should be provisioned.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMinimumPollers();

    /**
     * @return a {@link Builder} of {@link ProvisionedPollerConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ProvisionedPollerConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ProvisionedPollerConfig> {
        java.lang.Number maximumPollers;
        java.lang.Number minimumPollers;

        /**
         * Sets the value of {@link ProvisionedPollerConfig#getMaximumPollers}
         * @param maximumPollers The maximum number of pollers that can be provisioned. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumPollers(java.lang.Number maximumPollers) {
            this.maximumPollers = maximumPollers;
            return this;
        }

        /**
         * Sets the value of {@link ProvisionedPollerConfig#getMinimumPollers}
         * @param minimumPollers The minimum number of pollers that should be provisioned. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimumPollers(java.lang.Number minimumPollers) {
            this.minimumPollers = minimumPollers;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ProvisionedPollerConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ProvisionedPollerConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ProvisionedPollerConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProvisionedPollerConfig {
        private final java.lang.Number maximumPollers;
        private final java.lang.Number minimumPollers;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.maximumPollers = software.amazon.jsii.Kernel.get(this, "maximumPollers", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minimumPollers = software.amazon.jsii.Kernel.get(this, "minimumPollers", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.maximumPollers = java.util.Objects.requireNonNull(builder.maximumPollers, "maximumPollers is required");
            this.minimumPollers = java.util.Objects.requireNonNull(builder.minimumPollers, "minimumPollers is required");
        }

        @Override
        public final java.lang.Number getMaximumPollers() {
            return this.maximumPollers;
        }

        @Override
        public final java.lang.Number getMinimumPollers() {
            return this.minimumPollers;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("maximumPollers", om.valueToTree(this.getMaximumPollers()));
            data.set("minimumPollers", om.valueToTree(this.getMinimumPollers()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda_event_sources.ProvisionedPollerConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ProvisionedPollerConfig.Jsii$Proxy that = (ProvisionedPollerConfig.Jsii$Proxy) o;

            if (!maximumPollers.equals(that.maximumPollers)) return false;
            return this.minimumPollers.equals(that.minimumPollers);
        }

        @Override
        public final int hashCode() {
            int result = this.maximumPollers.hashCode();
            result = 31 * result + (this.minimumPollers.hashCode());
            return result;
        }
    }
}
