package software.amazon.awscdk.services.logs.destinations;

/**
 * Use a Data Firehose delivery stream as the destination for a log subscription.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.logs.destinations.*;
 * import software.amazon.awscdk.services.kinesisfirehose.*;
 * IDeliveryStream deliveryStream;
 * LogGroup logGroup;
 * SubscriptionFilter.Builder.create(this, "Subscription")
 *         .logGroup(logGroup)
 *         .destination(new FirehoseDestination(deliveryStream))
 *         .filterPattern(FilterPattern.allEvents())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:42.725Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs_destinations.FirehoseDestination")
public class FirehoseDestination extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.logs.ILogSubscriptionDestination {

    protected FirehoseDestination(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FirehoseDestination(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param stream The Data Firehose delivery stream to use as destination. This parameter is required.
     * @param props The Data Firehose Destination properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FirehoseDestination(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.IDeliveryStream stream, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.destinations.FirehoseDestinationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(stream, "stream is required"), props });
    }

    /**
     * @param stream The Data Firehose delivery stream to use as destination. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FirehoseDestination(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.IDeliveryStream stream) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(stream, "stream is required") });
    }

    /**
     * Return the properties required to send subscription events to this destination.
     * <p>
     * If necessary, the destination can use the properties of the SubscriptionFilter
     * object itself to configure its permissions to allow the subscription to write
     * to it.
     * <p>
     * The destination may reconfigure its own permissions in response to this
     * function call.
     * <p>
     * @param scope This parameter is required.
     * @param _sourceLogGroup This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.LogSubscriptionDestinationConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.ILogGroup _sourceLogGroup) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.LogSubscriptionDestinationConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(_sourceLogGroup, "_sourceLogGroup is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.logs.destinations.FirehoseDestination}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.logs.destinations.FirehoseDestination> {
        /**
         * @return a new instance of {@link Builder}.
         * @param stream The Data Firehose delivery stream to use as destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.kinesisfirehose.IDeliveryStream stream) {
            return new Builder(stream);
        }

        private final software.amazon.awscdk.services.kinesisfirehose.IDeliveryStream stream;
        private software.amazon.awscdk.services.logs.destinations.FirehoseDestinationProps.Builder props;

        private Builder(final software.amazon.awscdk.services.kinesisfirehose.IDeliveryStream stream) {
            this.stream = stream;
        }

        /**
         * The role to assume to write log events to the destination.
         * <p>
         * Default: - A new Role is created
         * <p>
         * @return {@code this}
         * @param role The role to assume to write log events to the destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props().role(role);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.logs.destinations.FirehoseDestination}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.logs.destinations.FirehoseDestination build() {
            return new software.amazon.awscdk.services.logs.destinations.FirehoseDestination(
                this.stream,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.logs.destinations.FirehoseDestinationProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.logs.destinations.FirehoseDestinationProps.Builder();
            }
            return this.props;
        }
    }
}
