package software.amazon.awscdk.services.medialive;

/**
 * Properties for defining a <code>CfnInputSecurityGroup</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.medialive.*;
 * Object tags;
 * CfnInputSecurityGroupProps cfnInputSecurityGroupProps = CfnInputSecurityGroupProps.builder()
 *         .tags(tags)
 *         .whitelistRules(List.of(InputWhitelistRuleCidrProperty.builder()
 *                 .cidr("cidr")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-inputsecuritygroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-inputsecuritygroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:43.042Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnInputSecurityGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnInputSecurityGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnInputSecurityGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A collection of tags for this input security group.
     * <p>
     * Each tag is a key-value pair.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-inputsecuritygroup.html#cfn-medialive-inputsecuritygroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-inputsecuritygroup.html#cfn-medialive-inputsecuritygroup-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTags() {
        return null;
    }

    /**
     * The list of IPv4 CIDR addresses to include in the input security group as "allowed" addresses.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-inputsecuritygroup.html#cfn-medialive-inputsecuritygroup-whitelistrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-inputsecuritygroup.html#cfn-medialive-inputsecuritygroup-whitelistrules</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getWhitelistRules() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnInputSecurityGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnInputSecurityGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnInputSecurityGroupProps> {
        java.lang.Object tags;
        java.lang.Object whitelistRules;

        /**
         * Sets the value of {@link CfnInputSecurityGroupProps#getTags}
         * @param tags A collection of tags for this input security group.
         *             Each tag is a key-value pair.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.lang.Object tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnInputSecurityGroupProps#getWhitelistRules}
         * @param whitelistRules The list of IPv4 CIDR addresses to include in the input security group as "allowed" addresses.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder whitelistRules(software.amazon.awscdk.IResolvable whitelistRules) {
            this.whitelistRules = whitelistRules;
            return this;
        }

        /**
         * Sets the value of {@link CfnInputSecurityGroupProps#getWhitelistRules}
         * @param whitelistRules The list of IPv4 CIDR addresses to include in the input security group as "allowed" addresses.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder whitelistRules(java.util.List<? extends java.lang.Object> whitelistRules) {
            this.whitelistRules = whitelistRules;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnInputSecurityGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnInputSecurityGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnInputSecurityGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnInputSecurityGroupProps {
        private final java.lang.Object tags;
        private final java.lang.Object whitelistRules;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.whitelistRules = software.amazon.jsii.Kernel.get(this, "whitelistRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.tags = builder.tags;
            this.whitelistRules = builder.whitelistRules;
        }

        @Override
        public final java.lang.Object getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getWhitelistRules() {
            return this.whitelistRules;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getWhitelistRules() != null) {
                data.set("whitelistRules", om.valueToTree(this.getWhitelistRules()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnInputSecurityGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnInputSecurityGroupProps.Jsii$Proxy that = (CfnInputSecurityGroupProps.Jsii$Proxy) o;

            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.whitelistRules != null ? this.whitelistRules.equals(that.whitelistRules) : that.whitelistRules == null;
        }

        @Override
        public final int hashCode() {
            int result = this.tags != null ? this.tags.hashCode() : 0;
            result = 31 * result + (this.whitelistRules != null ? this.whitelistRules.hashCode() : 0);
            return result;
        }
    }
}
