package software.amazon.awscdk.services.mediastore;

/**
 * The AWS::MediaStore::Container resource specifies a storage container to hold objects.
 * <p>
 * A container is similar to a bucket in Amazon S3.
 * <p>
 * When you create a container using AWS CloudFormation , the template manages data for five API actions: creating a container, setting access logging, updating the default container policy, adding a cross-origin resource sharing (CORS) policy, and adding an object lifecycle policy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediastore.*;
 * CfnContainer cfnContainer = CfnContainer.Builder.create(this, "MyCfnContainer")
 *         .containerName("containerName")
 *         // the properties below are optional
 *         .accessLoggingEnabled(false)
 *         .corsPolicy(List.of(CorsRuleProperty.builder()
 *                 .allowedHeaders(List.of("allowedHeaders"))
 *                 .allowedMethods(List.of("allowedMethods"))
 *                 .allowedOrigins(List.of("allowedOrigins"))
 *                 .exposeHeaders(List.of("exposeHeaders"))
 *                 .maxAgeSeconds(123)
 *                 .build()))
 *         .lifecyclePolicy("lifecyclePolicy")
 *         .metricPolicy(MetricPolicyProperty.builder()
 *                 .containerLevelMetrics("containerLevelMetrics")
 *                 // the properties below are optional
 *                 .metricPolicyRules(List.of(MetricPolicyRuleProperty.builder()
 *                         .objectGroup("objectGroup")
 *                         .objectGroupName("objectGroupName")
 *                         .build()))
 *                 .build())
 *         .policy("policy")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:43.134Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediastore.CfnContainer")
public class CfnContainer extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnContainer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnContainer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.mediastore.CfnContainer.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnContainer(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.mediastore.CfnContainerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The DNS endpoint of the container.
     * <p>
     * Use the endpoint to identify the specific container when sending requests to the data plane. The service assigns this value when the container is created. Once the value has been assigned, it does not change.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "attrEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name for the container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getContainerName() {
        return software.amazon.jsii.Kernel.get(this, "containerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name for the container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContainerName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "containerName", java.util.Objects.requireNonNull(value, "containerName is required"));
    }

    /**
     * The state of access logging on the container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAccessLoggingEnabled() {
        return software.amazon.jsii.Kernel.get(this, "accessLoggingEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The state of access logging on the container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessLoggingEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "accessLoggingEnabled", value);
    }

    /**
     * The state of access logging on the container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessLoggingEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "accessLoggingEnabled", value);
    }

    /**
     * <blockquote><p>End of support notice: On November 13, 2025, AWS will discontinue support for AWS Elemental MediaStore.<p></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCorsPolicy() {
        return software.amazon.jsii.Kernel.get(this, "corsPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * <blockquote><p>End of support notice: On November 13, 2025, AWS will discontinue support for AWS Elemental MediaStore.<p></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCorsPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "corsPolicy", value);
    }

    /**
     * <blockquote><p>End of support notice: On November 13, 2025, AWS will discontinue support for AWS Elemental MediaStore.<p></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCorsPolicy(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.mediastore.CfnContainer.CorsRuleProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.mediastore.CfnContainer.CorsRuleProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "corsPolicy", value);
    }

    /**
     * <blockquote><p>End of support notice: On November 13, 2025, AWS will discontinue support for AWS Elemental MediaStore.<p></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLifecyclePolicy() {
        return software.amazon.jsii.Kernel.get(this, "lifecyclePolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * <blockquote><p>End of support notice: On November 13, 2025, AWS will discontinue support for AWS Elemental MediaStore.<p></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLifecyclePolicy(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "lifecyclePolicy", value);
    }

    /**
     * The metric policy that is associated with the container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMetricPolicy() {
        return software.amazon.jsii.Kernel.get(this, "metricPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The metric policy that is associated with the container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetricPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "metricPolicy", value);
    }

    /**
     * The metric policy that is associated with the container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetricPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediastore.CfnContainer.MetricPolicyProperty value) {
        software.amazon.jsii.Kernel.set(this, "metricPolicy", value);
    }

    /**
     * Creates an access policy for the specified container to restrict the users and clients that can access it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPolicy() {
        return software.amazon.jsii.Kernel.get(this, "policy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Creates an access policy for the specified container to restrict the users and clients that can access it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicy(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "policy", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * A rule for a CORS policy.
     * <p>
     * You can add up to 100 rules to a CORS policy. If more than one rule applies, the service uses the first applicable rule listed.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediastore.*;
     * CorsRuleProperty corsRuleProperty = CorsRuleProperty.builder()
     *         .allowedHeaders(List.of("allowedHeaders"))
     *         .allowedMethods(List.of("allowedMethods"))
     *         .allowedOrigins(List.of("allowedOrigins"))
     *         .exposeHeaders(List.of("exposeHeaders"))
     *         .maxAgeSeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-corsrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-corsrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediastore.CfnContainer.CorsRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(CorsRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CorsRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies which headers are allowed in a preflight <code>OPTIONS</code> request through the <code>Access-Control-Request-Headers</code> header.
         * <p>
         * Each header name that is specified in <code>Access-Control-Request-Headers</code> must have a corresponding entry in the rule. Only the headers that were requested are sent back.
         * <p>
         * This element can contain only one wildcard character (*).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-corsrule.html#cfn-mediastore-container-corsrule-allowedheaders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-corsrule.html#cfn-mediastore-container-corsrule-allowedheaders</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedHeaders() {
            return null;
        }

        /**
         * Identifies an HTTP method that the origin that is specified in the rule is allowed to execute.
         * <p>
         * Each CORS rule must contain at least one <code>AllowedMethods</code> and one <code>AllowedOrigins</code> element.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-corsrule.html#cfn-mediastore-container-corsrule-allowedmethods">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-corsrule.html#cfn-mediastore-container-corsrule-allowedmethods</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedMethods() {
            return null;
        }

        /**
         * One or more response headers that you want users to be able to access from their applications (for example, from a JavaScript <code>XMLHttpRequest</code> object).
         * <p>
         * Each CORS rule must have at least one <code>AllowedOrigins</code> element. The string value can include only one wildcard character (<em>), for example, http://</em>.example.com. Additionally, you can specify only one wildcard character to allow cross-origin access for all origins.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-corsrule.html#cfn-mediastore-container-corsrule-allowedorigins">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-corsrule.html#cfn-mediastore-container-corsrule-allowedorigins</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedOrigins() {
            return null;
        }

        /**
         * One or more headers in the response that you want users to be able to access from their applications (for example, from a JavaScript <code>XMLHttpRequest</code> object).
         * <p>
         * This element is optional for each rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-corsrule.html#cfn-mediastore-container-corsrule-exposeheaders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-corsrule.html#cfn-mediastore-container-corsrule-exposeheaders</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExposeHeaders() {
            return null;
        }

        /**
         * The time in seconds that your browser caches the preflight response for the specified resource.
         * <p>
         * A CORS rule can have only one <code>MaxAgeSeconds</code> element.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-corsrule.html#cfn-mediastore-container-corsrule-maxageseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-corsrule.html#cfn-mediastore-container-corsrule-maxageseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxAgeSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CorsRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CorsRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CorsRuleProperty> {
            java.util.List<java.lang.String> allowedHeaders;
            java.util.List<java.lang.String> allowedMethods;
            java.util.List<java.lang.String> allowedOrigins;
            java.util.List<java.lang.String> exposeHeaders;
            java.lang.Number maxAgeSeconds;

            /**
             * Sets the value of {@link CorsRuleProperty#getAllowedHeaders}
             * @param allowedHeaders Specifies which headers are allowed in a preflight <code>OPTIONS</code> request through the <code>Access-Control-Request-Headers</code> header.
             *                       Each header name that is specified in <code>Access-Control-Request-Headers</code> must have a corresponding entry in the rule. Only the headers that were requested are sent back.
             *                       <p>
             *                       This element can contain only one wildcard character (*).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedHeaders(java.util.List<java.lang.String> allowedHeaders) {
                this.allowedHeaders = allowedHeaders;
                return this;
            }

            /**
             * Sets the value of {@link CorsRuleProperty#getAllowedMethods}
             * @param allowedMethods Identifies an HTTP method that the origin that is specified in the rule is allowed to execute.
             *                       Each CORS rule must contain at least one <code>AllowedMethods</code> and one <code>AllowedOrigins</code> element.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedMethods(java.util.List<java.lang.String> allowedMethods) {
                this.allowedMethods = allowedMethods;
                return this;
            }

            /**
             * Sets the value of {@link CorsRuleProperty#getAllowedOrigins}
             * @param allowedOrigins One or more response headers that you want users to be able to access from their applications (for example, from a JavaScript <code>XMLHttpRequest</code> object).
             *                       Each CORS rule must have at least one <code>AllowedOrigins</code> element. The string value can include only one wildcard character (<em>), for example, http://</em>.example.com. Additionally, you can specify only one wildcard character to allow cross-origin access for all origins.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedOrigins(java.util.List<java.lang.String> allowedOrigins) {
                this.allowedOrigins = allowedOrigins;
                return this;
            }

            /**
             * Sets the value of {@link CorsRuleProperty#getExposeHeaders}
             * @param exposeHeaders One or more headers in the response that you want users to be able to access from their applications (for example, from a JavaScript <code>XMLHttpRequest</code> object).
             *                      This element is optional for each rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exposeHeaders(java.util.List<java.lang.String> exposeHeaders) {
                this.exposeHeaders = exposeHeaders;
                return this;
            }

            /**
             * Sets the value of {@link CorsRuleProperty#getMaxAgeSeconds}
             * @param maxAgeSeconds The time in seconds that your browser caches the preflight response for the specified resource.
             *                      A CORS rule can have only one <code>MaxAgeSeconds</code> element.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxAgeSeconds(java.lang.Number maxAgeSeconds) {
                this.maxAgeSeconds = maxAgeSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CorsRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CorsRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CorsRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CorsRuleProperty {
            private final java.util.List<java.lang.String> allowedHeaders;
            private final java.util.List<java.lang.String> allowedMethods;
            private final java.util.List<java.lang.String> allowedOrigins;
            private final java.util.List<java.lang.String> exposeHeaders;
            private final java.lang.Number maxAgeSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowedHeaders = software.amazon.jsii.Kernel.get(this, "allowedHeaders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.allowedMethods = software.amazon.jsii.Kernel.get(this, "allowedMethods", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.allowedOrigins = software.amazon.jsii.Kernel.get(this, "allowedOrigins", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.exposeHeaders = software.amazon.jsii.Kernel.get(this, "exposeHeaders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.maxAgeSeconds = software.amazon.jsii.Kernel.get(this, "maxAgeSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowedHeaders = builder.allowedHeaders;
                this.allowedMethods = builder.allowedMethods;
                this.allowedOrigins = builder.allowedOrigins;
                this.exposeHeaders = builder.exposeHeaders;
                this.maxAgeSeconds = builder.maxAgeSeconds;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedHeaders() {
                return this.allowedHeaders;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedMethods() {
                return this.allowedMethods;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedOrigins() {
                return this.allowedOrigins;
            }

            @Override
            public final java.util.List<java.lang.String> getExposeHeaders() {
                return this.exposeHeaders;
            }

            @Override
            public final java.lang.Number getMaxAgeSeconds() {
                return this.maxAgeSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllowedHeaders() != null) {
                    data.set("allowedHeaders", om.valueToTree(this.getAllowedHeaders()));
                }
                if (this.getAllowedMethods() != null) {
                    data.set("allowedMethods", om.valueToTree(this.getAllowedMethods()));
                }
                if (this.getAllowedOrigins() != null) {
                    data.set("allowedOrigins", om.valueToTree(this.getAllowedOrigins()));
                }
                if (this.getExposeHeaders() != null) {
                    data.set("exposeHeaders", om.valueToTree(this.getExposeHeaders()));
                }
                if (this.getMaxAgeSeconds() != null) {
                    data.set("maxAgeSeconds", om.valueToTree(this.getMaxAgeSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediastore.CfnContainer.CorsRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CorsRuleProperty.Jsii$Proxy that = (CorsRuleProperty.Jsii$Proxy) o;

                if (this.allowedHeaders != null ? !this.allowedHeaders.equals(that.allowedHeaders) : that.allowedHeaders != null) return false;
                if (this.allowedMethods != null ? !this.allowedMethods.equals(that.allowedMethods) : that.allowedMethods != null) return false;
                if (this.allowedOrigins != null ? !this.allowedOrigins.equals(that.allowedOrigins) : that.allowedOrigins != null) return false;
                if (this.exposeHeaders != null ? !this.exposeHeaders.equals(that.exposeHeaders) : that.exposeHeaders != null) return false;
                return this.maxAgeSeconds != null ? this.maxAgeSeconds.equals(that.maxAgeSeconds) : that.maxAgeSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allowedHeaders != null ? this.allowedHeaders.hashCode() : 0;
                result = 31 * result + (this.allowedMethods != null ? this.allowedMethods.hashCode() : 0);
                result = 31 * result + (this.allowedOrigins != null ? this.allowedOrigins.hashCode() : 0);
                result = 31 * result + (this.exposeHeaders != null ? this.exposeHeaders.hashCode() : 0);
                result = 31 * result + (this.maxAgeSeconds != null ? this.maxAgeSeconds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The metric policy that is associated with the container.
     * <p>
     * A metric policy allows AWS Elemental MediaStore to send metrics to Amazon CloudWatch. In the policy, you must indicate whether you want MediaStore to send container-level metrics. You can also include rules to define groups of objects that you want MediaStore to send object-level metrics for.
     * <p>
     * To view examples of how to construct a metric policy for your use case, see <a href="https://docs.aws.amazon.com/mediastore/latest/ug/policies-metric-examples.html">Example Metric Policies</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediastore.*;
     * MetricPolicyProperty metricPolicyProperty = MetricPolicyProperty.builder()
     *         .containerLevelMetrics("containerLevelMetrics")
     *         // the properties below are optional
     *         .metricPolicyRules(List.of(MetricPolicyRuleProperty.builder()
     *                 .objectGroup("objectGroup")
     *                 .objectGroupName("objectGroupName")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-metricpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-metricpolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediastore.CfnContainer.MetricPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A setting to enable or disable metrics at the container level.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-metricpolicy.html#cfn-mediastore-container-metricpolicy-containerlevelmetrics">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-metricpolicy.html#cfn-mediastore-container-metricpolicy-containerlevelmetrics</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getContainerLevelMetrics();

        /**
         * A parameter that holds an array of rules that enable metrics at the object level.
         * <p>
         * This parameter is optional, but if you choose to include it, you must also include at least one rule. By default, you can include up to five rules. You can also <a href="https://docs.aws.amazon.com/servicequotas/home?region=us-east-1#!/services/mediastore/quotas">request a quota increase</a> to allow up to 300 rules per policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-metricpolicy.html#cfn-mediastore-container-metricpolicy-metricpolicyrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-metricpolicy.html#cfn-mediastore-container-metricpolicy-metricpolicyrules</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetricPolicyRules() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetricPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricPolicyProperty> {
            java.lang.String containerLevelMetrics;
            java.lang.Object metricPolicyRules;

            /**
             * Sets the value of {@link MetricPolicyProperty#getContainerLevelMetrics}
             * @param containerLevelMetrics A setting to enable or disable metrics at the container level. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerLevelMetrics(java.lang.String containerLevelMetrics) {
                this.containerLevelMetrics = containerLevelMetrics;
                return this;
            }

            /**
             * Sets the value of {@link MetricPolicyProperty#getMetricPolicyRules}
             * @param metricPolicyRules A parameter that holds an array of rules that enable metrics at the object level.
             *                          This parameter is optional, but if you choose to include it, you must also include at least one rule. By default, you can include up to five rules. You can also <a href="https://docs.aws.amazon.com/servicequotas/home?region=us-east-1#!/services/mediastore/quotas">request a quota increase</a> to allow up to 300 rules per policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricPolicyRules(software.amazon.awscdk.IResolvable metricPolicyRules) {
                this.metricPolicyRules = metricPolicyRules;
                return this;
            }

            /**
             * Sets the value of {@link MetricPolicyProperty#getMetricPolicyRules}
             * @param metricPolicyRules A parameter that holds an array of rules that enable metrics at the object level.
             *                          This parameter is optional, but if you choose to include it, you must also include at least one rule. By default, you can include up to five rules. You can also <a href="https://docs.aws.amazon.com/servicequotas/home?region=us-east-1#!/services/mediastore/quotas">request a quota increase</a> to allow up to 300 rules per policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricPolicyRules(java.util.List<? extends java.lang.Object> metricPolicyRules) {
                this.metricPolicyRules = metricPolicyRules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricPolicyProperty {
            private final java.lang.String containerLevelMetrics;
            private final java.lang.Object metricPolicyRules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerLevelMetrics = software.amazon.jsii.Kernel.get(this, "containerLevelMetrics", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metricPolicyRules = software.amazon.jsii.Kernel.get(this, "metricPolicyRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerLevelMetrics = java.util.Objects.requireNonNull(builder.containerLevelMetrics, "containerLevelMetrics is required");
                this.metricPolicyRules = builder.metricPolicyRules;
            }

            @Override
            public final java.lang.String getContainerLevelMetrics() {
                return this.containerLevelMetrics;
            }

            @Override
            public final java.lang.Object getMetricPolicyRules() {
                return this.metricPolicyRules;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("containerLevelMetrics", om.valueToTree(this.getContainerLevelMetrics()));
                if (this.getMetricPolicyRules() != null) {
                    data.set("metricPolicyRules", om.valueToTree(this.getMetricPolicyRules()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediastore.CfnContainer.MetricPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricPolicyProperty.Jsii$Proxy that = (MetricPolicyProperty.Jsii$Proxy) o;

                if (!containerLevelMetrics.equals(that.containerLevelMetrics)) return false;
                return this.metricPolicyRules != null ? this.metricPolicyRules.equals(that.metricPolicyRules) : that.metricPolicyRules == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containerLevelMetrics.hashCode();
                result = 31 * result + (this.metricPolicyRules != null ? this.metricPolicyRules.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A setting that enables metrics at the object level.
     * <p>
     * Each rule contains an object group and an object group name. If the policy includes the MetricPolicyRules parameter, you must include at least one rule. Each metric policy can include up to five rules by default. You can also <a href="https://docs.aws.amazon.com/servicequotas/home?region=us-east-1#!/services/mediastore/quotas">request a quota increase</a> to allow up to 300 rules per policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediastore.*;
     * MetricPolicyRuleProperty metricPolicyRuleProperty = MetricPolicyRuleProperty.builder()
     *         .objectGroup("objectGroup")
     *         .objectGroupName("objectGroupName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-metricpolicyrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-metricpolicyrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediastore.CfnContainer.MetricPolicyRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricPolicyRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricPolicyRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A path or file name that defines which objects to include in the group.
         * <p>
         * Wildcards (*) are acceptable.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-metricpolicyrule.html#cfn-mediastore-container-metricpolicyrule-objectgroup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-metricpolicyrule.html#cfn-mediastore-container-metricpolicyrule-objectgroup</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObjectGroup();

        /**
         * A name that allows you to refer to the object group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-metricpolicyrule.html#cfn-mediastore-container-metricpolicyrule-objectgroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-metricpolicyrule.html#cfn-mediastore-container-metricpolicyrule-objectgroupname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObjectGroupName();

        /**
         * @return a {@link Builder} of {@link MetricPolicyRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricPolicyRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricPolicyRuleProperty> {
            java.lang.String objectGroup;
            java.lang.String objectGroupName;

            /**
             * Sets the value of {@link MetricPolicyRuleProperty#getObjectGroup}
             * @param objectGroup A path or file name that defines which objects to include in the group. This parameter is required.
             *                    Wildcards (*) are acceptable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectGroup(java.lang.String objectGroup) {
                this.objectGroup = objectGroup;
                return this;
            }

            /**
             * Sets the value of {@link MetricPolicyRuleProperty#getObjectGroupName}
             * @param objectGroupName A name that allows you to refer to the object group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectGroupName(java.lang.String objectGroupName) {
                this.objectGroupName = objectGroupName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricPolicyRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricPolicyRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricPolicyRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricPolicyRuleProperty {
            private final java.lang.String objectGroup;
            private final java.lang.String objectGroupName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.objectGroup = software.amazon.jsii.Kernel.get(this, "objectGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.objectGroupName = software.amazon.jsii.Kernel.get(this, "objectGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.objectGroup = java.util.Objects.requireNonNull(builder.objectGroup, "objectGroup is required");
                this.objectGroupName = java.util.Objects.requireNonNull(builder.objectGroupName, "objectGroupName is required");
            }

            @Override
            public final java.lang.String getObjectGroup() {
                return this.objectGroup;
            }

            @Override
            public final java.lang.String getObjectGroupName() {
                return this.objectGroupName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("objectGroup", om.valueToTree(this.getObjectGroup()));
                data.set("objectGroupName", om.valueToTree(this.getObjectGroupName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediastore.CfnContainer.MetricPolicyRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricPolicyRuleProperty.Jsii$Proxy that = (MetricPolicyRuleProperty.Jsii$Proxy) o;

                if (!objectGroup.equals(that.objectGroup)) return false;
                return this.objectGroupName.equals(that.objectGroupName);
            }

            @Override
            public final int hashCode() {
                int result = this.objectGroup.hashCode();
                result = 31 * result + (this.objectGroupName.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.mediastore.CfnContainer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.mediastore.CfnContainer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.mediastore.CfnContainerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.mediastore.CfnContainerProps.Builder();
        }

        /**
         * The name for the container.
         * <p>
         * The name must be from 1 to 255 characters. Container names must be unique to your AWS account within a specific region. As an example, you could create a container named <code>movies</code> in every region, as long as you don’t have an existing container with that name.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-containername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-containername</a>
         * @param containerName The name for the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerName(final java.lang.String containerName) {
            this.props.containerName(containerName);
            return this;
        }

        /**
         * The state of access logging on the container.
         * <p>
         * This value is <code>false</code> by default, indicating that AWS Elemental MediaStore does not send access logs to Amazon CloudWatch Logs. When you enable access logging on the container, MediaStore changes this value to <code>true</code> , indicating that the service delivers access logs for objects stored in that container to CloudWatch Logs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-accessloggingenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-accessloggingenabled</a>
         * @param accessLoggingEnabled The state of access logging on the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessLoggingEnabled(final java.lang.Boolean accessLoggingEnabled) {
            this.props.accessLoggingEnabled(accessLoggingEnabled);
            return this;
        }
        /**
         * The state of access logging on the container.
         * <p>
         * This value is <code>false</code> by default, indicating that AWS Elemental MediaStore does not send access logs to Amazon CloudWatch Logs. When you enable access logging on the container, MediaStore changes this value to <code>true</code> , indicating that the service delivers access logs for objects stored in that container to CloudWatch Logs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-accessloggingenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-accessloggingenabled</a>
         * @param accessLoggingEnabled The state of access logging on the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessLoggingEnabled(final software.amazon.awscdk.IResolvable accessLoggingEnabled) {
            this.props.accessLoggingEnabled(accessLoggingEnabled);
            return this;
        }

        /**
         * <blockquote><p>End of support notice: On November 13, 2025, AWS will discontinue support for AWS Elemental MediaStore.<p></blockquote>
         * <p>
         * After November 13, 2025, you will no longer be able to access the AWS Elemental MediaStore console or AWS Elemental MediaStore resources. For more information, visit this <a href="https://docs.aws.amazon.com/media/support-for-aws-elemental-mediastore-ending-soon/">blog post</a> .
         * <p>
         * Sets the cross-origin resource sharing (CORS) configuration on a container so that the container can service cross-origin requests. For example, you might want to enable a request whose origin is http://www.example.com to access your AWS Elemental MediaStore container at my.example.container.com by using the browser's XMLHttpRequest capability.
         * <p>
         * To enable CORS on a container, you attach a CORS policy to the container. In the CORS policy, you configure rules that identify origins and the HTTP methods that can be executed on your container. The policy can contain up to 398,000 characters. You can add up to 100 rules to a CORS policy. If more than one rule applies, the service uses the first applicable rule listed.
         * <p>
         * To learn more about CORS, see <a href="https://docs.aws.amazon.com/mediastore/latest/ug/cors-policy.html">Cross-Origin Resource Sharing (CORS) in AWS Elemental MediaStore</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-corspolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-corspolicy</a>
         * @param corsPolicy <blockquote><p>End of support notice: On November 13, 2025, AWS will discontinue support for AWS Elemental MediaStore.<p></blockquote> This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder corsPolicy(final software.amazon.awscdk.IResolvable corsPolicy) {
            this.props.corsPolicy(corsPolicy);
            return this;
        }
        /**
         * <blockquote><p>End of support notice: On November 13, 2025, AWS will discontinue support for AWS Elemental MediaStore.<p></blockquote>
         * <p>
         * After November 13, 2025, you will no longer be able to access the AWS Elemental MediaStore console or AWS Elemental MediaStore resources. For more information, visit this <a href="https://docs.aws.amazon.com/media/support-for-aws-elemental-mediastore-ending-soon/">blog post</a> .
         * <p>
         * Sets the cross-origin resource sharing (CORS) configuration on a container so that the container can service cross-origin requests. For example, you might want to enable a request whose origin is http://www.example.com to access your AWS Elemental MediaStore container at my.example.container.com by using the browser's XMLHttpRequest capability.
         * <p>
         * To enable CORS on a container, you attach a CORS policy to the container. In the CORS policy, you configure rules that identify origins and the HTTP methods that can be executed on your container. The policy can contain up to 398,000 characters. You can add up to 100 rules to a CORS policy. If more than one rule applies, the service uses the first applicable rule listed.
         * <p>
         * To learn more about CORS, see <a href="https://docs.aws.amazon.com/mediastore/latest/ug/cors-policy.html">Cross-Origin Resource Sharing (CORS) in AWS Elemental MediaStore</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-corspolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-corspolicy</a>
         * @param corsPolicy <blockquote><p>End of support notice: On November 13, 2025, AWS will discontinue support for AWS Elemental MediaStore.<p></blockquote> This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder corsPolicy(final java.util.List<? extends java.lang.Object> corsPolicy) {
            this.props.corsPolicy(corsPolicy);
            return this;
        }

        /**
         * <blockquote><p>End of support notice: On November 13, 2025, AWS will discontinue support for AWS Elemental MediaStore.<p></blockquote>
         * <p>
         * After November 13, 2025, you will no longer be able to access the AWS Elemental MediaStore console or AWS Elemental MediaStore resources. For more information, visit this <a href="https://docs.aws.amazon.com/media/support-for-aws-elemental-mediastore-ending-soon/">blog post</a> .
         * <p>
         * Writes an object lifecycle policy to a container. If the container already has an object lifecycle policy, the service replaces the existing policy with the new policy. It takes up to 20 minutes for the change to take effect.
         * <p>
         * For information about how to construct an object lifecycle policy, see <a href="https://docs.aws.amazon.com/mediastore/latest/ug/policies-object-lifecycle-components.html">Components of an Object Lifecycle Policy</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-lifecyclepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-lifecyclepolicy</a>
         * @param lifecyclePolicy <blockquote><p>End of support notice: On November 13, 2025, AWS will discontinue support for AWS Elemental MediaStore.<p></blockquote> This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecyclePolicy(final java.lang.String lifecyclePolicy) {
            this.props.lifecyclePolicy(lifecyclePolicy);
            return this;
        }

        /**
         * The metric policy that is associated with the container.
         * <p>
         * A metric policy allows AWS Elemental MediaStore to send metrics to Amazon CloudWatch. In the policy, you must indicate whether you want MediaStore to send container-level metrics. You can also include rules to define groups of objects that you want MediaStore to send object-level metrics for.
         * <p>
         * To view examples of how to construct a metric policy for your use case, see <a href="https://docs.aws.amazon.com/mediastore/latest/ug/policies-metric-examples.html">Example Metric Policies</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-metricpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-metricpolicy</a>
         * @param metricPolicy The metric policy that is associated with the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricPolicy(final software.amazon.awscdk.IResolvable metricPolicy) {
            this.props.metricPolicy(metricPolicy);
            return this;
        }
        /**
         * The metric policy that is associated with the container.
         * <p>
         * A metric policy allows AWS Elemental MediaStore to send metrics to Amazon CloudWatch. In the policy, you must indicate whether you want MediaStore to send container-level metrics. You can also include rules to define groups of objects that you want MediaStore to send object-level metrics for.
         * <p>
         * To view examples of how to construct a metric policy for your use case, see <a href="https://docs.aws.amazon.com/mediastore/latest/ug/policies-metric-examples.html">Example Metric Policies</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-metricpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-metricpolicy</a>
         * @param metricPolicy The metric policy that is associated with the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricPolicy(final software.amazon.awscdk.services.mediastore.CfnContainer.MetricPolicyProperty metricPolicy) {
            this.props.metricPolicy(metricPolicy);
            return this;
        }

        /**
         * Creates an access policy for the specified container to restrict the users and clients that can access it.
         * <p>
         * For information about the data that is included in an access policy, see the <a href="https://docs.aws.amazon.com/iam/">AWS Identity and Access Management User Guide</a> .
         * <p>
         * For this release of the REST API, you can create only one policy for a container. If you enter <code>PutContainerPolicy</code> twice, the second command modifies the existing policy.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-policy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-policy</a>
         * @param policy Creates an access policy for the specified container to restrict the users and clients that can access it. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(final java.lang.String policy) {
            this.props.policy(policy);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-tags</a>
         * @param tags This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.mediastore.CfnContainer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.mediastore.CfnContainer build() {
            return new software.amazon.awscdk.services.mediastore.CfnContainer(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
