package software.amazon.awscdk.services.networkmanager;

/**
 * Properties for defining a <code>CfnConnectPeer</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.networkmanager.*;
 * CfnConnectPeerProps cfnConnectPeerProps = CfnConnectPeerProps.builder()
 *         .connectAttachmentId("connectAttachmentId")
 *         .peerAddress("peerAddress")
 *         // the properties below are optional
 *         .bgpOptions(BgpOptionsProperty.builder()
 *                 .peerAsn(123)
 *                 .build())
 *         .coreNetworkAddress("coreNetworkAddress")
 *         .insideCidrBlocks(List.of("insideCidrBlocks"))
 *         .subnetArn("subnetArn")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectpeer.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectpeer.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:43.340Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkmanager.CfnConnectPeerProps")
@software.amazon.jsii.Jsii.Proxy(CfnConnectPeerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnConnectPeerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the attachment to connect.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectpeer.html#cfn-networkmanager-connectpeer-connectattachmentid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectpeer.html#cfn-networkmanager-connectpeer-connectattachmentid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConnectAttachmentId();

    /**
     * The IP address of the Connect peer.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectpeer.html#cfn-networkmanager-connectpeer-peeraddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectpeer.html#cfn-networkmanager-connectpeer-peeraddress</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPeerAddress();

    /**
     * Describes the BGP options.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectpeer.html#cfn-networkmanager-connectpeer-bgpoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectpeer.html#cfn-networkmanager-connectpeer-bgpoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBgpOptions() {
        return null;
    }

    /**
     * The IP address of a core network.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectpeer.html#cfn-networkmanager-connectpeer-corenetworkaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectpeer.html#cfn-networkmanager-connectpeer-corenetworkaddress</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCoreNetworkAddress() {
        return null;
    }

    /**
     * The inside IP addresses used for a Connect peer configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectpeer.html#cfn-networkmanager-connectpeer-insidecidrblocks">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectpeer.html#cfn-networkmanager-connectpeer-insidecidrblocks</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInsideCidrBlocks() {
        return null;
    }

    /**
     * The subnet ARN of the Connect peer.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectpeer.html#cfn-networkmanager-connectpeer-subnetarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectpeer.html#cfn-networkmanager-connectpeer-subnetarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubnetArn() {
        return null;
    }

    /**
     * The list of key-value tags associated with the Connect peer.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectpeer.html#cfn-networkmanager-connectpeer-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-connectpeer.html#cfn-networkmanager-connectpeer-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnConnectPeerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnConnectPeerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnConnectPeerProps> {
        java.lang.String connectAttachmentId;
        java.lang.String peerAddress;
        java.lang.Object bgpOptions;
        java.lang.String coreNetworkAddress;
        java.util.List<java.lang.String> insideCidrBlocks;
        java.lang.String subnetArn;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnConnectPeerProps#getConnectAttachmentId}
         * @param connectAttachmentId The ID of the attachment to connect. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectAttachmentId(java.lang.String connectAttachmentId) {
            this.connectAttachmentId = connectAttachmentId;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectPeerProps#getPeerAddress}
         * @param peerAddress The IP address of the Connect peer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder peerAddress(java.lang.String peerAddress) {
            this.peerAddress = peerAddress;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectPeerProps#getBgpOptions}
         * @param bgpOptions Describes the BGP options.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bgpOptions(software.amazon.awscdk.IResolvable bgpOptions) {
            this.bgpOptions = bgpOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectPeerProps#getBgpOptions}
         * @param bgpOptions Describes the BGP options.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bgpOptions(software.amazon.awscdk.services.networkmanager.CfnConnectPeer.BgpOptionsProperty bgpOptions) {
            this.bgpOptions = bgpOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectPeerProps#getCoreNetworkAddress}
         * @param coreNetworkAddress The IP address of a core network.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder coreNetworkAddress(java.lang.String coreNetworkAddress) {
            this.coreNetworkAddress = coreNetworkAddress;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectPeerProps#getInsideCidrBlocks}
         * @param insideCidrBlocks The inside IP addresses used for a Connect peer configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insideCidrBlocks(java.util.List<java.lang.String> insideCidrBlocks) {
            this.insideCidrBlocks = insideCidrBlocks;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectPeerProps#getSubnetArn}
         * @param subnetArn The subnet ARN of the Connect peer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetArn(java.lang.String subnetArn) {
            this.subnetArn = subnetArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectPeerProps#getTags}
         * @param tags The list of key-value tags associated with the Connect peer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnConnectPeerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnConnectPeerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnConnectPeerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnConnectPeerProps {
        private final java.lang.String connectAttachmentId;
        private final java.lang.String peerAddress;
        private final java.lang.Object bgpOptions;
        private final java.lang.String coreNetworkAddress;
        private final java.util.List<java.lang.String> insideCidrBlocks;
        private final java.lang.String subnetArn;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.connectAttachmentId = software.amazon.jsii.Kernel.get(this, "connectAttachmentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.peerAddress = software.amazon.jsii.Kernel.get(this, "peerAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bgpOptions = software.amazon.jsii.Kernel.get(this, "bgpOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.coreNetworkAddress = software.amazon.jsii.Kernel.get(this, "coreNetworkAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.insideCidrBlocks = software.amazon.jsii.Kernel.get(this, "insideCidrBlocks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.subnetArn = software.amazon.jsii.Kernel.get(this, "subnetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.connectAttachmentId = java.util.Objects.requireNonNull(builder.connectAttachmentId, "connectAttachmentId is required");
            this.peerAddress = java.util.Objects.requireNonNull(builder.peerAddress, "peerAddress is required");
            this.bgpOptions = builder.bgpOptions;
            this.coreNetworkAddress = builder.coreNetworkAddress;
            this.insideCidrBlocks = builder.insideCidrBlocks;
            this.subnetArn = builder.subnetArn;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getConnectAttachmentId() {
            return this.connectAttachmentId;
        }

        @Override
        public final java.lang.String getPeerAddress() {
            return this.peerAddress;
        }

        @Override
        public final java.lang.Object getBgpOptions() {
            return this.bgpOptions;
        }

        @Override
        public final java.lang.String getCoreNetworkAddress() {
            return this.coreNetworkAddress;
        }

        @Override
        public final java.util.List<java.lang.String> getInsideCidrBlocks() {
            return this.insideCidrBlocks;
        }

        @Override
        public final java.lang.String getSubnetArn() {
            return this.subnetArn;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("connectAttachmentId", om.valueToTree(this.getConnectAttachmentId()));
            data.set("peerAddress", om.valueToTree(this.getPeerAddress()));
            if (this.getBgpOptions() != null) {
                data.set("bgpOptions", om.valueToTree(this.getBgpOptions()));
            }
            if (this.getCoreNetworkAddress() != null) {
                data.set("coreNetworkAddress", om.valueToTree(this.getCoreNetworkAddress()));
            }
            if (this.getInsideCidrBlocks() != null) {
                data.set("insideCidrBlocks", om.valueToTree(this.getInsideCidrBlocks()));
            }
            if (this.getSubnetArn() != null) {
                data.set("subnetArn", om.valueToTree(this.getSubnetArn()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkmanager.CfnConnectPeerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnConnectPeerProps.Jsii$Proxy that = (CfnConnectPeerProps.Jsii$Proxy) o;

            if (!connectAttachmentId.equals(that.connectAttachmentId)) return false;
            if (!peerAddress.equals(that.peerAddress)) return false;
            if (this.bgpOptions != null ? !this.bgpOptions.equals(that.bgpOptions) : that.bgpOptions != null) return false;
            if (this.coreNetworkAddress != null ? !this.coreNetworkAddress.equals(that.coreNetworkAddress) : that.coreNetworkAddress != null) return false;
            if (this.insideCidrBlocks != null ? !this.insideCidrBlocks.equals(that.insideCidrBlocks) : that.insideCidrBlocks != null) return false;
            if (this.subnetArn != null ? !this.subnetArn.equals(that.subnetArn) : that.subnetArn != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.connectAttachmentId.hashCode();
            result = 31 * result + (this.peerAddress.hashCode());
            result = 31 * result + (this.bgpOptions != null ? this.bgpOptions.hashCode() : 0);
            result = 31 * result + (this.coreNetworkAddress != null ? this.coreNetworkAddress.hashCode() : 0);
            result = 31 * result + (this.insideCidrBlocks != null ? this.insideCidrBlocks.hashCode() : 0);
            result = 31 * result + (this.subnetArn != null ? this.subnetArn.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
