package software.amazon.awscdk.services.nimblestudio;

/**
 * Properties for defining a <code>CfnLaunchProfile</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.nimblestudio.*;
 * CfnLaunchProfileProps cfnLaunchProfileProps = CfnLaunchProfileProps.builder()
 *         .ec2SubnetIds(List.of("ec2SubnetIds"))
 *         .launchProfileProtocolVersions(List.of("launchProfileProtocolVersions"))
 *         .name("name")
 *         .streamConfiguration(StreamConfigurationProperty.builder()
 *                 .clipboardMode("clipboardMode")
 *                 .ec2InstanceTypes(List.of("ec2InstanceTypes"))
 *                 .streamingImageIds(List.of("streamingImageIds"))
 *                 // the properties below are optional
 *                 .automaticTerminationMode("automaticTerminationMode")
 *                 .maxSessionLengthInMinutes(123)
 *                 .maxStoppedSessionLengthInMinutes(123)
 *                 .sessionBackup(StreamConfigurationSessionBackupProperty.builder()
 *                         .maxBackupsToRetain(123)
 *                         .mode("mode")
 *                         .build())
 *                 .sessionPersistenceMode("sessionPersistenceMode")
 *                 .sessionStorage(StreamConfigurationSessionStorageProperty.builder()
 *                         .mode(List.of("mode"))
 *                         // the properties below are optional
 *                         .root(StreamingSessionStorageRootProperty.builder()
 *                                 .linux("linux")
 *                                 .windows("windows")
 *                                 .build())
 *                         .build())
 *                 .volumeConfiguration(VolumeConfigurationProperty.builder()
 *                         .iops(123)
 *                         .size(123)
 *                         .throughput(123)
 *                         .build())
 *                 .build())
 *         .studioComponentIds(List.of("studioComponentIds"))
 *         .studioId("studioId")
 *         // the properties below are optional
 *         .description("description")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:43.384Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_nimblestudio.CfnLaunchProfileProps")
@software.amazon.jsii.Jsii.Proxy(CfnLaunchProfileProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLaunchProfileProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Unique identifiers for a collection of EC2 subnets.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-ec2subnetids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-ec2subnetids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getEc2SubnetIds();

    /**
     * The version number of the protocol that is used by the launch profile.
     * <p>
     * The only valid version is "2021-03-31".
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-launchprofileprotocolversions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-launchprofileprotocolversions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getLaunchProfileProtocolVersions();

    /**
     * A friendly name for the launch profile.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * A configuration for a streaming session.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-streamconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-streamconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getStreamConfiguration();

    /**
     * Unique identifiers for a collection of studio components that can be used with this launch profile.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-studiocomponentids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-studiocomponentids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getStudioComponentIds();

    /**
     * The unique identifier for a studio resource.
     * <p>
     * In Nimble Studio, all other resources are contained in a studio resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-studioid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-studioid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStudioId();

    /**
     * A human-readable description of the launch profile.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLaunchProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLaunchProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLaunchProfileProps> {
        java.util.List<java.lang.String> ec2SubnetIds;
        java.util.List<java.lang.String> launchProfileProtocolVersions;
        java.lang.String name;
        java.lang.Object streamConfiguration;
        java.util.List<java.lang.String> studioComponentIds;
        java.lang.String studioId;
        java.lang.String description;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnLaunchProfileProps#getEc2SubnetIds}
         * @param ec2SubnetIds Unique identifiers for a collection of EC2 subnets. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2SubnetIds(java.util.List<java.lang.String> ec2SubnetIds) {
            this.ec2SubnetIds = ec2SubnetIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchProfileProps#getLaunchProfileProtocolVersions}
         * @param launchProfileProtocolVersions The version number of the protocol that is used by the launch profile. This parameter is required.
         *                                      The only valid version is "2021-03-31".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchProfileProtocolVersions(java.util.List<java.lang.String> launchProfileProtocolVersions) {
            this.launchProfileProtocolVersions = launchProfileProtocolVersions;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchProfileProps#getName}
         * @param name A friendly name for the launch profile. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchProfileProps#getStreamConfiguration}
         * @param streamConfiguration A configuration for a streaming session. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamConfiguration(software.amazon.awscdk.IResolvable streamConfiguration) {
            this.streamConfiguration = streamConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchProfileProps#getStreamConfiguration}
         * @param streamConfiguration A configuration for a streaming session. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamConfiguration(software.amazon.awscdk.services.nimblestudio.CfnLaunchProfile.StreamConfigurationProperty streamConfiguration) {
            this.streamConfiguration = streamConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchProfileProps#getStudioComponentIds}
         * @param studioComponentIds Unique identifiers for a collection of studio components that can be used with this launch profile. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder studioComponentIds(java.util.List<java.lang.String> studioComponentIds) {
            this.studioComponentIds = studioComponentIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchProfileProps#getStudioId}
         * @param studioId The unique identifier for a studio resource. This parameter is required.
         *                 In Nimble Studio, all other resources are contained in a studio resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder studioId(java.lang.String studioId) {
            this.studioId = studioId;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchProfileProps#getDescription}
         * @param description A human-readable description of the launch profile.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchProfileProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLaunchProfileProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLaunchProfileProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLaunchProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLaunchProfileProps {
        private final java.util.List<java.lang.String> ec2SubnetIds;
        private final java.util.List<java.lang.String> launchProfileProtocolVersions;
        private final java.lang.String name;
        private final java.lang.Object streamConfiguration;
        private final java.util.List<java.lang.String> studioComponentIds;
        private final java.lang.String studioId;
        private final java.lang.String description;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ec2SubnetIds = software.amazon.jsii.Kernel.get(this, "ec2SubnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.launchProfileProtocolVersions = software.amazon.jsii.Kernel.get(this, "launchProfileProtocolVersions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.streamConfiguration = software.amazon.jsii.Kernel.get(this, "streamConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.studioComponentIds = software.amazon.jsii.Kernel.get(this, "studioComponentIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.studioId = software.amazon.jsii.Kernel.get(this, "studioId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ec2SubnetIds = java.util.Objects.requireNonNull(builder.ec2SubnetIds, "ec2SubnetIds is required");
            this.launchProfileProtocolVersions = java.util.Objects.requireNonNull(builder.launchProfileProtocolVersions, "launchProfileProtocolVersions is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.streamConfiguration = java.util.Objects.requireNonNull(builder.streamConfiguration, "streamConfiguration is required");
            this.studioComponentIds = java.util.Objects.requireNonNull(builder.studioComponentIds, "studioComponentIds is required");
            this.studioId = java.util.Objects.requireNonNull(builder.studioId, "studioId is required");
            this.description = builder.description;
            this.tags = builder.tags;
        }

        @Override
        public final java.util.List<java.lang.String> getEc2SubnetIds() {
            return this.ec2SubnetIds;
        }

        @Override
        public final java.util.List<java.lang.String> getLaunchProfileProtocolVersions() {
            return this.launchProfileProtocolVersions;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getStreamConfiguration() {
            return this.streamConfiguration;
        }

        @Override
        public final java.util.List<java.lang.String> getStudioComponentIds() {
            return this.studioComponentIds;
        }

        @Override
        public final java.lang.String getStudioId() {
            return this.studioId;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("ec2SubnetIds", om.valueToTree(this.getEc2SubnetIds()));
            data.set("launchProfileProtocolVersions", om.valueToTree(this.getLaunchProfileProtocolVersions()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("streamConfiguration", om.valueToTree(this.getStreamConfiguration()));
            data.set("studioComponentIds", om.valueToTree(this.getStudioComponentIds()));
            data.set("studioId", om.valueToTree(this.getStudioId()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_nimblestudio.CfnLaunchProfileProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLaunchProfileProps.Jsii$Proxy that = (CfnLaunchProfileProps.Jsii$Proxy) o;

            if (!ec2SubnetIds.equals(that.ec2SubnetIds)) return false;
            if (!launchProfileProtocolVersions.equals(that.launchProfileProtocolVersions)) return false;
            if (!name.equals(that.name)) return false;
            if (!streamConfiguration.equals(that.streamConfiguration)) return false;
            if (!studioComponentIds.equals(that.studioComponentIds)) return false;
            if (!studioId.equals(that.studioId)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.ec2SubnetIds.hashCode();
            result = 31 * result + (this.launchProfileProtocolVersions.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.streamConfiguration.hashCode());
            result = 31 * result + (this.studioComponentIds.hashCode());
            result = 31 * result + (this.studioId.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
