package software.amazon.awscdk.services.notifications;

/**
 * The <code>AWS::Notifications::ChannelAssociation</code> resource associates a <code>Channel</code> with a <code>NotificationConfiguration</code> for AWS User Notifications .
 * <p>
 * For more information about AWS User Notifications , see the <a href="https://docs.aws.amazon.com/notifications/latest/userguide/what-is-service.html">AWS User Notifications User Guide</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.notifications.*;
 * CfnChannelAssociation cfnChannelAssociation = CfnChannelAssociation.Builder.create(this, "MyCfnChannelAssociation")
 *         .arn("arn")
 *         .notificationConfigurationArn("notificationConfigurationArn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-notifications-channelassociation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-notifications-channelassociation.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:43.394Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_notifications.CfnChannelAssociation")
public class CfnChannelAssociation extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnChannelAssociation(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnChannelAssociation(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.notifications.CfnChannelAssociation.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnChannelAssociation(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.notifications.CfnChannelAssociationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The Amazon Resource Name (ARN) of the <code>Channel</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getArn() {
        return software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the <code>Channel</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "arn", java.util.Objects.requireNonNull(value, "arn is required"));
    }

    /**
     * The ARN of the <code>NotificationConfiguration</code> associated with the <code>Channel</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getNotificationConfigurationArn() {
        return software.amazon.jsii.Kernel.get(this, "notificationConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the <code>NotificationConfiguration</code> associated with the <code>Channel</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotificationConfigurationArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "notificationConfigurationArn", java.util.Objects.requireNonNull(value, "notificationConfigurationArn is required"));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.notifications.CfnChannelAssociation}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.notifications.CfnChannelAssociation> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.notifications.CfnChannelAssociationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.notifications.CfnChannelAssociationProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) of the <code>Channel</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-notifications-channelassociation.html#cfn-notifications-channelassociation-arn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-notifications-channelassociation.html#cfn-notifications-channelassociation-arn</a>
         * @param arn The Amazon Resource Name (ARN) of the <code>Channel</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder arn(final java.lang.String arn) {
            this.props.arn(arn);
            return this;
        }

        /**
         * The ARN of the <code>NotificationConfiguration</code> associated with the <code>Channel</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-notifications-channelassociation.html#cfn-notifications-channelassociation-notificationconfigurationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-notifications-channelassociation.html#cfn-notifications-channelassociation-notificationconfigurationarn</a>
         * @param notificationConfigurationArn The ARN of the <code>NotificationConfiguration</code> associated with the <code>Channel</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationConfigurationArn(final java.lang.String notificationConfigurationArn) {
            this.props.notificationConfigurationArn(notificationConfigurationArn);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.notifications.CfnChannelAssociation}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.notifications.CfnChannelAssociation build() {
            return new software.amazon.awscdk.services.notifications.CfnChannelAssociation(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
