package software.amazon.awscdk.services.rds;

/**
 * Options to add the multi user rotation.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * DatabaseInstance instance;
 * SecurityGroup mySecurityGroup;
 * instance.addRotationSingleUser(RotationSingleUserOptions.builder()
 *         .automaticallyAfter(Duration.days(7)) // defaults to 30 days
 *         .excludeCharacters("!&#64;#$%^&amp;*") // defaults to the set " %+~`#/// here*()|[]{}:;&lt;&gt;?!'/&#64;\"\\"
 *         .securityGroup(mySecurityGroup) // defaults to an auto-created security group
 *         .rotateImmediatelyOnUpdate(false)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:45.967Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.RotationSingleUserOptions")
@software.amazon.jsii.Jsii.Proxy(RotationSingleUserOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RotationSingleUserOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.rds.CommonRotationUserOptions {

    /**
     * @return a {@link Builder} of {@link RotationSingleUserOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RotationSingleUserOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RotationSingleUserOptions> {
        software.amazon.awscdk.Duration automaticallyAfter;
        software.amazon.awscdk.services.ec2.IInterfaceVpcEndpoint endpoint;
        java.lang.String excludeCharacters;
        java.lang.Boolean rotateImmediatelyOnUpdate;
        software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Sets the value of {@link RotationSingleUserOptions#getAutomaticallyAfter}
         * @param automaticallyAfter Specifies the number of days after the previous rotation before Secrets Manager triggers the next automatic rotation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automaticallyAfter(software.amazon.awscdk.Duration automaticallyAfter) {
            this.automaticallyAfter = automaticallyAfter;
            return this;
        }

        /**
         * Sets the value of {@link RotationSingleUserOptions#getEndpoint}
         * @param endpoint The VPC interface endpoint to use for the Secrets Manager API.
         *                 If you enable private DNS hostnames for your VPC private endpoint (the default), you don't
         *                 need to specify an endpoint. The standard Secrets Manager DNS hostname the Secrets Manager
         *                 CLI and SDKs use by default (https://secretsmanager.<region>.amazonaws.com) automatically
         *                 resolves to your VPC endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpoint(software.amazon.awscdk.services.ec2.IInterfaceVpcEndpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        /**
         * Sets the value of {@link RotationSingleUserOptions#getExcludeCharacters}
         * @param excludeCharacters Specifies characters to not include in generated passwords.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeCharacters(java.lang.String excludeCharacters) {
            this.excludeCharacters = excludeCharacters;
            return this;
        }

        /**
         * Sets the value of {@link RotationSingleUserOptions#getRotateImmediatelyOnUpdate}
         * @param rotateImmediatelyOnUpdate Specifies whether to rotate the secret immediately or wait until the next scheduled rotation window.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotateImmediatelyOnUpdate(java.lang.Boolean rotateImmediatelyOnUpdate) {
            this.rotateImmediatelyOnUpdate = rotateImmediatelyOnUpdate;
            return this;
        }

        /**
         * Sets the value of {@link RotationSingleUserOptions#getSecurityGroup}
         * @param securityGroup The security group for the Lambda rotation function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Sets the value of {@link RotationSingleUserOptions#getVpcSubnets}
         * @param vpcSubnets Where to place the rotation Lambda function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RotationSingleUserOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RotationSingleUserOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RotationSingleUserOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RotationSingleUserOptions {
        private final software.amazon.awscdk.Duration automaticallyAfter;
        private final software.amazon.awscdk.services.ec2.IInterfaceVpcEndpoint endpoint;
        private final java.lang.String excludeCharacters;
        private final java.lang.Boolean rotateImmediatelyOnUpdate;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.automaticallyAfter = software.amazon.jsii.Kernel.get(this, "automaticallyAfter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.endpoint = software.amazon.jsii.Kernel.get(this, "endpoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IInterfaceVpcEndpoint.class));
            this.excludeCharacters = software.amazon.jsii.Kernel.get(this, "excludeCharacters", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.rotateImmediatelyOnUpdate = software.amazon.jsii.Kernel.get(this, "rotateImmediatelyOnUpdate", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.securityGroup = software.amazon.jsii.Kernel.get(this, "securityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.automaticallyAfter = builder.automaticallyAfter;
            this.endpoint = builder.endpoint;
            this.excludeCharacters = builder.excludeCharacters;
            this.rotateImmediatelyOnUpdate = builder.rotateImmediatelyOnUpdate;
            this.securityGroup = builder.securityGroup;
            this.vpcSubnets = builder.vpcSubnets;
        }

        @Override
        public final software.amazon.awscdk.Duration getAutomaticallyAfter() {
            return this.automaticallyAfter;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IInterfaceVpcEndpoint getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final java.lang.String getExcludeCharacters() {
            return this.excludeCharacters;
        }

        @Override
        public final java.lang.Boolean getRotateImmediatelyOnUpdate() {
            return this.rotateImmediatelyOnUpdate;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAutomaticallyAfter() != null) {
                data.set("automaticallyAfter", om.valueToTree(this.getAutomaticallyAfter()));
            }
            if (this.getEndpoint() != null) {
                data.set("endpoint", om.valueToTree(this.getEndpoint()));
            }
            if (this.getExcludeCharacters() != null) {
                data.set("excludeCharacters", om.valueToTree(this.getExcludeCharacters()));
            }
            if (this.getRotateImmediatelyOnUpdate() != null) {
                data.set("rotateImmediatelyOnUpdate", om.valueToTree(this.getRotateImmediatelyOnUpdate()));
            }
            if (this.getSecurityGroup() != null) {
                data.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.RotationSingleUserOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RotationSingleUserOptions.Jsii$Proxy that = (RotationSingleUserOptions.Jsii$Proxy) o;

            if (this.automaticallyAfter != null ? !this.automaticallyAfter.equals(that.automaticallyAfter) : that.automaticallyAfter != null) return false;
            if (this.endpoint != null ? !this.endpoint.equals(that.endpoint) : that.endpoint != null) return false;
            if (this.excludeCharacters != null ? !this.excludeCharacters.equals(that.excludeCharacters) : that.excludeCharacters != null) return false;
            if (this.rotateImmediatelyOnUpdate != null ? !this.rotateImmediatelyOnUpdate.equals(that.rotateImmediatelyOnUpdate) : that.rotateImmediatelyOnUpdate != null) return false;
            if (this.securityGroup != null ? !this.securityGroup.equals(that.securityGroup) : that.securityGroup != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.automaticallyAfter != null ? this.automaticallyAfter.hashCode() : 0;
            result = 31 * result + (this.endpoint != null ? this.endpoint.hashCode() : 0);
            result = 31 * result + (this.excludeCharacters != null ? this.excludeCharacters.hashCode() : 0);
            result = 31 * result + (this.rotateImmediatelyOnUpdate != null ? this.rotateImmediatelyOnUpdate.hashCode() : 0);
            result = 31 * result + (this.securityGroup != null ? this.securityGroup.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
