package software.amazon.awscdk.services.route53;

/**
 * The status for a Key Signing Key.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * HostedZone hostedZone;
 * Key kmsKey;
 * KeySigningKey.Builder.create(this, "KeySigningKey")
 *         .hostedZone(hostedZone)
 *         .kmsKey(kmsKey)
 *         .keySigningKeyName("ksk")
 *         .status(KeySigningKeyStatus.ACTIVE)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:46.265Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.KeySigningKeyStatus")
public enum KeySigningKeyStatus {
    /**
     * The KSK is being used for signing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ACTIVE,
    /**
     * The KSK is not being used for signing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INACTIVE,
}
