package software.amazon.awscdk.services.s3;

/**
 * The ObjectOwnership of the bucket.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket accessLogsBucket = Bucket.Builder.create(this, "AccessLogsBucket")
 *         .objectOwnership(ObjectOwnership.BUCKET_OWNER_ENFORCED)
 *         .build();
 * accessLogsBucket.addToResourcePolicy(
 * PolicyStatement.Builder.create()
 *         .actions(List.of("s3:*"))
 *         .resources(List.of(accessLogsBucket.getBucketArn(), accessLogsBucket.arnForObjects("*")))
 *         .principals(List.of(new AnyPrincipal()))
 *         .build());
 * Bucket bucket = Bucket.Builder.create(this, "MyBucket")
 *         .serverAccessLogsBucket(accessLogsBucket)
 *         .serverAccessLogsPrefix("logs")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/about-object-ownership.html">https://docs.aws.amazon.com/AmazonS3/latest/dev/about-object-ownership.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:46.534Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.ObjectOwnership")
public enum ObjectOwnership {
    /**
     * ACLs are disabled, and the bucket owner automatically owns and has full control over every object in the bucket.
     * <p>
     * ACLs no longer affect permissions to data in the S3 bucket.
     * The bucket uses policies to define access control.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BUCKET_OWNER_ENFORCED,
    /**
     * The bucket owner will own the object if the object is uploaded with the bucket-owner-full-control canned ACL.
     * <p>
     * Without this setting and
     * canned ACL, the object is uploaded and remains owned by the uploading account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BUCKET_OWNER_PREFERRED,
    /**
     * The uploading account will own the object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OBJECT_WRITER,
}
