package software.amazon.awscdk.services.s3.notifications;

/**
 * Use an SQS queue as a bucket notification destination.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Queue myQueue;
 * Bucket bucket = Bucket.Builder.create(this, "MyBucket")
 *         .notificationsSkipDestinationValidation(true)
 *         .build();
 * bucket.addEventNotification(EventType.OBJECT_REMOVED, new SqsDestination(myQueue));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:46.560Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3_notifications.SqsDestination")
public class SqsDestination extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.s3.IBucketNotificationDestination {

    protected SqsDestination(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SqsDestination(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param queue This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SqsDestination(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sqs.IQueue queue) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(queue, "queue is required") });
    }

    /**
     * Allows using SQS queues as destinations for bucket notifications.
     * <p>
     * Use <code>bucket.onEvent(event, queue)</code> to subscribe.
     * <p>
     * @param _scope This parameter is required.
     * @param bucket This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.BucketNotificationDestinationConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.BucketNotificationDestinationConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(bucket, "bucket is required") });
    }
}
