package software.amazon.awscdk.services.s3tables;

/**
 * Properties for defining a <code>CfnTableBucketPolicy</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3tables.*;
 * Object resourcePolicy;
 * CfnTableBucketPolicyProps cfnTableBucketPolicyProps = CfnTableBucketPolicyProps.builder()
 *         .resourcePolicy(resourcePolicy)
 *         .tableBucketArn("tableBucketArn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-tablebucketpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-tablebucketpolicy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:46.599Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3tables.CfnTableBucketPolicyProps")
@software.amazon.jsii.Jsii.Proxy(CfnTableBucketPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTableBucketPolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The bucket policy JSON for the table bucket.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-tablebucketpolicy.html#cfn-s3tables-tablebucketpolicy-resourcepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-tablebucketpolicy.html#cfn-s3tables-tablebucketpolicy-resourcepolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getResourcePolicy();

    /**
     * The Amazon Resource Name (ARN) of the table bucket.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-tablebucketpolicy.html#cfn-s3tables-tablebucketpolicy-tablebucketarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-tablebucketpolicy.html#cfn-s3tables-tablebucketpolicy-tablebucketarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTableBucketArn();

    /**
     * @return a {@link Builder} of {@link CfnTableBucketPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTableBucketPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTableBucketPolicyProps> {
        java.lang.Object resourcePolicy;
        java.lang.String tableBucketArn;

        /**
         * Sets the value of {@link CfnTableBucketPolicyProps#getResourcePolicy}
         * @param resourcePolicy The bucket policy JSON for the table bucket. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcePolicy(java.lang.Object resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableBucketPolicyProps#getTableBucketArn}
         * @param tableBucketArn The Amazon Resource Name (ARN) of the table bucket. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableBucketArn(java.lang.String tableBucketArn) {
            this.tableBucketArn = tableBucketArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTableBucketPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTableBucketPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTableBucketPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTableBucketPolicyProps {
        private final java.lang.Object resourcePolicy;
        private final java.lang.String tableBucketArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.resourcePolicy = software.amazon.jsii.Kernel.get(this, "resourcePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tableBucketArn = software.amazon.jsii.Kernel.get(this, "tableBucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resourcePolicy = java.util.Objects.requireNonNull(builder.resourcePolicy, "resourcePolicy is required");
            this.tableBucketArn = java.util.Objects.requireNonNull(builder.tableBucketArn, "tableBucketArn is required");
        }

        @Override
        public final java.lang.Object getResourcePolicy() {
            return this.resourcePolicy;
        }

        @Override
        public final java.lang.String getTableBucketArn() {
            return this.tableBucketArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("resourcePolicy", om.valueToTree(this.getResourcePolicy()));
            data.set("tableBucketArn", om.valueToTree(this.getTableBucketArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3tables.CfnTableBucketPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTableBucketPolicyProps.Jsii$Proxy that = (CfnTableBucketPolicyProps.Jsii$Proxy) o;

            if (!resourcePolicy.equals(that.resourcePolicy)) return false;
            return this.tableBucketArn.equals(that.tableBucketArn);
        }

        @Override
        public final int hashCode() {
            int result = this.resourcePolicy.hashCode();
            result = 31 * result + (this.tableBucketArn.hashCode());
            return result;
        }
    }
}
