package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a <code>CfnDomain</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnDomainProps cfnDomainProps = CfnDomainProps.builder()
 *         .authMode("authMode")
 *         .defaultUserSettings(UserSettingsProperty.builder()
 *                 .executionRole("executionRole")
 *                 // the properties below are optional
 *                 .codeEditorAppSettings(CodeEditorAppSettingsProperty.builder()
 *                         .appLifecycleManagement(AppLifecycleManagementProperty.builder()
 *                                 .idleSettings(IdleSettingsProperty.builder()
 *                                         .idleTimeoutInMinutes(123)
 *                                         .lifecycleManagement("lifecycleManagement")
 *                                         .maxIdleTimeoutInMinutes(123)
 *                                         .minIdleTimeoutInMinutes(123)
 *                                         .build())
 *                                 .build())
 *                         .customImages(List.of(CustomImageProperty.builder()
 *                                 .appImageConfigName("appImageConfigName")
 *                                 .imageName("imageName")
 *                                 // the properties below are optional
 *                                 .imageVersionNumber(123)
 *                                 .build()))
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .lifecycleConfigArns(List.of("lifecycleConfigArns"))
 *                         .build())
 *                 .customFileSystemConfigs(List.of(CustomFileSystemConfigProperty.builder()
 *                         .efsFileSystemConfig(EFSFileSystemConfigProperty.builder()
 *                                 .fileSystemId("fileSystemId")
 *                                 // the properties below are optional
 *                                 .fileSystemPath("fileSystemPath")
 *                                 .build())
 *                         .fSxLustreFileSystemConfig(FSxLustreFileSystemConfigProperty.builder()
 *                                 .fileSystemId("fileSystemId")
 *                                 // the properties below are optional
 *                                 .fileSystemPath("fileSystemPath")
 *                                 .build())
 *                         .build()))
 *                 .customPosixUserConfig(CustomPosixUserConfigProperty.builder()
 *                         .gid(123)
 *                         .uid(123)
 *                         .build())
 *                 .defaultLandingUri("defaultLandingUri")
 *                 .jupyterLabAppSettings(JupyterLabAppSettingsProperty.builder()
 *                         .appLifecycleManagement(AppLifecycleManagementProperty.builder()
 *                                 .idleSettings(IdleSettingsProperty.builder()
 *                                         .idleTimeoutInMinutes(123)
 *                                         .lifecycleManagement("lifecycleManagement")
 *                                         .maxIdleTimeoutInMinutes(123)
 *                                         .minIdleTimeoutInMinutes(123)
 *                                         .build())
 *                                 .build())
 *                         .codeRepositories(List.of(CodeRepositoryProperty.builder()
 *                                 .repositoryUrl("repositoryUrl")
 *                                 .build()))
 *                         .customImages(List.of(CustomImageProperty.builder()
 *                                 .appImageConfigName("appImageConfigName")
 *                                 .imageName("imageName")
 *                                 // the properties below are optional
 *                                 .imageVersionNumber(123)
 *                                 .build()))
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .lifecycleConfigArns(List.of("lifecycleConfigArns"))
 *                         .build())
 *                 .jupyterServerAppSettings(JupyterServerAppSettingsProperty.builder()
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .lifecycleConfigArns(List.of("lifecycleConfigArns"))
 *                         .build())
 *                 .kernelGatewayAppSettings(KernelGatewayAppSettingsProperty.builder()
 *                         .customImages(List.of(CustomImageProperty.builder()
 *                                 .appImageConfigName("appImageConfigName")
 *                                 .imageName("imageName")
 *                                 // the properties below are optional
 *                                 .imageVersionNumber(123)
 *                                 .build()))
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .lifecycleConfigArns(List.of("lifecycleConfigArns"))
 *                         .build())
 *                 .rSessionAppSettings(RSessionAppSettingsProperty.builder()
 *                         .customImages(List.of(CustomImageProperty.builder()
 *                                 .appImageConfigName("appImageConfigName")
 *                                 .imageName("imageName")
 *                                 // the properties below are optional
 *                                 .imageVersionNumber(123)
 *                                 .build()))
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .build())
 *                 .rStudioServerProAppSettings(RStudioServerProAppSettingsProperty.builder()
 *                         .accessStatus("accessStatus")
 *                         .userGroup("userGroup")
 *                         .build())
 *                 .securityGroups(List.of("securityGroups"))
 *                 .sharingSettings(SharingSettingsProperty.builder()
 *                         .notebookOutputOption("notebookOutputOption")
 *                         .s3KmsKeyId("s3KmsKeyId")
 *                         .s3OutputPath("s3OutputPath")
 *                         .build())
 *                 .spaceStorageSettings(DefaultSpaceStorageSettingsProperty.builder()
 *                         .defaultEbsStorageSettings(DefaultEbsStorageSettingsProperty.builder()
 *                                 .defaultEbsVolumeSizeInGb(123)
 *                                 .maximumEbsVolumeSizeInGb(123)
 *                                 .build())
 *                         .build())
 *                 .studioWebPortal("studioWebPortal")
 *                 .studioWebPortalSettings(StudioWebPortalSettingsProperty.builder()
 *                         .hiddenAppTypes(List.of("hiddenAppTypes"))
 *                         .hiddenMlTools(List.of("hiddenMlTools"))
 *                         .build())
 *                 .build())
 *         .domainName("domainName")
 *         .subnetIds(List.of("subnetIds"))
 *         .vpcId("vpcId")
 *         // the properties below are optional
 *         .appNetworkAccessType("appNetworkAccessType")
 *         .appSecurityGroupManagement("appSecurityGroupManagement")
 *         .defaultSpaceSettings(DefaultSpaceSettingsProperty.builder()
 *                 .executionRole("executionRole")
 *                 // the properties below are optional
 *                 .customFileSystemConfigs(List.of(CustomFileSystemConfigProperty.builder()
 *                         .efsFileSystemConfig(EFSFileSystemConfigProperty.builder()
 *                                 .fileSystemId("fileSystemId")
 *                                 // the properties below are optional
 *                                 .fileSystemPath("fileSystemPath")
 *                                 .build())
 *                         .fSxLustreFileSystemConfig(FSxLustreFileSystemConfigProperty.builder()
 *                                 .fileSystemId("fileSystemId")
 *                                 // the properties below are optional
 *                                 .fileSystemPath("fileSystemPath")
 *                                 .build())
 *                         .build()))
 *                 .customPosixUserConfig(CustomPosixUserConfigProperty.builder()
 *                         .gid(123)
 *                         .uid(123)
 *                         .build())
 *                 .jupyterLabAppSettings(JupyterLabAppSettingsProperty.builder()
 *                         .appLifecycleManagement(AppLifecycleManagementProperty.builder()
 *                                 .idleSettings(IdleSettingsProperty.builder()
 *                                         .idleTimeoutInMinutes(123)
 *                                         .lifecycleManagement("lifecycleManagement")
 *                                         .maxIdleTimeoutInMinutes(123)
 *                                         .minIdleTimeoutInMinutes(123)
 *                                         .build())
 *                                 .build())
 *                         .codeRepositories(List.of(CodeRepositoryProperty.builder()
 *                                 .repositoryUrl("repositoryUrl")
 *                                 .build()))
 *                         .customImages(List.of(CustomImageProperty.builder()
 *                                 .appImageConfigName("appImageConfigName")
 *                                 .imageName("imageName")
 *                                 // the properties below are optional
 *                                 .imageVersionNumber(123)
 *                                 .build()))
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .lifecycleConfigArns(List.of("lifecycleConfigArns"))
 *                         .build())
 *                 .jupyterServerAppSettings(JupyterServerAppSettingsProperty.builder()
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .lifecycleConfigArns(List.of("lifecycleConfigArns"))
 *                         .build())
 *                 .kernelGatewayAppSettings(KernelGatewayAppSettingsProperty.builder()
 *                         .customImages(List.of(CustomImageProperty.builder()
 *                                 .appImageConfigName("appImageConfigName")
 *                                 .imageName("imageName")
 *                                 // the properties below are optional
 *                                 .imageVersionNumber(123)
 *                                 .build()))
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .lifecycleConfigArns(List.of("lifecycleConfigArns"))
 *                         .build())
 *                 .securityGroups(List.of("securityGroups"))
 *                 .spaceStorageSettings(DefaultSpaceStorageSettingsProperty.builder()
 *                         .defaultEbsStorageSettings(DefaultEbsStorageSettingsProperty.builder()
 *                                 .defaultEbsVolumeSizeInGb(123)
 *                                 .maximumEbsVolumeSizeInGb(123)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .domainSettings(DomainSettingsProperty.builder()
 *                 .dockerSettings(DockerSettingsProperty.builder()
 *                         .enableDockerAccess("enableDockerAccess")
 *                         .vpcOnlyTrustedAccounts(List.of("vpcOnlyTrustedAccounts"))
 *                         .build())
 *                 .executionRoleIdentityConfig("executionRoleIdentityConfig")
 *                 .rStudioServerProDomainSettings(RStudioServerProDomainSettingsProperty.builder()
 *                         .domainExecutionRoleArn("domainExecutionRoleArn")
 *                         // the properties below are optional
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .rStudioConnectUrl("rStudioConnectUrl")
 *                         .rStudioPackageManagerUrl("rStudioPackageManagerUrl")
 *                         .build())
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .build())
 *         .kmsKeyId("kmsKeyId")
 *         .tagPropagation("tagPropagation")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:46.671Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnDomainProps")
@software.amazon.jsii.Jsii.Proxy(CfnDomainProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDomainProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The mode of authentication that members use to access the Domain.
     * <p>
     * <em>Valid Values</em> : <code>SSO | IAM</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-authmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-authmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAuthMode();

    /**
     * The default user settings.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-defaultusersettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-defaultusersettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDefaultUserSettings();

    /**
     * The domain name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-domainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-domainname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

    /**
     * The VPC subnets that Studio uses for communication.
     * <p>
     * <em>Length Constraints</em> : Maximum length of 32.
     * <p>
     * <em>Array members</em> : Minimum number of 1 item. Maximum number of 16 items.
     * <p>
     * <em>Pattern</em> : <code>[-0-9a-zA-Z]+</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-subnetids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-subnetids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnetIds();

    /**
     * The ID of the Amazon Virtual Private Cloud (Amazon VPC) that Studio uses for communication.
     * <p>
     * <em>Length Constraints</em> : Maximum length of 32.
     * <p>
     * <em>Pattern</em> : <code>[-0-9a-zA-Z]+</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-vpcid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-vpcid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVpcId();

    /**
     * Specifies the VPC used for non-EFS traffic. The default value is <code>PublicInternetOnly</code> .
     * <p>
     * <ul>
     * <li><code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker AI , which allows direct internet access</li>
     * <li><code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets</li>
     * </ul>
     * <p>
     * <em>Valid Values</em> : <code>PublicInternetOnly | VpcOnly</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-appnetworkaccesstype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-appnetworkaccesstype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAppNetworkAccessType() {
        return null;
    }

    /**
     * The entity that creates and manages the required security groups for inter-app communication in <code>VpcOnly</code> mode.
     * <p>
     * Required when <code>CreateDomain.AppNetworkAccessType</code> is <code>VpcOnly</code> and <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided. If setting up the domain for use with RStudio, this value must be set to <code>Service</code> .
     * <p>
     * <em>Allowed Values</em> : <code>Service</code> | <code>Customer</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-appsecuritygroupmanagement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-appsecuritygroupmanagement</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAppSecurityGroupManagement() {
        return null;
    }

    /**
     * The default settings for shared spaces that users create in the domain.
     * <p>
     * SageMaker applies these settings only to shared spaces. It doesn't apply them to private spaces.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-defaultspacesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-defaultspacesettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultSpaceSettings() {
        return null;
    }

    /**
     * A collection of settings that apply to the <code>SageMaker Domain</code> .
     * <p>
     * These settings are specified through the <code>CreateDomain</code> API call.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-domainsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-domainsettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDomainSettings() {
        return null;
    }

    /**
     * SageMaker uses AWS KMS to encrypt the EFS volume attached to the Domain with an AWS managed customer master key (CMK) by default.
     * <p>
     * For more control, specify a customer managed CMK.
     * <p>
     * <em>Length Constraints</em> : Maximum length of 2048.
     * <p>
     * <em>Pattern</em> : <code>.*</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-kmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * Indicates whether the tags added to Domain, User Profile and Space entity is propagated to all SageMaker resources.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-tagpropagation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-tagpropagation</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTagPropagation() {
        return null;
    }

    /**
     * Tags to associated with the Domain.
     * <p>
     * Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the Search API.
     * <p>
     * Tags that you specify for the Domain are also added to all apps that are launched in the Domain.
     * <p>
     * <em>Array members</em> : Minimum number of 0 items. Maximum number of 50 items.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDomainProps> {
        java.lang.String authMode;
        java.lang.Object defaultUserSettings;
        java.lang.String domainName;
        java.util.List<java.lang.String> subnetIds;
        java.lang.String vpcId;
        java.lang.String appNetworkAccessType;
        java.lang.String appSecurityGroupManagement;
        java.lang.Object defaultSpaceSettings;
        java.lang.Object domainSettings;
        java.lang.String kmsKeyId;
        java.lang.String tagPropagation;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDomainProps#getAuthMode}
         * @param authMode The mode of authentication that members use to access the Domain. This parameter is required.
         *                 <em>Valid Values</em> : <code>SSO | IAM</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authMode(java.lang.String authMode) {
            this.authMode = authMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getDefaultUserSettings}
         * @param defaultUserSettings The default user settings. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultUserSettings(software.amazon.awscdk.IResolvable defaultUserSettings) {
            this.defaultUserSettings = defaultUserSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getDefaultUserSettings}
         * @param defaultUserSettings The default user settings. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultUserSettings(software.amazon.awscdk.services.sagemaker.CfnDomain.UserSettingsProperty defaultUserSettings) {
            this.defaultUserSettings = defaultUserSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getDomainName}
         * @param domainName The domain name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getSubnetIds}
         * @param subnetIds The VPC subnets that Studio uses for communication. This parameter is required.
         *                  <em>Length Constraints</em> : Maximum length of 32.
         *                  <p>
         *                  <em>Array members</em> : Minimum number of 1 item. Maximum number of 16 items.
         *                  <p>
         *                  <em>Pattern</em> : <code>[-0-9a-zA-Z]+</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
            this.subnetIds = subnetIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getVpcId}
         * @param vpcId The ID of the Amazon Virtual Private Cloud (Amazon VPC) that Studio uses for communication. This parameter is required.
         *              <em>Length Constraints</em> : Maximum length of 32.
         *              <p>
         *              <em>Pattern</em> : <code>[-0-9a-zA-Z]+</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getAppNetworkAccessType}
         * @param appNetworkAccessType Specifies the VPC used for non-EFS traffic. The default value is <code>PublicInternetOnly</code> .
         *                             <ul>
         *                             <li><code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker AI , which allows direct internet access</li>
         *                             <li><code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets</li>
         *                             </ul>
         *                             <p>
         *                             <em>Valid Values</em> : <code>PublicInternetOnly | VpcOnly</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appNetworkAccessType(java.lang.String appNetworkAccessType) {
            this.appNetworkAccessType = appNetworkAccessType;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getAppSecurityGroupManagement}
         * @param appSecurityGroupManagement The entity that creates and manages the required security groups for inter-app communication in <code>VpcOnly</code> mode.
         *                                   Required when <code>CreateDomain.AppNetworkAccessType</code> is <code>VpcOnly</code> and <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided. If setting up the domain for use with RStudio, this value must be set to <code>Service</code> .
         *                                   <p>
         *                                   <em>Allowed Values</em> : <code>Service</code> | <code>Customer</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appSecurityGroupManagement(java.lang.String appSecurityGroupManagement) {
            this.appSecurityGroupManagement = appSecurityGroupManagement;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getDefaultSpaceSettings}
         * @param defaultSpaceSettings The default settings for shared spaces that users create in the domain.
         *                             SageMaker applies these settings only to shared spaces. It doesn't apply them to private spaces.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultSpaceSettings(software.amazon.awscdk.IResolvable defaultSpaceSettings) {
            this.defaultSpaceSettings = defaultSpaceSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getDefaultSpaceSettings}
         * @param defaultSpaceSettings The default settings for shared spaces that users create in the domain.
         *                             SageMaker applies these settings only to shared spaces. It doesn't apply them to private spaces.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultSpaceSettings(software.amazon.awscdk.services.sagemaker.CfnDomain.DefaultSpaceSettingsProperty defaultSpaceSettings) {
            this.defaultSpaceSettings = defaultSpaceSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getDomainSettings}
         * @param domainSettings A collection of settings that apply to the <code>SageMaker Domain</code> .
         *                       These settings are specified through the <code>CreateDomain</code> API call.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainSettings(software.amazon.awscdk.IResolvable domainSettings) {
            this.domainSettings = domainSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getDomainSettings}
         * @param domainSettings A collection of settings that apply to the <code>SageMaker Domain</code> .
         *                       These settings are specified through the <code>CreateDomain</code> API call.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainSettings(software.amazon.awscdk.services.sagemaker.CfnDomain.DomainSettingsProperty domainSettings) {
            this.domainSettings = domainSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getKmsKeyId}
         * @param kmsKeyId SageMaker uses AWS KMS to encrypt the EFS volume attached to the Domain with an AWS managed customer master key (CMK) by default.
         *                 For more control, specify a customer managed CMK.
         *                 <p>
         *                 <em>Length Constraints</em> : Maximum length of 2048.
         *                 <p>
         *                 <em>Pattern</em> : <code>.*</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getTagPropagation}
         * @param tagPropagation Indicates whether the tags added to Domain, User Profile and Space entity is propagated to all SageMaker resources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagPropagation(java.lang.String tagPropagation) {
            this.tagPropagation = tagPropagation;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getTags}
         * @param tags Tags to associated with the Domain.
         *             Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the Search API.
         *             <p>
         *             Tags that you specify for the Domain are also added to all apps that are launched in the Domain.
         *             <p>
         *             <em>Array members</em> : Minimum number of 0 items. Maximum number of 50 items.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDomainProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDomainProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDomainProps {
        private final java.lang.String authMode;
        private final java.lang.Object defaultUserSettings;
        private final java.lang.String domainName;
        private final java.util.List<java.lang.String> subnetIds;
        private final java.lang.String vpcId;
        private final java.lang.String appNetworkAccessType;
        private final java.lang.String appSecurityGroupManagement;
        private final java.lang.Object defaultSpaceSettings;
        private final java.lang.Object domainSettings;
        private final java.lang.String kmsKeyId;
        private final java.lang.String tagPropagation;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authMode = software.amazon.jsii.Kernel.get(this, "authMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultUserSettings = software.amazon.jsii.Kernel.get(this, "defaultUserSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.appNetworkAccessType = software.amazon.jsii.Kernel.get(this, "appNetworkAccessType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.appSecurityGroupManagement = software.amazon.jsii.Kernel.get(this, "appSecurityGroupManagement", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultSpaceSettings = software.amazon.jsii.Kernel.get(this, "defaultSpaceSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.domainSettings = software.amazon.jsii.Kernel.get(this, "domainSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tagPropagation = software.amazon.jsii.Kernel.get(this, "tagPropagation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authMode = java.util.Objects.requireNonNull(builder.authMode, "authMode is required");
            this.defaultUserSettings = java.util.Objects.requireNonNull(builder.defaultUserSettings, "defaultUserSettings is required");
            this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
            this.subnetIds = java.util.Objects.requireNonNull(builder.subnetIds, "subnetIds is required");
            this.vpcId = java.util.Objects.requireNonNull(builder.vpcId, "vpcId is required");
            this.appNetworkAccessType = builder.appNetworkAccessType;
            this.appSecurityGroupManagement = builder.appSecurityGroupManagement;
            this.defaultSpaceSettings = builder.defaultSpaceSettings;
            this.domainSettings = builder.domainSettings;
            this.kmsKeyId = builder.kmsKeyId;
            this.tagPropagation = builder.tagPropagation;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getAuthMode() {
            return this.authMode;
        }

        @Override
        public final java.lang.Object getDefaultUserSettings() {
            return this.defaultUserSettings;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final java.util.List<java.lang.String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final java.lang.String getAppNetworkAccessType() {
            return this.appNetworkAccessType;
        }

        @Override
        public final java.lang.String getAppSecurityGroupManagement() {
            return this.appSecurityGroupManagement;
        }

        @Override
        public final java.lang.Object getDefaultSpaceSettings() {
            return this.defaultSpaceSettings;
        }

        @Override
        public final java.lang.Object getDomainSettings() {
            return this.domainSettings;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.String getTagPropagation() {
            return this.tagPropagation;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("authMode", om.valueToTree(this.getAuthMode()));
            data.set("defaultUserSettings", om.valueToTree(this.getDefaultUserSettings()));
            data.set("domainName", om.valueToTree(this.getDomainName()));
            data.set("subnetIds", om.valueToTree(this.getSubnetIds()));
            data.set("vpcId", om.valueToTree(this.getVpcId()));
            if (this.getAppNetworkAccessType() != null) {
                data.set("appNetworkAccessType", om.valueToTree(this.getAppNetworkAccessType()));
            }
            if (this.getAppSecurityGroupManagement() != null) {
                data.set("appSecurityGroupManagement", om.valueToTree(this.getAppSecurityGroupManagement()));
            }
            if (this.getDefaultSpaceSettings() != null) {
                data.set("defaultSpaceSettings", om.valueToTree(this.getDefaultSpaceSettings()));
            }
            if (this.getDomainSettings() != null) {
                data.set("domainSettings", om.valueToTree(this.getDomainSettings()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getTagPropagation() != null) {
                data.set("tagPropagation", om.valueToTree(this.getTagPropagation()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnDomainProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDomainProps.Jsii$Proxy that = (CfnDomainProps.Jsii$Proxy) o;

            if (!authMode.equals(that.authMode)) return false;
            if (!defaultUserSettings.equals(that.defaultUserSettings)) return false;
            if (!domainName.equals(that.domainName)) return false;
            if (!subnetIds.equals(that.subnetIds)) return false;
            if (!vpcId.equals(that.vpcId)) return false;
            if (this.appNetworkAccessType != null ? !this.appNetworkAccessType.equals(that.appNetworkAccessType) : that.appNetworkAccessType != null) return false;
            if (this.appSecurityGroupManagement != null ? !this.appSecurityGroupManagement.equals(that.appSecurityGroupManagement) : that.appSecurityGroupManagement != null) return false;
            if (this.defaultSpaceSettings != null ? !this.defaultSpaceSettings.equals(that.defaultSpaceSettings) : that.defaultSpaceSettings != null) return false;
            if (this.domainSettings != null ? !this.domainSettings.equals(that.domainSettings) : that.domainSettings != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.tagPropagation != null ? !this.tagPropagation.equals(that.tagPropagation) : that.tagPropagation != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authMode.hashCode();
            result = 31 * result + (this.defaultUserSettings.hashCode());
            result = 31 * result + (this.domainName.hashCode());
            result = 31 * result + (this.subnetIds.hashCode());
            result = 31 * result + (this.vpcId.hashCode());
            result = 31 * result + (this.appNetworkAccessType != null ? this.appNetworkAccessType.hashCode() : 0);
            result = 31 * result + (this.appSecurityGroupManagement != null ? this.appSecurityGroupManagement.hashCode() : 0);
            result = 31 * result + (this.defaultSpaceSettings != null ? this.defaultSpaceSettings.hashCode() : 0);
            result = 31 * result + (this.domainSettings != null ? this.domainSettings.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.tagPropagation != null ? this.tagPropagation.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
