package software.amazon.awscdk.services.ses;

/**
 * A configuration set event destination.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.*;
 * ConfigurationSet configurationSet;
 * EventDestination eventDestination;
 * ConfigurationSetEventDestination configurationSetEventDestination = ConfigurationSetEventDestination.Builder.create(this, "MyConfigurationSetEventDestination")
 *         .configurationSet(configurationSet)
 *         .destination(eventDestination)
 *         // the properties below are optional
 *         .configurationSetEventDestinationName("configurationSetEventDestinationName")
 *         .enabled(false)
 *         .events(List.of(EmailSendingEvent.SEND))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:47.460Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.ConfigurationSetEventDestination")
public class ConfigurationSetEventDestination extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.ses.IConfigurationSetEventDestination {

    protected ConfigurationSetEventDestination(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ConfigurationSetEventDestination(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ConfigurationSetEventDestination(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.ConfigurationSetEventDestinationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Use an existing configuration set.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param configurationSetEventDestinationId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.IConfigurationSetEventDestination fromConfigurationSetEventDestinationId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String configurationSetEventDestinationId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ses.ConfigurationSetEventDestination.class, "fromConfigurationSetEventDestinationId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.IConfigurationSetEventDestination.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(configurationSetEventDestinationId, "configurationSetEventDestinationId is required") });
    }

    /**
     * The ID of the configuration set event destination.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getConfigurationSetEventDestinationId() {
        return software.amazon.jsii.Kernel.get(this, "configurationSetEventDestinationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ses.ConfigurationSetEventDestination}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ses.ConfigurationSetEventDestination> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ses.ConfigurationSetEventDestinationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ses.ConfigurationSetEventDestinationProps.Builder();
        }

        /**
         * The event destination.
         * <p>
         * @return {@code this}
         * @param destination The event destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destination(final software.amazon.awscdk.services.ses.EventDestination destination) {
            this.props.destination(destination);
            return this;
        }

        /**
         * A name for the configuration set event destination.
         * <p>
         * Default: - a CloudFormation generated name
         * <p>
         * @return {@code this}
         * @param configurationSetEventDestinationName A name for the configuration set event destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationSetEventDestinationName(final java.lang.String configurationSetEventDestinationName) {
            this.props.configurationSetEventDestinationName(configurationSetEventDestinationName);
            return this;
        }

        /**
         * Whether Amazon SES publishes events to this destination.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enabled Whether Amazon SES publishes events to this destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }

        /**
         * The type of email sending events to publish to the event destination.
         * <p>
         * Default: - send all event types
         * <p>
         * @return {@code this}
         * @param events The type of email sending events to publish to the event destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder events(final java.util.List<? extends software.amazon.awscdk.services.ses.EmailSendingEvent> events) {
            this.props.events(events);
            return this;
        }

        /**
         * The configuration set that contains the event destination.
         * <p>
         * @return {@code this}
         * @param configurationSet The configuration set that contains the event destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationSet(final software.amazon.awscdk.services.ses.IConfigurationSet configurationSet) {
            this.props.configurationSet(configurationSet);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ses.ConfigurationSetEventDestination}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ses.ConfigurationSetEventDestination build() {
            return new software.amazon.awscdk.services.ses.ConfigurationSetEventDestination(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
