package software.amazon.awscdk.services.ses.actions;

/**
 * Rejects the received email by returning a bounce response to the sender and, optionally, publishes a notification to Amazon SNS.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.actions.*;
 * import software.amazon.awscdk.services.sns.*;
 * BounceTemplate bounceTemplate;
 * Topic topic;
 * Bounce bounce = Bounce.Builder.create()
 *         .sender("sender")
 *         .template(bounceTemplate)
 *         // the properties below are optional
 *         .topic(topic)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:47.481Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses_actions.Bounce")
public class Bounce extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ses.IReceiptRuleAction {

    protected Bounce(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Bounce(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Bounce(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.actions.BounceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Returns the receipt rule action specification.
     * <p>
     * @param _rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.ReceiptRuleActionConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.IReceiptRule _rule) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.ReceiptRuleActionConfig.class), new Object[] { java.util.Objects.requireNonNull(_rule, "_rule is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ses.actions.Bounce}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ses.actions.Bounce> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.ses.actions.BounceProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.ses.actions.BounceProps.Builder();
        }

        /**
         * The email address of the sender of the bounced email.
         * <p>
         * This is the address
         * from which the bounce message will be sent.
         * <p>
         * @return {@code this}
         * @param sender The email address of the sender of the bounced email. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sender(final java.lang.String sender) {
            this.props.sender(sender);
            return this;
        }

        /**
         * The template containing the message, reply code and status code.
         * <p>
         * @return {@code this}
         * @param template The template containing the message, reply code and status code. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder template(final software.amazon.awscdk.services.ses.actions.BounceTemplate template) {
            this.props.template(template);
            return this;
        }

        /**
         * The SNS topic to notify when the bounce action is taken.
         * <p>
         * Default: no notification
         * <p>
         * @return {@code this}
         * @param topic The SNS topic to notify when the bounce action is taken. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topic(final software.amazon.awscdk.services.sns.ITopic topic) {
            this.props.topic(topic);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ses.actions.Bounce}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ses.actions.Bounce build() {
            return new software.amazon.awscdk.services.ses.actions.Bounce(
                this.props.build()
            );
        }
    }
}
