package software.amazon.awscdk.services.stepfunctions;

/**
 * Base class for all other state classes.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:47.849Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.State")
public abstract class State extends software.constructs.Construct implements software.amazon.awscdk.services.stepfunctions.IChainable {

    protected State(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected State(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id Descriptive identifier for this chainable. This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected State(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Return only the states that allow chaining from an array of states.
     * <p>
     * @param states This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.INextable> filterNextables(final @org.jetbrains.annotations.NotNull java.util.List<? extends software.amazon.awscdk.services.stepfunctions.State> states) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.State.class, "filterNextables", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.INextable.class)), new Object[] { java.util.Objects.requireNonNull(states, "states is required") }));
    }

    /**
     * Find the set of end states states reachable through transitions from the given start state.
     * <p>
     * @param start This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.State> findReachableEndStates(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.State start, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.FindStateOptions options) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.State.class, "findReachableEndStates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.State.class)), new Object[] { java.util.Objects.requireNonNull(start, "start is required"), options }));
    }

    /**
     * Find the set of end states states reachable through transitions from the given start state.
     * <p>
     * @param start This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.State> findReachableEndStates(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.State start) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.State.class, "findReachableEndStates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.State.class)), new Object[] { java.util.Objects.requireNonNull(start, "start is required") }));
    }

    /**
     * Find the set of states reachable through transitions from the given start state.
     * <p>
     * This does not retrieve states from within sub-graphs, such as states within a Parallel state's branch.
     * <p>
     * @param start This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.State> findReachableStates(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.State start, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.FindStateOptions options) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.State.class, "findReachableStates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.State.class)), new Object[] { java.util.Objects.requireNonNull(start, "start is required"), options }));
    }

    /**
     * Find the set of states reachable through transitions from the given start state.
     * <p>
     * This does not retrieve states from within sub-graphs, such as states within a Parallel state's branch.
     * <p>
     * @param start This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.State> findReachableStates(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.State start) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.State.class, "findReachableStates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.State.class)), new Object[] { java.util.Objects.requireNonNull(start, "start is required") }));
    }

    /**
     * Add a prefix to the stateId of all States found in a construct tree.
     * <p>
     * @param root This parameter is required.
     * @param prefix This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static void prefixStates(final @org.jetbrains.annotations.NotNull software.constructs.IConstruct root, final @org.jetbrains.annotations.NotNull java.lang.String prefix) {
        software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.State.class, "prefixStates", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(root, "root is required"), java.util.Objects.requireNonNull(prefix, "prefix is required") });
    }

    /**
     * Add a parallel branch to this state.
     * <p>
     * @param branch This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void addBranch(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StateGraph branch) {
        software.amazon.jsii.Kernel.call(this, "addBranch", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(branch, "branch is required") });
    }

    /**
     * Add a choice branch to this state.
     * <p>
     * @param condition This parameter is required.
     * @param next This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void addChoice(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition condition, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.State next, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.ChoiceTransitionOptions options) {
        software.amazon.jsii.Kernel.call(this, "addChoice", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(condition, "condition is required"), java.util.Objects.requireNonNull(next, "next is required"), options });
    }

    /**
     * Add a choice branch to this state.
     * <p>
     * @param condition This parameter is required.
     * @param next This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void addChoice(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition condition, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.State next) {
        software.amazon.jsii.Kernel.call(this, "addChoice", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(condition, "condition is required"), java.util.Objects.requireNonNull(next, "next is required") });
    }

    /**
     * Add a item processor to this state.
     * <p>
     * @param processor This parameter is required.
     * @param config
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void addItemProcessor(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StateGraph processor, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.ProcessorConfig config) {
        software.amazon.jsii.Kernel.call(this, "addItemProcessor", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(processor, "processor is required"), config });
    }

    /**
     * Add a item processor to this state.
     * <p>
     * @param processor This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void addItemProcessor(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StateGraph processor) {
        software.amazon.jsii.Kernel.call(this, "addItemProcessor", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(processor, "processor is required") });
    }

    /**
     * Add a map iterator to this state.
     * <p>
     * @param iteration This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void addIterator(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StateGraph iteration) {
        software.amazon.jsii.Kernel.call(this, "addIterator", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(iteration, "iteration is required") });
    }

    /**
     * Add a prefix to the stateId of this state.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addPrefix(final @org.jetbrains.annotations.NotNull java.lang.String x) {
        software.amazon.jsii.Kernel.call(this, "addPrefix", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(x, "x is required") });
    }

    /**
     * Register this state as part of the given graph.
     * <p>
     * Don't call this. It will be called automatically when you work
     * with states normally.
     * <p>
     * @param graph This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void bindToGraph(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StateGraph graph) {
        software.amazon.jsii.Kernel.call(this, "bindToGraph", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(graph, "graph is required") });
    }

    /**
     * Make the indicated state the default choice transition of this state.
     * <p>
     * @param def This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void makeDefault(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.State def) {
        software.amazon.jsii.Kernel.call(this, "makeDefault", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(def, "def is required") });
    }

    /**
     * Make the indicated state the default transition of this state.
     * <p>
     * @param next This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void makeNext(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.State next) {
        software.amazon.jsii.Kernel.call(this, "makeNext", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(next, "next is required") });
    }

    /**
     * Render the assign in ASL JSON format.
     * <p>
     * @param topLevelQueryLanguage
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Object renderAssign(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.QueryLanguage topLevelQueryLanguage) {
        return software.amazon.jsii.Kernel.call(this, "renderAssign", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), new Object[] { topLevelQueryLanguage });
    }

    /**
     * Render the assign in ASL JSON format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Object renderAssign() {
        return software.amazon.jsii.Kernel.call(this, "renderAssign", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Render parallel branches in ASL JSON format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Object renderBranches() {
        return software.amazon.jsii.Kernel.call(this, "renderBranches", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Render the choices in ASL JSON format.
     * <p>
     * @param topLevelQueryLanguage
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Object renderChoices(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.QueryLanguage topLevelQueryLanguage) {
        return software.amazon.jsii.Kernel.call(this, "renderChoices", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), new Object[] { topLevelQueryLanguage });
    }

    /**
     * Render the choices in ASL JSON format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Object renderChoices() {
        return software.amazon.jsii.Kernel.call(this, "renderChoices", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Render InputPath/Parameters/OutputPath/Arguments/Output in ASL JSON format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Object renderInputOutput() {
        return software.amazon.jsii.Kernel.call(this, "renderInputOutput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Render ItemProcessor in ASL JSON format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Object renderItemProcessor() {
        return software.amazon.jsii.Kernel.call(this, "renderItemProcessor", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Render map iterator in ASL JSON format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Object renderIterator() {
        return software.amazon.jsii.Kernel.call(this, "renderIterator", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Render the default next state in ASL JSON format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Object renderNextEnd() {
        return software.amazon.jsii.Kernel.call(this, "renderNextEnd", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Render QueryLanguage in ASL JSON format if needed.
     * <p>
     * @param topLevelQueryLanguage
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Object renderQueryLanguage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.QueryLanguage topLevelQueryLanguage) {
        return software.amazon.jsii.Kernel.call(this, "renderQueryLanguage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), new Object[] { topLevelQueryLanguage });
    }

    /**
     * Render QueryLanguage in ASL JSON format if needed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Object renderQueryLanguage() {
        return software.amazon.jsii.Kernel.call(this, "renderQueryLanguage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Render ResultSelector in ASL JSON format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Object renderResultSelector() {
        return software.amazon.jsii.Kernel.call(this, "renderResultSelector", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Render error recovery options in ASL JSON format.
     * <p>
     * @param topLevelQueryLanguage
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Object renderRetryCatch(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.QueryLanguage topLevelQueryLanguage) {
        return software.amazon.jsii.Kernel.call(this, "renderRetryCatch", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), new Object[] { topLevelQueryLanguage });
    }

    /**
     * Render error recovery options in ASL JSON format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Object renderRetryCatch() {
        return software.amazon.jsii.Kernel.call(this, "renderRetryCatch", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Render the state as JSON.
     * <p>
     * @param stateMachineQueryLanguage
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull com.fasterxml.jackson.databind.node.ObjectNode toStateJson(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.QueryLanguage stateMachineQueryLanguage);

    /**
     * Render the state as JSON.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull com.fasterxml.jackson.databind.node.ObjectNode toStateJson();

    /**
     * Allows the state to validate itself.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validateState() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validateState", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Called whenever this state is bound to a graph.
     * <p>
     * Can be overridden by subclasses.
     * <p>
     * @param graph This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void whenBoundToGraph(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StateGraph graph) {
        software.amazon.jsii.Kernel.call(this, "whenBoundToGraph", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(graph, "graph is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.StateGraph> getBranches() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "branches", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.StateGraph.class))));
    }

    /**
     * Continuable states of this Chainable.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.INextable> getEndStates();

    /**
     * Descriptive identifier for this chainable.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getId() {
        return software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * First state of this Chainable.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.State getStartState() {
        return software.amazon.jsii.Kernel.get(this, "startState", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.State.class));
    }

    /**
     * Tokenized string that evaluates to the state's ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStateId() {
        return software.amazon.jsii.Kernel.get(this, "stateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable com.fasterxml.jackson.databind.node.ObjectNode getArguments() {
        return software.amazon.jsii.Kernel.get(this, "arguments", software.amazon.jsii.NativeType.forClass(com.fasterxml.jackson.databind.node.ObjectNode.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable com.fasterxml.jackson.databind.node.ObjectNode getAssign() {
        return software.amazon.jsii.Kernel.get(this, "assign", software.amazon.jsii.NativeType.forClass(com.fasterxml.jackson.databind.node.ObjectNode.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.lang.String getComment() {
        return software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.lang.String getInputPath() {
        return software.amazon.jsii.Kernel.get(this, "inputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.lang.String getOutputPath() {
        return software.amazon.jsii.Kernel.get(this, "outputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable com.fasterxml.jackson.databind.node.ObjectNode getOutputs() {
        return software.amazon.jsii.Kernel.get(this, "outputs", software.amazon.jsii.NativeType.forClass(com.fasterxml.jackson.databind.node.ObjectNode.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable com.fasterxml.jackson.databind.node.ObjectNode getParameters() {
        return software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(com.fasterxml.jackson.databind.node.ObjectNode.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.QueryLanguage getQueryLanguage() {
        return software.amazon.jsii.Kernel.get(this, "queryLanguage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.QueryLanguage.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.lang.String getResultPath() {
        return software.amazon.jsii.Kernel.get(this, "resultPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable com.fasterxml.jackson.databind.node.ObjectNode getResultSelector() {
        return software.amazon.jsii.Kernel.get(this, "resultSelector", software.amazon.jsii.NativeType.forClass(com.fasterxml.jackson.databind.node.ObjectNode.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.lang.String getStateName() {
        return software.amazon.jsii.Kernel.get(this, "stateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.State getDefaultChoice() {
        return software.amazon.jsii.Kernel.get(this, "defaultChoice", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.State.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setDefaultChoice(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.State value) {
        software.amazon.jsii.Kernel.set(this, "defaultChoice", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.StateGraph getIteration() {
        return software.amazon.jsii.Kernel.get(this, "iteration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.StateGraph.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setIteration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.StateGraph value) {
        software.amazon.jsii.Kernel.set(this, "iteration", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.StateGraph getProcessor() {
        return software.amazon.jsii.Kernel.get(this, "processor", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.StateGraph.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setProcessor(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.StateGraph value) {
        software.amazon.jsii.Kernel.set(this, "processor", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.ProcessorConfig getProcessorConfig() {
        return software.amazon.jsii.Kernel.get(this, "processorConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.ProcessorConfig.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setProcessorConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.ProcessorConfig value) {
        software.amazon.jsii.Kernel.set(this, "processorConfig", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.ProcessorMode getProcessorMode() {
        return software.amazon.jsii.Kernel.get(this, "processorMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.ProcessorMode.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setProcessorMode(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.ProcessorMode value) {
        software.amazon.jsii.Kernel.set(this, "processorMode", value);
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.stepfunctions.State implements software.amazon.awscdk.services.stepfunctions.IChainable.Jsii$Default, software.constructs.IConstruct.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Continuable states of this Chainable.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.INextable> getEndStates() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "endStates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.INextable.class))));
        }

        /**
         * Render the state as JSON.
         * <p>
         * @param stateMachineQueryLanguage
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull com.fasterxml.jackson.databind.node.ObjectNode toStateJson(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.QueryLanguage stateMachineQueryLanguage) {
            return software.amazon.jsii.Kernel.call(this, "toStateJson", software.amazon.jsii.NativeType.forClass(com.fasterxml.jackson.databind.node.ObjectNode.class), new Object[] { stateMachineQueryLanguage });
        }

        /**
         * Render the state as JSON.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull com.fasterxml.jackson.databind.node.ObjectNode toStateJson() {
            return software.amazon.jsii.Kernel.call(this, "toStateJson", software.amazon.jsii.NativeType.forClass(com.fasterxml.jackson.databind.node.ObjectNode.class));
        }
    }
}
