package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Location where the Bedrock InvokeModel API response is written.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.bedrock.*;
 * FoundationModel model = FoundationModel.fromFoundationModelId(this, "Model", FoundationModelIdentifier.AMAZON_TITAN_TEXT_G1_EXPRESS_V1);
 * BedrockInvokeModel task = BedrockInvokeModel.Builder.create(this, "Prompt Model")
 *         .model(model)
 *         .input(BedrockInvokeModelInputProps.builder().s3InputUri(JsonPath.stringAt("$.prompt")).build())
 *         .output(BedrockInvokeModelOutputProps.builder().s3OutputUri(JsonPath.stringAt("$.prompt")).build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-bedrock.html">https://docs.aws.amazon.com/step-functions/latest/dg/connect-bedrock.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:47.957Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.BedrockInvokeModelOutputProps")
@software.amazon.jsii.Jsii.Proxy(BedrockInvokeModelOutputProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BedrockInvokeModelOutputProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * S3 object where the Bedrock InvokeModel API response is written.
     * <p>
     * If you specify this field, the API response body is replaced with
     * a reference to the Amazon S3 location of the original output.
     * <p>
     * Default: - Response body is returned in the task result
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.Location getS3Location() {
        return null;
    }

    /**
     * The destination location where the API response is written.
     * <p>
     * This field can be used to specify s3 URI in the form of token
     * <p>
     * Default: - The API response body is returned in the result.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getS3OutputUri() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BedrockInvokeModelOutputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BedrockInvokeModelOutputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BedrockInvokeModelOutputProps> {
        software.amazon.awscdk.services.s3.Location s3Location;
        java.lang.String s3OutputUri;

        /**
         * Sets the value of {@link BedrockInvokeModelOutputProps#getS3Location}
         * @param s3Location S3 object where the Bedrock InvokeModel API response is written.
         *                   If you specify this field, the API response body is replaced with
         *                   a reference to the Amazon S3 location of the original output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Location(software.amazon.awscdk.services.s3.Location s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        /**
         * Sets the value of {@link BedrockInvokeModelOutputProps#getS3OutputUri}
         * @param s3OutputUri The destination location where the API response is written.
         *                    This field can be used to specify s3 URI in the form of token
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3OutputUri(java.lang.String s3OutputUri) {
            this.s3OutputUri = s3OutputUri;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BedrockInvokeModelOutputProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BedrockInvokeModelOutputProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BedrockInvokeModelOutputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BedrockInvokeModelOutputProps {
        private final software.amazon.awscdk.services.s3.Location s3Location;
        private final java.lang.String s3OutputUri;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.s3Location = software.amazon.jsii.Kernel.get(this, "s3Location", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.Location.class));
            this.s3OutputUri = software.amazon.jsii.Kernel.get(this, "s3OutputUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.s3Location = builder.s3Location;
            this.s3OutputUri = builder.s3OutputUri;
        }

        @Override
        public final software.amazon.awscdk.services.s3.Location getS3Location() {
            return this.s3Location;
        }

        @Override
        public final java.lang.String getS3OutputUri() {
            return this.s3OutputUri;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getS3Location() != null) {
                data.set("s3Location", om.valueToTree(this.getS3Location()));
            }
            if (this.getS3OutputUri() != null) {
                data.set("s3OutputUri", om.valueToTree(this.getS3OutputUri()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.BedrockInvokeModelOutputProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BedrockInvokeModelOutputProps.Jsii$Proxy that = (BedrockInvokeModelOutputProps.Jsii$Proxy) o;

            if (this.s3Location != null ? !this.s3Location.equals(that.s3Location) : that.s3Location != null) return false;
            return this.s3OutputUri != null ? this.s3OutputUri.equals(that.s3OutputUri) : that.s3OutputUri == null;
        }

        @Override
        public final int hashCode() {
            int result = this.s3Location != null ? this.s3Location.hashCode() : 0;
            result = 31 * result + (this.s3OutputUri != null ? this.s3OutputUri.hashCode() : 0);
            return result;
        }
    }
}
