package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * The style used when applying URL encoding to array values.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.events.*;
 * Connection connection = Connection.Builder.create(this, "Connection")
 *         .authorization(Authorization.basic("username", SecretValue.unsafePlainText("password")))
 *         .build();
 * HttpInvoke.Builder.create(this, "Invoke HTTP API")
 *         .apiRoot("https://api.example.com")
 *         .apiEndpoint(TaskInput.fromText("path/to/resource"))
 *         .body(TaskInput.fromObject(Map.of("foo", "bar")))
 *         .connection(connection)
 *         .headers(TaskInput.fromObject(Map.of("Content-Type", "application/json")))
 *         .method(TaskInput.fromText("POST"))
 *         .queryStringParameters(TaskInput.fromObject(Map.of("id", "123")))
 *         .urlEncodingFormat(URLEncodingFormat.BRACKETS)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:48.333Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.URLEncodingFormat")
public enum URLEncodingFormat {
    /**
     * Encode arrays using brackets.
     * <p>
     * For example, {'array': ['a','b','c']} encodes to 'array[]=a&amp;array[]=b&amp;array[]=c'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BRACKETS,
    /**
     * Encode arrays using commas.
     * <p>
     * For example, {'array': ['a','b','c']} encodes to 'array=a,b,c,d'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMMAS,
    /**
     * Apply the default URL encoding style (INDICES).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DEFAULT,
    /**
     * Encode arrays using the index value.
     * <p>
     * For example, {'array': ['a','b','c']} encodes to 'array[0]=a&amp;array[1]=b&amp;array[2]=c'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INDICES,
    /**
     * Do not apply URL encoding.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NONE,
    /**
     * Repeat key for each item in the array.
     * <p>
     * For example, {'array': ['a','b','c']} encodes to 'array[]=a&amp;array[]=b&amp;array[]=c'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REPEAT,
}
