package software.amazon.awscdk.services.transfer;

/**
 * Properties for defining a <code>CfnUser</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.transfer.*;
 * CfnUserProps cfnUserProps = CfnUserProps.builder()
 *         .role("role")
 *         .serverId("serverId")
 *         .userName("userName")
 *         // the properties below are optional
 *         .homeDirectory("homeDirectory")
 *         .homeDirectoryMappings(List.of(HomeDirectoryMapEntryProperty.builder()
 *                 .entry("entry")
 *                 .target("target")
 *                 // the properties below are optional
 *                 .type("type")
 *                 .build()))
 *         .homeDirectoryType("homeDirectoryType")
 *         .policy("policy")
 *         .posixProfile(PosixProfileProperty.builder()
 *                 .gid(123)
 *                 .uid(123)
 *                 // the properties below are optional
 *                 .secondaryGids(List.of(123))
 *                 .build())
 *         .sshPublicKeys(List.of("sshPublicKeys"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:48.439Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnUserProps")
@software.amazon.jsii.Jsii.Proxy(CfnUserProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnUserProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that controls your users' access to your Amazon S3 bucket or Amazon EFS file system.
     * <p>
     * The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or Amazon EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-role">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-role</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRole();

    /**
     * A system-assigned unique identifier for a server instance.
     * <p>
     * This is the specific server that you added your user to.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-serverid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-serverid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServerId();

    /**
     * A unique string that identifies a user and is associated with a <code>ServerId</code> .
     * <p>
     * This user name must be a minimum of 3 and a maximum of 100 characters long. The following are valid characters: a-z, A-Z, 0-9, underscore '_', hyphen '-', period '.', and at sign '&#64;'. The user name can't start with a hyphen, period, or at sign.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-username">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-username</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUserName();

    /**
     * The landing directory (folder) for a user when they log in to the server using the client.
     * <p>
     * A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code> .
     * <p>
     * <blockquote>
     * <p>
     * The <code>HomeDirectory</code> parameter is only used if <code>HomeDirectoryType</code> is set to <code>PATH</code> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-homedirectory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-homedirectory</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHomeDirectory() {
        return null;
    }

    /**
     * Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible.
     * <p>
     * You must specify the <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your AWS Identity and Access Management (IAM) role provides access to paths in <code>Target</code> . This value can be set only when <code>HomeDirectoryType</code> is set to <em>LOGICAL</em> .
     * <p>
     * The following is an <code>Entry</code> and <code>Target</code> pair example.
     * <p>
     * <code>[ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]</code>
     * <p>
     * In most cases, you can use this value instead of the session policy to lock your user down to the designated home directory (" <code>chroot</code> "). To do this, you can set <code>Entry</code> to <code>/</code> and set <code>Target</code> to the value the user should see for their home directory when they log in.
     * <p>
     * The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code> .
     * <p>
     * <code>[ { "Entry": "/", "Target": "/bucket_name/home/mydirectory" } ]</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-homedirectorymappings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-homedirectorymappings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getHomeDirectoryMappings() {
        return null;
    }

    /**
     * The type of landing directory (folder) that you want your users' home directory to be when they log in to the server.
     * <p>
     * If you set it to <code>PATH</code> , the user will see the absolute Amazon S3 bucket or Amazon EFS path as is in their file transfer protocol clients. If you set it to <code>LOGICAL</code> , you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or Amazon EFS paths visible to your users.
     * <p>
     * <blockquote>
     * <p>
     * If <code>HomeDirectoryType</code> is <code>LOGICAL</code> , you must provide mappings, using the <code>HomeDirectoryMappings</code> parameter. If, on the other hand, <code>HomeDirectoryType</code> is <code>PATH</code> , you provide an absolute path using the <code>HomeDirectory</code> parameter. You cannot have both <code>HomeDirectory</code> and <code>HomeDirectoryMappings</code> in your template.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-homedirectorytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-homedirectorytype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHomeDirectoryType() {
        return null;
    }

    /**
     * A session policy for your user so you can use the same IAM role across multiple users.
     * <p>
     * This policy restricts user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code> , <code>${Transfer:HomeDirectory}</code> , and <code>${Transfer:HomeBucket}</code> .
     * <p>
     * <blockquote>
     * <p>
     * For session policies, AWS Transfer Family stores the policy as a JSON blob, instead of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass it in the <code>Policy</code> argument.
     * <p>
     * For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy.html">Example session policy</a> .
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <em>AWS Security Token Service API Reference</em> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-policy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-policy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPolicy() {
        return null;
    }

    /**
     * Specifies the full POSIX identity, including user ID ( <code>Uid</code> ), group ID ( <code>Gid</code> ), and any secondary groups IDs ( <code>SecondaryGids</code> ), that controls your users' access to your Amazon Elastic File System (Amazon EFS) file systems.
     * <p>
     * The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-posixprofile">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-posixprofile</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPosixProfile() {
        return null;
    }

    /**
     * Specifies the public key portion of the Secure Shell (SSH) keys stored for the described user.
     * <p>
     * <blockquote>
     * <p>
     * To delete the public key body, set its value to zero keys, as shown here:
     * <p>
     * <code>SshPublicKeys: []</code>
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-sshpublickeys">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-sshpublickeys</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSshPublicKeys() {
        return null;
    }

    /**
     * Key-value pairs that can be used to group and search for users.
     * <p>
     * Tags are metadata attached to users for any purpose.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnUserProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnUserProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnUserProps> {
        java.lang.String role;
        java.lang.String serverId;
        java.lang.String userName;
        java.lang.String homeDirectory;
        java.lang.Object homeDirectoryMappings;
        java.lang.String homeDirectoryType;
        java.lang.String policy;
        java.lang.Object posixProfile;
        java.util.List<java.lang.String> sshPublicKeys;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnUserProps#getRole}
         * @param role The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that controls your users' access to your Amazon S3 bucket or Amazon EFS file system. This parameter is required.
         *             The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or Amazon EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(java.lang.String role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getServerId}
         * @param serverId A system-assigned unique identifier for a server instance. This parameter is required.
         *                 This is the specific server that you added your user to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverId(java.lang.String serverId) {
            this.serverId = serverId;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getUserName}
         * @param userName A unique string that identifies a user and is associated with a <code>ServerId</code> . This parameter is required.
         *                 This user name must be a minimum of 3 and a maximum of 100 characters long. The following are valid characters: a-z, A-Z, 0-9, underscore '_', hyphen '-', period '.', and at sign '&#64;'. The user name can't start with a hyphen, period, or at sign.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userName(java.lang.String userName) {
            this.userName = userName;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getHomeDirectory}
         * @param homeDirectory The landing directory (folder) for a user when they log in to the server using the client.
         *                      A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code> .
         *                      <p>
         *                      <blockquote>
         *                      <p>
         *                      The <code>HomeDirectory</code> parameter is only used if <code>HomeDirectoryType</code> is set to <code>PATH</code> .
         *                      <p>
         *                      </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder homeDirectory(java.lang.String homeDirectory) {
            this.homeDirectory = homeDirectory;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getHomeDirectoryMappings}
         * @param homeDirectoryMappings Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible.
         *                              You must specify the <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your AWS Identity and Access Management (IAM) role provides access to paths in <code>Target</code> . This value can be set only when <code>HomeDirectoryType</code> is set to <em>LOGICAL</em> .
         *                              <p>
         *                              The following is an <code>Entry</code> and <code>Target</code> pair example.
         *                              <p>
         *                              <code>[ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]</code>
         *                              <p>
         *                              In most cases, you can use this value instead of the session policy to lock your user down to the designated home directory (" <code>chroot</code> "). To do this, you can set <code>Entry</code> to <code>/</code> and set <code>Target</code> to the value the user should see for their home directory when they log in.
         *                              <p>
         *                              The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code> .
         *                              <p>
         *                              <code>[ { "Entry": "/", "Target": "/bucket_name/home/mydirectory" } ]</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder homeDirectoryMappings(software.amazon.awscdk.IResolvable homeDirectoryMappings) {
            this.homeDirectoryMappings = homeDirectoryMappings;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getHomeDirectoryMappings}
         * @param homeDirectoryMappings Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible.
         *                              You must specify the <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your AWS Identity and Access Management (IAM) role provides access to paths in <code>Target</code> . This value can be set only when <code>HomeDirectoryType</code> is set to <em>LOGICAL</em> .
         *                              <p>
         *                              The following is an <code>Entry</code> and <code>Target</code> pair example.
         *                              <p>
         *                              <code>[ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]</code>
         *                              <p>
         *                              In most cases, you can use this value instead of the session policy to lock your user down to the designated home directory (" <code>chroot</code> "). To do this, you can set <code>Entry</code> to <code>/</code> and set <code>Target</code> to the value the user should see for their home directory when they log in.
         *                              <p>
         *                              The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code> .
         *                              <p>
         *                              <code>[ { "Entry": "/", "Target": "/bucket_name/home/mydirectory" } ]</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder homeDirectoryMappings(java.util.List<? extends java.lang.Object> homeDirectoryMappings) {
            this.homeDirectoryMappings = homeDirectoryMappings;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getHomeDirectoryType}
         * @param homeDirectoryType The type of landing directory (folder) that you want your users' home directory to be when they log in to the server.
         *                          If you set it to <code>PATH</code> , the user will see the absolute Amazon S3 bucket or Amazon EFS path as is in their file transfer protocol clients. If you set it to <code>LOGICAL</code> , you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or Amazon EFS paths visible to your users.
         *                          <p>
         *                          <blockquote>
         *                          <p>
         *                          If <code>HomeDirectoryType</code> is <code>LOGICAL</code> , you must provide mappings, using the <code>HomeDirectoryMappings</code> parameter. If, on the other hand, <code>HomeDirectoryType</code> is <code>PATH</code> , you provide an absolute path using the <code>HomeDirectory</code> parameter. You cannot have both <code>HomeDirectory</code> and <code>HomeDirectoryMappings</code> in your template.
         *                          <p>
         *                          </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder homeDirectoryType(java.lang.String homeDirectoryType) {
            this.homeDirectoryType = homeDirectoryType;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getPolicy}
         * @param policy A session policy for your user so you can use the same IAM role across multiple users.
         *               This policy restricts user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code> , <code>${Transfer:HomeDirectory}</code> , and <code>${Transfer:HomeBucket}</code> .
         *               <p>
         *               <blockquote>
         *               <p>
         *               For session policies, AWS Transfer Family stores the policy as a JSON blob, instead of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass it in the <code>Policy</code> argument.
         *               <p>
         *               For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy.html">Example session policy</a> .
         *               <p>
         *               For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <em>AWS Security Token Service API Reference</em> .
         *               <p>
         *               </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(java.lang.String policy) {
            this.policy = policy;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getPosixProfile}
         * @param posixProfile Specifies the full POSIX identity, including user ID ( <code>Uid</code> ), group ID ( <code>Gid</code> ), and any secondary groups IDs ( <code>SecondaryGids</code> ), that controls your users' access to your Amazon Elastic File System (Amazon EFS) file systems.
         *                     The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder posixProfile(software.amazon.awscdk.IResolvable posixProfile) {
            this.posixProfile = posixProfile;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getPosixProfile}
         * @param posixProfile Specifies the full POSIX identity, including user ID ( <code>Uid</code> ), group ID ( <code>Gid</code> ), and any secondary groups IDs ( <code>SecondaryGids</code> ), that controls your users' access to your Amazon Elastic File System (Amazon EFS) file systems.
         *                     The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder posixProfile(software.amazon.awscdk.services.transfer.CfnUser.PosixProfileProperty posixProfile) {
            this.posixProfile = posixProfile;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getSshPublicKeys}
         * @param sshPublicKeys Specifies the public key portion of the Secure Shell (SSH) keys stored for the described user.
         *                      <blockquote>
         *                      <p>
         *                      To delete the public key body, set its value to zero keys, as shown here:
         *                      <p>
         *                      <code>SshPublicKeys: []</code>
         *                      <p>
         *                      </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sshPublicKeys(java.util.List<java.lang.String> sshPublicKeys) {
            this.sshPublicKeys = sshPublicKeys;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getTags}
         * @param tags Key-value pairs that can be used to group and search for users.
         *             Tags are metadata attached to users for any purpose.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnUserProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnUserProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnUserProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnUserProps {
        private final java.lang.String role;
        private final java.lang.String serverId;
        private final java.lang.String userName;
        private final java.lang.String homeDirectory;
        private final java.lang.Object homeDirectoryMappings;
        private final java.lang.String homeDirectoryType;
        private final java.lang.String policy;
        private final java.lang.Object posixProfile;
        private final java.util.List<java.lang.String> sshPublicKeys;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serverId = software.amazon.jsii.Kernel.get(this, "serverId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userName = software.amazon.jsii.Kernel.get(this, "userName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.homeDirectory = software.amazon.jsii.Kernel.get(this, "homeDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.homeDirectoryMappings = software.amazon.jsii.Kernel.get(this, "homeDirectoryMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.homeDirectoryType = software.amazon.jsii.Kernel.get(this, "homeDirectoryType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.policy = software.amazon.jsii.Kernel.get(this, "policy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.posixProfile = software.amazon.jsii.Kernel.get(this, "posixProfile", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sshPublicKeys = software.amazon.jsii.Kernel.get(this, "sshPublicKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.role = java.util.Objects.requireNonNull(builder.role, "role is required");
            this.serverId = java.util.Objects.requireNonNull(builder.serverId, "serverId is required");
            this.userName = java.util.Objects.requireNonNull(builder.userName, "userName is required");
            this.homeDirectory = builder.homeDirectory;
            this.homeDirectoryMappings = builder.homeDirectoryMappings;
            this.homeDirectoryType = builder.homeDirectoryType;
            this.policy = builder.policy;
            this.posixProfile = builder.posixProfile;
            this.sshPublicKeys = builder.sshPublicKeys;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getRole() {
            return this.role;
        }

        @Override
        public final java.lang.String getServerId() {
            return this.serverId;
        }

        @Override
        public final java.lang.String getUserName() {
            return this.userName;
        }

        @Override
        public final java.lang.String getHomeDirectory() {
            return this.homeDirectory;
        }

        @Override
        public final java.lang.Object getHomeDirectoryMappings() {
            return this.homeDirectoryMappings;
        }

        @Override
        public final java.lang.String getHomeDirectoryType() {
            return this.homeDirectoryType;
        }

        @Override
        public final java.lang.String getPolicy() {
            return this.policy;
        }

        @Override
        public final java.lang.Object getPosixProfile() {
            return this.posixProfile;
        }

        @Override
        public final java.util.List<java.lang.String> getSshPublicKeys() {
            return this.sshPublicKeys;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("role", om.valueToTree(this.getRole()));
            data.set("serverId", om.valueToTree(this.getServerId()));
            data.set("userName", om.valueToTree(this.getUserName()));
            if (this.getHomeDirectory() != null) {
                data.set("homeDirectory", om.valueToTree(this.getHomeDirectory()));
            }
            if (this.getHomeDirectoryMappings() != null) {
                data.set("homeDirectoryMappings", om.valueToTree(this.getHomeDirectoryMappings()));
            }
            if (this.getHomeDirectoryType() != null) {
                data.set("homeDirectoryType", om.valueToTree(this.getHomeDirectoryType()));
            }
            if (this.getPolicy() != null) {
                data.set("policy", om.valueToTree(this.getPolicy()));
            }
            if (this.getPosixProfile() != null) {
                data.set("posixProfile", om.valueToTree(this.getPosixProfile()));
            }
            if (this.getSshPublicKeys() != null) {
                data.set("sshPublicKeys", om.valueToTree(this.getSshPublicKeys()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_transfer.CfnUserProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnUserProps.Jsii$Proxy that = (CfnUserProps.Jsii$Proxy) o;

            if (!role.equals(that.role)) return false;
            if (!serverId.equals(that.serverId)) return false;
            if (!userName.equals(that.userName)) return false;
            if (this.homeDirectory != null ? !this.homeDirectory.equals(that.homeDirectory) : that.homeDirectory != null) return false;
            if (this.homeDirectoryMappings != null ? !this.homeDirectoryMappings.equals(that.homeDirectoryMappings) : that.homeDirectoryMappings != null) return false;
            if (this.homeDirectoryType != null ? !this.homeDirectoryType.equals(that.homeDirectoryType) : that.homeDirectoryType != null) return false;
            if (this.policy != null ? !this.policy.equals(that.policy) : that.policy != null) return false;
            if (this.posixProfile != null ? !this.posixProfile.equals(that.posixProfile) : that.posixProfile != null) return false;
            if (this.sshPublicKeys != null ? !this.sshPublicKeys.equals(that.sshPublicKeys) : that.sshPublicKeys != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.role.hashCode();
            result = 31 * result + (this.serverId.hashCode());
            result = 31 * result + (this.userName.hashCode());
            result = 31 * result + (this.homeDirectory != null ? this.homeDirectory.hashCode() : 0);
            result = 31 * result + (this.homeDirectoryMappings != null ? this.homeDirectoryMappings.hashCode() : 0);
            result = 31 * result + (this.homeDirectoryType != null ? this.homeDirectoryType.hashCode() : 0);
            result = 31 * result + (this.policy != null ? this.policy.hashCode() : 0);
            result = 31 * result + (this.posixProfile != null ? this.posixProfile.hashCode() : 0);
            result = 31 * result + (this.sshPublicKeys != null ? this.sshPublicKeys.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
