package software.amazon.awscdk.services.verifiedpermissions;

/**
 * Creates or updates a reference to Amazon Cognito as an external identity provider.
 * <p>
 * If you are creating a new identity source, then you must specify a <code>Configuration</code> . If you are updating an existing identity source, then you must specify an <code>UpdateConfiguration</code> .
 * <p>
 * After you create an identity source, you can use the identities provided by the IdP as proxies for the principal in authorization queries that use the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html">IsAuthorizedWithToken</a> operation. These identities take the form of tokens that contain claims about the user, such as IDs, attributes and group memberships. Amazon Cognito provides both identity tokens and access tokens, and Verified Permissions can use either or both. Any combination of identity and access tokens results in the same Cedar principal. Verified Permissions automatically translates the information about the identities into the standard Cedar attributes that can be evaluated by your policies. Because the Amazon Cognito identity and access tokens can contain different information, the tokens you choose to use determine the attributes that are available to access in the Cedar principal from your policies.
 * <p>
 * Amazon Cognito Identity is not available in all of the same AWS Regions as Amazon Verified Permissions . Because of this, the <code>AWS::VerifiedPermissions::IdentitySource</code> type is not available to create from AWS CloudFormation in Regions where Amazon Cognito Identity is not currently available. Users can still create <code>AWS::VerifiedPermissions::IdentitySource</code> in those Regions, but only from the AWS CLI , Amazon Verified Permissions SDK, or from the AWS console.
 * <p>
 * <blockquote>
 * <p>
 * To reference a user from this identity source in your Cedar policies, use the following syntax.
 * <p>
 * <em>IdentityType::"<CognitoUserPoolIdentifier>|<CognitoClientId></em>
 * <p>
 * Where <code>IdentityType</code> is the string that you provide to the <code>PrincipalEntityType</code> parameter for this operation. The <code>CognitoUserPoolId</code> and <code>CognitoClientId</code> are defined by the Amazon Cognito user pool.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.verifiedpermissions.*;
 * CfnIdentitySource cfnIdentitySource = CfnIdentitySource.Builder.create(this, "MyCfnIdentitySource")
 *         .configuration(IdentitySourceConfigurationProperty.builder()
 *                 .cognitoUserPoolConfiguration(CognitoUserPoolConfigurationProperty.builder()
 *                         .userPoolArn("userPoolArn")
 *                         // the properties below are optional
 *                         .clientIds(List.of("clientIds"))
 *                         .groupConfiguration(CognitoGroupConfigurationProperty.builder()
 *                                 .groupEntityType("groupEntityType")
 *                                 .build())
 *                         .build())
 *                 .openIdConnectConfiguration(OpenIdConnectConfigurationProperty.builder()
 *                         .issuer("issuer")
 *                         .tokenSelection(OpenIdConnectTokenSelectionProperty.builder()
 *                                 .accessTokenOnly(OpenIdConnectAccessTokenConfigurationProperty.builder()
 *                                         .audiences(List.of("audiences"))
 *                                         .principalIdClaim("principalIdClaim")
 *                                         .build())
 *                                 .identityTokenOnly(OpenIdConnectIdentityTokenConfigurationProperty.builder()
 *                                         .clientIds(List.of("clientIds"))
 *                                         .principalIdClaim("principalIdClaim")
 *                                         .build())
 *                                 .build())
 *                         // the properties below are optional
 *                         .entityIdPrefix("entityIdPrefix")
 *                         .groupConfiguration(OpenIdConnectGroupConfigurationProperty.builder()
 *                                 .groupClaim("groupClaim")
 *                                 .groupEntityType("groupEntityType")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .policyStoreId("policyStoreId")
 *         // the properties below are optional
 *         .principalEntityType("principalEntityType")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-identitysource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-identitysource.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:48.461Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_verifiedpermissions.CfnIdentitySource")
public class CfnIdentitySource extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnIdentitySource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnIdentitySource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.verifiedpermissions.CfnIdentitySource.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnIdentitySource(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.verifiedpermissions.CfnIdentitySourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrDetails() {
        return software.amazon.jsii.Kernel.get(this, "attrDetails", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrDetailsClientIds() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrDetailsClientIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDetailsDiscoveryUrl() {
        return software.amazon.jsii.Kernel.get(this, "attrDetailsDiscoveryUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDetailsOpenIdIssuer() {
        return software.amazon.jsii.Kernel.get(this, "attrDetailsOpenIdIssuer", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDetailsUserPoolArn() {
        return software.amazon.jsii.Kernel.get(this, "attrDetailsUserPoolArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique ID of the new or updated identity store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIdentitySourceId() {
        return software.amazon.jsii.Kernel.get(this, "attrIdentitySourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Contains configuration information used when creating a new identity source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains configuration information used when creating a new identity source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configuration", java.util.Objects.requireNonNull(value, "configuration is required"));
    }

    /**
     * Contains configuration information used when creating a new identity source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.verifiedpermissions.CfnIdentitySource.IdentitySourceConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "configuration", java.util.Objects.requireNonNull(value, "configuration is required"));
    }

    /**
     * Specifies the ID of the policy store in which you want to store this identity source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPolicyStoreId() {
        return software.amazon.jsii.Kernel.get(this, "policyStoreId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the ID of the policy store in which you want to store this identity source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicyStoreId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "policyStoreId", java.util.Objects.requireNonNull(value, "policyStoreId is required"));
    }

    /**
     * Specifies the namespace and data type of the principals generated for identities authenticated by the new identity source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPrincipalEntityType() {
        return software.amazon.jsii.Kernel.get(this, "principalEntityType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the namespace and data type of the principals generated for identities authenticated by the new identity source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPrincipalEntityType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "principalEntityType", value);
    }
    /**
     * The type of entity that a policy store maps to groups from an Amazon Cognito user pool identity source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.verifiedpermissions.*;
     * CognitoGroupConfigurationProperty cognitoGroupConfigurationProperty = CognitoGroupConfigurationProperty.builder()
     *         .groupEntityType("groupEntityType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-cognitogroupconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-cognitogroupconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_verifiedpermissions.CfnIdentitySource.CognitoGroupConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CognitoGroupConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CognitoGroupConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the schema entity type that's mapped to the user pool group.
         * <p>
         * Defaults to <code>AWS::CognitoGroup</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-cognitogroupconfiguration.html#cfn-verifiedpermissions-identitysource-cognitogroupconfiguration-groupentitytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-cognitogroupconfiguration.html#cfn-verifiedpermissions-identitysource-cognitogroupconfiguration-groupentitytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getGroupEntityType();

        /**
         * @return a {@link Builder} of {@link CognitoGroupConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CognitoGroupConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CognitoGroupConfigurationProperty> {
            java.lang.String groupEntityType;

            /**
             * Sets the value of {@link CognitoGroupConfigurationProperty#getGroupEntityType}
             * @param groupEntityType The name of the schema entity type that's mapped to the user pool group. This parameter is required.
             *                        Defaults to <code>AWS::CognitoGroup</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupEntityType(java.lang.String groupEntityType) {
                this.groupEntityType = groupEntityType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CognitoGroupConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CognitoGroupConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CognitoGroupConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CognitoGroupConfigurationProperty {
            private final java.lang.String groupEntityType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.groupEntityType = software.amazon.jsii.Kernel.get(this, "groupEntityType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.groupEntityType = java.util.Objects.requireNonNull(builder.groupEntityType, "groupEntityType is required");
            }

            @Override
            public final java.lang.String getGroupEntityType() {
                return this.groupEntityType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("groupEntityType", om.valueToTree(this.getGroupEntityType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_verifiedpermissions.CfnIdentitySource.CognitoGroupConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CognitoGroupConfigurationProperty.Jsii$Proxy that = (CognitoGroupConfigurationProperty.Jsii$Proxy) o;

                return this.groupEntityType.equals(that.groupEntityType);
            }

            @Override
            public final int hashCode() {
                int result = this.groupEntityType.hashCode();
                return result;
            }
        }
    }
    /**
     * A structure that contains configuration information used when creating or updating an identity source that represents a connection to an Amazon Cognito user pool used as an identity provider for Verified Permissions .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.verifiedpermissions.*;
     * CognitoUserPoolConfigurationProperty cognitoUserPoolConfigurationProperty = CognitoUserPoolConfigurationProperty.builder()
     *         .userPoolArn("userPoolArn")
     *         // the properties below are optional
     *         .clientIds(List.of("clientIds"))
     *         .groupConfiguration(CognitoGroupConfigurationProperty.builder()
     *                 .groupEntityType("groupEntityType")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-cognitouserpoolconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-cognitouserpoolconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_verifiedpermissions.CfnIdentitySource.CognitoUserPoolConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CognitoUserPoolConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CognitoUserPoolConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The <a href="https://docs.aws.amazon.com//general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of the Amazon Cognito user pool that contains the identities to be authorized.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-cognitouserpoolconfiguration.html#cfn-verifiedpermissions-identitysource-cognitouserpoolconfiguration-userpoolarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-cognitouserpoolconfiguration.html#cfn-verifiedpermissions-identitysource-cognitouserpoolconfiguration-userpoolarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUserPoolArn();

        /**
         * The unique application client IDs that are associated with the specified Amazon Cognito user pool.
         * <p>
         * Example: <code>"ClientIds": ["&amp;ExampleCogClientId;"]</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-cognitouserpoolconfiguration.html#cfn-verifiedpermissions-identitysource-cognitouserpoolconfiguration-clientids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-cognitouserpoolconfiguration.html#cfn-verifiedpermissions-identitysource-cognitouserpoolconfiguration-clientids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getClientIds() {
            return null;
        }

        /**
         * The type of entity that a policy store maps to groups from an Amazon Cognito user pool identity source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-cognitouserpoolconfiguration.html#cfn-verifiedpermissions-identitysource-cognitouserpoolconfiguration-groupconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-cognitouserpoolconfiguration.html#cfn-verifiedpermissions-identitysource-cognitouserpoolconfiguration-groupconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGroupConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CognitoUserPoolConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CognitoUserPoolConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CognitoUserPoolConfigurationProperty> {
            java.lang.String userPoolArn;
            java.util.List<java.lang.String> clientIds;
            java.lang.Object groupConfiguration;

            /**
             * Sets the value of {@link CognitoUserPoolConfigurationProperty#getUserPoolArn}
             * @param userPoolArn The <a href="https://docs.aws.amazon.com//general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a> of the Amazon Cognito user pool that contains the identities to be authorized. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPoolArn(java.lang.String userPoolArn) {
                this.userPoolArn = userPoolArn;
                return this;
            }

            /**
             * Sets the value of {@link CognitoUserPoolConfigurationProperty#getClientIds}
             * @param clientIds The unique application client IDs that are associated with the specified Amazon Cognito user pool.
             *                  Example: <code>"ClientIds": ["&amp;ExampleCogClientId;"]</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientIds(java.util.List<java.lang.String> clientIds) {
                this.clientIds = clientIds;
                return this;
            }

            /**
             * Sets the value of {@link CognitoUserPoolConfigurationProperty#getGroupConfiguration}
             * @param groupConfiguration The type of entity that a policy store maps to groups from an Amazon Cognito user pool identity source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupConfiguration(software.amazon.awscdk.IResolvable groupConfiguration) {
                this.groupConfiguration = groupConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link CognitoUserPoolConfigurationProperty#getGroupConfiguration}
             * @param groupConfiguration The type of entity that a policy store maps to groups from an Amazon Cognito user pool identity source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupConfiguration(software.amazon.awscdk.services.verifiedpermissions.CfnIdentitySource.CognitoGroupConfigurationProperty groupConfiguration) {
                this.groupConfiguration = groupConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CognitoUserPoolConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CognitoUserPoolConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CognitoUserPoolConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CognitoUserPoolConfigurationProperty {
            private final java.lang.String userPoolArn;
            private final java.util.List<java.lang.String> clientIds;
            private final java.lang.Object groupConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.userPoolArn = software.amazon.jsii.Kernel.get(this, "userPoolArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clientIds = software.amazon.jsii.Kernel.get(this, "clientIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.groupConfiguration = software.amazon.jsii.Kernel.get(this, "groupConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.userPoolArn = java.util.Objects.requireNonNull(builder.userPoolArn, "userPoolArn is required");
                this.clientIds = builder.clientIds;
                this.groupConfiguration = builder.groupConfiguration;
            }

            @Override
            public final java.lang.String getUserPoolArn() {
                return this.userPoolArn;
            }

            @Override
            public final java.util.List<java.lang.String> getClientIds() {
                return this.clientIds;
            }

            @Override
            public final java.lang.Object getGroupConfiguration() {
                return this.groupConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("userPoolArn", om.valueToTree(this.getUserPoolArn()));
                if (this.getClientIds() != null) {
                    data.set("clientIds", om.valueToTree(this.getClientIds()));
                }
                if (this.getGroupConfiguration() != null) {
                    data.set("groupConfiguration", om.valueToTree(this.getGroupConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_verifiedpermissions.CfnIdentitySource.CognitoUserPoolConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CognitoUserPoolConfigurationProperty.Jsii$Proxy that = (CognitoUserPoolConfigurationProperty.Jsii$Proxy) o;

                if (!userPoolArn.equals(that.userPoolArn)) return false;
                if (this.clientIds != null ? !this.clientIds.equals(that.clientIds) : that.clientIds != null) return false;
                return this.groupConfiguration != null ? this.groupConfiguration.equals(that.groupConfiguration) : that.groupConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.userPoolArn.hashCode();
                result = 31 * result + (this.clientIds != null ? this.clientIds.hashCode() : 0);
                result = 31 * result + (this.groupConfiguration != null ? this.groupConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that contains configuration information used when creating or updating a new identity source.
     * <p>
     * <blockquote>
     * <p>
     * At this time, the only valid member of this structure is a Amazon Cognito user pool configuration.
     * <p>
     * You must specify a <code>userPoolArn</code> , and optionally, a <code>ClientId</code> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.verifiedpermissions.*;
     * IdentitySourceConfigurationProperty identitySourceConfigurationProperty = IdentitySourceConfigurationProperty.builder()
     *         .cognitoUserPoolConfiguration(CognitoUserPoolConfigurationProperty.builder()
     *                 .userPoolArn("userPoolArn")
     *                 // the properties below are optional
     *                 .clientIds(List.of("clientIds"))
     *                 .groupConfiguration(CognitoGroupConfigurationProperty.builder()
     *                         .groupEntityType("groupEntityType")
     *                         .build())
     *                 .build())
     *         .openIdConnectConfiguration(OpenIdConnectConfigurationProperty.builder()
     *                 .issuer("issuer")
     *                 .tokenSelection(OpenIdConnectTokenSelectionProperty.builder()
     *                         .accessTokenOnly(OpenIdConnectAccessTokenConfigurationProperty.builder()
     *                                 .audiences(List.of("audiences"))
     *                                 .principalIdClaim("principalIdClaim")
     *                                 .build())
     *                         .identityTokenOnly(OpenIdConnectIdentityTokenConfigurationProperty.builder()
     *                                 .clientIds(List.of("clientIds"))
     *                                 .principalIdClaim("principalIdClaim")
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .entityIdPrefix("entityIdPrefix")
     *                 .groupConfiguration(OpenIdConnectGroupConfigurationProperty.builder()
     *                         .groupClaim("groupClaim")
     *                         .groupEntityType("groupEntityType")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-identitysourceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-identitysourceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_verifiedpermissions.CfnIdentitySource.IdentitySourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(IdentitySourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IdentitySourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A structure that contains configuration information used when creating or updating an identity source that represents a connection to an Amazon Cognito user pool used as an identity provider for Verified Permissions .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-identitysourceconfiguration.html#cfn-verifiedpermissions-identitysource-identitysourceconfiguration-cognitouserpoolconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-identitysourceconfiguration.html#cfn-verifiedpermissions-identitysource-identitysourceconfiguration-cognitouserpoolconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCognitoUserPoolConfiguration() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-identitysourceconfiguration.html#cfn-verifiedpermissions-identitysource-identitysourceconfiguration-openidconnectconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-identitysourceconfiguration.html#cfn-verifiedpermissions-identitysource-identitysourceconfiguration-openidconnectconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOpenIdConnectConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IdentitySourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IdentitySourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IdentitySourceConfigurationProperty> {
            java.lang.Object cognitoUserPoolConfiguration;
            java.lang.Object openIdConnectConfiguration;

            /**
             * Sets the value of {@link IdentitySourceConfigurationProperty#getCognitoUserPoolConfiguration}
             * @param cognitoUserPoolConfiguration A structure that contains configuration information used when creating or updating an identity source that represents a connection to an Amazon Cognito user pool used as an identity provider for Verified Permissions .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cognitoUserPoolConfiguration(software.amazon.awscdk.IResolvable cognitoUserPoolConfiguration) {
                this.cognitoUserPoolConfiguration = cognitoUserPoolConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link IdentitySourceConfigurationProperty#getCognitoUserPoolConfiguration}
             * @param cognitoUserPoolConfiguration A structure that contains configuration information used when creating or updating an identity source that represents a connection to an Amazon Cognito user pool used as an identity provider for Verified Permissions .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cognitoUserPoolConfiguration(software.amazon.awscdk.services.verifiedpermissions.CfnIdentitySource.CognitoUserPoolConfigurationProperty cognitoUserPoolConfiguration) {
                this.cognitoUserPoolConfiguration = cognitoUserPoolConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link IdentitySourceConfigurationProperty#getOpenIdConnectConfiguration}
             * @param openIdConnectConfiguration the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder openIdConnectConfiguration(software.amazon.awscdk.IResolvable openIdConnectConfiguration) {
                this.openIdConnectConfiguration = openIdConnectConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link IdentitySourceConfigurationProperty#getOpenIdConnectConfiguration}
             * @param openIdConnectConfiguration the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder openIdConnectConfiguration(software.amazon.awscdk.services.verifiedpermissions.CfnIdentitySource.OpenIdConnectConfigurationProperty openIdConnectConfiguration) {
                this.openIdConnectConfiguration = openIdConnectConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IdentitySourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IdentitySourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IdentitySourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdentitySourceConfigurationProperty {
            private final java.lang.Object cognitoUserPoolConfiguration;
            private final java.lang.Object openIdConnectConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cognitoUserPoolConfiguration = software.amazon.jsii.Kernel.get(this, "cognitoUserPoolConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.openIdConnectConfiguration = software.amazon.jsii.Kernel.get(this, "openIdConnectConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cognitoUserPoolConfiguration = builder.cognitoUserPoolConfiguration;
                this.openIdConnectConfiguration = builder.openIdConnectConfiguration;
            }

            @Override
            public final java.lang.Object getCognitoUserPoolConfiguration() {
                return this.cognitoUserPoolConfiguration;
            }

            @Override
            public final java.lang.Object getOpenIdConnectConfiguration() {
                return this.openIdConnectConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCognitoUserPoolConfiguration() != null) {
                    data.set("cognitoUserPoolConfiguration", om.valueToTree(this.getCognitoUserPoolConfiguration()));
                }
                if (this.getOpenIdConnectConfiguration() != null) {
                    data.set("openIdConnectConfiguration", om.valueToTree(this.getOpenIdConnectConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_verifiedpermissions.CfnIdentitySource.IdentitySourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IdentitySourceConfigurationProperty.Jsii$Proxy that = (IdentitySourceConfigurationProperty.Jsii$Proxy) o;

                if (this.cognitoUserPoolConfiguration != null ? !this.cognitoUserPoolConfiguration.equals(that.cognitoUserPoolConfiguration) : that.cognitoUserPoolConfiguration != null) return false;
                return this.openIdConnectConfiguration != null ? this.openIdConnectConfiguration.equals(that.openIdConnectConfiguration) : that.openIdConnectConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cognitoUserPoolConfiguration != null ? this.cognitoUserPoolConfiguration.hashCode() : 0;
                result = 31 * result + (this.openIdConnectConfiguration != null ? this.openIdConnectConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.verifiedpermissions.*;
     * IdentitySourceDetailsProperty identitySourceDetailsProperty = IdentitySourceDetailsProperty.builder()
     *         .clientIds(List.of("clientIds"))
     *         .discoveryUrl("discoveryUrl")
     *         .openIdIssuer("openIdIssuer")
     *         .userPoolArn("userPoolArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-identitysourcedetails.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-identitysourcedetails.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_verifiedpermissions.CfnIdentitySource.IdentitySourceDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(IdentitySourceDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IdentitySourceDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-identitysourcedetails.html#cfn-verifiedpermissions-identitysource-identitysourcedetails-clientids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-identitysourcedetails.html#cfn-verifiedpermissions-identitysource-identitysourcedetails-clientids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getClientIds() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-identitysourcedetails.html#cfn-verifiedpermissions-identitysource-identitysourcedetails-discoveryurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-identitysourcedetails.html#cfn-verifiedpermissions-identitysource-identitysourcedetails-discoveryurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDiscoveryUrl() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-identitysourcedetails.html#cfn-verifiedpermissions-identitysource-identitysourcedetails-openidissuer">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-identitysourcedetails.html#cfn-verifiedpermissions-identitysource-identitysourcedetails-openidissuer</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOpenIdIssuer() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-identitysourcedetails.html#cfn-verifiedpermissions-identitysource-identitysourcedetails-userpoolarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-identitysourcedetails.html#cfn-verifiedpermissions-identitysource-identitysourcedetails-userpoolarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserPoolArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IdentitySourceDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IdentitySourceDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IdentitySourceDetailsProperty> {
            java.util.List<java.lang.String> clientIds;
            java.lang.String discoveryUrl;
            java.lang.String openIdIssuer;
            java.lang.String userPoolArn;

            /**
             * Sets the value of {@link IdentitySourceDetailsProperty#getClientIds}
             * @param clientIds the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientIds(java.util.List<java.lang.String> clientIds) {
                this.clientIds = clientIds;
                return this;
            }

            /**
             * Sets the value of {@link IdentitySourceDetailsProperty#getDiscoveryUrl}
             * @param discoveryUrl the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder discoveryUrl(java.lang.String discoveryUrl) {
                this.discoveryUrl = discoveryUrl;
                return this;
            }

            /**
             * Sets the value of {@link IdentitySourceDetailsProperty#getOpenIdIssuer}
             * @param openIdIssuer the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder openIdIssuer(java.lang.String openIdIssuer) {
                this.openIdIssuer = openIdIssuer;
                return this;
            }

            /**
             * Sets the value of {@link IdentitySourceDetailsProperty#getUserPoolArn}
             * @param userPoolArn the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPoolArn(java.lang.String userPoolArn) {
                this.userPoolArn = userPoolArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IdentitySourceDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IdentitySourceDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IdentitySourceDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdentitySourceDetailsProperty {
            private final java.util.List<java.lang.String> clientIds;
            private final java.lang.String discoveryUrl;
            private final java.lang.String openIdIssuer;
            private final java.lang.String userPoolArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientIds = software.amazon.jsii.Kernel.get(this, "clientIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.discoveryUrl = software.amazon.jsii.Kernel.get(this, "discoveryUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.openIdIssuer = software.amazon.jsii.Kernel.get(this, "openIdIssuer", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userPoolArn = software.amazon.jsii.Kernel.get(this, "userPoolArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientIds = builder.clientIds;
                this.discoveryUrl = builder.discoveryUrl;
                this.openIdIssuer = builder.openIdIssuer;
                this.userPoolArn = builder.userPoolArn;
            }

            @Override
            public final java.util.List<java.lang.String> getClientIds() {
                return this.clientIds;
            }

            @Override
            public final java.lang.String getDiscoveryUrl() {
                return this.discoveryUrl;
            }

            @Override
            public final java.lang.String getOpenIdIssuer() {
                return this.openIdIssuer;
            }

            @Override
            public final java.lang.String getUserPoolArn() {
                return this.userPoolArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getClientIds() != null) {
                    data.set("clientIds", om.valueToTree(this.getClientIds()));
                }
                if (this.getDiscoveryUrl() != null) {
                    data.set("discoveryUrl", om.valueToTree(this.getDiscoveryUrl()));
                }
                if (this.getOpenIdIssuer() != null) {
                    data.set("openIdIssuer", om.valueToTree(this.getOpenIdIssuer()));
                }
                if (this.getUserPoolArn() != null) {
                    data.set("userPoolArn", om.valueToTree(this.getUserPoolArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_verifiedpermissions.CfnIdentitySource.IdentitySourceDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IdentitySourceDetailsProperty.Jsii$Proxy that = (IdentitySourceDetailsProperty.Jsii$Proxy) o;

                if (this.clientIds != null ? !this.clientIds.equals(that.clientIds) : that.clientIds != null) return false;
                if (this.discoveryUrl != null ? !this.discoveryUrl.equals(that.discoveryUrl) : that.discoveryUrl != null) return false;
                if (this.openIdIssuer != null ? !this.openIdIssuer.equals(that.openIdIssuer) : that.openIdIssuer != null) return false;
                return this.userPoolArn != null ? this.userPoolArn.equals(that.userPoolArn) : that.userPoolArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clientIds != null ? this.clientIds.hashCode() : 0;
                result = 31 * result + (this.discoveryUrl != null ? this.discoveryUrl.hashCode() : 0);
                result = 31 * result + (this.openIdIssuer != null ? this.openIdIssuer.hashCode() : 0);
                result = 31 * result + (this.userPoolArn != null ? this.userPoolArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of an OpenID Connect (OIDC) identity source for handling access token claims.
     * <p>
     * Contains the claim that you want to identify as the principal in an authorization request, and the values of the <code>aud</code> claim, or audiences, that you want to accept.
     * <p>
     * This data type is part of a <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectTokenSelection.html">OpenIdConnectTokenSelection</a> structure, which is a parameter of <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html">CreateIdentitySource</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.verifiedpermissions.*;
     * OpenIdConnectAccessTokenConfigurationProperty openIdConnectAccessTokenConfigurationProperty = OpenIdConnectAccessTokenConfigurationProperty.builder()
     *         .audiences(List.of("audiences"))
     *         .principalIdClaim("principalIdClaim")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnectaccesstokenconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnectaccesstokenconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_verifiedpermissions.CfnIdentitySource.OpenIdConnectAccessTokenConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(OpenIdConnectAccessTokenConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OpenIdConnectAccessTokenConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The access token <code>aud</code> claim values that you want to accept in your policy store.
         * <p>
         * For example, <code>https://myapp.example.com, https://myapp2.example.com</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnectaccesstokenconfiguration.html#cfn-verifiedpermissions-identitysource-openidconnectaccesstokenconfiguration-audiences">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnectaccesstokenconfiguration.html#cfn-verifiedpermissions-identitysource-openidconnectaccesstokenconfiguration-audiences</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAudiences() {
            return null;
        }

        /**
         * The claim that determines the principal in OIDC access tokens.
         * <p>
         * For example, <code>sub</code> .
         * <p>
         * Default: - "sub"
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnectaccesstokenconfiguration.html#cfn-verifiedpermissions-identitysource-openidconnectaccesstokenconfiguration-principalidclaim">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnectaccesstokenconfiguration.html#cfn-verifiedpermissions-identitysource-openidconnectaccesstokenconfiguration-principalidclaim</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrincipalIdClaim() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OpenIdConnectAccessTokenConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OpenIdConnectAccessTokenConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OpenIdConnectAccessTokenConfigurationProperty> {
            java.util.List<java.lang.String> audiences;
            java.lang.String principalIdClaim;

            /**
             * Sets the value of {@link OpenIdConnectAccessTokenConfigurationProperty#getAudiences}
             * @param audiences The access token <code>aud</code> claim values that you want to accept in your policy store.
             *                  For example, <code>https://myapp.example.com, https://myapp2.example.com</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audiences(java.util.List<java.lang.String> audiences) {
                this.audiences = audiences;
                return this;
            }

            /**
             * Sets the value of {@link OpenIdConnectAccessTokenConfigurationProperty#getPrincipalIdClaim}
             * @param principalIdClaim The claim that determines the principal in OIDC access tokens.
             *                         For example, <code>sub</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder principalIdClaim(java.lang.String principalIdClaim) {
                this.principalIdClaim = principalIdClaim;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OpenIdConnectAccessTokenConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OpenIdConnectAccessTokenConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OpenIdConnectAccessTokenConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenIdConnectAccessTokenConfigurationProperty {
            private final java.util.List<java.lang.String> audiences;
            private final java.lang.String principalIdClaim;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.audiences = software.amazon.jsii.Kernel.get(this, "audiences", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.principalIdClaim = software.amazon.jsii.Kernel.get(this, "principalIdClaim", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.audiences = builder.audiences;
                this.principalIdClaim = builder.principalIdClaim;
            }

            @Override
            public final java.util.List<java.lang.String> getAudiences() {
                return this.audiences;
            }

            @Override
            public final java.lang.String getPrincipalIdClaim() {
                return this.principalIdClaim;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAudiences() != null) {
                    data.set("audiences", om.valueToTree(this.getAudiences()));
                }
                if (this.getPrincipalIdClaim() != null) {
                    data.set("principalIdClaim", om.valueToTree(this.getPrincipalIdClaim()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_verifiedpermissions.CfnIdentitySource.OpenIdConnectAccessTokenConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OpenIdConnectAccessTokenConfigurationProperty.Jsii$Proxy that = (OpenIdConnectAccessTokenConfigurationProperty.Jsii$Proxy) o;

                if (this.audiences != null ? !this.audiences.equals(that.audiences) : that.audiences != null) return false;
                return this.principalIdClaim != null ? this.principalIdClaim.equals(that.principalIdClaim) : that.principalIdClaim == null;
            }

            @Override
            public final int hashCode() {
                int result = this.audiences != null ? this.audiences.hashCode() : 0;
                result = 31 * result + (this.principalIdClaim != null ? this.principalIdClaim.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that Verified Permissions can use to generate entities from authenticated identities.
     * <p>
     * It specifies the issuer URL, token type that you want to use, and policy store entity details.
     * <p>
     * This data type is part of a <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_Configuration.html">Configuration</a> structure, which is a parameter to <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html">CreateIdentitySource</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.verifiedpermissions.*;
     * OpenIdConnectConfigurationProperty openIdConnectConfigurationProperty = OpenIdConnectConfigurationProperty.builder()
     *         .issuer("issuer")
     *         .tokenSelection(OpenIdConnectTokenSelectionProperty.builder()
     *                 .accessTokenOnly(OpenIdConnectAccessTokenConfigurationProperty.builder()
     *                         .audiences(List.of("audiences"))
     *                         .principalIdClaim("principalIdClaim")
     *                         .build())
     *                 .identityTokenOnly(OpenIdConnectIdentityTokenConfigurationProperty.builder()
     *                         .clientIds(List.of("clientIds"))
     *                         .principalIdClaim("principalIdClaim")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .entityIdPrefix("entityIdPrefix")
     *         .groupConfiguration(OpenIdConnectGroupConfigurationProperty.builder()
     *                 .groupClaim("groupClaim")
     *                 .groupEntityType("groupEntityType")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnectconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnectconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_verifiedpermissions.CfnIdentitySource.OpenIdConnectConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(OpenIdConnectConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OpenIdConnectConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The issuer URL of an OIDC identity provider.
         * <p>
         * This URL must have an OIDC discovery endpoint at the path <code>.well-known/openid-configuration</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnectconfiguration.html#cfn-verifiedpermissions-identitysource-openidconnectconfiguration-issuer">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnectconfiguration.html#cfn-verifiedpermissions-identitysource-openidconnectconfiguration-issuer</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIssuer();

        /**
         * The token type that you want to process from your OIDC identity provider.
         * <p>
         * Your policy store can process either identity (ID) or access tokens from a given OIDC identity source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnectconfiguration.html#cfn-verifiedpermissions-identitysource-openidconnectconfiguration-tokenselection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnectconfiguration.html#cfn-verifiedpermissions-identitysource-openidconnectconfiguration-tokenselection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTokenSelection();

        /**
         * A descriptive string that you want to prefix to user entities from your OIDC identity provider.
         * <p>
         * For example, if you set an <code>entityIdPrefix</code> of <code>MyOIDCProvider</code> , you can reference principals in your policies in the format <code>MyCorp::User::MyOIDCProvider|Carlos</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnectconfiguration.html#cfn-verifiedpermissions-identitysource-openidconnectconfiguration-entityidprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnectconfiguration.html#cfn-verifiedpermissions-identitysource-openidconnectconfiguration-entityidprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEntityIdPrefix() {
            return null;
        }

        /**
         * The claim in OIDC identity provider tokens that indicates a user's group membership, and the entity type that you want to map it to.
         * <p>
         * For example, this object can map the contents of a <code>groups</code> claim to <code>MyCorp::UserGroup</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnectconfiguration.html#cfn-verifiedpermissions-identitysource-openidconnectconfiguration-groupconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnectconfiguration.html#cfn-verifiedpermissions-identitysource-openidconnectconfiguration-groupconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGroupConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OpenIdConnectConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OpenIdConnectConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OpenIdConnectConfigurationProperty> {
            java.lang.String issuer;
            java.lang.Object tokenSelection;
            java.lang.String entityIdPrefix;
            java.lang.Object groupConfiguration;

            /**
             * Sets the value of {@link OpenIdConnectConfigurationProperty#getIssuer}
             * @param issuer The issuer URL of an OIDC identity provider. This parameter is required.
             *               This URL must have an OIDC discovery endpoint at the path <code>.well-known/openid-configuration</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder issuer(java.lang.String issuer) {
                this.issuer = issuer;
                return this;
            }

            /**
             * Sets the value of {@link OpenIdConnectConfigurationProperty#getTokenSelection}
             * @param tokenSelection The token type that you want to process from your OIDC identity provider. This parameter is required.
             *                       Your policy store can process either identity (ID) or access tokens from a given OIDC identity source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tokenSelection(software.amazon.awscdk.IResolvable tokenSelection) {
                this.tokenSelection = tokenSelection;
                return this;
            }

            /**
             * Sets the value of {@link OpenIdConnectConfigurationProperty#getTokenSelection}
             * @param tokenSelection The token type that you want to process from your OIDC identity provider. This parameter is required.
             *                       Your policy store can process either identity (ID) or access tokens from a given OIDC identity source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tokenSelection(software.amazon.awscdk.services.verifiedpermissions.CfnIdentitySource.OpenIdConnectTokenSelectionProperty tokenSelection) {
                this.tokenSelection = tokenSelection;
                return this;
            }

            /**
             * Sets the value of {@link OpenIdConnectConfigurationProperty#getEntityIdPrefix}
             * @param entityIdPrefix A descriptive string that you want to prefix to user entities from your OIDC identity provider.
             *                       For example, if you set an <code>entityIdPrefix</code> of <code>MyOIDCProvider</code> , you can reference principals in your policies in the format <code>MyCorp::User::MyOIDCProvider|Carlos</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entityIdPrefix(java.lang.String entityIdPrefix) {
                this.entityIdPrefix = entityIdPrefix;
                return this;
            }

            /**
             * Sets the value of {@link OpenIdConnectConfigurationProperty#getGroupConfiguration}
             * @param groupConfiguration The claim in OIDC identity provider tokens that indicates a user's group membership, and the entity type that you want to map it to.
             *                           For example, this object can map the contents of a <code>groups</code> claim to <code>MyCorp::UserGroup</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupConfiguration(software.amazon.awscdk.IResolvable groupConfiguration) {
                this.groupConfiguration = groupConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link OpenIdConnectConfigurationProperty#getGroupConfiguration}
             * @param groupConfiguration The claim in OIDC identity provider tokens that indicates a user's group membership, and the entity type that you want to map it to.
             *                           For example, this object can map the contents of a <code>groups</code> claim to <code>MyCorp::UserGroup</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupConfiguration(software.amazon.awscdk.services.verifiedpermissions.CfnIdentitySource.OpenIdConnectGroupConfigurationProperty groupConfiguration) {
                this.groupConfiguration = groupConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OpenIdConnectConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OpenIdConnectConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OpenIdConnectConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenIdConnectConfigurationProperty {
            private final java.lang.String issuer;
            private final java.lang.Object tokenSelection;
            private final java.lang.String entityIdPrefix;
            private final java.lang.Object groupConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.issuer = software.amazon.jsii.Kernel.get(this, "issuer", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tokenSelection = software.amazon.jsii.Kernel.get(this, "tokenSelection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.entityIdPrefix = software.amazon.jsii.Kernel.get(this, "entityIdPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.groupConfiguration = software.amazon.jsii.Kernel.get(this, "groupConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.issuer = java.util.Objects.requireNonNull(builder.issuer, "issuer is required");
                this.tokenSelection = java.util.Objects.requireNonNull(builder.tokenSelection, "tokenSelection is required");
                this.entityIdPrefix = builder.entityIdPrefix;
                this.groupConfiguration = builder.groupConfiguration;
            }

            @Override
            public final java.lang.String getIssuer() {
                return this.issuer;
            }

            @Override
            public final java.lang.Object getTokenSelection() {
                return this.tokenSelection;
            }

            @Override
            public final java.lang.String getEntityIdPrefix() {
                return this.entityIdPrefix;
            }

            @Override
            public final java.lang.Object getGroupConfiguration() {
                return this.groupConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("issuer", om.valueToTree(this.getIssuer()));
                data.set("tokenSelection", om.valueToTree(this.getTokenSelection()));
                if (this.getEntityIdPrefix() != null) {
                    data.set("entityIdPrefix", om.valueToTree(this.getEntityIdPrefix()));
                }
                if (this.getGroupConfiguration() != null) {
                    data.set("groupConfiguration", om.valueToTree(this.getGroupConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_verifiedpermissions.CfnIdentitySource.OpenIdConnectConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OpenIdConnectConfigurationProperty.Jsii$Proxy that = (OpenIdConnectConfigurationProperty.Jsii$Proxy) o;

                if (!issuer.equals(that.issuer)) return false;
                if (!tokenSelection.equals(that.tokenSelection)) return false;
                if (this.entityIdPrefix != null ? !this.entityIdPrefix.equals(that.entityIdPrefix) : that.entityIdPrefix != null) return false;
                return this.groupConfiguration != null ? this.groupConfiguration.equals(that.groupConfiguration) : that.groupConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.issuer.hashCode();
                result = 31 * result + (this.tokenSelection.hashCode());
                result = 31 * result + (this.entityIdPrefix != null ? this.entityIdPrefix.hashCode() : 0);
                result = 31 * result + (this.groupConfiguration != null ? this.groupConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The claim in OIDC identity provider tokens that indicates a user's group membership, and the entity type that you want to map it to.
     * <p>
     * For example, this object can map the contents of a <code>groups</code> claim to <code>MyCorp::UserGroup</code> .
     * <p>
     * This data type is part of a <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectConfiguration.html">OpenIdConnectConfiguration</a> structure, which is a parameter of <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html">CreateIdentitySource</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.verifiedpermissions.*;
     * OpenIdConnectGroupConfigurationProperty openIdConnectGroupConfigurationProperty = OpenIdConnectGroupConfigurationProperty.builder()
     *         .groupClaim("groupClaim")
     *         .groupEntityType("groupEntityType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnectgroupconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnectgroupconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_verifiedpermissions.CfnIdentitySource.OpenIdConnectGroupConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(OpenIdConnectGroupConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OpenIdConnectGroupConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The token claim that you want Verified Permissions to interpret as group membership.
         * <p>
         * For example, <code>groups</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnectgroupconfiguration.html#cfn-verifiedpermissions-identitysource-openidconnectgroupconfiguration-groupclaim">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnectgroupconfiguration.html#cfn-verifiedpermissions-identitysource-openidconnectgroupconfiguration-groupclaim</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getGroupClaim();

        /**
         * The policy store entity type that you want to map your users' group claim to.
         * <p>
         * For example, <code>MyCorp::UserGroup</code> . A group entity type is an entity that can have a user entity type as a member.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnectgroupconfiguration.html#cfn-verifiedpermissions-identitysource-openidconnectgroupconfiguration-groupentitytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnectgroupconfiguration.html#cfn-verifiedpermissions-identitysource-openidconnectgroupconfiguration-groupentitytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getGroupEntityType();

        /**
         * @return a {@link Builder} of {@link OpenIdConnectGroupConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OpenIdConnectGroupConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OpenIdConnectGroupConfigurationProperty> {
            java.lang.String groupClaim;
            java.lang.String groupEntityType;

            /**
             * Sets the value of {@link OpenIdConnectGroupConfigurationProperty#getGroupClaim}
             * @param groupClaim The token claim that you want Verified Permissions to interpret as group membership. This parameter is required.
             *                   For example, <code>groups</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupClaim(java.lang.String groupClaim) {
                this.groupClaim = groupClaim;
                return this;
            }

            /**
             * Sets the value of {@link OpenIdConnectGroupConfigurationProperty#getGroupEntityType}
             * @param groupEntityType The policy store entity type that you want to map your users' group claim to. This parameter is required.
             *                        For example, <code>MyCorp::UserGroup</code> . A group entity type is an entity that can have a user entity type as a member.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupEntityType(java.lang.String groupEntityType) {
                this.groupEntityType = groupEntityType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OpenIdConnectGroupConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OpenIdConnectGroupConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OpenIdConnectGroupConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenIdConnectGroupConfigurationProperty {
            private final java.lang.String groupClaim;
            private final java.lang.String groupEntityType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.groupClaim = software.amazon.jsii.Kernel.get(this, "groupClaim", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.groupEntityType = software.amazon.jsii.Kernel.get(this, "groupEntityType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.groupClaim = java.util.Objects.requireNonNull(builder.groupClaim, "groupClaim is required");
                this.groupEntityType = java.util.Objects.requireNonNull(builder.groupEntityType, "groupEntityType is required");
            }

            @Override
            public final java.lang.String getGroupClaim() {
                return this.groupClaim;
            }

            @Override
            public final java.lang.String getGroupEntityType() {
                return this.groupEntityType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("groupClaim", om.valueToTree(this.getGroupClaim()));
                data.set("groupEntityType", om.valueToTree(this.getGroupEntityType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_verifiedpermissions.CfnIdentitySource.OpenIdConnectGroupConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OpenIdConnectGroupConfigurationProperty.Jsii$Proxy that = (OpenIdConnectGroupConfigurationProperty.Jsii$Proxy) o;

                if (!groupClaim.equals(that.groupClaim)) return false;
                return this.groupEntityType.equals(that.groupEntityType);
            }

            @Override
            public final int hashCode() {
                int result = this.groupClaim.hashCode();
                result = 31 * result + (this.groupEntityType.hashCode());
                return result;
            }
        }
    }
    /**
     * The configuration of an OpenID Connect (OIDC) identity source for handling identity (ID) token claims.
     * <p>
     * Contains the claim that you want to identify as the principal in an authorization request, and the values of the <code>aud</code> claim, or audiences, that you want to accept.
     * <p>
     * This data type is part of a <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectTokenSelection.html">OpenIdConnectTokenSelection</a> structure, which is a parameter of <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html">CreateIdentitySource</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.verifiedpermissions.*;
     * OpenIdConnectIdentityTokenConfigurationProperty openIdConnectIdentityTokenConfigurationProperty = OpenIdConnectIdentityTokenConfigurationProperty.builder()
     *         .clientIds(List.of("clientIds"))
     *         .principalIdClaim("principalIdClaim")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnectidentitytokenconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnectidentitytokenconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_verifiedpermissions.CfnIdentitySource.OpenIdConnectIdentityTokenConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(OpenIdConnectIdentityTokenConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OpenIdConnectIdentityTokenConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID token audience, or client ID, claim values that you want to accept in your policy store from an OIDC identity provider.
         * <p>
         * For example, <code>1example23456789, 2example10111213</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnectidentitytokenconfiguration.html#cfn-verifiedpermissions-identitysource-openidconnectidentitytokenconfiguration-clientids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnectidentitytokenconfiguration.html#cfn-verifiedpermissions-identitysource-openidconnectidentitytokenconfiguration-clientids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getClientIds() {
            return null;
        }

        /**
         * The claim that determines the principal in OIDC access tokens.
         * <p>
         * For example, <code>sub</code> .
         * <p>
         * Default: - "sub"
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnectidentitytokenconfiguration.html#cfn-verifiedpermissions-identitysource-openidconnectidentitytokenconfiguration-principalidclaim">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnectidentitytokenconfiguration.html#cfn-verifiedpermissions-identitysource-openidconnectidentitytokenconfiguration-principalidclaim</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrincipalIdClaim() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OpenIdConnectIdentityTokenConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OpenIdConnectIdentityTokenConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OpenIdConnectIdentityTokenConfigurationProperty> {
            java.util.List<java.lang.String> clientIds;
            java.lang.String principalIdClaim;

            /**
             * Sets the value of {@link OpenIdConnectIdentityTokenConfigurationProperty#getClientIds}
             * @param clientIds The ID token audience, or client ID, claim values that you want to accept in your policy store from an OIDC identity provider.
             *                  For example, <code>1example23456789, 2example10111213</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientIds(java.util.List<java.lang.String> clientIds) {
                this.clientIds = clientIds;
                return this;
            }

            /**
             * Sets the value of {@link OpenIdConnectIdentityTokenConfigurationProperty#getPrincipalIdClaim}
             * @param principalIdClaim The claim that determines the principal in OIDC access tokens.
             *                         For example, <code>sub</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder principalIdClaim(java.lang.String principalIdClaim) {
                this.principalIdClaim = principalIdClaim;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OpenIdConnectIdentityTokenConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OpenIdConnectIdentityTokenConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OpenIdConnectIdentityTokenConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenIdConnectIdentityTokenConfigurationProperty {
            private final java.util.List<java.lang.String> clientIds;
            private final java.lang.String principalIdClaim;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientIds = software.amazon.jsii.Kernel.get(this, "clientIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.principalIdClaim = software.amazon.jsii.Kernel.get(this, "principalIdClaim", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientIds = builder.clientIds;
                this.principalIdClaim = builder.principalIdClaim;
            }

            @Override
            public final java.util.List<java.lang.String> getClientIds() {
                return this.clientIds;
            }

            @Override
            public final java.lang.String getPrincipalIdClaim() {
                return this.principalIdClaim;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getClientIds() != null) {
                    data.set("clientIds", om.valueToTree(this.getClientIds()));
                }
                if (this.getPrincipalIdClaim() != null) {
                    data.set("principalIdClaim", om.valueToTree(this.getPrincipalIdClaim()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_verifiedpermissions.CfnIdentitySource.OpenIdConnectIdentityTokenConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OpenIdConnectIdentityTokenConfigurationProperty.Jsii$Proxy that = (OpenIdConnectIdentityTokenConfigurationProperty.Jsii$Proxy) o;

                if (this.clientIds != null ? !this.clientIds.equals(that.clientIds) : that.clientIds != null) return false;
                return this.principalIdClaim != null ? this.principalIdClaim.equals(that.principalIdClaim) : that.principalIdClaim == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clientIds != null ? this.clientIds.hashCode() : 0;
                result = 31 * result + (this.principalIdClaim != null ? this.principalIdClaim.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The token type that you want to process from your OIDC identity provider.
     * <p>
     * Your policy store can process either identity (ID) or access tokens from a given OIDC identity source.
     * <p>
     * This data type is part of a <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectConfiguration.html">OpenIdConnectConfiguration</a> structure, which is a parameter of <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html">CreateIdentitySource</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.verifiedpermissions.*;
     * OpenIdConnectTokenSelectionProperty openIdConnectTokenSelectionProperty = OpenIdConnectTokenSelectionProperty.builder()
     *         .accessTokenOnly(OpenIdConnectAccessTokenConfigurationProperty.builder()
     *                 .audiences(List.of("audiences"))
     *                 .principalIdClaim("principalIdClaim")
     *                 .build())
     *         .identityTokenOnly(OpenIdConnectIdentityTokenConfigurationProperty.builder()
     *                 .clientIds(List.of("clientIds"))
     *                 .principalIdClaim("principalIdClaim")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnecttokenselection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnecttokenselection.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_verifiedpermissions.CfnIdentitySource.OpenIdConnectTokenSelectionProperty")
    @software.amazon.jsii.Jsii.Proxy(OpenIdConnectTokenSelectionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OpenIdConnectTokenSelectionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The OIDC configuration for processing access tokens.
         * <p>
         * Contains allowed audience claims, for example <code>https://auth.example.com</code> , and the claim that you want to map to the principal, for example <code>sub</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnecttokenselection.html#cfn-verifiedpermissions-identitysource-openidconnecttokenselection-accesstokenonly">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnecttokenselection.html#cfn-verifiedpermissions-identitysource-openidconnecttokenselection-accesstokenonly</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAccessTokenOnly() {
            return null;
        }

        /**
         * The OIDC configuration for processing identity (ID) tokens.
         * <p>
         * Contains allowed client ID claims, for example <code>1example23456789</code> , and the claim that you want to map to the principal, for example <code>sub</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnecttokenselection.html#cfn-verifiedpermissions-identitysource-openidconnecttokenselection-identitytokenonly">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-identitysource-openidconnecttokenselection.html#cfn-verifiedpermissions-identitysource-openidconnecttokenselection-identitytokenonly</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIdentityTokenOnly() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OpenIdConnectTokenSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OpenIdConnectTokenSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OpenIdConnectTokenSelectionProperty> {
            java.lang.Object accessTokenOnly;
            java.lang.Object identityTokenOnly;

            /**
             * Sets the value of {@link OpenIdConnectTokenSelectionProperty#getAccessTokenOnly}
             * @param accessTokenOnly The OIDC configuration for processing access tokens.
             *                        Contains allowed audience claims, for example <code>https://auth.example.com</code> , and the claim that you want to map to the principal, for example <code>sub</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessTokenOnly(software.amazon.awscdk.IResolvable accessTokenOnly) {
                this.accessTokenOnly = accessTokenOnly;
                return this;
            }

            /**
             * Sets the value of {@link OpenIdConnectTokenSelectionProperty#getAccessTokenOnly}
             * @param accessTokenOnly The OIDC configuration for processing access tokens.
             *                        Contains allowed audience claims, for example <code>https://auth.example.com</code> , and the claim that you want to map to the principal, for example <code>sub</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessTokenOnly(software.amazon.awscdk.services.verifiedpermissions.CfnIdentitySource.OpenIdConnectAccessTokenConfigurationProperty accessTokenOnly) {
                this.accessTokenOnly = accessTokenOnly;
                return this;
            }

            /**
             * Sets the value of {@link OpenIdConnectTokenSelectionProperty#getIdentityTokenOnly}
             * @param identityTokenOnly The OIDC configuration for processing identity (ID) tokens.
             *                          Contains allowed client ID claims, for example <code>1example23456789</code> , and the claim that you want to map to the principal, for example <code>sub</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identityTokenOnly(software.amazon.awscdk.IResolvable identityTokenOnly) {
                this.identityTokenOnly = identityTokenOnly;
                return this;
            }

            /**
             * Sets the value of {@link OpenIdConnectTokenSelectionProperty#getIdentityTokenOnly}
             * @param identityTokenOnly The OIDC configuration for processing identity (ID) tokens.
             *                          Contains allowed client ID claims, for example <code>1example23456789</code> , and the claim that you want to map to the principal, for example <code>sub</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identityTokenOnly(software.amazon.awscdk.services.verifiedpermissions.CfnIdentitySource.OpenIdConnectIdentityTokenConfigurationProperty identityTokenOnly) {
                this.identityTokenOnly = identityTokenOnly;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OpenIdConnectTokenSelectionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OpenIdConnectTokenSelectionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OpenIdConnectTokenSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenIdConnectTokenSelectionProperty {
            private final java.lang.Object accessTokenOnly;
            private final java.lang.Object identityTokenOnly;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessTokenOnly = software.amazon.jsii.Kernel.get(this, "accessTokenOnly", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.identityTokenOnly = software.amazon.jsii.Kernel.get(this, "identityTokenOnly", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessTokenOnly = builder.accessTokenOnly;
                this.identityTokenOnly = builder.identityTokenOnly;
            }

            @Override
            public final java.lang.Object getAccessTokenOnly() {
                return this.accessTokenOnly;
            }

            @Override
            public final java.lang.Object getIdentityTokenOnly() {
                return this.identityTokenOnly;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccessTokenOnly() != null) {
                    data.set("accessTokenOnly", om.valueToTree(this.getAccessTokenOnly()));
                }
                if (this.getIdentityTokenOnly() != null) {
                    data.set("identityTokenOnly", om.valueToTree(this.getIdentityTokenOnly()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_verifiedpermissions.CfnIdentitySource.OpenIdConnectTokenSelectionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OpenIdConnectTokenSelectionProperty.Jsii$Proxy that = (OpenIdConnectTokenSelectionProperty.Jsii$Proxy) o;

                if (this.accessTokenOnly != null ? !this.accessTokenOnly.equals(that.accessTokenOnly) : that.accessTokenOnly != null) return false;
                return this.identityTokenOnly != null ? this.identityTokenOnly.equals(that.identityTokenOnly) : that.identityTokenOnly == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accessTokenOnly != null ? this.accessTokenOnly.hashCode() : 0;
                result = 31 * result + (this.identityTokenOnly != null ? this.identityTokenOnly.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.verifiedpermissions.CfnIdentitySource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.verifiedpermissions.CfnIdentitySource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.verifiedpermissions.CfnIdentitySourceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.verifiedpermissions.CfnIdentitySourceProps.Builder();
        }

        /**
         * Contains configuration information used when creating a new identity source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-identitysource.html#cfn-verifiedpermissions-identitysource-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-identitysource.html#cfn-verifiedpermissions-identitysource-configuration</a>
         * @param configuration Contains configuration information used when creating a new identity source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.IResolvable configuration) {
            this.props.configuration(configuration);
            return this;
        }
        /**
         * Contains configuration information used when creating a new identity source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-identitysource.html#cfn-verifiedpermissions-identitysource-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-identitysource.html#cfn-verifiedpermissions-identitysource-configuration</a>
         * @param configuration Contains configuration information used when creating a new identity source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.services.verifiedpermissions.CfnIdentitySource.IdentitySourceConfigurationProperty configuration) {
            this.props.configuration(configuration);
            return this;
        }

        /**
         * Specifies the ID of the policy store in which you want to store this identity source.
         * <p>
         * Only policies and requests made using this policy store can reference identities from the identity provider configured in the new identity source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-identitysource.html#cfn-verifiedpermissions-identitysource-policystoreid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-identitysource.html#cfn-verifiedpermissions-identitysource-policystoreid</a>
         * @param policyStoreId Specifies the ID of the policy store in which you want to store this identity source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyStoreId(final java.lang.String policyStoreId) {
            this.props.policyStoreId(policyStoreId);
            return this;
        }

        /**
         * Specifies the namespace and data type of the principals generated for identities authenticated by the new identity source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-identitysource.html#cfn-verifiedpermissions-identitysource-principalentitytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-identitysource.html#cfn-verifiedpermissions-identitysource-principalentitytype</a>
         * @param principalEntityType Specifies the namespace and data type of the principals generated for identities authenticated by the new identity source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principalEntityType(final java.lang.String principalEntityType) {
            this.props.principalEntityType(principalEntityType);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.verifiedpermissions.CfnIdentitySource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.verifiedpermissions.CfnIdentitySource build() {
            return new software.amazon.awscdk.services.verifiedpermissions.CfnIdentitySource(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
