package software.amazon.awscdk.services.waf.regional;

/**
 * <blockquote><p>This is <em>AWS WAF Classic</em> documentation.<p></blockquote>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.
 * <p>
 * <blockquote>
 * <p>
 * <em>For the latest version of AWS WAF</em> , use the AWS WAF V2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a> . With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 * <p>
 * </blockquote>
 * <p>
 * The <code>AWS::WAFRegional::ByteMatchSet</code> resource creates an AWS WAF <code>ByteMatchSet</code> that identifies a part of a web request that you want to inspect.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.waf.regional.*;
 * CfnByteMatchSet cfnByteMatchSet = CfnByteMatchSet.Builder.create(this, "MyCfnByteMatchSet")
 *         .name("name")
 *         // the properties below are optional
 *         .byteMatchTuples(List.of(ByteMatchTupleProperty.builder()
 *                 .fieldToMatch(FieldToMatchProperty.builder()
 *                         .type("type")
 *                         // the properties below are optional
 *                         .data("data")
 *                         .build())
 *                 .positionalConstraint("positionalConstraint")
 *                 .textTransformation("textTransformation")
 *                 // the properties below are optional
 *                 .targetString("targetString")
 *                 .targetStringBase64("targetStringBase64")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-bytematchset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-bytematchset.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:48.550Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafregional.CfnByteMatchSet")
public class CfnByteMatchSet extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnByteMatchSet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnByteMatchSet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.waf.regional.CfnByteMatchSet.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnByteMatchSet(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.waf.regional.CfnByteMatchSetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A friendly name or description of the <code>ByteMatchSet</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A friendly name or description of the <code>ByteMatchSet</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * Specifies the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getByteMatchTuples() {
        return software.amazon.jsii.Kernel.get(this, "byteMatchTuples", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setByteMatchTuples(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "byteMatchTuples", value);
    }

    /**
     * Specifies the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setByteMatchTuples(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.waf.regional.CfnByteMatchSet.ByteMatchTupleProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.waf.regional.CfnByteMatchSet.ByteMatchTupleProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "byteMatchTuples", value);
    }
    /**
     * <blockquote><p>AWS WAF Classic support will end on September 30, 2025.<p></blockquote>
     * <p>
     * <blockquote>
     * <p>
     * This is <em>AWS WAF Classic</em> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.
     * <p>
     * <em>For the latest version of AWS WAF</em> , use the AWS WAF V2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a> . With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     * <p>
     * </blockquote>
     * <p>
     * The bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.waf.regional.*;
     * ByteMatchTupleProperty byteMatchTupleProperty = ByteMatchTupleProperty.builder()
     *         .fieldToMatch(FieldToMatchProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .data("data")
     *                 .build())
     *         .positionalConstraint("positionalConstraint")
     *         .textTransformation("textTransformation")
     *         // the properties below are optional
     *         .targetString("targetString")
     *         .targetStringBase64("targetStringBase64")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafregional-bytematchset-bytematchtuple.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafregional-bytematchset-bytematchtuple.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafregional.CfnByteMatchSet.ByteMatchTupleProperty")
    @software.amazon.jsii.Jsii.Proxy(ByteMatchTupleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ByteMatchTupleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The part of a web request that you want AWS WAF to inspect, such as a specific header or a query string.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafregional-bytematchset-bytematchtuple.html#cfn-wafregional-bytematchset-bytematchtuple-fieldtomatch">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafregional-bytematchset-bytematchtuple.html#cfn-wafregional-bytematchset-bytematchtuple-fieldtomatch</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFieldToMatch();

        /**
         * Within the portion of a web request that you want to search (for example, in the query string, if any), specify where you want AWS WAF to search.
         * <p>
         * Valid values include the following:
         * <p>
         * <em>CONTAINS</em>
         * <p>
         * The specified part of the web request must include the value of <code>TargetString</code> , but the location doesn't matter.
         * <p>
         * <em>CONTAINS_WORD</em>
         * <p>
         * The specified part of the web request must include the value of <code>TargetString</code> , and <code>TargetString</code> must contain only alphanumeric characters or underscore (A-Z, a-z, 0-9, or _). In addition, <code>TargetString</code> must be a word, which means one of the following:
         * <p>
         * <ul>
         * <li><code>TargetString</code> exactly matches the value of the specified part of the web request, such as the value of a header.</li>
         * <li><code>TargetString</code> is at the beginning of the specified part of the web request and is followed by a character other than an alphanumeric character or underscore (_), for example, <code>BadBot;</code> .</li>
         * <li><code>TargetString</code> is at the end of the specified part of the web request and is preceded by a character other than an alphanumeric character or underscore (_), for example, <code>;BadBot</code> .</li>
         * <li><code>TargetString</code> is in the middle of the specified part of the web request and is preceded and followed by characters other than alphanumeric characters or underscore (_), for example, <code>-BadBot;</code> .</li>
         * </ul>
         * <p>
         * <em>EXACTLY</em>
         * <p>
         * The value of the specified part of the web request must exactly match the value of <code>TargetString</code> .
         * <p>
         * <em>STARTS_WITH</em>
         * <p>
         * The value of <code>TargetString</code> must appear at the beginning of the specified part of the web request.
         * <p>
         * <em>ENDS_WITH</em>
         * <p>
         * The value of <code>TargetString</code> must appear at the end of the specified part of the web request.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafregional-bytematchset-bytematchtuple.html#cfn-wafregional-bytematchset-bytematchtuple-positionalconstraint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafregional-bytematchset-bytematchtuple.html#cfn-wafregional-bytematchset-bytematchtuple-positionalconstraint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPositionalConstraint();

        /**
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass AWS WAF .
         * <p>
         * If you specify a transformation, AWS WAF performs the transformation on <code>FieldToMatch</code> before inspecting it for a match.
         * <p>
         * You can only specify a single type of TextTransformation.
         * <p>
         * <em>CMD_LINE</em>
         * <p>
         * When you're concerned that attackers are injecting an operating system command line command and using unusual formatting to disguise some or all of the command, use this option to perform the following transformations:
         * <p>
         * <ul>
         * <li>Delete the following characters: \ " ' ^</li>
         * <li>Delete spaces before the following characters: / (</li>
         * <li>Replace the following characters with a space: , ;</li>
         * <li>Replace multiple spaces with one space</li>
         * <li>Convert uppercase letters (A-Z) to lowercase (a-z)</li>
         * </ul>
         * <p>
         * <em>COMPRESS_WHITE_SPACE</em>
         * <p>
         * Use this option to replace the following characters with a space character (decimal 32):
         * <p>
         * <ul>
         * <li>\f, formfeed, decimal 12</li>
         * <li>\t, tab, decimal 9</li>
         * <li>\n, newline, decimal 10</li>
         * <li>\r, carriage return, decimal 13</li>
         * <li>\v, vertical tab, decimal 11</li>
         * <li>non-breaking space, decimal 160</li>
         * </ul>
         * <p>
         * <code>COMPRESS_WHITE_SPACE</code> also replaces multiple spaces with one space.
         * <p>
         * <em>HTML_ENTITY_DECODE</em>
         * <p>
         * Use this option to replace HTML-encoded characters with unencoded characters. <code>HTML_ENTITY_DECODE</code> performs the following operations:
         * <p>
         * <ul>
         * <li>Replaces <code>(ampersand)quot;</code> with <code>"</code></li>
         * <li>Replaces <code>(ampersand)nbsp;</code> with a non-breaking space, decimal 160</li>
         * <li>Replaces <code>(ampersand)lt;</code> with a "less than" symbol</li>
         * <li>Replaces <code>(ampersand)gt;</code> with <code>&gt;</code></li>
         * <li>Replaces characters that are represented in hexadecimal format, <code>(ampersand)#xhhhh;</code> , with the corresponding characters</li>
         * <li>Replaces characters that are represented in decimal format, <code>(ampersand)#nnnn;</code> , with the corresponding characters</li>
         * </ul>
         * <p>
         * <em>LOWERCASE</em>
         * <p>
         * Use this option to convert uppercase letters (A-Z) to lowercase (a-z).
         * <p>
         * <em>URL_DECODE</em>
         * <p>
         * Use this option to decode a URL-encoded value.
         * <p>
         * <em>NONE</em>
         * <p>
         * Specify <code>NONE</code> if you don't want to perform any text transformations.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafregional-bytematchset-bytematchtuple.html#cfn-wafregional-bytematchset-bytematchtuple-texttransformation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafregional-bytematchset-bytematchtuple.html#cfn-wafregional-bytematchset-bytematchtuple-texttransformation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTextTransformation();

        /**
         * The value that you want AWS WAF to search for.
         * <p>
         * AWS WAF searches for the specified string in the part of web requests that you specified in <code>FieldToMatch</code> . The maximum length of the value is 50 bytes.
         * <p>
         * You must specify this property or the <code>TargetStringBase64</code> property.
         * <p>
         * Valid values depend on the values that you specified for <code>FieldToMatch</code> :
         * <p>
         * <ul>
         * <li><code>HEADER</code> : The value that you want AWS WAF to search for in the request header that you specified in <code>FieldToMatch</code> , for example, the value of the <code>User-Agent</code> or <code>Referer</code> header.</li>
         * <li><code>METHOD</code> : The HTTP method, which indicates the type of operation specified in the request.</li>
         * <li><code>QUERY_STRING</code> : The value that you want AWS WAF to search for in the query string, which is the part of a URL that appears after a <code>?</code> character.</li>
         * <li><code>URI</code> : The value that you want AWS WAF to search for in the part of a URL that identifies a resource, for example, <code>/images/daily-ad.jpg</code> .</li>
         * <li><code>BODY</code> : The part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form. The request body immediately follows the request headers. Note that only the first <code>8192</code> bytes of the request body are forwarded to AWS WAF for inspection. To allow or block requests based on the length of the body, you can create a size constraint set.</li>
         * <li><code>SINGLE_QUERY_ARG</code> : The parameter in the query string that you will inspect, such as <em>UserName</em> or <em>SalesRegion</em> . The maximum length for <code>SINGLE_QUERY_ARG</code> is 30 characters.</li>
         * <li><code>ALL_QUERY_ARGS</code> : Similar to <code>SINGLE_QUERY_ARG</code> , but instead of inspecting a single parameter, AWS WAF inspects all parameters within the query string for the value or regex pattern that you specify in <code>TargetString</code> .</li>
         * </ul>
         * <p>
         * If <code>TargetString</code> includes alphabetic characters A-Z and a-z, note that the value is case sensitive.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafregional-bytematchset-bytematchtuple.html#cfn-wafregional-bytematchset-bytematchtuple-targetstring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafregional-bytematchset-bytematchtuple.html#cfn-wafregional-bytematchset-bytematchtuple-targetstring</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetString() {
            return null;
        }

        /**
         * The base64-encoded value that AWS WAF searches for. AWS CloudFormation sends this value to AWS WAF without encoding it.
         * <p>
         * You must specify this property or the <code>TargetString</code> property.
         * <p>
         * AWS WAF searches for this value in a specific part of web requests, which you define in the <code>FieldToMatch</code> property.
         * <p>
         * Valid values depend on the Type value in the <code>FieldToMatch</code> property. For example, for a <code>METHOD</code> type, you must specify HTTP methods such as <code>DELETE, GET, HEAD, OPTIONS, PATCH, POST</code> , and <code>PUT</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafregional-bytematchset-bytematchtuple.html#cfn-wafregional-bytematchset-bytematchtuple-targetstringbase64">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafregional-bytematchset-bytematchtuple.html#cfn-wafregional-bytematchset-bytematchtuple-targetstringbase64</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetStringBase64() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ByteMatchTupleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ByteMatchTupleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ByteMatchTupleProperty> {
            java.lang.Object fieldToMatch;
            java.lang.String positionalConstraint;
            java.lang.String textTransformation;
            java.lang.String targetString;
            java.lang.String targetStringBase64;

            /**
             * Sets the value of {@link ByteMatchTupleProperty#getFieldToMatch}
             * @param fieldToMatch The part of a web request that you want AWS WAF to inspect, such as a specific header or a query string. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldToMatch(software.amazon.awscdk.IResolvable fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            /**
             * Sets the value of {@link ByteMatchTupleProperty#getFieldToMatch}
             * @param fieldToMatch The part of a web request that you want AWS WAF to inspect, such as a specific header or a query string. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldToMatch(software.amazon.awscdk.services.waf.regional.CfnByteMatchSet.FieldToMatchProperty fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            /**
             * Sets the value of {@link ByteMatchTupleProperty#getPositionalConstraint}
             * @param positionalConstraint Within the portion of a web request that you want to search (for example, in the query string, if any), specify where you want AWS WAF to search. This parameter is required.
             *                             Valid values include the following:
             *                             <p>
             *                             <em>CONTAINS</em>
             *                             <p>
             *                             The specified part of the web request must include the value of <code>TargetString</code> , but the location doesn't matter.
             *                             <p>
             *                             <em>CONTAINS_WORD</em>
             *                             <p>
             *                             The specified part of the web request must include the value of <code>TargetString</code> , and <code>TargetString</code> must contain only alphanumeric characters or underscore (A-Z, a-z, 0-9, or _). In addition, <code>TargetString</code> must be a word, which means one of the following:
             *                             <p>
             *                             <ul>
             *                             <li><code>TargetString</code> exactly matches the value of the specified part of the web request, such as the value of a header.</li>
             *                             <li><code>TargetString</code> is at the beginning of the specified part of the web request and is followed by a character other than an alphanumeric character or underscore (_), for example, <code>BadBot;</code> .</li>
             *                             <li><code>TargetString</code> is at the end of the specified part of the web request and is preceded by a character other than an alphanumeric character or underscore (_), for example, <code>;BadBot</code> .</li>
             *                             <li><code>TargetString</code> is in the middle of the specified part of the web request and is preceded and followed by characters other than alphanumeric characters or underscore (_), for example, <code>-BadBot;</code> .</li>
             *                             </ul>
             *                             <p>
             *                             <em>EXACTLY</em>
             *                             <p>
             *                             The value of the specified part of the web request must exactly match the value of <code>TargetString</code> .
             *                             <p>
             *                             <em>STARTS_WITH</em>
             *                             <p>
             *                             The value of <code>TargetString</code> must appear at the beginning of the specified part of the web request.
             *                             <p>
             *                             <em>ENDS_WITH</em>
             *                             <p>
             *                             The value of <code>TargetString</code> must appear at the end of the specified part of the web request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder positionalConstraint(java.lang.String positionalConstraint) {
                this.positionalConstraint = positionalConstraint;
                return this;
            }

            /**
             * Sets the value of {@link ByteMatchTupleProperty#getTextTransformation}
             * @param textTransformation Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass AWS WAF . This parameter is required.
             *                           If you specify a transformation, AWS WAF performs the transformation on <code>FieldToMatch</code> before inspecting it for a match.
             *                           <p>
             *                           You can only specify a single type of TextTransformation.
             *                           <p>
             *                           <em>CMD_LINE</em>
             *                           <p>
             *                           When you're concerned that attackers are injecting an operating system command line command and using unusual formatting to disguise some or all of the command, use this option to perform the following transformations:
             *                           <p>
             *                           <ul>
             *                           <li>Delete the following characters: \ " ' ^</li>
             *                           <li>Delete spaces before the following characters: / (</li>
             *                           <li>Replace the following characters with a space: , ;</li>
             *                           <li>Replace multiple spaces with one space</li>
             *                           <li>Convert uppercase letters (A-Z) to lowercase (a-z)</li>
             *                           </ul>
             *                           <p>
             *                           <em>COMPRESS_WHITE_SPACE</em>
             *                           <p>
             *                           Use this option to replace the following characters with a space character (decimal 32):
             *                           <p>
             *                           <ul>
             *                           <li>\f, formfeed, decimal 12</li>
             *                           <li>\t, tab, decimal 9</li>
             *                           <li>\n, newline, decimal 10</li>
             *                           <li>\r, carriage return, decimal 13</li>
             *                           <li>\v, vertical tab, decimal 11</li>
             *                           <li>non-breaking space, decimal 160</li>
             *                           </ul>
             *                           <p>
             *                           <code>COMPRESS_WHITE_SPACE</code> also replaces multiple spaces with one space.
             *                           <p>
             *                           <em>HTML_ENTITY_DECODE</em>
             *                           <p>
             *                           Use this option to replace HTML-encoded characters with unencoded characters. <code>HTML_ENTITY_DECODE</code> performs the following operations:
             *                           <p>
             *                           <ul>
             *                           <li>Replaces <code>(ampersand)quot;</code> with <code>"</code></li>
             *                           <li>Replaces <code>(ampersand)nbsp;</code> with a non-breaking space, decimal 160</li>
             *                           <li>Replaces <code>(ampersand)lt;</code> with a "less than" symbol</li>
             *                           <li>Replaces <code>(ampersand)gt;</code> with <code>&gt;</code></li>
             *                           <li>Replaces characters that are represented in hexadecimal format, <code>(ampersand)#xhhhh;</code> , with the corresponding characters</li>
             *                           <li>Replaces characters that are represented in decimal format, <code>(ampersand)#nnnn;</code> , with the corresponding characters</li>
             *                           </ul>
             *                           <p>
             *                           <em>LOWERCASE</em>
             *                           <p>
             *                           Use this option to convert uppercase letters (A-Z) to lowercase (a-z).
             *                           <p>
             *                           <em>URL_DECODE</em>
             *                           <p>
             *                           Use this option to decode a URL-encoded value.
             *                           <p>
             *                           <em>NONE</em>
             *                           <p>
             *                           Specify <code>NONE</code> if you don't want to perform any text transformations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textTransformation(java.lang.String textTransformation) {
                this.textTransformation = textTransformation;
                return this;
            }

            /**
             * Sets the value of {@link ByteMatchTupleProperty#getTargetString}
             * @param targetString The value that you want AWS WAF to search for.
             *                     AWS WAF searches for the specified string in the part of web requests that you specified in <code>FieldToMatch</code> . The maximum length of the value is 50 bytes.
             *                     <p>
             *                     You must specify this property or the <code>TargetStringBase64</code> property.
             *                     <p>
             *                     Valid values depend on the values that you specified for <code>FieldToMatch</code> :
             *                     <p>
             *                     <ul>
             *                     <li><code>HEADER</code> : The value that you want AWS WAF to search for in the request header that you specified in <code>FieldToMatch</code> , for example, the value of the <code>User-Agent</code> or <code>Referer</code> header.</li>
             *                     <li><code>METHOD</code> : The HTTP method, which indicates the type of operation specified in the request.</li>
             *                     <li><code>QUERY_STRING</code> : The value that you want AWS WAF to search for in the query string, which is the part of a URL that appears after a <code>?</code> character.</li>
             *                     <li><code>URI</code> : The value that you want AWS WAF to search for in the part of a URL that identifies a resource, for example, <code>/images/daily-ad.jpg</code> .</li>
             *                     <li><code>BODY</code> : The part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form. The request body immediately follows the request headers. Note that only the first <code>8192</code> bytes of the request body are forwarded to AWS WAF for inspection. To allow or block requests based on the length of the body, you can create a size constraint set.</li>
             *                     <li><code>SINGLE_QUERY_ARG</code> : The parameter in the query string that you will inspect, such as <em>UserName</em> or <em>SalesRegion</em> . The maximum length for <code>SINGLE_QUERY_ARG</code> is 30 characters.</li>
             *                     <li><code>ALL_QUERY_ARGS</code> : Similar to <code>SINGLE_QUERY_ARG</code> , but instead of inspecting a single parameter, AWS WAF inspects all parameters within the query string for the value or regex pattern that you specify in <code>TargetString</code> .</li>
             *                     </ul>
             *                     <p>
             *                     If <code>TargetString</code> includes alphabetic characters A-Z and a-z, note that the value is case sensitive.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetString(java.lang.String targetString) {
                this.targetString = targetString;
                return this;
            }

            /**
             * Sets the value of {@link ByteMatchTupleProperty#getTargetStringBase64}
             * @param targetStringBase64 The base64-encoded value that AWS WAF searches for. AWS CloudFormation sends this value to AWS WAF without encoding it.
             *                           You must specify this property or the <code>TargetString</code> property.
             *                           <p>
             *                           AWS WAF searches for this value in a specific part of web requests, which you define in the <code>FieldToMatch</code> property.
             *                           <p>
             *                           Valid values depend on the Type value in the <code>FieldToMatch</code> property. For example, for a <code>METHOD</code> type, you must specify HTTP methods such as <code>DELETE, GET, HEAD, OPTIONS, PATCH, POST</code> , and <code>PUT</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetStringBase64(java.lang.String targetStringBase64) {
                this.targetStringBase64 = targetStringBase64;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ByteMatchTupleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ByteMatchTupleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ByteMatchTupleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ByteMatchTupleProperty {
            private final java.lang.Object fieldToMatch;
            private final java.lang.String positionalConstraint;
            private final java.lang.String textTransformation;
            private final java.lang.String targetString;
            private final java.lang.String targetStringBase64;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fieldToMatch = software.amazon.jsii.Kernel.get(this, "fieldToMatch", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.positionalConstraint = software.amazon.jsii.Kernel.get(this, "positionalConstraint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.textTransformation = software.amazon.jsii.Kernel.get(this, "textTransformation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetString = software.amazon.jsii.Kernel.get(this, "targetString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetStringBase64 = software.amazon.jsii.Kernel.get(this, "targetStringBase64", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fieldToMatch = java.util.Objects.requireNonNull(builder.fieldToMatch, "fieldToMatch is required");
                this.positionalConstraint = java.util.Objects.requireNonNull(builder.positionalConstraint, "positionalConstraint is required");
                this.textTransformation = java.util.Objects.requireNonNull(builder.textTransformation, "textTransformation is required");
                this.targetString = builder.targetString;
                this.targetStringBase64 = builder.targetStringBase64;
            }

            @Override
            public final java.lang.Object getFieldToMatch() {
                return this.fieldToMatch;
            }

            @Override
            public final java.lang.String getPositionalConstraint() {
                return this.positionalConstraint;
            }

            @Override
            public final java.lang.String getTextTransformation() {
                return this.textTransformation;
            }

            @Override
            public final java.lang.String getTargetString() {
                return this.targetString;
            }

            @Override
            public final java.lang.String getTargetStringBase64() {
                return this.targetStringBase64;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fieldToMatch", om.valueToTree(this.getFieldToMatch()));
                data.set("positionalConstraint", om.valueToTree(this.getPositionalConstraint()));
                data.set("textTransformation", om.valueToTree(this.getTextTransformation()));
                if (this.getTargetString() != null) {
                    data.set("targetString", om.valueToTree(this.getTargetString()));
                }
                if (this.getTargetStringBase64() != null) {
                    data.set("targetStringBase64", om.valueToTree(this.getTargetStringBase64()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafregional.CfnByteMatchSet.ByteMatchTupleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ByteMatchTupleProperty.Jsii$Proxy that = (ByteMatchTupleProperty.Jsii$Proxy) o;

                if (!fieldToMatch.equals(that.fieldToMatch)) return false;
                if (!positionalConstraint.equals(that.positionalConstraint)) return false;
                if (!textTransformation.equals(that.textTransformation)) return false;
                if (this.targetString != null ? !this.targetString.equals(that.targetString) : that.targetString != null) return false;
                return this.targetStringBase64 != null ? this.targetStringBase64.equals(that.targetStringBase64) : that.targetStringBase64 == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fieldToMatch.hashCode();
                result = 31 * result + (this.positionalConstraint.hashCode());
                result = 31 * result + (this.textTransformation.hashCode());
                result = 31 * result + (this.targetString != null ? this.targetString.hashCode() : 0);
                result = 31 * result + (this.targetStringBase64 != null ? this.targetStringBase64.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <blockquote><p>AWS WAF Classic support will end on September 30, 2025.<p></blockquote>
     * <p>
     * <blockquote>
     * <p>
     * This is <em>AWS WAF Classic</em> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.
     * <p>
     * <em>For the latest version of AWS WAF</em> , use the AWS WAF V2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a> . With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     * <p>
     * </blockquote>
     * <p>
     * Specifies where in a web request to look for <code>TargetString</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.waf.regional.*;
     * FieldToMatchProperty fieldToMatchProperty = FieldToMatchProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .data("data")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafregional-bytematchset-fieldtomatch.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafregional-bytematchset-fieldtomatch.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafregional.CfnByteMatchSet.FieldToMatchProperty")
    @software.amazon.jsii.Jsii.Proxy(FieldToMatchProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FieldToMatchProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The part of the web request that you want AWS WAF to search for a specified string.
         * <p>
         * Parts of a request that you can search include the following:
         * <p>
         * <ul>
         * <li><code>HEADER</code> : A specified request header, for example, the value of the <code>User-Agent</code> or <code>Referer</code> header. If you choose <code>HEADER</code> for the type, specify the name of the header in <code>Data</code> .</li>
         * <li><code>METHOD</code> : The HTTP method, which indicated the type of operation that the request is asking the origin to perform.</li>
         * <li><code>QUERY_STRING</code> : A query string, which is the part of a URL that appears after a <code>?</code> character, if any.</li>
         * <li><code>URI</code> : The part of a web request that identifies a resource, for example, <code>/images/daily-ad.jpg</code> .</li>
         * <li><code>BODY</code> : The part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form. The request body immediately follows the request headers. Note that only the first <code>8192</code> bytes of the request body are forwarded to AWS WAF for inspection. To allow or block requests based on the length of the body, you can create a size constraint set.</li>
         * <li><code>SINGLE_QUERY_ARG</code> : The parameter in the query string that you will inspect, such as <em>UserName</em> or <em>SalesRegion</em> . The maximum length for <code>SINGLE_QUERY_ARG</code> is 30 characters.</li>
         * <li><code>ALL_QUERY_ARGS</code> : Similar to <code>SINGLE_QUERY_ARG</code> , but rather than inspecting a single parameter, AWS WAF will inspect all parameters within the query for the value or regex pattern that you specify in <code>TargetString</code> .</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafregional-bytematchset-fieldtomatch.html#cfn-wafregional-bytematchset-fieldtomatch-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafregional-bytematchset-fieldtomatch.html#cfn-wafregional-bytematchset-fieldtomatch-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * When the value of <code>Type</code> is <code>HEADER</code> , enter the name of the header that you want AWS WAF to search, for example, <code>User-Agent</code> or <code>Referer</code> .
         * <p>
         * The name of the header is not case sensitive.
         * <p>
         * When the value of <code>Type</code> is <code>SINGLE_QUERY_ARG</code> , enter the name of the parameter that you want AWS WAF to search, for example, <code>UserName</code> or <code>SalesRegion</code> . The parameter name is not case sensitive.
         * <p>
         * If the value of <code>Type</code> is any other value, omit <code>Data</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafregional-bytematchset-fieldtomatch.html#cfn-wafregional-bytematchset-fieldtomatch-data">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafregional-bytematchset-fieldtomatch.html#cfn-wafregional-bytematchset-fieldtomatch-data</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getData() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FieldToMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FieldToMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FieldToMatchProperty> {
            java.lang.String type;
            java.lang.String data;

            /**
             * Sets the value of {@link FieldToMatchProperty#getType}
             * @param type The part of the web request that you want AWS WAF to search for a specified string. This parameter is required.
             *             Parts of a request that you can search include the following:
             *             <p>
             *             <ul>
             *             <li><code>HEADER</code> : A specified request header, for example, the value of the <code>User-Agent</code> or <code>Referer</code> header. If you choose <code>HEADER</code> for the type, specify the name of the header in <code>Data</code> .</li>
             *             <li><code>METHOD</code> : The HTTP method, which indicated the type of operation that the request is asking the origin to perform.</li>
             *             <li><code>QUERY_STRING</code> : A query string, which is the part of a URL that appears after a <code>?</code> character, if any.</li>
             *             <li><code>URI</code> : The part of a web request that identifies a resource, for example, <code>/images/daily-ad.jpg</code> .</li>
             *             <li><code>BODY</code> : The part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form. The request body immediately follows the request headers. Note that only the first <code>8192</code> bytes of the request body are forwarded to AWS WAF for inspection. To allow or block requests based on the length of the body, you can create a size constraint set.</li>
             *             <li><code>SINGLE_QUERY_ARG</code> : The parameter in the query string that you will inspect, such as <em>UserName</em> or <em>SalesRegion</em> . The maximum length for <code>SINGLE_QUERY_ARG</code> is 30 characters.</li>
             *             <li><code>ALL_QUERY_ARGS</code> : Similar to <code>SINGLE_QUERY_ARG</code> , but rather than inspecting a single parameter, AWS WAF will inspect all parameters within the query for the value or regex pattern that you specify in <code>TargetString</code> .</li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getData}
             * @param data When the value of <code>Type</code> is <code>HEADER</code> , enter the name of the header that you want AWS WAF to search, for example, <code>User-Agent</code> or <code>Referer</code> .
             *             The name of the header is not case sensitive.
             *             <p>
             *             When the value of <code>Type</code> is <code>SINGLE_QUERY_ARG</code> , enter the name of the parameter that you want AWS WAF to search, for example, <code>UserName</code> or <code>SalesRegion</code> . The parameter name is not case sensitive.
             *             <p>
             *             If the value of <code>Type</code> is any other value, omit <code>Data</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder data(java.lang.String data) {
                this.data = data;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FieldToMatchProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FieldToMatchProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FieldToMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FieldToMatchProperty {
            private final java.lang.String type;
            private final java.lang.String data;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.data = software.amazon.jsii.Kernel.get(this, "data", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.data = builder.data;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getData() {
                return this.data;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getData() != null) {
                    data.set("data", om.valueToTree(this.getData()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafregional.CfnByteMatchSet.FieldToMatchProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FieldToMatchProperty.Jsii$Proxy that = (FieldToMatchProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.data != null ? this.data.equals(that.data) : that.data == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.waf.regional.CfnByteMatchSet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.waf.regional.CfnByteMatchSet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.waf.regional.CfnByteMatchSetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.waf.regional.CfnByteMatchSetProps.Builder();
        }

        /**
         * A friendly name or description of the <code>ByteMatchSet</code> .
         * <p>
         * You can't change <code>Name</code> after you create a <code>ByteMatchSet</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-bytematchset.html#cfn-wafregional-bytematchset-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-bytematchset.html#cfn-wafregional-bytematchset-name</a>
         * @param name A friendly name or description of the <code>ByteMatchSet</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Specifies the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-bytematchset.html#cfn-wafregional-bytematchset-bytematchtuples">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-bytematchset.html#cfn-wafregional-bytematchset-bytematchtuples</a>
         * @param byteMatchTuples Specifies the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder byteMatchTuples(final software.amazon.awscdk.IResolvable byteMatchTuples) {
            this.props.byteMatchTuples(byteMatchTuples);
            return this;
        }
        /**
         * Specifies the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-bytematchset.html#cfn-wafregional-bytematchset-bytematchtuples">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-bytematchset.html#cfn-wafregional-bytematchset-bytematchtuples</a>
         * @param byteMatchTuples Specifies the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder byteMatchTuples(final java.util.List<? extends java.lang.Object> byteMatchTuples) {
            this.props.byteMatchTuples(byteMatchTuples);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.waf.regional.CfnByteMatchSet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.waf.regional.CfnByteMatchSet build() {
            return new software.amazon.awscdk.services.waf.regional.CfnByteMatchSet(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
