package software.amazon.awscdk.services.wisdom;

/**
 * Properties for defining a <code>CfnAIGuardrail</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.wisdom.*;
 * CfnAIGuardrailProps cfnAIGuardrailProps = CfnAIGuardrailProps.builder()
 *         .assistantId("assistantId")
 *         .blockedInputMessaging("blockedInputMessaging")
 *         .blockedOutputsMessaging("blockedOutputsMessaging")
 *         // the properties below are optional
 *         .contentPolicyConfig(AIGuardrailContentPolicyConfigProperty.builder()
 *                 .filtersConfig(List.of(GuardrailContentFilterConfigProperty.builder()
 *                         .inputStrength("inputStrength")
 *                         .outputStrength("outputStrength")
 *                         .type("type")
 *                         .build()))
 *                 .build())
 *         .contextualGroundingPolicyConfig(AIGuardrailContextualGroundingPolicyConfigProperty.builder()
 *                 .filtersConfig(List.of(GuardrailContextualGroundingFilterConfigProperty.builder()
 *                         .threshold(123)
 *                         .type("type")
 *                         .build()))
 *                 .build())
 *         .description("description")
 *         .name("name")
 *         .sensitiveInformationPolicyConfig(AIGuardrailSensitiveInformationPolicyConfigProperty.builder()
 *                 .piiEntitiesConfig(List.of(GuardrailPiiEntityConfigProperty.builder()
 *                         .action("action")
 *                         .type("type")
 *                         .build()))
 *                 .regexesConfig(List.of(GuardrailRegexConfigProperty.builder()
 *                         .action("action")
 *                         .name("name")
 *                         .pattern("pattern")
 *                         // the properties below are optional
 *                         .description("description")
 *                         .build()))
 *                 .build())
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .topicPolicyConfig(AIGuardrailTopicPolicyConfigProperty.builder()
 *                 .topicsConfig(List.of(GuardrailTopicConfigProperty.builder()
 *                         .definition("definition")
 *                         .name("name")
 *                         .type("type")
 *                         // the properties below are optional
 *                         .examples(List.of("examples"))
 *                         .build()))
 *                 .build())
 *         .wordPolicyConfig(AIGuardrailWordPolicyConfigProperty.builder()
 *                 .managedWordListsConfig(List.of(GuardrailManagedWordsConfigProperty.builder()
 *                         .type("type")
 *                         .build()))
 *                 .wordsConfig(List.of(GuardrailWordConfigProperty.builder()
 *                         .text("text")
 *                         .build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:48.788Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnAIGuardrailProps")
@software.amazon.jsii.Jsii.Proxy(CfnAIGuardrailProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAIGuardrailProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The identifier of the Amazon Q in Connect assistant.
     * <p>
     * Can be either the ID or the ARN. URLs cannot contain the ARN.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-assistantid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-assistantid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAssistantId();

    /**
     * The message to return when the AI Guardrail blocks a prompt.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-blockedinputmessaging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-blockedinputmessaging</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBlockedInputMessaging();

    /**
     * The message to return when the AI Guardrail blocks a model response.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-blockedoutputsmessaging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-blockedoutputsmessaging</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBlockedOutputsMessaging();

    /**
     * Contains details about how to handle harmful content.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-contentpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-contentpolicyconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getContentPolicyConfig() {
        return null;
    }

    /**
     * The policy configuration details for the AI Guardrail's contextual grounding policy.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-contextualgroundingpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-contextualgroundingpolicyconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getContextualGroundingPolicyConfig() {
        return null;
    }

    /**
     * A description of the AI Guardrail.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The name of the AI Guardrail.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * Contains details about PII entities and regular expressions to configure for the AI Guardrail.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-sensitiveinformationpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-sensitiveinformationpolicyconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSensitiveInformationPolicyConfig() {
        return null;
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * Contains details about topics that the AI Guardrail should identify and deny.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-topicpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-topicpolicyconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTopicPolicyConfig() {
        return null;
    }

    /**
     * Contains details about the word policy to configured for the AI Guardrail.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-wordpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-wordpolicyconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getWordPolicyConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAIGuardrailProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAIGuardrailProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAIGuardrailProps> {
        java.lang.String assistantId;
        java.lang.String blockedInputMessaging;
        java.lang.String blockedOutputsMessaging;
        java.lang.Object contentPolicyConfig;
        java.lang.Object contextualGroundingPolicyConfig;
        java.lang.String description;
        java.lang.String name;
        java.lang.Object sensitiveInformationPolicyConfig;
        java.util.Map<java.lang.String, java.lang.String> tags;
        java.lang.Object topicPolicyConfig;
        java.lang.Object wordPolicyConfig;

        /**
         * Sets the value of {@link CfnAIGuardrailProps#getAssistantId}
         * @param assistantId The identifier of the Amazon Q in Connect assistant. This parameter is required.
         *                    Can be either the ID or the ARN. URLs cannot contain the ARN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assistantId(java.lang.String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIGuardrailProps#getBlockedInputMessaging}
         * @param blockedInputMessaging The message to return when the AI Guardrail blocks a prompt. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockedInputMessaging(java.lang.String blockedInputMessaging) {
            this.blockedInputMessaging = blockedInputMessaging;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIGuardrailProps#getBlockedOutputsMessaging}
         * @param blockedOutputsMessaging The message to return when the AI Guardrail blocks a model response. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockedOutputsMessaging(java.lang.String blockedOutputsMessaging) {
            this.blockedOutputsMessaging = blockedOutputsMessaging;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIGuardrailProps#getContentPolicyConfig}
         * @param contentPolicyConfig Contains details about how to handle harmful content.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentPolicyConfig(software.amazon.awscdk.IResolvable contentPolicyConfig) {
            this.contentPolicyConfig = contentPolicyConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIGuardrailProps#getContentPolicyConfig}
         * @param contentPolicyConfig Contains details about how to handle harmful content.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentPolicyConfig(software.amazon.awscdk.services.wisdom.CfnAIGuardrail.AIGuardrailContentPolicyConfigProperty contentPolicyConfig) {
            this.contentPolicyConfig = contentPolicyConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIGuardrailProps#getContextualGroundingPolicyConfig}
         * @param contextualGroundingPolicyConfig The policy configuration details for the AI Guardrail's contextual grounding policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contextualGroundingPolicyConfig(software.amazon.awscdk.IResolvable contextualGroundingPolicyConfig) {
            this.contextualGroundingPolicyConfig = contextualGroundingPolicyConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIGuardrailProps#getContextualGroundingPolicyConfig}
         * @param contextualGroundingPolicyConfig The policy configuration details for the AI Guardrail's contextual grounding policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contextualGroundingPolicyConfig(software.amazon.awscdk.services.wisdom.CfnAIGuardrail.AIGuardrailContextualGroundingPolicyConfigProperty contextualGroundingPolicyConfig) {
            this.contextualGroundingPolicyConfig = contextualGroundingPolicyConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIGuardrailProps#getDescription}
         * @param description A description of the AI Guardrail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIGuardrailProps#getName}
         * @param name The name of the AI Guardrail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIGuardrailProps#getSensitiveInformationPolicyConfig}
         * @param sensitiveInformationPolicyConfig Contains details about PII entities and regular expressions to configure for the AI Guardrail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sensitiveInformationPolicyConfig(software.amazon.awscdk.IResolvable sensitiveInformationPolicyConfig) {
            this.sensitiveInformationPolicyConfig = sensitiveInformationPolicyConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIGuardrailProps#getSensitiveInformationPolicyConfig}
         * @param sensitiveInformationPolicyConfig Contains details about PII entities and regular expressions to configure for the AI Guardrail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sensitiveInformationPolicyConfig(software.amazon.awscdk.services.wisdom.CfnAIGuardrail.AIGuardrailSensitiveInformationPolicyConfigProperty sensitiveInformationPolicyConfig) {
            this.sensitiveInformationPolicyConfig = sensitiveInformationPolicyConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIGuardrailProps#getTags}
         * @param tags The tags used to organize, track, or control access for this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIGuardrailProps#getTopicPolicyConfig}
         * @param topicPolicyConfig Contains details about topics that the AI Guardrail should identify and deny.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topicPolicyConfig(software.amazon.awscdk.IResolvable topicPolicyConfig) {
            this.topicPolicyConfig = topicPolicyConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIGuardrailProps#getTopicPolicyConfig}
         * @param topicPolicyConfig Contains details about topics that the AI Guardrail should identify and deny.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topicPolicyConfig(software.amazon.awscdk.services.wisdom.CfnAIGuardrail.AIGuardrailTopicPolicyConfigProperty topicPolicyConfig) {
            this.topicPolicyConfig = topicPolicyConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIGuardrailProps#getWordPolicyConfig}
         * @param wordPolicyConfig Contains details about the word policy to configured for the AI Guardrail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder wordPolicyConfig(software.amazon.awscdk.IResolvable wordPolicyConfig) {
            this.wordPolicyConfig = wordPolicyConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIGuardrailProps#getWordPolicyConfig}
         * @param wordPolicyConfig Contains details about the word policy to configured for the AI Guardrail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder wordPolicyConfig(software.amazon.awscdk.services.wisdom.CfnAIGuardrail.AIGuardrailWordPolicyConfigProperty wordPolicyConfig) {
            this.wordPolicyConfig = wordPolicyConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAIGuardrailProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAIGuardrailProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAIGuardrailProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAIGuardrailProps {
        private final java.lang.String assistantId;
        private final java.lang.String blockedInputMessaging;
        private final java.lang.String blockedOutputsMessaging;
        private final java.lang.Object contentPolicyConfig;
        private final java.lang.Object contextualGroundingPolicyConfig;
        private final java.lang.String description;
        private final java.lang.String name;
        private final java.lang.Object sensitiveInformationPolicyConfig;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final java.lang.Object topicPolicyConfig;
        private final java.lang.Object wordPolicyConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assistantId = software.amazon.jsii.Kernel.get(this, "assistantId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.blockedInputMessaging = software.amazon.jsii.Kernel.get(this, "blockedInputMessaging", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.blockedOutputsMessaging = software.amazon.jsii.Kernel.get(this, "blockedOutputsMessaging", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.contentPolicyConfig = software.amazon.jsii.Kernel.get(this, "contentPolicyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.contextualGroundingPolicyConfig = software.amazon.jsii.Kernel.get(this, "contextualGroundingPolicyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sensitiveInformationPolicyConfig = software.amazon.jsii.Kernel.get(this, "sensitiveInformationPolicyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.topicPolicyConfig = software.amazon.jsii.Kernel.get(this, "topicPolicyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.wordPolicyConfig = software.amazon.jsii.Kernel.get(this, "wordPolicyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assistantId = java.util.Objects.requireNonNull(builder.assistantId, "assistantId is required");
            this.blockedInputMessaging = java.util.Objects.requireNonNull(builder.blockedInputMessaging, "blockedInputMessaging is required");
            this.blockedOutputsMessaging = java.util.Objects.requireNonNull(builder.blockedOutputsMessaging, "blockedOutputsMessaging is required");
            this.contentPolicyConfig = builder.contentPolicyConfig;
            this.contextualGroundingPolicyConfig = builder.contextualGroundingPolicyConfig;
            this.description = builder.description;
            this.name = builder.name;
            this.sensitiveInformationPolicyConfig = builder.sensitiveInformationPolicyConfig;
            this.tags = builder.tags;
            this.topicPolicyConfig = builder.topicPolicyConfig;
            this.wordPolicyConfig = builder.wordPolicyConfig;
        }

        @Override
        public final java.lang.String getAssistantId() {
            return this.assistantId;
        }

        @Override
        public final java.lang.String getBlockedInputMessaging() {
            return this.blockedInputMessaging;
        }

        @Override
        public final java.lang.String getBlockedOutputsMessaging() {
            return this.blockedOutputsMessaging;
        }

        @Override
        public final java.lang.Object getContentPolicyConfig() {
            return this.contentPolicyConfig;
        }

        @Override
        public final java.lang.Object getContextualGroundingPolicyConfig() {
            return this.contextualGroundingPolicyConfig;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getSensitiveInformationPolicyConfig() {
            return this.sensitiveInformationPolicyConfig;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTopicPolicyConfig() {
            return this.topicPolicyConfig;
        }

        @Override
        public final java.lang.Object getWordPolicyConfig() {
            return this.wordPolicyConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("assistantId", om.valueToTree(this.getAssistantId()));
            data.set("blockedInputMessaging", om.valueToTree(this.getBlockedInputMessaging()));
            data.set("blockedOutputsMessaging", om.valueToTree(this.getBlockedOutputsMessaging()));
            if (this.getContentPolicyConfig() != null) {
                data.set("contentPolicyConfig", om.valueToTree(this.getContentPolicyConfig()));
            }
            if (this.getContextualGroundingPolicyConfig() != null) {
                data.set("contextualGroundingPolicyConfig", om.valueToTree(this.getContextualGroundingPolicyConfig()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getSensitiveInformationPolicyConfig() != null) {
                data.set("sensitiveInformationPolicyConfig", om.valueToTree(this.getSensitiveInformationPolicyConfig()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTopicPolicyConfig() != null) {
                data.set("topicPolicyConfig", om.valueToTree(this.getTopicPolicyConfig()));
            }
            if (this.getWordPolicyConfig() != null) {
                data.set("wordPolicyConfig", om.valueToTree(this.getWordPolicyConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnAIGuardrailProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAIGuardrailProps.Jsii$Proxy that = (CfnAIGuardrailProps.Jsii$Proxy) o;

            if (!assistantId.equals(that.assistantId)) return false;
            if (!blockedInputMessaging.equals(that.blockedInputMessaging)) return false;
            if (!blockedOutputsMessaging.equals(that.blockedOutputsMessaging)) return false;
            if (this.contentPolicyConfig != null ? !this.contentPolicyConfig.equals(that.contentPolicyConfig) : that.contentPolicyConfig != null) return false;
            if (this.contextualGroundingPolicyConfig != null ? !this.contextualGroundingPolicyConfig.equals(that.contextualGroundingPolicyConfig) : that.contextualGroundingPolicyConfig != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.sensitiveInformationPolicyConfig != null ? !this.sensitiveInformationPolicyConfig.equals(that.sensitiveInformationPolicyConfig) : that.sensitiveInformationPolicyConfig != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.topicPolicyConfig != null ? !this.topicPolicyConfig.equals(that.topicPolicyConfig) : that.topicPolicyConfig != null) return false;
            return this.wordPolicyConfig != null ? this.wordPolicyConfig.equals(that.wordPolicyConfig) : that.wordPolicyConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.assistantId.hashCode();
            result = 31 * result + (this.blockedInputMessaging.hashCode());
            result = 31 * result + (this.blockedOutputsMessaging.hashCode());
            result = 31 * result + (this.contentPolicyConfig != null ? this.contentPolicyConfig.hashCode() : 0);
            result = 31 * result + (this.contextualGroundingPolicyConfig != null ? this.contextualGroundingPolicyConfig.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.sensitiveInformationPolicyConfig != null ? this.sensitiveInformationPolicyConfig.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.topicPolicyConfig != null ? this.topicPolicyConfig.hashCode() : 0);
            result = 31 * result + (this.wordPolicyConfig != null ? this.wordPolicyConfig.hashCode() : 0);
            return result;
        }
    }
}
