/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.bedrock;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.bedrock.CfnDataSource;
import software.amazon.awscdk.services.bedrock.CfnDataSourceProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource")
public class CfnDataSource
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnDataSource.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnDataSource(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataSource(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnDataSource(@NotNull Construct scope, @NotNull String id, @NotNull CfnDataSourceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrCreatedAt() {
        return (String)Kernel.get((Object)this, (String)"attrCreatedAt", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrDataSourceConfigurationWebConfigurationCrawlerConfigurationUserAgentHeader() {
        return (String)Kernel.get((Object)this, (String)"attrDataSourceConfigurationWebConfigurationCrawlerConfigurationUserAgentHeader", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrDataSourceId() {
        return (String)Kernel.get((Object)this, (String)"attrDataSourceId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrDataSourceStatus() {
        return (String)Kernel.get((Object)this, (String)"attrDataSourceStatus", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public List<String> getAttrFailureReasons() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"attrFailureReasons", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public String getAttrUpdatedAt() {
        return (String)Kernel.get((Object)this, (String)"attrUpdatedAt", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getDataSourceConfiguration() {
        return Kernel.get((Object)this, (String)"dataSourceConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDataSourceConfiguration(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"dataSourceConfiguration", (Object)Objects.requireNonNull(value, "dataSourceConfiguration is required"));
    }

    public void setDataSourceConfiguration(@NotNull DataSourceConfigurationProperty value) {
        Kernel.set((Object)this, (String)"dataSourceConfiguration", (Object)Objects.requireNonNull(value, "dataSourceConfiguration is required"));
    }

    @NotNull
    public String getKnowledgeBaseId() {
        return (String)Kernel.get((Object)this, (String)"knowledgeBaseId", (NativeType)NativeType.forClass(String.class));
    }

    public void setKnowledgeBaseId(@NotNull String value) {
        Kernel.set((Object)this, (String)"knowledgeBaseId", (Object)Objects.requireNonNull(value, "knowledgeBaseId is required"));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @Nullable
    public String getDataDeletionPolicy() {
        return (String)Kernel.get((Object)this, (String)"dataDeletionPolicy", (NativeType)NativeType.forClass(String.class));
    }

    public void setDataDeletionPolicy(@Nullable String value) {
        Kernel.set((Object)this, (String)"dataDeletionPolicy", (Object)value);
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public Object getServerSideEncryptionConfiguration() {
        return Kernel.get((Object)this, (String)"serverSideEncryptionConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setServerSideEncryptionConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"serverSideEncryptionConfiguration", (Object)value);
    }

    public void setServerSideEncryptionConfiguration(@Nullable ServerSideEncryptionConfigurationProperty value) {
        Kernel.set((Object)this, (String)"serverSideEncryptionConfiguration", (Object)value);
    }

    @Nullable
    public Object getVectorIngestionConfiguration() {
        return Kernel.get((Object)this, (String)"vectorIngestionConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setVectorIngestionConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"vectorIngestionConfiguration", (Object)value);
    }

    public void setVectorIngestionConfiguration(@Nullable VectorIngestionConfigurationProperty value) {
        Kernel.set((Object)this, (String)"vectorIngestionConfiguration", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnDataSource> {
        private final Construct scope;
        private final String id;
        private final CfnDataSourceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnDataSourceProps.Builder();
        }

        public Builder dataSourceConfiguration(IResolvable dataSourceConfiguration) {
            this.props.dataSourceConfiguration(dataSourceConfiguration);
            return this;
        }

        public Builder dataSourceConfiguration(DataSourceConfigurationProperty dataSourceConfiguration) {
            this.props.dataSourceConfiguration(dataSourceConfiguration);
            return this;
        }

        public Builder knowledgeBaseId(String knowledgeBaseId) {
            this.props.knowledgeBaseId(knowledgeBaseId);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder dataDeletionPolicy(String dataDeletionPolicy) {
            this.props.dataDeletionPolicy(dataDeletionPolicy);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder serverSideEncryptionConfiguration(IResolvable serverSideEncryptionConfiguration) {
            this.props.serverSideEncryptionConfiguration(serverSideEncryptionConfiguration);
            return this;
        }

        public Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfigurationProperty serverSideEncryptionConfiguration) {
            this.props.serverSideEncryptionConfiguration(serverSideEncryptionConfiguration);
            return this;
        }

        public Builder vectorIngestionConfiguration(IResolvable vectorIngestionConfiguration) {
            this.props.vectorIngestionConfiguration(vectorIngestionConfiguration);
            return this;
        }

        public Builder vectorIngestionConfiguration(VectorIngestionConfigurationProperty vectorIngestionConfiguration) {
            this.props.vectorIngestionConfiguration(vectorIngestionConfiguration);
            return this;
        }

        public CfnDataSource build() {
            return new CfnDataSource(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.WebSourceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WebSourceConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getUrlConfiguration();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WebSourceConfigurationProperty> {
            Object urlConfiguration;

            public Builder urlConfiguration(IResolvable urlConfiguration) {
                this.urlConfiguration = urlConfiguration;
                return this;
            }

            public Builder urlConfiguration(UrlConfigurationProperty urlConfiguration) {
                this.urlConfiguration = urlConfiguration;
                return this;
            }

            public WebSourceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.WebDataSourceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WebDataSourceConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getSourceConfiguration();

        @Nullable
        default public Object getCrawlerConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WebDataSourceConfigurationProperty> {
            Object sourceConfiguration;
            Object crawlerConfiguration;

            public Builder sourceConfiguration(IResolvable sourceConfiguration) {
                this.sourceConfiguration = sourceConfiguration;
                return this;
            }

            public Builder sourceConfiguration(WebSourceConfigurationProperty sourceConfiguration) {
                this.sourceConfiguration = sourceConfiguration;
                return this;
            }

            public Builder crawlerConfiguration(IResolvable crawlerConfiguration) {
                this.crawlerConfiguration = crawlerConfiguration;
                return this;
            }

            public Builder crawlerConfiguration(WebCrawlerConfigurationProperty crawlerConfiguration) {
                this.crawlerConfiguration = crawlerConfiguration;
                return this;
            }

            public WebDataSourceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.WebCrawlerLimitsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WebCrawlerLimitsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMaxPages() {
            return null;
        }

        @Nullable
        default public Number getRateLimit() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WebCrawlerLimitsProperty> {
            Number maxPages;
            Number rateLimit;

            public Builder maxPages(Number maxPages) {
                this.maxPages = maxPages;
                return this;
            }

            public Builder rateLimit(Number rateLimit) {
                this.rateLimit = rateLimit;
                return this;
            }

            public WebCrawlerLimitsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.WebCrawlerConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WebCrawlerConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCrawlerLimits() {
            return null;
        }

        @Nullable
        default public List<String> getExclusionFilters() {
            return null;
        }

        @Nullable
        default public List<String> getInclusionFilters() {
            return null;
        }

        @Nullable
        default public String getScope() {
            return null;
        }

        @Nullable
        default public String getUserAgent() {
            return null;
        }

        @Nullable
        default public String getUserAgentHeader() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WebCrawlerConfigurationProperty> {
            Object crawlerLimits;
            List<String> exclusionFilters;
            List<String> inclusionFilters;
            String scope;
            String userAgent;
            String userAgentHeader;

            public Builder crawlerLimits(IResolvable crawlerLimits) {
                this.crawlerLimits = crawlerLimits;
                return this;
            }

            public Builder crawlerLimits(WebCrawlerLimitsProperty crawlerLimits) {
                this.crawlerLimits = crawlerLimits;
                return this;
            }

            public Builder exclusionFilters(List<String> exclusionFilters) {
                this.exclusionFilters = exclusionFilters;
                return this;
            }

            public Builder inclusionFilters(List<String> inclusionFilters) {
                this.inclusionFilters = inclusionFilters;
                return this;
            }

            public Builder scope(String scope) {
                this.scope = scope;
                return this;
            }

            public Builder userAgent(String userAgent) {
                this.userAgent = userAgent;
                return this;
            }

            public Builder userAgentHeader(String userAgentHeader) {
                this.userAgentHeader = userAgentHeader;
                return this;
            }

            public WebCrawlerConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.VectorIngestionConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VectorIngestionConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getChunkingConfiguration() {
            return null;
        }

        @Nullable
        default public Object getContextEnrichmentConfiguration() {
            return null;
        }

        @Nullable
        default public Object getCustomTransformationConfiguration() {
            return null;
        }

        @Nullable
        default public Object getParsingConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VectorIngestionConfigurationProperty> {
            Object chunkingConfiguration;
            Object contextEnrichmentConfiguration;
            Object customTransformationConfiguration;
            Object parsingConfiguration;

            public Builder chunkingConfiguration(IResolvable chunkingConfiguration) {
                this.chunkingConfiguration = chunkingConfiguration;
                return this;
            }

            public Builder chunkingConfiguration(ChunkingConfigurationProperty chunkingConfiguration) {
                this.chunkingConfiguration = chunkingConfiguration;
                return this;
            }

            public Builder contextEnrichmentConfiguration(IResolvable contextEnrichmentConfiguration) {
                this.contextEnrichmentConfiguration = contextEnrichmentConfiguration;
                return this;
            }

            public Builder contextEnrichmentConfiguration(ContextEnrichmentConfigurationProperty contextEnrichmentConfiguration) {
                this.contextEnrichmentConfiguration = contextEnrichmentConfiguration;
                return this;
            }

            public Builder customTransformationConfiguration(IResolvable customTransformationConfiguration) {
                this.customTransformationConfiguration = customTransformationConfiguration;
                return this;
            }

            public Builder customTransformationConfiguration(CustomTransformationConfigurationProperty customTransformationConfiguration) {
                this.customTransformationConfiguration = customTransformationConfiguration;
                return this;
            }

            public Builder parsingConfiguration(IResolvable parsingConfiguration) {
                this.parsingConfiguration = parsingConfiguration;
                return this;
            }

            public Builder parsingConfiguration(ParsingConfigurationProperty parsingConfiguration) {
                this.parsingConfiguration = parsingConfiguration;
                return this;
            }

            public VectorIngestionConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.UrlConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface UrlConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getSeedUrls();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<UrlConfigurationProperty> {
            Object seedUrls;

            public Builder seedUrls(IResolvable seedUrls) {
                this.seedUrls = seedUrls;
                return this;
            }

            public Builder seedUrls(List<? extends Object> seedUrls) {
                this.seedUrls = seedUrls;
                return this;
            }

            public UrlConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.TransformationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TransformationProperty
    extends JsiiSerializable {
        @NotNull
        public String getStepToApply();

        @NotNull
        public Object getTransformationFunction();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TransformationProperty> {
            String stepToApply;
            Object transformationFunction;

            public Builder stepToApply(String stepToApply) {
                this.stepToApply = stepToApply;
                return this;
            }

            public Builder transformationFunction(IResolvable transformationFunction) {
                this.transformationFunction = transformationFunction;
                return this;
            }

            public Builder transformationFunction(TransformationFunctionProperty transformationFunction) {
                this.transformationFunction = transformationFunction;
                return this;
            }

            public TransformationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.TransformationLambdaConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TransformationLambdaConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getLambdaArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TransformationLambdaConfigurationProperty> {
            String lambdaArn;

            public Builder lambdaArn(String lambdaArn) {
                this.lambdaArn = lambdaArn;
                return this;
            }

            public TransformationLambdaConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.TransformationFunctionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TransformationFunctionProperty
    extends JsiiSerializable {
        @NotNull
        public Object getTransformationLambdaConfiguration();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TransformationFunctionProperty> {
            Object transformationLambdaConfiguration;

            public Builder transformationLambdaConfiguration(IResolvable transformationLambdaConfiguration) {
                this.transformationLambdaConfiguration = transformationLambdaConfiguration;
                return this;
            }

            public Builder transformationLambdaConfiguration(TransformationLambdaConfigurationProperty transformationLambdaConfiguration) {
                this.transformationLambdaConfiguration = transformationLambdaConfiguration;
                return this;
            }

            public TransformationFunctionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.SharePointSourceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SharePointSourceConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getAuthType();

        @NotNull
        public String getCredentialsSecretArn();

        @NotNull
        public String getDomain();

        @NotNull
        public String getHostType();

        @NotNull
        public List<String> getSiteUrls();

        @Nullable
        default public String getTenantId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SharePointSourceConfigurationProperty> {
            String authType;
            String credentialsSecretArn;
            String domain;
            String hostType;
            List<String> siteUrls;
            String tenantId;

            public Builder authType(String authType) {
                this.authType = authType;
                return this;
            }

            public Builder credentialsSecretArn(String credentialsSecretArn) {
                this.credentialsSecretArn = credentialsSecretArn;
                return this;
            }

            public Builder domain(String domain) {
                this.domain = domain;
                return this;
            }

            public Builder hostType(String hostType) {
                this.hostType = hostType;
                return this;
            }

            public Builder siteUrls(List<String> siteUrls) {
                this.siteUrls = siteUrls;
                return this;
            }

            public Builder tenantId(String tenantId) {
                this.tenantId = tenantId;
                return this;
            }

            public SharePointSourceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.SharePointDataSourceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SharePointDataSourceConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getSourceConfiguration();

        @Nullable
        default public Object getCrawlerConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SharePointDataSourceConfigurationProperty> {
            Object sourceConfiguration;
            Object crawlerConfiguration;

            public Builder sourceConfiguration(IResolvable sourceConfiguration) {
                this.sourceConfiguration = sourceConfiguration;
                return this;
            }

            public Builder sourceConfiguration(SharePointSourceConfigurationProperty sourceConfiguration) {
                this.sourceConfiguration = sourceConfiguration;
                return this;
            }

            public Builder crawlerConfiguration(IResolvable crawlerConfiguration) {
                this.crawlerConfiguration = crawlerConfiguration;
                return this;
            }

            public Builder crawlerConfiguration(SharePointCrawlerConfigurationProperty crawlerConfiguration) {
                this.crawlerConfiguration = crawlerConfiguration;
                return this;
            }

            public SharePointDataSourceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.SharePointCrawlerConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SharePointCrawlerConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getFilterConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SharePointCrawlerConfigurationProperty> {
            Object filterConfiguration;

            public Builder filterConfiguration(IResolvable filterConfiguration) {
                this.filterConfiguration = filterConfiguration;
                return this;
            }

            public Builder filterConfiguration(CrawlFilterConfigurationProperty filterConfiguration) {
                this.filterConfiguration = filterConfiguration;
                return this;
            }

            public SharePointCrawlerConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.ServerSideEncryptionConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServerSideEncryptionConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getKmsKeyArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServerSideEncryptionConfigurationProperty> {
            String kmsKeyArn;

            public Builder kmsKeyArn(String kmsKeyArn) {
                this.kmsKeyArn = kmsKeyArn;
                return this;
            }

            public ServerSideEncryptionConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.SemanticChunkingConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SemanticChunkingConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Number getBreakpointPercentileThreshold();

        @NotNull
        public Number getBufferSize();

        @NotNull
        public Number getMaxTokens();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SemanticChunkingConfigurationProperty> {
            Number breakpointPercentileThreshold;
            Number bufferSize;
            Number maxTokens;

            public Builder breakpointPercentileThreshold(Number breakpointPercentileThreshold) {
                this.breakpointPercentileThreshold = breakpointPercentileThreshold;
                return this;
            }

            public Builder bufferSize(Number bufferSize) {
                this.bufferSize = bufferSize;
                return this;
            }

            public Builder maxTokens(Number maxTokens) {
                this.maxTokens = maxTokens;
                return this;
            }

            public SemanticChunkingConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.SeedUrlProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SeedUrlProperty
    extends JsiiSerializable {
        @NotNull
        public String getUrl();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SeedUrlProperty> {
            String url;

            public Builder url(String url) {
                this.url = url;
                return this;
            }

            public SeedUrlProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.SalesforceSourceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SalesforceSourceConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getAuthType();

        @NotNull
        public String getCredentialsSecretArn();

        @NotNull
        public String getHostUrl();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SalesforceSourceConfigurationProperty> {
            String authType;
            String credentialsSecretArn;
            String hostUrl;

            public Builder authType(String authType) {
                this.authType = authType;
                return this;
            }

            public Builder credentialsSecretArn(String credentialsSecretArn) {
                this.credentialsSecretArn = credentialsSecretArn;
                return this;
            }

            public Builder hostUrl(String hostUrl) {
                this.hostUrl = hostUrl;
                return this;
            }

            public SalesforceSourceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.SalesforceDataSourceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SalesforceDataSourceConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getSourceConfiguration();

        @Nullable
        default public Object getCrawlerConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SalesforceDataSourceConfigurationProperty> {
            Object sourceConfiguration;
            Object crawlerConfiguration;

            public Builder sourceConfiguration(IResolvable sourceConfiguration) {
                this.sourceConfiguration = sourceConfiguration;
                return this;
            }

            public Builder sourceConfiguration(SalesforceSourceConfigurationProperty sourceConfiguration) {
                this.sourceConfiguration = sourceConfiguration;
                return this;
            }

            public Builder crawlerConfiguration(IResolvable crawlerConfiguration) {
                this.crawlerConfiguration = crawlerConfiguration;
                return this;
            }

            public Builder crawlerConfiguration(SalesforceCrawlerConfigurationProperty crawlerConfiguration) {
                this.crawlerConfiguration = crawlerConfiguration;
                return this;
            }

            public SalesforceDataSourceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.SalesforceCrawlerConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SalesforceCrawlerConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getFilterConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SalesforceCrawlerConfigurationProperty> {
            Object filterConfiguration;

            public Builder filterConfiguration(IResolvable filterConfiguration) {
                this.filterConfiguration = filterConfiguration;
                return this;
            }

            public Builder filterConfiguration(CrawlFilterConfigurationProperty filterConfiguration) {
                this.filterConfiguration = filterConfiguration;
                return this;
            }

            public SalesforceCrawlerConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.S3LocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3LocationProperty
    extends JsiiSerializable {
        @NotNull
        public String getUri();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3LocationProperty> {
            String uri;

            public Builder uri(String uri) {
                this.uri = uri;
                return this;
            }

            public S3LocationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.S3DataSourceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3DataSourceConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucketArn();

        @Nullable
        default public String getBucketOwnerAccountId() {
            return null;
        }

        @Nullable
        default public List<String> getInclusionPrefixes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3DataSourceConfigurationProperty> {
            String bucketArn;
            String bucketOwnerAccountId;
            List<String> inclusionPrefixes;

            public Builder bucketArn(String bucketArn) {
                this.bucketArn = bucketArn;
                return this;
            }

            public Builder bucketOwnerAccountId(String bucketOwnerAccountId) {
                this.bucketOwnerAccountId = bucketOwnerAccountId;
                return this;
            }

            public Builder inclusionPrefixes(List<String> inclusionPrefixes) {
                this.inclusionPrefixes = inclusionPrefixes;
                return this;
            }

            public S3DataSourceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.PatternObjectFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PatternObjectFilterProperty
    extends JsiiSerializable {
        @NotNull
        public String getObjectType();

        @Nullable
        default public List<String> getExclusionFilters() {
            return null;
        }

        @Nullable
        default public List<String> getInclusionFilters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PatternObjectFilterProperty> {
            String objectType;
            List<String> exclusionFilters;
            List<String> inclusionFilters;

            public Builder objectType(String objectType) {
                this.objectType = objectType;
                return this;
            }

            public Builder exclusionFilters(List<String> exclusionFilters) {
                this.exclusionFilters = exclusionFilters;
                return this;
            }

            public Builder inclusionFilters(List<String> inclusionFilters) {
                this.inclusionFilters = inclusionFilters;
                return this;
            }

            public PatternObjectFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.PatternObjectFilterConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PatternObjectFilterConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getFilters();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PatternObjectFilterConfigurationProperty> {
            Object filters;

            public Builder filters(IResolvable filters) {
                this.filters = filters;
                return this;
            }

            public Builder filters(List<? extends Object> filters) {
                this.filters = filters;
                return this;
            }

            public PatternObjectFilterConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.ParsingPromptProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ParsingPromptProperty
    extends JsiiSerializable {
        @NotNull
        public String getParsingPromptText();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ParsingPromptProperty> {
            String parsingPromptText;

            public Builder parsingPromptText(String parsingPromptText) {
                this.parsingPromptText = parsingPromptText;
                return this;
            }

            public ParsingPromptProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.ParsingConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ParsingConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getParsingStrategy();

        @Nullable
        default public Object getBedrockDataAutomationConfiguration() {
            return null;
        }

        @Nullable
        default public Object getBedrockFoundationModelConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ParsingConfigurationProperty> {
            String parsingStrategy;
            Object bedrockDataAutomationConfiguration;
            Object bedrockFoundationModelConfiguration;

            public Builder parsingStrategy(String parsingStrategy) {
                this.parsingStrategy = parsingStrategy;
                return this;
            }

            public Builder bedrockDataAutomationConfiguration(IResolvable bedrockDataAutomationConfiguration) {
                this.bedrockDataAutomationConfiguration = bedrockDataAutomationConfiguration;
                return this;
            }

            public Builder bedrockDataAutomationConfiguration(BedrockDataAutomationConfigurationProperty bedrockDataAutomationConfiguration) {
                this.bedrockDataAutomationConfiguration = bedrockDataAutomationConfiguration;
                return this;
            }

            public Builder bedrockFoundationModelConfiguration(IResolvable bedrockFoundationModelConfiguration) {
                this.bedrockFoundationModelConfiguration = bedrockFoundationModelConfiguration;
                return this;
            }

            public Builder bedrockFoundationModelConfiguration(BedrockFoundationModelConfigurationProperty bedrockFoundationModelConfiguration) {
                this.bedrockFoundationModelConfiguration = bedrockFoundationModelConfiguration;
                return this;
            }

            public ParsingConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.IntermediateStorageProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IntermediateStorageProperty
    extends JsiiSerializable {
        @NotNull
        public Object getS3Location();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IntermediateStorageProperty> {
            Object s3Location;

            public Builder s3Location(IResolvable s3Location) {
                this.s3Location = s3Location;
                return this;
            }

            public Builder s3Location(S3LocationProperty s3Location) {
                this.s3Location = s3Location;
                return this;
            }

            public IntermediateStorageProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.HierarchicalChunkingLevelConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HierarchicalChunkingLevelConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Number getMaxTokens();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HierarchicalChunkingLevelConfigurationProperty> {
            Number maxTokens;

            public Builder maxTokens(Number maxTokens) {
                this.maxTokens = maxTokens;
                return this;
            }

            public HierarchicalChunkingLevelConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.HierarchicalChunkingConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HierarchicalChunkingConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getLevelConfigurations();

        @NotNull
        public Number getOverlapTokens();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HierarchicalChunkingConfigurationProperty> {
            Object levelConfigurations;
            Number overlapTokens;

            public Builder levelConfigurations(IResolvable levelConfigurations) {
                this.levelConfigurations = levelConfigurations;
                return this;
            }

            public Builder levelConfigurations(List<? extends Object> levelConfigurations) {
                this.levelConfigurations = levelConfigurations;
                return this;
            }

            public Builder overlapTokens(Number overlapTokens) {
                this.overlapTokens = overlapTokens;
                return this;
            }

            public HierarchicalChunkingConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.FixedSizeChunkingConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FixedSizeChunkingConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Number getMaxTokens();

        @NotNull
        public Number getOverlapPercentage();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FixedSizeChunkingConfigurationProperty> {
            Number maxTokens;
            Number overlapPercentage;

            public Builder maxTokens(Number maxTokens) {
                this.maxTokens = maxTokens;
                return this;
            }

            public Builder overlapPercentage(Number overlapPercentage) {
                this.overlapPercentage = overlapPercentage;
                return this;
            }

            public FixedSizeChunkingConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.EnrichmentStrategyConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EnrichmentStrategyConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getMethod();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EnrichmentStrategyConfigurationProperty> {
            String method;

            public Builder method(String method) {
                this.method = method;
                return this;
            }

            public EnrichmentStrategyConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.DataSourceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataSourceConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @Nullable
        default public Object getConfluenceConfiguration() {
            return null;
        }

        @Nullable
        default public Object getS3Configuration() {
            return null;
        }

        @Nullable
        default public Object getSalesforceConfiguration() {
            return null;
        }

        @Nullable
        default public Object getSharePointConfiguration() {
            return null;
        }

        @Nullable
        default public Object getWebConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataSourceConfigurationProperty> {
            String type;
            Object confluenceConfiguration;
            Object s3Configuration;
            Object salesforceConfiguration;
            Object sharePointConfiguration;
            Object webConfiguration;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder confluenceConfiguration(IResolvable confluenceConfiguration) {
                this.confluenceConfiguration = confluenceConfiguration;
                return this;
            }

            public Builder confluenceConfiguration(ConfluenceDataSourceConfigurationProperty confluenceConfiguration) {
                this.confluenceConfiguration = confluenceConfiguration;
                return this;
            }

            public Builder s3Configuration(IResolvable s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            public Builder s3Configuration(S3DataSourceConfigurationProperty s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            public Builder salesforceConfiguration(IResolvable salesforceConfiguration) {
                this.salesforceConfiguration = salesforceConfiguration;
                return this;
            }

            public Builder salesforceConfiguration(SalesforceDataSourceConfigurationProperty salesforceConfiguration) {
                this.salesforceConfiguration = salesforceConfiguration;
                return this;
            }

            public Builder sharePointConfiguration(IResolvable sharePointConfiguration) {
                this.sharePointConfiguration = sharePointConfiguration;
                return this;
            }

            public Builder sharePointConfiguration(SharePointDataSourceConfigurationProperty sharePointConfiguration) {
                this.sharePointConfiguration = sharePointConfiguration;
                return this;
            }

            public Builder webConfiguration(IResolvable webConfiguration) {
                this.webConfiguration = webConfiguration;
                return this;
            }

            public Builder webConfiguration(WebDataSourceConfigurationProperty webConfiguration) {
                this.webConfiguration = webConfiguration;
                return this;
            }

            public DataSourceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.CustomTransformationConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomTransformationConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getIntermediateStorage();

        @NotNull
        public Object getTransformations();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomTransformationConfigurationProperty> {
            Object intermediateStorage;
            Object transformations;

            public Builder intermediateStorage(IResolvable intermediateStorage) {
                this.intermediateStorage = intermediateStorage;
                return this;
            }

            public Builder intermediateStorage(IntermediateStorageProperty intermediateStorage) {
                this.intermediateStorage = intermediateStorage;
                return this;
            }

            public Builder transformations(IResolvable transformations) {
                this.transformations = transformations;
                return this;
            }

            public Builder transformations(List<? extends Object> transformations) {
                this.transformations = transformations;
                return this;
            }

            public CustomTransformationConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.CrawlFilterConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CrawlFilterConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @Nullable
        default public Object getPatternObjectFilter() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CrawlFilterConfigurationProperty> {
            String type;
            Object patternObjectFilter;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder patternObjectFilter(IResolvable patternObjectFilter) {
                this.patternObjectFilter = patternObjectFilter;
                return this;
            }

            public Builder patternObjectFilter(PatternObjectFilterConfigurationProperty patternObjectFilter) {
                this.patternObjectFilter = patternObjectFilter;
                return this;
            }

            public CrawlFilterConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.ContextEnrichmentConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ContextEnrichmentConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @Nullable
        default public Object getBedrockFoundationModelConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ContextEnrichmentConfigurationProperty> {
            String type;
            Object bedrockFoundationModelConfiguration;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder bedrockFoundationModelConfiguration(IResolvable bedrockFoundationModelConfiguration) {
                this.bedrockFoundationModelConfiguration = bedrockFoundationModelConfiguration;
                return this;
            }

            public Builder bedrockFoundationModelConfiguration(BedrockFoundationModelContextEnrichmentConfigurationProperty bedrockFoundationModelConfiguration) {
                this.bedrockFoundationModelConfiguration = bedrockFoundationModelConfiguration;
                return this;
            }

            public ContextEnrichmentConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.ConfluenceSourceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConfluenceSourceConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getAuthType();

        @NotNull
        public String getCredentialsSecretArn();

        @NotNull
        public String getHostType();

        @NotNull
        public String getHostUrl();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConfluenceSourceConfigurationProperty> {
            String authType;
            String credentialsSecretArn;
            String hostType;
            String hostUrl;

            public Builder authType(String authType) {
                this.authType = authType;
                return this;
            }

            public Builder credentialsSecretArn(String credentialsSecretArn) {
                this.credentialsSecretArn = credentialsSecretArn;
                return this;
            }

            public Builder hostType(String hostType) {
                this.hostType = hostType;
                return this;
            }

            public Builder hostUrl(String hostUrl) {
                this.hostUrl = hostUrl;
                return this;
            }

            public ConfluenceSourceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.ConfluenceDataSourceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConfluenceDataSourceConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getSourceConfiguration();

        @Nullable
        default public Object getCrawlerConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConfluenceDataSourceConfigurationProperty> {
            Object sourceConfiguration;
            Object crawlerConfiguration;

            public Builder sourceConfiguration(IResolvable sourceConfiguration) {
                this.sourceConfiguration = sourceConfiguration;
                return this;
            }

            public Builder sourceConfiguration(ConfluenceSourceConfigurationProperty sourceConfiguration) {
                this.sourceConfiguration = sourceConfiguration;
                return this;
            }

            public Builder crawlerConfiguration(IResolvable crawlerConfiguration) {
                this.crawlerConfiguration = crawlerConfiguration;
                return this;
            }

            public Builder crawlerConfiguration(ConfluenceCrawlerConfigurationProperty crawlerConfiguration) {
                this.crawlerConfiguration = crawlerConfiguration;
                return this;
            }

            public ConfluenceDataSourceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.ConfluenceCrawlerConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConfluenceCrawlerConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getFilterConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConfluenceCrawlerConfigurationProperty> {
            Object filterConfiguration;

            public Builder filterConfiguration(IResolvable filterConfiguration) {
                this.filterConfiguration = filterConfiguration;
                return this;
            }

            public Builder filterConfiguration(CrawlFilterConfigurationProperty filterConfiguration) {
                this.filterConfiguration = filterConfiguration;
                return this;
            }

            public ConfluenceCrawlerConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.ChunkingConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ChunkingConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getChunkingStrategy();

        @Nullable
        default public Object getFixedSizeChunkingConfiguration() {
            return null;
        }

        @Nullable
        default public Object getHierarchicalChunkingConfiguration() {
            return null;
        }

        @Nullable
        default public Object getSemanticChunkingConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ChunkingConfigurationProperty> {
            String chunkingStrategy;
            Object fixedSizeChunkingConfiguration;
            Object hierarchicalChunkingConfiguration;
            Object semanticChunkingConfiguration;

            public Builder chunkingStrategy(String chunkingStrategy) {
                this.chunkingStrategy = chunkingStrategy;
                return this;
            }

            public Builder fixedSizeChunkingConfiguration(IResolvable fixedSizeChunkingConfiguration) {
                this.fixedSizeChunkingConfiguration = fixedSizeChunkingConfiguration;
                return this;
            }

            public Builder fixedSizeChunkingConfiguration(FixedSizeChunkingConfigurationProperty fixedSizeChunkingConfiguration) {
                this.fixedSizeChunkingConfiguration = fixedSizeChunkingConfiguration;
                return this;
            }

            public Builder hierarchicalChunkingConfiguration(IResolvable hierarchicalChunkingConfiguration) {
                this.hierarchicalChunkingConfiguration = hierarchicalChunkingConfiguration;
                return this;
            }

            public Builder hierarchicalChunkingConfiguration(HierarchicalChunkingConfigurationProperty hierarchicalChunkingConfiguration) {
                this.hierarchicalChunkingConfiguration = hierarchicalChunkingConfiguration;
                return this;
            }

            public Builder semanticChunkingConfiguration(IResolvable semanticChunkingConfiguration) {
                this.semanticChunkingConfiguration = semanticChunkingConfiguration;
                return this;
            }

            public Builder semanticChunkingConfiguration(SemanticChunkingConfigurationProperty semanticChunkingConfiguration) {
                this.semanticChunkingConfiguration = semanticChunkingConfiguration;
                return this;
            }

            public ChunkingConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.BedrockFoundationModelContextEnrichmentConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BedrockFoundationModelContextEnrichmentConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getEnrichmentStrategyConfiguration();

        @NotNull
        public String getModelArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BedrockFoundationModelContextEnrichmentConfigurationProperty> {
            Object enrichmentStrategyConfiguration;
            String modelArn;

            public Builder enrichmentStrategyConfiguration(IResolvable enrichmentStrategyConfiguration) {
                this.enrichmentStrategyConfiguration = enrichmentStrategyConfiguration;
                return this;
            }

            public Builder enrichmentStrategyConfiguration(EnrichmentStrategyConfigurationProperty enrichmentStrategyConfiguration) {
                this.enrichmentStrategyConfiguration = enrichmentStrategyConfiguration;
                return this;
            }

            public Builder modelArn(String modelArn) {
                this.modelArn = modelArn;
                return this;
            }

            public BedrockFoundationModelContextEnrichmentConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.BedrockFoundationModelConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BedrockFoundationModelConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getModelArn();

        @Nullable
        default public String getParsingModality() {
            return null;
        }

        @Nullable
        default public Object getParsingPrompt() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BedrockFoundationModelConfigurationProperty> {
            String modelArn;
            String parsingModality;
            Object parsingPrompt;

            public Builder modelArn(String modelArn) {
                this.modelArn = modelArn;
                return this;
            }

            public Builder parsingModality(String parsingModality) {
                this.parsingModality = parsingModality;
                return this;
            }

            public Builder parsingPrompt(IResolvable parsingPrompt) {
                this.parsingPrompt = parsingPrompt;
                return this;
            }

            public Builder parsingPrompt(ParsingPromptProperty parsingPrompt) {
                this.parsingPrompt = parsingPrompt;
                return this;
            }

            public BedrockFoundationModelConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnDataSource.BedrockDataAutomationConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BedrockDataAutomationConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getParsingModality() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BedrockDataAutomationConfigurationProperty> {
            String parsingModality;

            public Builder parsingModality(String parsingModality) {
                this.parsingModality = parsingModality;
                return this;
            }

            public BedrockDataAutomationConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

