/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloudfront.origins;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy;
import software.amazon.awscdk.services.cloudfront.OriginSslPolicy;
import software.amazon.awscdk.services.cloudfront.origins.HttpOrigin;
import software.amazon.awscdk.services.cloudfront.origins.S3StaticWebsiteOriginProps;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_cloudfront_origins.S3StaticWebsiteOrigin")
public class S3StaticWebsiteOrigin
extends HttpOrigin {
    protected S3StaticWebsiteOrigin(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected S3StaticWebsiteOrigin(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public S3StaticWebsiteOrigin(@NotNull IBucket bucket, @Nullable S3StaticWebsiteOriginProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(bucket, "bucket is required"), props});
    }

    public S3StaticWebsiteOrigin(@NotNull IBucket bucket) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(bucket, "bucket is required")});
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<S3StaticWebsiteOrigin> {
        private final IBucket bucket;
        private S3StaticWebsiteOriginProps.Builder props;

        public static Builder create(IBucket bucket) {
            return new Builder(bucket);
        }

        private Builder(IBucket bucket) {
            this.bucket = bucket;
        }

        public Builder connectionAttempts(Number connectionAttempts) {
            this.props().connectionAttempts(connectionAttempts);
            return this;
        }

        public Builder connectionTimeout(Duration connectionTimeout) {
            this.props().connectionTimeout(connectionTimeout);
            return this;
        }

        public Builder customHeaders(Map<String, String> customHeaders) {
            this.props().customHeaders(customHeaders);
            return this;
        }

        public Builder originAccessControlId(String originAccessControlId) {
            this.props().originAccessControlId(originAccessControlId);
            return this;
        }

        public Builder originId(String originId) {
            this.props().originId(originId);
            return this;
        }

        public Builder originShieldEnabled(Boolean originShieldEnabled) {
            this.props().originShieldEnabled(originShieldEnabled);
            return this;
        }

        public Builder originShieldRegion(String originShieldRegion) {
            this.props().originShieldRegion(originShieldRegion);
            return this;
        }

        public Builder originPath(String originPath) {
            this.props().originPath(originPath);
            return this;
        }

        public Builder httpPort(Number httpPort) {
            this.props().httpPort(httpPort);
            return this;
        }

        public Builder httpsPort(Number httpsPort) {
            this.props().httpsPort(httpsPort);
            return this;
        }

        public Builder keepaliveTimeout(Duration keepaliveTimeout) {
            this.props().keepaliveTimeout(keepaliveTimeout);
            return this;
        }

        public Builder originSslProtocols(List<? extends OriginSslPolicy> originSslProtocols) {
            this.props().originSslProtocols(originSslProtocols);
            return this;
        }

        public Builder protocolPolicy(OriginProtocolPolicy protocolPolicy) {
            this.props().protocolPolicy(protocolPolicy);
            return this;
        }

        public Builder readTimeout(Duration readTimeout) {
            this.props().readTimeout(readTimeout);
            return this;
        }

        public S3StaticWebsiteOrigin build() {
            return new S3StaticWebsiteOrigin(this.bucket, this.props != null ? this.props.build() : null);
        }

        private S3StaticWebsiteOriginProps.Builder props() {
            if (this.props == null) {
                this.props = new S3StaticWebsiteOriginProps.Builder();
            }
            return this.props;
        }
    }
}

