/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.IgnoreMode;
import software.amazon.awscdk.SymlinkFollowMode;
import software.amazon.awscdk.services.ecr.assets.DockerCacheOption;
import software.amazon.awscdk.services.ecr.assets.DockerImageAssetInvalidationOptions;
import software.amazon.awscdk.services.ecr.assets.NetworkMode;
import software.amazon.awscdk.services.ecr.assets.Platform;
import software.amazon.awscdk.services.ecs.AssetImageProps;
import software.amazon.awscdk.services.ecs.ContainerDefinition;
import software.amazon.awscdk.services.ecs.ContainerImage;
import software.amazon.awscdk.services.ecs.ContainerImageConfig;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs.AssetImage")
public class AssetImage
extends ContainerImage {
    protected AssetImage(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AssetImage(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public AssetImage(@NotNull String directory, @Nullable AssetImageProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(directory, "directory is required"), props});
    }

    public AssetImage(@NotNull String directory) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(directory, "directory is required")});
    }

    @Override
    @NotNull
    public ContainerImageConfig bind(@NotNull Construct scope, @NotNull ContainerDefinition containerDefinition) {
        return (ContainerImageConfig)Kernel.call((Object)((Object)this), (String)"bind", (NativeType)NativeType.forClass(ContainerImageConfig.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(containerDefinition, "containerDefinition is required")});
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<AssetImage> {
        private final String directory;
        private AssetImageProps.Builder props;

        public static Builder create(String directory) {
            return new Builder(directory);
        }

        private Builder(String directory) {
            this.directory = directory;
        }

        public Builder exclude(List<String> exclude) {
            this.props().exclude(exclude);
            return this;
        }

        public Builder followSymlinks(SymlinkFollowMode followSymlinks) {
            this.props().followSymlinks(followSymlinks);
            return this;
        }

        public Builder ignoreMode(IgnoreMode ignoreMode) {
            this.props().ignoreMode(ignoreMode);
            return this;
        }

        public Builder extraHash(String extraHash) {
            this.props().extraHash(extraHash);
            return this;
        }

        public Builder assetName(String assetName) {
            this.props().assetName(assetName);
            return this;
        }

        public Builder buildArgs(Map<String, String> buildArgs) {
            this.props().buildArgs(buildArgs);
            return this;
        }

        public Builder buildSecrets(Map<String, String> buildSecrets) {
            this.props().buildSecrets(buildSecrets);
            return this;
        }

        public Builder buildSsh(String buildSsh) {
            this.props().buildSsh(buildSsh);
            return this;
        }

        public Builder cacheDisabled(Boolean cacheDisabled) {
            this.props().cacheDisabled(cacheDisabled);
            return this;
        }

        public Builder cacheFrom(List<? extends DockerCacheOption> cacheFrom) {
            this.props().cacheFrom(cacheFrom);
            return this;
        }

        public Builder cacheTo(DockerCacheOption cacheTo) {
            this.props().cacheTo(cacheTo);
            return this;
        }

        public Builder displayName(String displayName) {
            this.props().displayName(displayName);
            return this;
        }

        public Builder file(String file) {
            this.props().file(file);
            return this;
        }

        public Builder invalidation(DockerImageAssetInvalidationOptions invalidation) {
            this.props().invalidation(invalidation);
            return this;
        }

        public Builder networkMode(NetworkMode networkMode) {
            this.props().networkMode(networkMode);
            return this;
        }

        public Builder outputs(List<String> outputs) {
            this.props().outputs(outputs);
            return this;
        }

        public Builder platform(Platform platform) {
            this.props().platform(platform);
            return this;
        }

        public Builder target(String target) {
            this.props().target(target);
            return this;
        }

        public AssetImage build() {
            return new AssetImage(this.directory, this.props != null ? this.props.build() : null);
        }

        private AssetImageProps.Builder props() {
            if (this.props == null) {
                this.props = new AssetImageProps.Builder();
            }
            return this.props;
        }
    }
}

