/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.kinesisfirehose;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.Size;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.kinesisfirehose.Compression;
import software.amazon.awscdk.services.kinesisfirehose.DestinationBindOptions;
import software.amazon.awscdk.services.kinesisfirehose.DestinationConfig;
import software.amazon.awscdk.services.kinesisfirehose.DestinationS3BackupProps;
import software.amazon.awscdk.services.kinesisfirehose.IDataProcessor;
import software.amazon.awscdk.services.kinesisfirehose.IDestination;
import software.amazon.awscdk.services.kinesisfirehose.ILoggingConfig;
import software.amazon.awscdk.services.kinesisfirehose.S3BucketProps;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.S3Bucket")
public class S3Bucket
extends JsiiObject
implements IDestination {
    protected S3Bucket(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected S3Bucket(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public S3Bucket(@NotNull IBucket bucket, @Nullable S3BucketProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(bucket, "bucket is required"), props});
    }

    public S3Bucket(@NotNull IBucket bucket) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(bucket, "bucket is required")});
    }

    @Override
    @NotNull
    public DestinationConfig bind(@NotNull Construct scope, @NotNull DestinationBindOptions _options) {
        return (DestinationConfig)Kernel.call((Object)this, (String)"bind", (NativeType)NativeType.forClass(DestinationConfig.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(_options, "_options is required")});
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<S3Bucket> {
        private final IBucket bucket;
        private S3BucketProps.Builder props;

        public static Builder create(IBucket bucket) {
            return new Builder(bucket);
        }

        private Builder(IBucket bucket) {
            this.bucket = bucket;
        }

        public Builder bufferingInterval(Duration bufferingInterval) {
            this.props().bufferingInterval(bufferingInterval);
            return this;
        }

        public Builder bufferingSize(Size bufferingSize) {
            this.props().bufferingSize(bufferingSize);
            return this;
        }

        public Builder compression(Compression compression) {
            this.props().compression(compression);
            return this;
        }

        public Builder dataOutputPrefix(String dataOutputPrefix) {
            this.props().dataOutputPrefix(dataOutputPrefix);
            return this;
        }

        public Builder encryptionKey(IKey encryptionKey) {
            this.props().encryptionKey(encryptionKey);
            return this;
        }

        public Builder errorOutputPrefix(String errorOutputPrefix) {
            this.props().errorOutputPrefix(errorOutputPrefix);
            return this;
        }

        public Builder loggingConfig(ILoggingConfig loggingConfig) {
            this.props().loggingConfig(loggingConfig);
            return this;
        }

        public Builder processor(IDataProcessor processor) {
            this.props().processor(processor);
            return this;
        }

        public Builder role(IRole role) {
            this.props().role(role);
            return this;
        }

        public Builder s3Backup(DestinationS3BackupProps s3Backup) {
            this.props().s3Backup(s3Backup);
            return this;
        }

        public Builder fileExtension(String fileExtension) {
            this.props().fileExtension(fileExtension);
            return this;
        }

        public S3Bucket build() {
            return new S3Bucket(this.bucket, this.props != null ? this.props.build() : null);
        }

        private S3BucketProps.Builder props() {
            if (this.props == null) {
                this.props = new S3BucketProps.Builder();
            }
            return this.props;
        }
    }
}

