/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.logs.destinations;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.kinesisfirehose.IDeliveryStream;
import software.amazon.awscdk.services.logs.ILogGroup;
import software.amazon.awscdk.services.logs.ILogSubscriptionDestination;
import software.amazon.awscdk.services.logs.LogSubscriptionDestinationConfig;
import software.amazon.awscdk.services.logs.destinations.FirehoseDestinationProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_logs_destinations.FirehoseDestination")
public class FirehoseDestination
extends JsiiObject
implements ILogSubscriptionDestination {
    protected FirehoseDestination(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FirehoseDestination(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public FirehoseDestination(@NotNull IDeliveryStream stream, @Nullable FirehoseDestinationProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(stream, "stream is required"), props});
    }

    public FirehoseDestination(@NotNull IDeliveryStream stream) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(stream, "stream is required")});
    }

    @Override
    @NotNull
    public LogSubscriptionDestinationConfig bind(@NotNull Construct scope, @NotNull ILogGroup _sourceLogGroup) {
        return (LogSubscriptionDestinationConfig)Kernel.call((Object)this, (String)"bind", (NativeType)NativeType.forClass(LogSubscriptionDestinationConfig.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(_sourceLogGroup, "_sourceLogGroup is required")});
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<FirehoseDestination> {
        private final IDeliveryStream stream;
        private FirehoseDestinationProps.Builder props;

        public static Builder create(IDeliveryStream stream) {
            return new Builder(stream);
        }

        private Builder(IDeliveryStream stream) {
            this.stream = stream;
        }

        public Builder role(IRole role) {
            this.props().role(role);
            return this;
        }

        public FirehoseDestination build() {
            return new FirehoseDestination(this.stream, this.props != null ? this.props.build() : null);
        }

        private FirehoseDestinationProps.Builder props() {
            if (this.props == null) {
                this.props = new FirehoseDestinationProps.Builder();
            }
            return this.props;
        }
    }
}

