/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.scheduler.targets;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.kinesisfirehose.IDeliveryStream;
import software.amazon.awscdk.services.scheduler.IScheduleTarget;
import software.amazon.awscdk.services.scheduler.ScheduleTargetInput;
import software.amazon.awscdk.services.scheduler.targets.ScheduleTargetBase;
import software.amazon.awscdk.services.scheduler.targets.ScheduleTargetBaseProps;
import software.amazon.awscdk.services.sqs.IQueue;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_scheduler_targets.FirehosePutRecord")
public class FirehosePutRecord
extends ScheduleTargetBase
implements IScheduleTarget {
    protected FirehosePutRecord(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FirehosePutRecord(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public FirehosePutRecord(@NotNull IDeliveryStream deliveryStream, @Nullable ScheduleTargetBaseProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(deliveryStream, "deliveryStream is required"), props});
    }

    public FirehosePutRecord(@NotNull IDeliveryStream deliveryStream) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(deliveryStream, "deliveryStream is required")});
    }

    @Override
    protected void addTargetActionToRole(@NotNull IRole role) {
        Kernel.call((Object)this, (String)"addTargetActionToRole", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(role, "role is required")});
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<FirehosePutRecord> {
        private final IDeliveryStream deliveryStream;
        private ScheduleTargetBaseProps.Builder props;

        public static Builder create(IDeliveryStream deliveryStream) {
            return new Builder(deliveryStream);
        }

        private Builder(IDeliveryStream deliveryStream) {
            this.deliveryStream = deliveryStream;
        }

        public Builder deadLetterQueue(IQueue deadLetterQueue) {
            this.props().deadLetterQueue(deadLetterQueue);
            return this;
        }

        public Builder input(ScheduleTargetInput input) {
            this.props().input(input);
            return this;
        }

        public Builder maxEventAge(Duration maxEventAge) {
            this.props().maxEventAge(maxEventAge);
            return this;
        }

        public Builder retryAttempts(Number retryAttempts) {
            this.props().retryAttempts(retryAttempts);
            return this;
        }

        public Builder role(IRole role) {
            this.props().role(role);
            return this;
        }

        public FirehosePutRecord build() {
            return new FirehosePutRecord(this.deliveryStream, this.props != null ? this.props.build() : null);
        }

        private ScheduleTargetBaseProps.Builder props() {
            if (this.props == null) {
                this.props = new ScheduleTargetBaseProps.Builder();
            }
            return this.props;
        }
    }
}

