/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.scheduler.targets;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.sagemaker.IPipeline;
import software.amazon.awscdk.services.scheduler.ISchedule;
import software.amazon.awscdk.services.scheduler.IScheduleTarget;
import software.amazon.awscdk.services.scheduler.ScheduleTargetConfig;
import software.amazon.awscdk.services.scheduler.ScheduleTargetInput;
import software.amazon.awscdk.services.scheduler.targets.SageMakerPipelineParameter;
import software.amazon.awscdk.services.scheduler.targets.SageMakerStartPipelineExecutionProps;
import software.amazon.awscdk.services.scheduler.targets.ScheduleTargetBase;
import software.amazon.awscdk.services.sqs.IQueue;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_scheduler_targets.SageMakerStartPipelineExecution")
public class SageMakerStartPipelineExecution
extends ScheduleTargetBase
implements IScheduleTarget {
    protected SageMakerStartPipelineExecution(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SageMakerStartPipelineExecution(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public SageMakerStartPipelineExecution(@NotNull IPipeline pipeline, @Nullable SageMakerStartPipelineExecutionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(pipeline, "pipeline is required"), props});
    }

    public SageMakerStartPipelineExecution(@NotNull IPipeline pipeline) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(pipeline, "pipeline is required")});
    }

    @Override
    protected void addTargetActionToRole(@NotNull IRole role) {
        Kernel.call((Object)this, (String)"addTargetActionToRole", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(role, "role is required")});
    }

    @Override
    @NotNull
    protected ScheduleTargetConfig bindBaseTargetConfig(@NotNull ISchedule schedule) {
        return (ScheduleTargetConfig)Kernel.call((Object)this, (String)"bindBaseTargetConfig", (NativeType)NativeType.forClass(ScheduleTargetConfig.class), (Object[])new Object[]{Objects.requireNonNull(schedule, "schedule is required")});
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<SageMakerStartPipelineExecution> {
        private final IPipeline pipeline;
        private SageMakerStartPipelineExecutionProps.Builder props;

        public static Builder create(IPipeline pipeline) {
            return new Builder(pipeline);
        }

        private Builder(IPipeline pipeline) {
            this.pipeline = pipeline;
        }

        public Builder deadLetterQueue(IQueue deadLetterQueue) {
            this.props().deadLetterQueue(deadLetterQueue);
            return this;
        }

        public Builder input(ScheduleTargetInput input) {
            this.props().input(input);
            return this;
        }

        public Builder maxEventAge(Duration maxEventAge) {
            this.props().maxEventAge(maxEventAge);
            return this;
        }

        public Builder retryAttempts(Number retryAttempts) {
            this.props().retryAttempts(retryAttempts);
            return this;
        }

        public Builder role(IRole role) {
            this.props().role(role);
            return this;
        }

        public Builder pipelineParameterList(List<? extends SageMakerPipelineParameter> pipelineParameterList) {
            this.props().pipelineParameterList(pipelineParameterList);
            return this;
        }

        public SageMakerStartPipelineExecution build() {
            return new SageMakerStartPipelineExecution(this.pipeline, this.props != null ? this.props.build() : null);
        }

        private SageMakerStartPipelineExecutionProps.Builder props() {
            if (this.props == null) {
                this.props = new SageMakerStartPipelineExecutionProps.Builder();
            }
            return this.props;
        }
    }
}

