/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.RemovalPolicy;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.cloudwatch.MetricOptions;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.stepfunctions.DefinitionBody;
import software.amazon.awscdk.services.stepfunctions.EncryptionConfiguration;
import software.amazon.awscdk.services.stepfunctions.IChainable;
import software.amazon.awscdk.services.stepfunctions.IStateMachine;
import software.amazon.awscdk.services.stepfunctions.LogOptions;
import software.amazon.awscdk.services.stepfunctions.QueryLanguage;
import software.amazon.awscdk.services.stepfunctions.StateMachineProps;
import software.amazon.awscdk.services.stepfunctions.StateMachineType;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_stepfunctions.StateMachine")
public class StateMachine
extends Resource
implements IStateMachine {
    protected StateMachine(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StateMachine(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public StateMachine(@NotNull Construct scope, @NotNull String id, @NotNull StateMachineProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IStateMachine fromStateMachineArn(@NotNull Construct scope, @NotNull String id, @NotNull String stateMachineArn) {
        return (IStateMachine)JsiiObject.jsiiStaticCall(StateMachine.class, (String)"fromStateMachineArn", (NativeType)NativeType.forClass(IStateMachine.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(stateMachineArn, "stateMachineArn is required")});
    }

    @NotNull
    public static IStateMachine fromStateMachineName(@NotNull Construct scope, @NotNull String id, @NotNull String stateMachineName) {
        return (IStateMachine)JsiiObject.jsiiStaticCall(StateMachine.class, (String)"fromStateMachineName", (NativeType)NativeType.forClass(IStateMachine.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(stateMachineName, "stateMachineName is required")});
    }

    public void addToRolePolicy(@NotNull PolicyStatement statement) {
        Kernel.call((Object)this, (String)"addToRolePolicy", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    @Override
    @NotNull
    public Grant grant(@NotNull IGrantable identity, String ... actions) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grant", (NativeType)NativeType.forClass(Grant.class), (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(identity, "identity is required")}), Arrays.stream(actions)).toArray(Object[]::new)));
    }

    @Override
    @NotNull
    public Grant grantExecution(@NotNull IGrantable identity, String ... actions) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantExecution", (NativeType)NativeType.forClass(Grant.class), (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(identity, "identity is required")}), Arrays.stream(actions)).toArray(Object[]::new)));
    }

    @Override
    @NotNull
    public Grant grantRead(@NotNull IGrantable identity) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantRead", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required")}));
    }

    @Override
    @NotNull
    public Grant grantStartExecution(@NotNull IGrantable identity) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantStartExecution", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required")}));
    }

    @Override
    @NotNull
    public Grant grantStartSyncExecution(@NotNull IGrantable identity) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantStartSyncExecution", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required")}));
    }

    @Override
    @NotNull
    public Grant grantTaskResponse(@NotNull IGrantable identity) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantTaskResponse", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required")}));
    }

    @Override
    @NotNull
    public Metric metric(@NotNull String metricName, @Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required"), props});
    }

    @Override
    @NotNull
    public Metric metric(@NotNull String metricName) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required")});
    }

    @Override
    @NotNull
    public Metric metricAborted(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricAborted", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricAborted() {
        return (Metric)Kernel.call((Object)this, (String)"metricAborted", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricFailed(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricFailed", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricFailed() {
        return (Metric)Kernel.call((Object)this, (String)"metricFailed", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricStarted(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricStarted", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricStarted() {
        return (Metric)Kernel.call((Object)this, (String)"metricStarted", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricSucceeded(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricSucceeded", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricSucceeded() {
        return (Metric)Kernel.call((Object)this, (String)"metricSucceeded", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricThrottled(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricThrottled", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricThrottled() {
        return (Metric)Kernel.call((Object)this, (String)"metricThrottled", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricTime(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricTime", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricTime() {
        return (Metric)Kernel.call((Object)this, (String)"metricTime", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricTimedOut(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricTimedOut", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricTimedOut() {
        return (Metric)Kernel.call((Object)this, (String)"metricTimedOut", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public IPrincipal getGrantPrincipal() {
        return (IPrincipal)Kernel.get((Object)this, (String)"grantPrincipal", (NativeType)NativeType.forClass(IPrincipal.class));
    }

    @NotNull
    public IRole getRole() {
        return (IRole)Kernel.get((Object)this, (String)"role", (NativeType)NativeType.forClass(IRole.class));
    }

    @Override
    @NotNull
    public String getStateMachineArn() {
        return (String)Kernel.get((Object)this, (String)"stateMachineArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getStateMachineName() {
        return (String)Kernel.get((Object)this, (String)"stateMachineName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getStateMachineRevisionId() {
        return (String)Kernel.get((Object)this, (String)"stateMachineRevisionId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public StateMachineType getStateMachineType() {
        return (StateMachineType)((Object)Kernel.get((Object)this, (String)"stateMachineType", (NativeType)NativeType.forClass(StateMachineType.class)));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<StateMachine> {
        private final Construct scope;
        private final String id;
        private final StateMachineProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new StateMachineProps.Builder();
        }

        public Builder comment(String comment) {
            this.props.comment(comment);
            return this;
        }

        @Deprecated
        public Builder definition(IChainable definition) {
            this.props.definition(definition);
            return this;
        }

        public Builder definitionBody(DefinitionBody definitionBody) {
            this.props.definitionBody(definitionBody);
            return this;
        }

        public Builder definitionSubstitutions(Map<String, String> definitionSubstitutions) {
            this.props.definitionSubstitutions(definitionSubstitutions);
            return this;
        }

        public Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.props.encryptionConfiguration(encryptionConfiguration);
            return this;
        }

        public Builder logs(LogOptions logs) {
            this.props.logs(logs);
            return this;
        }

        public Builder queryLanguage(QueryLanguage queryLanguage) {
            this.props.queryLanguage(queryLanguage);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        public Builder role(IRole role) {
            this.props.role(role);
            return this;
        }

        public Builder stateMachineName(String stateMachineName) {
            this.props.stateMachineName(stateMachineName);
            return this;
        }

        public Builder stateMachineType(StateMachineType stateMachineType) {
            this.props.stateMachineType(stateMachineType);
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        public Builder tracingEnabled(Boolean tracingEnabled) {
            this.props.tracingEnabled(tracingEnabled);
            return this;
        }

        public StateMachine build() {
            return new StateMachine(this.scope, this.id, this.props.build());
        }
    }
}

