/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.synthetics;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.AssetHashType;
import software.amazon.awscdk.BundlingOptions;
import software.amazon.awscdk.IgnoreMode;
import software.amazon.awscdk.SymlinkFollowMode;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.s3.assets.AssetOptions;
import software.amazon.awscdk.services.synthetics.Code;
import software.amazon.awscdk.services.synthetics.CodeConfig;
import software.amazon.awscdk.services.synthetics.RuntimeFamily;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_synthetics.AssetCode")
public class AssetCode
extends Code {
    protected AssetCode(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AssetCode(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public AssetCode(@NotNull String assetPath, @Nullable AssetOptions options) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(assetPath, "assetPath is required"), options});
    }

    public AssetCode(@NotNull String assetPath) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(assetPath, "assetPath is required")});
    }

    @Override
    @NotNull
    public CodeConfig bind(@NotNull Construct scope, @NotNull String handler, @NotNull RuntimeFamily family, @Nullable String runtimeName) {
        return (CodeConfig)Kernel.call((Object)((Object)this), (String)"bind", (NativeType)NativeType.forClass(CodeConfig.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(handler, "handler is required"), Objects.requireNonNull(family, "family is required"), runtimeName});
    }

    @Override
    @NotNull
    public CodeConfig bind(@NotNull Construct scope, @NotNull String handler, @NotNull RuntimeFamily family) {
        return (CodeConfig)Kernel.call((Object)((Object)this), (String)"bind", (NativeType)NativeType.forClass(CodeConfig.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(handler, "handler is required"), Objects.requireNonNull(family, "family is required")});
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<AssetCode> {
        private final String assetPath;
        private AssetOptions.Builder options;

        public static Builder create(String assetPath) {
            return new Builder(assetPath);
        }

        private Builder(String assetPath) {
            this.assetPath = assetPath;
        }

        public Builder assetHash(String assetHash) {
            this.options().assetHash(assetHash);
            return this;
        }

        public Builder assetHashType(AssetHashType assetHashType) {
            this.options().assetHashType(assetHashType);
            return this;
        }

        public Builder bundling(BundlingOptions bundling) {
            this.options().bundling(bundling);
            return this;
        }

        public Builder exclude(List<String> exclude) {
            this.options().exclude(exclude);
            return this;
        }

        public Builder followSymlinks(SymlinkFollowMode followSymlinks) {
            this.options().followSymlinks(followSymlinks);
            return this;
        }

        public Builder ignoreMode(IgnoreMode ignoreMode) {
            this.options().ignoreMode(ignoreMode);
            return this;
        }

        public Builder deployTime(Boolean deployTime) {
            this.options().deployTime(deployTime);
            return this;
        }

        public Builder displayName(String displayName) {
            this.options().displayName(displayName);
            return this;
        }

        public Builder readers(List<? extends IGrantable> readers) {
            this.options().readers(readers);
            return this;
        }

        public Builder sourceKmsKey(IKey sourceKmsKey) {
            this.options().sourceKmsKey(sourceKmsKey);
            return this;
        }

        public AssetCode build() {
            return new AssetCode(this.assetPath, this.options != null ? this.options.build() : null);
        }

        private AssetOptions.Builder options() {
            if (this.options == null) {
                this.options = new AssetOptions.Builder();
            }
            return this.options;
        }
    }
}

