package software.amazon.awscdk;

/**
 * Build an asset manifest from assets added to a stack.
 * <p>
 * This class does not need to be used by app builders; it is only necessary for building Stack Synthesizers.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * AssetManifestBuilder assetManifestBuilder = new AssetManifestBuilder();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:11.381Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.AssetManifestBuilder")
public class AssetManifestBuilder extends software.amazon.jsii.JsiiObject {

    protected AssetManifestBuilder(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AssetManifestBuilder(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AssetManifestBuilder() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Add a docker asset source and destination to the manifest.
     * <p>
     * sourceHash should be unique for every source.
     * <p>
     * @param stack This parameter is required.
     * @param sourceHash This parameter is required.
     * @param source This parameter is required.
     * @param dest This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloud_assembly_schema.DockerImageDestination addDockerImageAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack stack, final @org.jetbrains.annotations.NotNull java.lang.String sourceHash, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloud_assembly_schema.DockerImageSource source, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloud_assembly_schema.DockerImageDestination dest, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.AddDockerImageAssetOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addDockerImageAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloud_assembly_schema.DockerImageDestination.class), new Object[] { java.util.Objects.requireNonNull(stack, "stack is required"), java.util.Objects.requireNonNull(sourceHash, "sourceHash is required"), java.util.Objects.requireNonNull(source, "source is required"), java.util.Objects.requireNonNull(dest, "dest is required"), options });
    }

    /**
     * Add a docker asset source and destination to the manifest.
     * <p>
     * sourceHash should be unique for every source.
     * <p>
     * @param stack This parameter is required.
     * @param sourceHash This parameter is required.
     * @param source This parameter is required.
     * @param dest This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloud_assembly_schema.DockerImageDestination addDockerImageAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack stack, final @org.jetbrains.annotations.NotNull java.lang.String sourceHash, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloud_assembly_schema.DockerImageSource source, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloud_assembly_schema.DockerImageDestination dest) {
        return software.amazon.jsii.Kernel.call(this, "addDockerImageAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloud_assembly_schema.DockerImageDestination.class), new Object[] { java.util.Objects.requireNonNull(stack, "stack is required"), java.util.Objects.requireNonNull(sourceHash, "sourceHash is required"), java.util.Objects.requireNonNull(source, "source is required"), java.util.Objects.requireNonNull(dest, "dest is required") });
    }

    /**
     * Add a file asset source and destination to the manifest.
     * <p>
     * sourceHash should be unique for every source.
     * <p>
     * @param stack This parameter is required.
     * @param sourceHash This parameter is required.
     * @param source This parameter is required.
     * @param dest This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloud_assembly_schema.FileDestination addFileAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack stack, final @org.jetbrains.annotations.NotNull java.lang.String sourceHash, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloud_assembly_schema.FileSource source, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloud_assembly_schema.FileDestination dest, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.AddFileAssetOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addFileAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloud_assembly_schema.FileDestination.class), new Object[] { java.util.Objects.requireNonNull(stack, "stack is required"), java.util.Objects.requireNonNull(sourceHash, "sourceHash is required"), java.util.Objects.requireNonNull(source, "source is required"), java.util.Objects.requireNonNull(dest, "dest is required"), options });
    }

    /**
     * Add a file asset source and destination to the manifest.
     * <p>
     * sourceHash should be unique for every source.
     * <p>
     * @param stack This parameter is required.
     * @param sourceHash This parameter is required.
     * @param source This parameter is required.
     * @param dest This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloud_assembly_schema.FileDestination addFileAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack stack, final @org.jetbrains.annotations.NotNull java.lang.String sourceHash, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloud_assembly_schema.FileSource source, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloud_assembly_schema.FileDestination dest) {
        return software.amazon.jsii.Kernel.call(this, "addFileAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloud_assembly_schema.FileDestination.class), new Object[] { java.util.Objects.requireNonNull(stack, "stack is required"), java.util.Objects.requireNonNull(sourceHash, "sourceHash is required"), java.util.Objects.requireNonNull(source, "source is required"), java.util.Objects.requireNonNull(dest, "dest is required") });
    }

    /**
     * Add a docker image asset to the manifest with default settings.
     * <p>
     * Derive the region from the stack, use the asset hash as the key, and set the prefix.
     * <p>
     * @param stack This parameter is required.
     * @param asset This parameter is required.
     * @param target This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloud_assembly_schema.DockerImageDestination defaultAddDockerImageAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack stack, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.DockerImageAssetSource asset, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.AssetManifestDockerImageDestination target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.AddDockerImageAssetOptions options) {
        return software.amazon.jsii.Kernel.call(this, "defaultAddDockerImageAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloud_assembly_schema.DockerImageDestination.class), new Object[] { java.util.Objects.requireNonNull(stack, "stack is required"), java.util.Objects.requireNonNull(asset, "asset is required"), java.util.Objects.requireNonNull(target, "target is required"), options });
    }

    /**
     * Add a docker image asset to the manifest with default settings.
     * <p>
     * Derive the region from the stack, use the asset hash as the key, and set the prefix.
     * <p>
     * @param stack This parameter is required.
     * @param asset This parameter is required.
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloud_assembly_schema.DockerImageDestination defaultAddDockerImageAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack stack, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.DockerImageAssetSource asset, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.AssetManifestDockerImageDestination target) {
        return software.amazon.jsii.Kernel.call(this, "defaultAddDockerImageAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloud_assembly_schema.DockerImageDestination.class), new Object[] { java.util.Objects.requireNonNull(stack, "stack is required"), java.util.Objects.requireNonNull(asset, "asset is required"), java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * Add a file asset to the manifest with default settings.
     * <p>
     * Derive the region from the stack, use the asset hash as the key, copy the
     * file extension over, and set the prefix.
     * <p>
     * @param stack This parameter is required.
     * @param asset This parameter is required.
     * @param target This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloud_assembly_schema.FileDestination defaultAddFileAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack stack, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.FileAssetSource asset, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.AssetManifestFileDestination target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.AddFileAssetOptions options) {
        return software.amazon.jsii.Kernel.call(this, "defaultAddFileAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloud_assembly_schema.FileDestination.class), new Object[] { java.util.Objects.requireNonNull(stack, "stack is required"), java.util.Objects.requireNonNull(asset, "asset is required"), java.util.Objects.requireNonNull(target, "target is required"), options });
    }

    /**
     * Add a file asset to the manifest with default settings.
     * <p>
     * Derive the region from the stack, use the asset hash as the key, copy the
     * file extension over, and set the prefix.
     * <p>
     * @param stack This parameter is required.
     * @param asset This parameter is required.
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloud_assembly_schema.FileDestination defaultAddFileAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack stack, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.FileAssetSource asset, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.AssetManifestFileDestination target) {
        return software.amazon.jsii.Kernel.call(this, "defaultAddFileAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloud_assembly_schema.FileDestination.class), new Object[] { java.util.Objects.requireNonNull(stack, "stack is required"), java.util.Objects.requireNonNull(asset, "asset is required"), java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * Write the manifest to disk, and add it to the synthesis session.
     * <p>
     * Return the artifact id, which should be added to the <code>additionalDependencies</code>
     * field of the stack artifact.
     * <p>
     * @param stack This parameter is required.
     * @param session This parameter is required.
     * @param options
     * @param dependencies
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String emitManifest(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack stack, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ISynthesisSession session, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.cloud_assembly_schema.AssetManifestOptions options, final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> dependencies) {
        return software.amazon.jsii.Kernel.call(this, "emitManifest", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(stack, "stack is required"), java.util.Objects.requireNonNull(session, "session is required"), options, dependencies });
    }

    /**
     * Write the manifest to disk, and add it to the synthesis session.
     * <p>
     * Return the artifact id, which should be added to the <code>additionalDependencies</code>
     * field of the stack artifact.
     * <p>
     * @param stack This parameter is required.
     * @param session This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String emitManifest(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack stack, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ISynthesisSession session, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.cloud_assembly_schema.AssetManifestOptions options) {
        return software.amazon.jsii.Kernel.call(this, "emitManifest", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(stack, "stack is required"), java.util.Objects.requireNonNull(session, "session is required"), options });
    }

    /**
     * Write the manifest to disk, and add it to the synthesis session.
     * <p>
     * Return the artifact id, which should be added to the <code>additionalDependencies</code>
     * field of the stack artifact.
     * <p>
     * @param stack This parameter is required.
     * @param session This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String emitManifest(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack stack, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ISynthesisSession session) {
        return software.amazon.jsii.Kernel.call(this, "emitManifest", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(stack, "stack is required"), java.util.Objects.requireNonNull(session, "session is required") });
    }

    /**
     * Whether there are any assets registered in the manifest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getHasAssets() {
        return software.amazon.jsii.Kernel.get(this, "hasAssets", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }
}
