package software.amazon.awscdk;

/**
 * A rule can include a RuleCondition property and must include an Assertions property.
 * <p>
 * For each rule, you can define only one rule condition; you can define one or more asserts within the Assertions property.
 * You define a rule condition and assertions by using rule-specific intrinsic functions.
 * <p>
 * You can use the following rule-specific intrinsic functions to define rule conditions and assertions:
 * <p>
 * Fn::And
 * Fn::Contains
 * Fn::EachMemberEquals
 * Fn::EachMemberIn
 * Fn::Equals
 * Fn::If
 * Fn::Not
 * Fn::Or
 * Fn::RefAll
 * Fn::ValueOf
 * Fn::ValueOfAll
 * <p>
 * https://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * ICfnConditionExpression cfnConditionExpression;
 * CfnRuleProps cfnRuleProps = CfnRuleProps.builder()
 *         .assertions(List.of(CfnRuleAssertion.builder()
 *                 .assert(cfnConditionExpression)
 *                 .assertDescription("assertDescription")
 *                 .build()))
 *         .ruleCondition(cfnConditionExpression)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:11.465Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CfnRuleProps")
@software.amazon.jsii.Jsii.Proxy(CfnRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRuleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Assertions which define the rule.
     * <p>
     * Default: - No assertions for the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnRuleAssertion> getAssertions() {
        return null;
    }

    /**
     * If the rule condition evaluates to false, the rule doesn't take effect.
     * <p>
     * If the function in the rule condition evaluates to true, expressions in each assert are evaluated and applied.
     * <p>
     * Default: - Rule's assertions will always take effect.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.ICfnConditionExpression getRuleCondition() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRuleProps> {
        java.util.List<software.amazon.awscdk.CfnRuleAssertion> assertions;
        software.amazon.awscdk.ICfnConditionExpression ruleCondition;

        /**
         * Sets the value of {@link CfnRuleProps#getAssertions}
         * @param assertions Assertions which define the rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder assertions(java.util.List<? extends software.amazon.awscdk.CfnRuleAssertion> assertions) {
            this.assertions = (java.util.List<software.amazon.awscdk.CfnRuleAssertion>)assertions;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleProps#getRuleCondition}
         * @param ruleCondition If the rule condition evaluates to false, the rule doesn't take effect.
         *                      If the function in the rule condition evaluates to true, expressions in each assert are evaluated and applied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleCondition(software.amazon.awscdk.ICfnConditionExpression ruleCondition) {
            this.ruleCondition = ruleCondition;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRuleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRuleProps {
        private final java.util.List<software.amazon.awscdk.CfnRuleAssertion> assertions;
        private final software.amazon.awscdk.ICfnConditionExpression ruleCondition;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assertions = software.amazon.jsii.Kernel.get(this, "assertions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnRuleAssertion.class)));
            this.ruleCondition = software.amazon.jsii.Kernel.get(this, "ruleCondition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.ICfnConditionExpression.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assertions = (java.util.List<software.amazon.awscdk.CfnRuleAssertion>)builder.assertions;
            this.ruleCondition = builder.ruleCondition;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnRuleAssertion> getAssertions() {
            return this.assertions;
        }

        @Override
        public final software.amazon.awscdk.ICfnConditionExpression getRuleCondition() {
            return this.ruleCondition;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAssertions() != null) {
                data.set("assertions", om.valueToTree(this.getAssertions()));
            }
            if (this.getRuleCondition() != null) {
                data.set("ruleCondition", om.valueToTree(this.getRuleCondition()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.CfnRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRuleProps.Jsii$Proxy that = (CfnRuleProps.Jsii$Proxy) o;

            if (this.assertions != null ? !this.assertions.equals(that.assertions) : that.assertions != null) return false;
            return this.ruleCondition != null ? this.ruleCondition.equals(that.ruleCondition) : that.ruleCondition == null;
        }

        @Override
        public final int hashCode() {
            int result = this.assertions != null ? this.assertions.hashCode() : 0;
            result = 31 * result + (this.ruleCondition != null ? this.ruleCondition.hashCode() : 0);
            return result;
        }
    }
}
