package software.amazon.awscdk;

/**
 * Uses conventionally named roles and asset storage locations.
 * <p>
 * This synthesizer:
 * <p>
 * <ul>
 * <li>Supports cross-account deployments (the CLI can have credentials to one
 * account, and you can still deploy to another account by assuming roles with
 * well-known names in the other account).</li>
 * <li>Supports the <strong>CDK Pipelines</strong> library.</li>
 * </ul>
 * <p>
 * Requires the environment to have been bootstrapped with Bootstrap Stack V2
 * (also known as "modern bootstrap stack"). The synthesizer adds a version
 * check to the template, to make sure the bootstrap stack is recent enough
 * to support all features expected by this synthesizer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * App app;
 * Stage prodStage = Stage.Builder.create(app, "ProdStage")
 *         .permissionsBoundary(PermissionsBoundary.fromName("cdk-${Qualifier}-PermissionsBoundary-${AWS::AccountId}-${AWS::Region}"))
 *         .build();
 * Stack.Builder.create(prodStage, "ProdStack")
 *         .synthesizer(DefaultStackSynthesizer.Builder.create()
 *                 .qualifier("custom")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:11.522Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.DefaultStackSynthesizer")
public class DefaultStackSynthesizer extends software.amazon.awscdk.StackSynthesizer implements software.amazon.awscdk.IReusableStackSynthesizer, software.amazon.awscdk.IBoundStackSynthesizer {

    protected DefaultStackSynthesizer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DefaultStackSynthesizer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        DEFAULT_BOOTSTRAP_STACK_VERSION_SSM_PARAMETER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.DefaultStackSynthesizer.class, "DEFAULT_BOOTSTRAP_STACK_VERSION_SSM_PARAMETER", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DEFAULT_CLOUDFORMATION_ROLE_ARN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.DefaultStackSynthesizer.class, "DEFAULT_CLOUDFORMATION_ROLE_ARN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DEFAULT_DEPLOY_ROLE_ARN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.DefaultStackSynthesizer.class, "DEFAULT_DEPLOY_ROLE_ARN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DEFAULT_DOCKER_ASSET_PREFIX = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.DefaultStackSynthesizer.class, "DEFAULT_DOCKER_ASSET_PREFIX", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DEFAULT_FILE_ASSET_KEY_ARN_EXPORT_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.DefaultStackSynthesizer.class, "DEFAULT_FILE_ASSET_KEY_ARN_EXPORT_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DEFAULT_FILE_ASSET_PREFIX = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.DefaultStackSynthesizer.class, "DEFAULT_FILE_ASSET_PREFIX", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DEFAULT_FILE_ASSET_PUBLISHING_ROLE_ARN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.DefaultStackSynthesizer.class, "DEFAULT_FILE_ASSET_PUBLISHING_ROLE_ARN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DEFAULT_FILE_ASSETS_BUCKET_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.DefaultStackSynthesizer.class, "DEFAULT_FILE_ASSETS_BUCKET_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DEFAULT_IMAGE_ASSET_PUBLISHING_ROLE_ARN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.DefaultStackSynthesizer.class, "DEFAULT_IMAGE_ASSET_PUBLISHING_ROLE_ARN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DEFAULT_IMAGE_ASSETS_REPOSITORY_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.DefaultStackSynthesizer.class, "DEFAULT_IMAGE_ASSETS_REPOSITORY_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DEFAULT_LOOKUP_ROLE_ARN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.DefaultStackSynthesizer.class, "DEFAULT_LOOKUP_ROLE_ARN", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        DEFAULT_QUALIFIER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.DefaultStackSynthesizer.class, "DEFAULT_QUALIFIER", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DefaultStackSynthesizer(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.DefaultStackSynthesizerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DefaultStackSynthesizer() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Register a Docker Image Asset.
     * <p>
     * Returns the parameters that can be used to refer to the asset inside the template.
     * <p>
     * The synthesizer must rely on some out-of-band mechanism to make sure the given files
     * are actually placed in the returned location before the deployment happens. This can
     * be by writing the instructions to the asset manifest (for use by the <code>cdk-assets</code> tool),
     * by relying on the CLI to upload files (legacy behavior), or some other operator controlled
     * mechanism.
     * <p>
     * @param asset This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.DockerImageAssetLocation addDockerImageAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.DockerImageAssetSource asset) {
        return software.amazon.jsii.Kernel.call(this, "addDockerImageAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.DockerImageAssetLocation.class), new Object[] { java.util.Objects.requireNonNull(asset, "asset is required") });
    }

    /**
     * Register a File Asset.
     * <p>
     * Returns the parameters that can be used to refer to the asset inside the template.
     * <p>
     * The synthesizer must rely on some out-of-band mechanism to make sure the given files
     * are actually placed in the returned location before the deployment happens. This can
     * be by writing the instructions to the asset manifest (for use by the <code>cdk-assets</code> tool),
     * by relying on the CLI to upload files (legacy behavior), or some other operator controlled
     * mechanism.
     * <p>
     * @param asset This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.FileAssetLocation addFileAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.FileAssetSource asset) {
        return software.amazon.jsii.Kernel.call(this, "addFileAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.FileAssetLocation.class), new Object[] { java.util.Objects.requireNonNull(asset, "asset is required") });
    }

    /**
     * Bind to the stack this environment is going to be used on.
     * <p>
     * Must be called before any of the other methods are called.
     * <p>
     * @param stack This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack stack) {
        software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(stack, "stack is required") });
    }

    /**
     * Produce a bound Stack Synthesizer for the given stack.
     * <p>
     * This method may be called more than once on the same object.
     * <p>
     * @param stack This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IBoundStackSynthesizer reusableBind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack stack) {
        return software.amazon.jsii.Kernel.call(this, "reusableBind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IBoundStackSynthesizer.class), new Object[] { java.util.Objects.requireNonNull(stack, "stack is required") });
    }

    /**
     * Synthesize the associated stack to the session.
     * <p>
     * @param session This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void synthesize(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ISynthesisSession session) {
        software.amazon.jsii.Kernel.call(this, "synthesize", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(session, "session is required") });
    }

    /**
     * Synthesize the stack template to the given session, passing the configured lookup role ARN.
     * <p>
     * @param stack This parameter is required.
     * @param session This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected void synthesizeStackTemplate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack stack, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ISynthesisSession session) {
        software.amazon.jsii.Kernel.call(this, "synthesizeStackTemplate", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(stack, "stack is required"), java.util.Objects.requireNonNull(session, "session is required") });
    }

    /**
     * Default bootstrap stack version SSM parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DEFAULT_BOOTSTRAP_STACK_VERSION_SSM_PARAMETER;

    /**
     * Default CloudFormation role ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DEFAULT_CLOUDFORMATION_ROLE_ARN;

    /**
     * Default deploy role ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DEFAULT_DEPLOY_ROLE_ARN;

    /**
     * Default Docker asset prefix.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DEFAULT_DOCKER_ASSET_PREFIX;

    /**
     * Name of the CloudFormation Export with the asset key name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DEFAULT_FILE_ASSET_KEY_ARN_EXPORT_NAME;

    /**
     * Default file asset prefix.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DEFAULT_FILE_ASSET_PREFIX;

    /**
     * Default asset publishing role ARN for file (S3) assets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DEFAULT_FILE_ASSET_PUBLISHING_ROLE_ARN;

    /**
     * Default file assets bucket name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DEFAULT_FILE_ASSETS_BUCKET_NAME;

    /**
     * Default asset publishing role ARN for image (ECR) assets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DEFAULT_IMAGE_ASSET_PUBLISHING_ROLE_ARN;

    /**
     * Default image assets repository name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DEFAULT_IMAGE_ASSETS_REPOSITORY_NAME;

    /**
     * Default lookup role ARN for missing values.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DEFAULT_LOOKUP_ROLE_ARN;

    /**
     * Default ARN qualifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DEFAULT_QUALIFIER;

    /**
     * Returns the ARN of the CFN execution Role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCloudFormationExecutionRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "cloudFormationExecutionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the ARN of the deploy Role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDeployRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "deployRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The qualifier used to bootstrap this stack.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBootstrapQualifier() {
        return software.amazon.jsii.Kernel.get(this, "bootstrapQualifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The role used to lookup for this stack.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLookupRole() {
        return software.amazon.jsii.Kernel.get(this, "lookupRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (deprecated) Return the currently bound stack.
     * <p>
     * @deprecated Use <code>boundStack</code> instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.Stack getStack() {
        return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.DefaultStackSynthesizer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.DefaultStackSynthesizer> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.DefaultStackSynthesizerProps.Builder props;

        private Builder() {
        }

        /**
         * Bootstrap stack version SSM parameter.
         * <p>
         * The placeholder <code>${Qualifier}</code> will be replaced with the value of qualifier.
         * <p>
         * Default: DefaultStackSynthesizer.DEFAULT_BOOTSTRAP_STACK_VERSION_SSM_PARAMETER
         * <p>
         * @return {@code this}
         * @param bootstrapStackVersionSsmParameter Bootstrap stack version SSM parameter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bootstrapStackVersionSsmParameter(final java.lang.String bootstrapStackVersionSsmParameter) {
            this.props().bootstrapStackVersionSsmParameter(bootstrapStackVersionSsmParameter);
            return this;
        }

        /**
         * bucketPrefix to use while storing S3 Assets.
         * <p>
         * Default: - DefaultStackSynthesizer.DEFAULT_FILE_ASSET_PREFIX
         * <p>
         * @return {@code this}
         * @param bucketPrefix bucketPrefix to use while storing S3 Assets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketPrefix(final java.lang.String bucketPrefix) {
            this.props().bucketPrefix(bucketPrefix);
            return this;
        }

        /**
         * The role CloudFormation will assume when deploying the Stack.
         * <p>
         * You must supply this if you have given a non-standard name to the execution role.
         * <p>
         * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         * be replaced with the values of qualifier and the stack's account and region,
         * respectively.
         * <p>
         * Default: DefaultStackSynthesizer.DEFAULT_CLOUDFORMATION_ROLE_ARN
         * <p>
         * @return {@code this}
         * @param cloudFormationExecutionRole The role CloudFormation will assume when deploying the Stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudFormationExecutionRole(final java.lang.String cloudFormationExecutionRole) {
            this.props().cloudFormationExecutionRole(cloudFormationExecutionRole);
            return this;
        }

        /**
         * Additional options to pass to STS when assuming the deploy role.
         * <p>
         * <ul>
         * <li><code>RoleArn</code> should not be used. Use the dedicated <code>deployRoleArn</code> property instead.</li>
         * <li><code>ExternalId</code> should not be used. Use the dedicated <code>deployRoleExternalId</code> instead.</li>
         * <li><code>TransitiveTagKeys</code> defaults to use all keys (if any) specified in <code>Tags</code>. E.g, all tags are transitive by default.</li>
         * </ul>
         * <p>
         * Default: - No additional options.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/STS.html#assumeRole-property">https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/STS.html#assumeRole-property</a>
         * @param deployRoleAdditionalOptions Additional options to pass to STS when assuming the deploy role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deployRoleAdditionalOptions(final java.util.Map<java.lang.String, ? extends java.lang.Object> deployRoleAdditionalOptions) {
            this.props().deployRoleAdditionalOptions(deployRoleAdditionalOptions);
            return this;
        }

        /**
         * The role to assume to initiate a deployment in this environment.
         * <p>
         * You must supply this if you have given a non-standard name to the publishing role.
         * <p>
         * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         * be replaced with the values of qualifier and the stack's account and region,
         * respectively.
         * <p>
         * Default: DefaultStackSynthesizer.DEFAULT_DEPLOY_ROLE_ARN
         * <p>
         * @return {@code this}
         * @param deployRoleArn The role to assume to initiate a deployment in this environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deployRoleArn(final java.lang.String deployRoleArn) {
            this.props().deployRoleArn(deployRoleArn);
            return this;
        }

        /**
         * External ID to use when assuming role for cloudformation deployments.
         * <p>
         * Default: - No external ID
         * <p>
         * @return {@code this}
         * @param deployRoleExternalId External ID to use when assuming role for cloudformation deployments. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deployRoleExternalId(final java.lang.String deployRoleExternalId) {
            this.props().deployRoleExternalId(deployRoleExternalId);
            return this;
        }

        /**
         * A prefix to use while tagging and uploading Docker images to ECR.
         * <p>
         * This does not add any separators - the source hash will be appended to
         * this string directly.
         * <p>
         * Default: - DefaultStackSynthesizer.DEFAULT_DOCKER_ASSET_PREFIX
         * <p>
         * @return {@code this}
         * @param dockerTagPrefix A prefix to use while tagging and uploading Docker images to ECR. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerTagPrefix(final java.lang.String dockerTagPrefix) {
            this.props().dockerTagPrefix(dockerTagPrefix);
            return this;
        }

        /**
         * External ID to use when assuming role for file asset publishing.
         * <p>
         * Default: - No external ID
         * <p>
         * @return {@code this}
         * @param fileAssetPublishingExternalId External ID to use when assuming role for file asset publishing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileAssetPublishingExternalId(final java.lang.String fileAssetPublishingExternalId) {
            this.props().fileAssetPublishingExternalId(fileAssetPublishingExternalId);
            return this;
        }

        /**
         * Additional options to pass to STS when assuming the file asset publishing.
         * <p>
         * <ul>
         * <li><code>RoleArn</code> should not be used. Use the dedicated <code>fileAssetPublishingRoleArn</code> property instead.</li>
         * <li><code>ExternalId</code> should not be used. Use the dedicated <code>fileAssetPublishingExternalId</code> instead.</li>
         * <li><code>TransitiveTagKeys</code> defaults to use all keys (if any) specified in <code>Tags</code>. E.g, all tags are transitive by default.</li>
         * </ul>
         * <p>
         * Default: - No additional options.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/STS.html#assumeRole-property">https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/STS.html#assumeRole-property</a>
         * @param fileAssetPublishingRoleAdditionalOptions Additional options to pass to STS when assuming the file asset publishing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileAssetPublishingRoleAdditionalOptions(final java.util.Map<java.lang.String, ? extends java.lang.Object> fileAssetPublishingRoleAdditionalOptions) {
            this.props().fileAssetPublishingRoleAdditionalOptions(fileAssetPublishingRoleAdditionalOptions);
            return this;
        }

        /**
         * The role to use to publish file assets to the S3 bucket in this environment.
         * <p>
         * You must supply this if you have given a non-standard name to the publishing role.
         * <p>
         * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         * be replaced with the values of qualifier and the stack's account and region,
         * respectively.
         * <p>
         * Default: DefaultStackSynthesizer.DEFAULT_FILE_ASSET_PUBLISHING_ROLE_ARN
         * <p>
         * @return {@code this}
         * @param fileAssetPublishingRoleArn The role to use to publish file assets to the S3 bucket in this environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileAssetPublishingRoleArn(final java.lang.String fileAssetPublishingRoleArn) {
            this.props().fileAssetPublishingRoleArn(fileAssetPublishingRoleArn);
            return this;
        }

        /**
         * Name of the S3 bucket to hold file assets.
         * <p>
         * You must supply this if you have given a non-standard name to the staging bucket.
         * <p>
         * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         * be replaced with the values of qualifier and the stack's account and region,
         * respectively.
         * <p>
         * Default: DefaultStackSynthesizer.DEFAULT_FILE_ASSETS_BUCKET_NAME
         * <p>
         * @return {@code this}
         * @param fileAssetsBucketName Name of the S3 bucket to hold file assets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileAssetsBucketName(final java.lang.String fileAssetsBucketName) {
            this.props().fileAssetsBucketName(fileAssetsBucketName);
            return this;
        }

        /**
         * Whether to add a Rule to the stack template verifying the bootstrap stack version.
         * <p>
         * This generally should be left set to <code>true</code>, unless you explicitly
         * want to be able to deploy to an unbootstrapped environment.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param generateBootstrapVersionRule Whether to add a Rule to the stack template verifying the bootstrap stack version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder generateBootstrapVersionRule(final java.lang.Boolean generateBootstrapVersionRule) {
            this.props().generateBootstrapVersionRule(generateBootstrapVersionRule);
            return this;
        }

        /**
         * External ID to use when assuming role for image asset publishing.
         * <p>
         * Default: - No external ID
         * <p>
         * @return {@code this}
         * @param imageAssetPublishingExternalId External ID to use when assuming role for image asset publishing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageAssetPublishingExternalId(final java.lang.String imageAssetPublishingExternalId) {
            this.props().imageAssetPublishingExternalId(imageAssetPublishingExternalId);
            return this;
        }

        /**
         * Additional options to pass to STS when assuming the image asset publishing.
         * <p>
         * <ul>
         * <li><code>RoleArn</code> should not be used. Use the dedicated <code>imageAssetPublishingRoleArn</code> property instead.</li>
         * <li><code>ExternalId</code> should not be used. Use the dedicated <code>imageAssetPublishingExternalId</code> instead.</li>
         * <li><code>TransitiveTagKeys</code> defaults to use all keys (if any) specified in <code>Tags</code>. E.g, all tags are transitive by default.</li>
         * </ul>
         * <p>
         * Default: - No additional options.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/STS.html#assumeRole-property">https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/STS.html#assumeRole-property</a>
         * @param imageAssetPublishingRoleAdditionalOptions Additional options to pass to STS when assuming the image asset publishing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageAssetPublishingRoleAdditionalOptions(final java.util.Map<java.lang.String, ? extends java.lang.Object> imageAssetPublishingRoleAdditionalOptions) {
            this.props().imageAssetPublishingRoleAdditionalOptions(imageAssetPublishingRoleAdditionalOptions);
            return this;
        }

        /**
         * The role to use to publish image assets to the ECR repository in this environment.
         * <p>
         * You must supply this if you have given a non-standard name to the publishing role.
         * <p>
         * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         * be replaced with the values of qualifier and the stack's account and region,
         * respectively.
         * <p>
         * Default: DefaultStackSynthesizer.DEFAULT_IMAGE_ASSET_PUBLISHING_ROLE_ARN
         * <p>
         * @return {@code this}
         * @param imageAssetPublishingRoleArn The role to use to publish image assets to the ECR repository in this environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageAssetPublishingRoleArn(final java.lang.String imageAssetPublishingRoleArn) {
            this.props().imageAssetPublishingRoleArn(imageAssetPublishingRoleArn);
            return this;
        }

        /**
         * Name of the ECR repository to hold Docker Image assets.
         * <p>
         * You must supply this if you have given a non-standard name to the ECR repository.
         * <p>
         * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         * be replaced with the values of qualifier and the stack's account and region,
         * respectively.
         * <p>
         * Default: DefaultStackSynthesizer.DEFAULT_IMAGE_ASSETS_REPOSITORY_NAME
         * <p>
         * @return {@code this}
         * @param imageAssetsRepositoryName Name of the ECR repository to hold Docker Image assets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageAssetsRepositoryName(final java.lang.String imageAssetsRepositoryName) {
            this.props().imageAssetsRepositoryName(imageAssetsRepositoryName);
            return this;
        }

        /**
         * Additional options to pass to STS when assuming the lookup role.
         * <p>
         * <ul>
         * <li><code>RoleArn</code> should not be used. Use the dedicated <code>lookupRoleArn</code> property instead.</li>
         * <li><code>ExternalId</code> should not be used. Use the dedicated <code>lookupRoleExternalId</code> instead.</li>
         * <li><code>TransitiveTagKeys</code> defaults to use all keys (if any) specified in <code>Tags</code>. E.g, all tags are transitive by default.</li>
         * </ul>
         * <p>
         * Default: - No additional options.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/STS.html#assumeRole-property">https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/STS.html#assumeRole-property</a>
         * @param lookupRoleAdditionalOptions Additional options to pass to STS when assuming the lookup role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lookupRoleAdditionalOptions(final java.util.Map<java.lang.String, ? extends java.lang.Object> lookupRoleAdditionalOptions) {
            this.props().lookupRoleAdditionalOptions(lookupRoleAdditionalOptions);
            return this;
        }

        /**
         * The role to use to look up values from the target AWS account during synthesis.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param lookupRoleArn The role to use to look up values from the target AWS account during synthesis. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lookupRoleArn(final java.lang.String lookupRoleArn) {
            this.props().lookupRoleArn(lookupRoleArn);
            return this;
        }

        /**
         * External ID to use when assuming lookup role.
         * <p>
         * Default: - No external ID
         * <p>
         * @return {@code this}
         * @param lookupRoleExternalId External ID to use when assuming lookup role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lookupRoleExternalId(final java.lang.String lookupRoleExternalId) {
            this.props().lookupRoleExternalId(lookupRoleExternalId);
            return this;
        }

        /**
         * Qualifier to disambiguate multiple environments in the same account.
         * <p>
         * You can use this and leave the other naming properties empty if you have deployed
         * the bootstrap environment with standard names but only different qualifiers.
         * <p>
         * Default: - Value of context key '@aws-cdk/core:bootstrapQualifier' if set, otherwise `DefaultStackSynthesizer.DEFAULT_QUALIFIER`
         * <p>
         * @return {@code this}
         * @param qualifier Qualifier to disambiguate multiple environments in the same account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder qualifier(final java.lang.String qualifier) {
            this.props().qualifier(qualifier);
            return this;
        }

        /**
         * Use the bootstrapped lookup role for (read-only) stack operations.
         * <p>
         * Use the lookup role when performing a <code>cdk diff</code>. If set to <code>false</code>, the
         * <code>deploy role</code> credentials will be used to perform a <code>cdk diff</code>.
         * <p>
         * Requires bootstrap stack version 8.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param useLookupRoleForStackOperations Use the bootstrapped lookup role for (read-only) stack operations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useLookupRoleForStackOperations(final java.lang.Boolean useLookupRoleForStackOperations) {
            this.props().useLookupRoleForStackOperations(useLookupRoleForStackOperations);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.DefaultStackSynthesizer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.DefaultStackSynthesizer build() {
            return new software.amazon.awscdk.DefaultStackSynthesizer(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.DefaultStackSynthesizerProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.DefaultStackSynthesizerProps.Builder();
            }
            return this.props;
        }
    }
}
