package software.amazon.awscdk;

/**
 * An object which serializes to the JSON <code>null</code> literal, and which can safely be passed across languages where <code>undefined</code> and <code>null</code> are not different.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * JsonNull jsonNull = JsonNull.INSTANCE;
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:11.570Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.JsonNull")
public class JsonNull extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.IResolvable {

    protected JsonNull(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected JsonNull(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        INSTANCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.JsonNull.class, "INSTANCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.JsonNull.class));
    }

    /**
     * Produce the Token's value at resolution time.
     * <p>
     * @param _ctx This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Object resolve(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolveContext _ctx) {
        return software.amazon.jsii.Kernel.call(this, "resolve", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), new Object[] { java.util.Objects.requireNonNull(_ctx, "_ctx is required") });
    }

    /**
     * Obtains the JSON representation of this object (<code>null</code>).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object toJSON() {
        return software.amazon.jsii.Kernel.call(this, "toJSON", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Obtains the string representation of this object (<code>'null'</code>).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The canonical instance of <code>JsonNull</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.JsonNull INSTANCE;

    /**
     * The creation stack of this resolvable which will be appended to errors thrown during resolution.
     * <p>
     * This may return an array with a single informational element indicating how
     * to get this property populated, if it was skipped for performance reasons.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getCreationStack() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "creationStack", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }
}
