package software.amazon.awscdk.alexa.ask;

/**
 * Properties for defining a <code>CfnSkill</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.alexa.ask.*;
 * Object manifest;
 * CfnSkillProps cfnSkillProps = CfnSkillProps.builder()
 *         .authenticationConfiguration(AuthenticationConfigurationProperty.builder()
 *                 .clientId("clientId")
 *                 .clientSecret("clientSecret")
 *                 .refreshToken("refreshToken")
 *                 .build())
 *         .skillPackage(SkillPackageProperty.builder()
 *                 .s3Bucket("s3Bucket")
 *                 .s3Key("s3Key")
 *                 // the properties below are optional
 *                 .overrides(OverridesProperty.builder()
 *                         .manifest(manifest)
 *                         .build())
 *                 .s3BucketRole("s3BucketRole")
 *                 .s3ObjectVersion("s3ObjectVersion")
 *                 .build())
 *         .vendorId("vendorId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ask-skill.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ask-skill.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:11.642Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.alexa_ask.CfnSkillProps")
@software.amazon.jsii.Jsii.Proxy(CfnSkillProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSkillProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Login with Amazon (LWA) configuration used to authenticate with the Alexa service.
     * <p>
     * Only Login with Amazon clients created through the  are supported. The client ID, client secret, and refresh token are required.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ask-skill.html#cfn-ask-skill-authenticationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ask-skill.html#cfn-ask-skill-authenticationconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getAuthenticationConfiguration();

    /**
     * Configuration for the skill package that contains the components of the Alexa skill.
     * <p>
     * Skill packages are retrieved from an Amazon S3 bucket and key and used to create and update the skill. For more information about the skill package format, see the  .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ask-skill.html#cfn-ask-skill-skillpackage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ask-skill.html#cfn-ask-skill-skillpackage</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSkillPackage();

    /**
     * The vendor ID associated with the Amazon developer account that will host the skill.
     * <p>
     * Details for retrieving the vendor ID are in  . The provided LWA credentials must be linked to the developer account associated with this vendor ID.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ask-skill.html#cfn-ask-skill-vendorid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ask-skill.html#cfn-ask-skill-vendorid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVendorId();

    /**
     * @return a {@link Builder} of {@link CfnSkillProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSkillProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSkillProps> {
        java.lang.Object authenticationConfiguration;
        java.lang.Object skillPackage;
        java.lang.String vendorId;

        /**
         * Sets the value of {@link CfnSkillProps#getAuthenticationConfiguration}
         * @param authenticationConfiguration Login with Amazon (LWA) configuration used to authenticate with the Alexa service. This parameter is required.
         *                                    Only Login with Amazon clients created through the  are supported. The client ID, client secret, and refresh token are required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationConfiguration(software.amazon.awscdk.IResolvable authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnSkillProps#getAuthenticationConfiguration}
         * @param authenticationConfiguration Login with Amazon (LWA) configuration used to authenticate with the Alexa service. This parameter is required.
         *                                    Only Login with Amazon clients created through the  are supported. The client ID, client secret, and refresh token are required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationConfiguration(software.amazon.awscdk.alexa.ask.CfnSkill.AuthenticationConfigurationProperty authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnSkillProps#getSkillPackage}
         * @param skillPackage Configuration for the skill package that contains the components of the Alexa skill. This parameter is required.
         *                     Skill packages are retrieved from an Amazon S3 bucket and key and used to create and update the skill. For more information about the skill package format, see the  .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder skillPackage(software.amazon.awscdk.IResolvable skillPackage) {
            this.skillPackage = skillPackage;
            return this;
        }

        /**
         * Sets the value of {@link CfnSkillProps#getSkillPackage}
         * @param skillPackage Configuration for the skill package that contains the components of the Alexa skill. This parameter is required.
         *                     Skill packages are retrieved from an Amazon S3 bucket and key and used to create and update the skill. For more information about the skill package format, see the  .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder skillPackage(software.amazon.awscdk.alexa.ask.CfnSkill.SkillPackageProperty skillPackage) {
            this.skillPackage = skillPackage;
            return this;
        }

        /**
         * Sets the value of {@link CfnSkillProps#getVendorId}
         * @param vendorId The vendor ID associated with the Amazon developer account that will host the skill. This parameter is required.
         *                 Details for retrieving the vendor ID are in  . The provided LWA credentials must be linked to the developer account associated with this vendor ID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vendorId(java.lang.String vendorId) {
            this.vendorId = vendorId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSkillProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSkillProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSkillProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSkillProps {
        private final java.lang.Object authenticationConfiguration;
        private final java.lang.Object skillPackage;
        private final java.lang.String vendorId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authenticationConfiguration = software.amazon.jsii.Kernel.get(this, "authenticationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.skillPackage = software.amazon.jsii.Kernel.get(this, "skillPackage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.vendorId = software.amazon.jsii.Kernel.get(this, "vendorId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authenticationConfiguration = java.util.Objects.requireNonNull(builder.authenticationConfiguration, "authenticationConfiguration is required");
            this.skillPackage = java.util.Objects.requireNonNull(builder.skillPackage, "skillPackage is required");
            this.vendorId = java.util.Objects.requireNonNull(builder.vendorId, "vendorId is required");
        }

        @Override
        public final java.lang.Object getAuthenticationConfiguration() {
            return this.authenticationConfiguration;
        }

        @Override
        public final java.lang.Object getSkillPackage() {
            return this.skillPackage;
        }

        @Override
        public final java.lang.String getVendorId() {
            return this.vendorId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("authenticationConfiguration", om.valueToTree(this.getAuthenticationConfiguration()));
            data.set("skillPackage", om.valueToTree(this.getSkillPackage()));
            data.set("vendorId", om.valueToTree(this.getVendorId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.alexa_ask.CfnSkillProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSkillProps.Jsii$Proxy that = (CfnSkillProps.Jsii$Proxy) o;

            if (!authenticationConfiguration.equals(that.authenticationConfiguration)) return false;
            if (!skillPackage.equals(that.skillPackage)) return false;
            return this.vendorId.equals(that.vendorId);
        }

        @Override
        public final int hashCode() {
            int result = this.authenticationConfiguration.hashCode();
            result = 31 * result + (this.skillPackage.hashCode());
            result = 31 * result + (this.vendorId.hashCode());
            return result;
        }
    }
}
