package software.amazon.awscdk.services.apigateway;

/**
 * The <code>AWS::ApiGateway::Deployment</code> resource deploys an API Gateway <code>RestApi</code> resource to a stage so that clients can call the API over the internet.
 * <p>
 * The stage acts as an environment.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * CfnDeployment cfnDeployment = CfnDeployment.Builder.create(this, "MyCfnDeployment")
 *         .restApiId("restApiId")
 *         // the properties below are optional
 *         .deploymentCanarySettings(DeploymentCanarySettingsProperty.builder()
 *                 .percentTraffic(123)
 *                 .stageVariableOverrides(Map.of(
 *                         "stageVariableOverridesKey", "stageVariableOverrides"))
 *                 .useStageCache(false)
 *                 .build())
 *         .description("description")
 *         .stageDescription(StageDescriptionProperty.builder()
 *                 .accessLogSetting(AccessLogSettingProperty.builder()
 *                         .destinationArn("destinationArn")
 *                         .format("format")
 *                         .build())
 *                 .cacheClusterEnabled(false)
 *                 .cacheClusterSize("cacheClusterSize")
 *                 .cacheDataEncrypted(false)
 *                 .cacheTtlInSeconds(123)
 *                 .cachingEnabled(false)
 *                 .canarySetting(CanarySettingProperty.builder()
 *                         .percentTraffic(123)
 *                         .stageVariableOverrides(Map.of(
 *                                 "stageVariableOverridesKey", "stageVariableOverrides"))
 *                         .useStageCache(false)
 *                         .build())
 *                 .clientCertificateId("clientCertificateId")
 *                 .dataTraceEnabled(false)
 *                 .description("description")
 *                 .documentationVersion("documentationVersion")
 *                 .loggingLevel("loggingLevel")
 *                 .methodSettings(List.of(MethodSettingProperty.builder()
 *                         .cacheDataEncrypted(false)
 *                         .cacheTtlInSeconds(123)
 *                         .cachingEnabled(false)
 *                         .dataTraceEnabled(false)
 *                         .httpMethod("httpMethod")
 *                         .loggingLevel("loggingLevel")
 *                         .metricsEnabled(false)
 *                         .resourcePath("resourcePath")
 *                         .throttlingBurstLimit(123)
 *                         .throttlingRateLimit(123)
 *                         .build()))
 *                 .metricsEnabled(false)
 *                 .tags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .throttlingBurstLimit(123)
 *                 .throttlingRateLimit(123)
 *                 .tracingEnabled(false)
 *                 .variables(Map.of(
 *                         "variablesKey", "variables"))
 *                 .build())
 *         .stageName("stageName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:11.868Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.CfnDeployment")
public class CfnDeployment extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnDeployment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDeployment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.CfnDeployment.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDeployment(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.CfnDeploymentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID for the deployment.
     * <p>
     * For example: <code>abc123</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDeploymentId() {
        return software.amazon.jsii.Kernel.get(this, "attrDeploymentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The string identifier of the associated RestApi.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRestApiId() {
        return software.amazon.jsii.Kernel.get(this, "restApiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The string identifier of the associated RestApi.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRestApiId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "restApiId", java.util.Objects.requireNonNull(value, "restApiId is required"));
    }

    /**
     * The input configuration for a canary deployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeploymentCanarySettings() {
        return software.amazon.jsii.Kernel.get(this, "deploymentCanarySettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The input configuration for a canary deployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentCanarySettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deploymentCanarySettings", value);
    }

    /**
     * The input configuration for a canary deployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentCanarySettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.CfnDeployment.DeploymentCanarySettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "deploymentCanarySettings", value);
    }

    /**
     * The description for the Deployment resource to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description for the Deployment resource to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The description of the Stage resource for the Deployment resource to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStageDescription() {
        return software.amazon.jsii.Kernel.get(this, "stageDescription", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The description of the Stage resource for the Deployment resource to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStageDescription(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "stageDescription", value);
    }

    /**
     * The description of the Stage resource for the Deployment resource to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStageDescription(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.CfnDeployment.StageDescriptionProperty value) {
        software.amazon.jsii.Kernel.set(this, "stageDescription", value);
    }

    /**
     * The name of the Stage resource for the Deployment resource to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStageName() {
        return software.amazon.jsii.Kernel.get(this, "stageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the Stage resource for the Deployment resource to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStageName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "stageName", value);
    }
    /**
     * The <code>AccessLogSetting</code> property type specifies settings for logging access in this stage.
     * <p>
     * <code>AccessLogSetting</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html">StageDescription</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apigateway.*;
     * AccessLogSettingProperty accessLogSettingProperty = AccessLogSettingProperty.builder()
     *         .destinationArn("destinationArn")
     *         .format("format")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-accesslogsetting.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-accesslogsetting.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.CfnDeployment.AccessLogSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(AccessLogSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccessLogSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs.
         * <p>
         * If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with <code>amazon-apigateway-</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-accesslogsetting.html#cfn-apigateway-deployment-accesslogsetting-destinationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-accesslogsetting.html#cfn-apigateway-deployment-accesslogsetting-destinationarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDestinationArn() {
            return null;
        }

        /**
         * A single line format of the access logs of data, as specified by selected $context variables.
         * <p>
         * The format must include at least <code>$context.requestId</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-accesslogsetting.html#cfn-apigateway-deployment-accesslogsetting-format">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-accesslogsetting.html#cfn-apigateway-deployment-accesslogsetting-format</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFormat() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AccessLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccessLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AccessLogSettingProperty> {
            java.lang.String destinationArn;
            java.lang.String format;

            /**
             * Sets the value of {@link AccessLogSettingProperty#getDestinationArn}
             * @param destinationArn The Amazon Resource Name (ARN) of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs.
             *                       If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with <code>amazon-apigateway-</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationArn(java.lang.String destinationArn) {
                this.destinationArn = destinationArn;
                return this;
            }

            /**
             * Sets the value of {@link AccessLogSettingProperty#getFormat}
             * @param format A single line format of the access logs of data, as specified by selected $context variables.
             *               The format must include at least <code>$context.requestId</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder format(java.lang.String format) {
                this.format = format;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessLogSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AccessLogSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AccessLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessLogSettingProperty {
            private final java.lang.String destinationArn;
            private final java.lang.String format;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationArn = software.amazon.jsii.Kernel.get(this, "destinationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.format = software.amazon.jsii.Kernel.get(this, "format", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationArn = builder.destinationArn;
                this.format = builder.format;
            }

            @Override
            public final java.lang.String getDestinationArn() {
                return this.destinationArn;
            }

            @Override
            public final java.lang.String getFormat() {
                return this.format;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDestinationArn() != null) {
                    data.set("destinationArn", om.valueToTree(this.getDestinationArn()));
                }
                if (this.getFormat() != null) {
                    data.set("format", om.valueToTree(this.getFormat()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigateway.CfnDeployment.AccessLogSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccessLogSettingProperty.Jsii$Proxy that = (AccessLogSettingProperty.Jsii$Proxy) o;

                if (this.destinationArn != null ? !this.destinationArn.equals(that.destinationArn) : that.destinationArn != null) return false;
                return this.format != null ? this.format.equals(that.format) : that.format == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destinationArn != null ? this.destinationArn.hashCode() : 0;
                result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>CanarySetting</code> property type specifies settings for the canary deployment in this stage.
     * <p>
     * <code>CanarySetting</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html">StageDescription</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apigateway.*;
     * CanarySettingProperty canarySettingProperty = CanarySettingProperty.builder()
     *         .percentTraffic(123)
     *         .stageVariableOverrides(Map.of(
     *                 "stageVariableOverridesKey", "stageVariableOverrides"))
     *         .useStageCache(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-canarysetting.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-canarysetting.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.CfnDeployment.CanarySettingProperty")
    @software.amazon.jsii.Jsii.Proxy(CanarySettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CanarySettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The percent (0-100) of traffic diverted to a canary deployment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-canarysetting.html#cfn-apigateway-deployment-canarysetting-percenttraffic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-canarysetting.html#cfn-apigateway-deployment-canarysetting-percenttraffic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPercentTraffic() {
            return null;
        }

        /**
         * Stage variables overridden for a canary release deployment, including new stage variables introduced in the canary.
         * <p>
         * These stage variables are represented as a string-to-string map between stage variable names and their values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-canarysetting.html#cfn-apigateway-deployment-canarysetting-stagevariableoverrides">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-canarysetting.html#cfn-apigateway-deployment-canarysetting-stagevariableoverrides</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStageVariableOverrides() {
            return null;
        }

        /**
         * A Boolean flag to indicate whether the canary deployment uses the stage cache or not.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-canarysetting.html#cfn-apigateway-deployment-canarysetting-usestagecache">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-canarysetting.html#cfn-apigateway-deployment-canarysetting-usestagecache</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseStageCache() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CanarySettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CanarySettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CanarySettingProperty> {
            java.lang.Number percentTraffic;
            java.lang.Object stageVariableOverrides;
            java.lang.Object useStageCache;

            /**
             * Sets the value of {@link CanarySettingProperty#getPercentTraffic}
             * @param percentTraffic The percent (0-100) of traffic diverted to a canary deployment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder percentTraffic(java.lang.Number percentTraffic) {
                this.percentTraffic = percentTraffic;
                return this;
            }

            /**
             * Sets the value of {@link CanarySettingProperty#getStageVariableOverrides}
             * @param stageVariableOverrides Stage variables overridden for a canary release deployment, including new stage variables introduced in the canary.
             *                               These stage variables are represented as a string-to-string map between stage variable names and their values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stageVariableOverrides(java.util.Map<java.lang.String, java.lang.String> stageVariableOverrides) {
                this.stageVariableOverrides = stageVariableOverrides;
                return this;
            }

            /**
             * Sets the value of {@link CanarySettingProperty#getStageVariableOverrides}
             * @param stageVariableOverrides Stage variables overridden for a canary release deployment, including new stage variables introduced in the canary.
             *                               These stage variables are represented as a string-to-string map between stage variable names and their values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stageVariableOverrides(software.amazon.awscdk.IResolvable stageVariableOverrides) {
                this.stageVariableOverrides = stageVariableOverrides;
                return this;
            }

            /**
             * Sets the value of {@link CanarySettingProperty#getUseStageCache}
             * @param useStageCache A Boolean flag to indicate whether the canary deployment uses the stage cache or not.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useStageCache(java.lang.Boolean useStageCache) {
                this.useStageCache = useStageCache;
                return this;
            }

            /**
             * Sets the value of {@link CanarySettingProperty#getUseStageCache}
             * @param useStageCache A Boolean flag to indicate whether the canary deployment uses the stage cache or not.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useStageCache(software.amazon.awscdk.IResolvable useStageCache) {
                this.useStageCache = useStageCache;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CanarySettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CanarySettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CanarySettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CanarySettingProperty {
            private final java.lang.Number percentTraffic;
            private final java.lang.Object stageVariableOverrides;
            private final java.lang.Object useStageCache;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.percentTraffic = software.amazon.jsii.Kernel.get(this, "percentTraffic", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.stageVariableOverrides = software.amazon.jsii.Kernel.get(this, "stageVariableOverrides", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.useStageCache = software.amazon.jsii.Kernel.get(this, "useStageCache", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.percentTraffic = builder.percentTraffic;
                this.stageVariableOverrides = builder.stageVariableOverrides;
                this.useStageCache = builder.useStageCache;
            }

            @Override
            public final java.lang.Number getPercentTraffic() {
                return this.percentTraffic;
            }

            @Override
            public final java.lang.Object getStageVariableOverrides() {
                return this.stageVariableOverrides;
            }

            @Override
            public final java.lang.Object getUseStageCache() {
                return this.useStageCache;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPercentTraffic() != null) {
                    data.set("percentTraffic", om.valueToTree(this.getPercentTraffic()));
                }
                if (this.getStageVariableOverrides() != null) {
                    data.set("stageVariableOverrides", om.valueToTree(this.getStageVariableOverrides()));
                }
                if (this.getUseStageCache() != null) {
                    data.set("useStageCache", om.valueToTree(this.getUseStageCache()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigateway.CfnDeployment.CanarySettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CanarySettingProperty.Jsii$Proxy that = (CanarySettingProperty.Jsii$Proxy) o;

                if (this.percentTraffic != null ? !this.percentTraffic.equals(that.percentTraffic) : that.percentTraffic != null) return false;
                if (this.stageVariableOverrides != null ? !this.stageVariableOverrides.equals(that.stageVariableOverrides) : that.stageVariableOverrides != null) return false;
                return this.useStageCache != null ? this.useStageCache.equals(that.useStageCache) : that.useStageCache == null;
            }

            @Override
            public final int hashCode() {
                int result = this.percentTraffic != null ? this.percentTraffic.hashCode() : 0;
                result = 31 * result + (this.stageVariableOverrides != null ? this.stageVariableOverrides.hashCode() : 0);
                result = 31 * result + (this.useStageCache != null ? this.useStageCache.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>DeploymentCanarySettings</code> property type specifies settings for the canary deployment.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apigateway.*;
     * DeploymentCanarySettingsProperty deploymentCanarySettingsProperty = DeploymentCanarySettingsProperty.builder()
     *         .percentTraffic(123)
     *         .stageVariableOverrides(Map.of(
     *                 "stageVariableOverridesKey", "stageVariableOverrides"))
     *         .useStageCache(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-deploymentcanarysettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-deploymentcanarysettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.CfnDeployment.DeploymentCanarySettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(DeploymentCanarySettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeploymentCanarySettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The percentage (0.0-100.0) of traffic routed to the canary deployment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-deploymentcanarysettings.html#cfn-apigateway-deployment-deploymentcanarysettings-percenttraffic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-deploymentcanarysettings.html#cfn-apigateway-deployment-deploymentcanarysettings-percenttraffic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPercentTraffic() {
            return null;
        }

        /**
         * A stage variable overrides used for the canary release deployment.
         * <p>
         * They can override existing stage variables or add new stage variables for the canary release deployment. These stage variables are represented as a string-to-string map between stage variable names and their values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-deploymentcanarysettings.html#cfn-apigateway-deployment-deploymentcanarysettings-stagevariableoverrides">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-deploymentcanarysettings.html#cfn-apigateway-deployment-deploymentcanarysettings-stagevariableoverrides</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStageVariableOverrides() {
            return null;
        }

        /**
         * A Boolean flag to indicate whether the canary release deployment uses the stage cache or not.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-deploymentcanarysettings.html#cfn-apigateway-deployment-deploymentcanarysettings-usestagecache">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-deploymentcanarysettings.html#cfn-apigateway-deployment-deploymentcanarysettings-usestagecache</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseStageCache() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeploymentCanarySettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeploymentCanarySettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeploymentCanarySettingsProperty> {
            java.lang.Number percentTraffic;
            java.lang.Object stageVariableOverrides;
            java.lang.Object useStageCache;

            /**
             * Sets the value of {@link DeploymentCanarySettingsProperty#getPercentTraffic}
             * @param percentTraffic The percentage (0.0-100.0) of traffic routed to the canary deployment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder percentTraffic(java.lang.Number percentTraffic) {
                this.percentTraffic = percentTraffic;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentCanarySettingsProperty#getStageVariableOverrides}
             * @param stageVariableOverrides A stage variable overrides used for the canary release deployment.
             *                               They can override existing stage variables or add new stage variables for the canary release deployment. These stage variables are represented as a string-to-string map between stage variable names and their values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stageVariableOverrides(java.util.Map<java.lang.String, java.lang.String> stageVariableOverrides) {
                this.stageVariableOverrides = stageVariableOverrides;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentCanarySettingsProperty#getStageVariableOverrides}
             * @param stageVariableOverrides A stage variable overrides used for the canary release deployment.
             *                               They can override existing stage variables or add new stage variables for the canary release deployment. These stage variables are represented as a string-to-string map between stage variable names and their values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stageVariableOverrides(software.amazon.awscdk.IResolvable stageVariableOverrides) {
                this.stageVariableOverrides = stageVariableOverrides;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentCanarySettingsProperty#getUseStageCache}
             * @param useStageCache A Boolean flag to indicate whether the canary release deployment uses the stage cache or not.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useStageCache(java.lang.Boolean useStageCache) {
                this.useStageCache = useStageCache;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentCanarySettingsProperty#getUseStageCache}
             * @param useStageCache A Boolean flag to indicate whether the canary release deployment uses the stage cache or not.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useStageCache(software.amazon.awscdk.IResolvable useStageCache) {
                this.useStageCache = useStageCache;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentCanarySettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeploymentCanarySettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeploymentCanarySettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentCanarySettingsProperty {
            private final java.lang.Number percentTraffic;
            private final java.lang.Object stageVariableOverrides;
            private final java.lang.Object useStageCache;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.percentTraffic = software.amazon.jsii.Kernel.get(this, "percentTraffic", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.stageVariableOverrides = software.amazon.jsii.Kernel.get(this, "stageVariableOverrides", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.useStageCache = software.amazon.jsii.Kernel.get(this, "useStageCache", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.percentTraffic = builder.percentTraffic;
                this.stageVariableOverrides = builder.stageVariableOverrides;
                this.useStageCache = builder.useStageCache;
            }

            @Override
            public final java.lang.Number getPercentTraffic() {
                return this.percentTraffic;
            }

            @Override
            public final java.lang.Object getStageVariableOverrides() {
                return this.stageVariableOverrides;
            }

            @Override
            public final java.lang.Object getUseStageCache() {
                return this.useStageCache;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPercentTraffic() != null) {
                    data.set("percentTraffic", om.valueToTree(this.getPercentTraffic()));
                }
                if (this.getStageVariableOverrides() != null) {
                    data.set("stageVariableOverrides", om.valueToTree(this.getStageVariableOverrides()));
                }
                if (this.getUseStageCache() != null) {
                    data.set("useStageCache", om.valueToTree(this.getUseStageCache()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigateway.CfnDeployment.DeploymentCanarySettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeploymentCanarySettingsProperty.Jsii$Proxy that = (DeploymentCanarySettingsProperty.Jsii$Proxy) o;

                if (this.percentTraffic != null ? !this.percentTraffic.equals(that.percentTraffic) : that.percentTraffic != null) return false;
                if (this.stageVariableOverrides != null ? !this.stageVariableOverrides.equals(that.stageVariableOverrides) : that.stageVariableOverrides != null) return false;
                return this.useStageCache != null ? this.useStageCache.equals(that.useStageCache) : that.useStageCache == null;
            }

            @Override
            public final int hashCode() {
                int result = this.percentTraffic != null ? this.percentTraffic.hashCode() : 0;
                result = 31 * result + (this.stageVariableOverrides != null ? this.stageVariableOverrides.hashCode() : 0);
                result = 31 * result + (this.useStageCache != null ? this.useStageCache.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>MethodSetting</code> property type configures settings for all methods in a stage.
     * <p>
     * The <code>MethodSettings</code> property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html">Amazon API Gateway Deployment StageDescription</a> property type contains a list of <code>MethodSetting</code> property types.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apigateway.*;
     * MethodSettingProperty methodSettingProperty = MethodSettingProperty.builder()
     *         .cacheDataEncrypted(false)
     *         .cacheTtlInSeconds(123)
     *         .cachingEnabled(false)
     *         .dataTraceEnabled(false)
     *         .httpMethod("httpMethod")
     *         .loggingLevel("loggingLevel")
     *         .metricsEnabled(false)
     *         .resourcePath("resourcePath")
     *         .throttlingBurstLimit(123)
     *         .throttlingRateLimit(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-methodsetting.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-methodsetting.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.CfnDeployment.MethodSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(MethodSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MethodSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether the cached responses are encrypted.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-methodsetting.html#cfn-apigateway-deployment-methodsetting-cachedataencrypted">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-methodsetting.html#cfn-apigateway-deployment-methodsetting-cachedataencrypted</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCacheDataEncrypted() {
            return null;
        }

        /**
         * Specifies the time to live (TTL), in seconds, for cached responses.
         * <p>
         * The higher the TTL, the longer the response will be cached.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-methodsetting.html#cfn-apigateway-deployment-methodsetting-cachettlinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-methodsetting.html#cfn-apigateway-deployment-methodsetting-cachettlinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCacheTtlInSeconds() {
            return null;
        }

        /**
         * Specifies whether responses should be cached and returned for requests.
         * <p>
         * A cache cluster must be enabled on the stage for responses to be cached.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-methodsetting.html#cfn-apigateway-deployment-methodsetting-cachingenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-methodsetting.html#cfn-apigateway-deployment-methodsetting-cachingenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCachingEnabled() {
            return null;
        }

        /**
         * Specifies whether data trace logging is enabled for this method, which affects the log entries pushed to Amazon CloudWatch Logs.
         * <p>
         * This can be useful to troubleshoot APIs, but can result in logging sensitive data. We recommend that you don't enable this option for production APIs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-methodsetting.html#cfn-apigateway-deployment-methodsetting-datatraceenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-methodsetting.html#cfn-apigateway-deployment-methodsetting-datatraceenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataTraceEnabled() {
            return null;
        }

        /**
         * The HTTP method.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-methodsetting.html#cfn-apigateway-deployment-methodsetting-httpmethod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-methodsetting.html#cfn-apigateway-deployment-methodsetting-httpmethod</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHttpMethod() {
            return null;
        }

        /**
         * Specifies the logging level for this method, which affects the log entries pushed to Amazon CloudWatch Logs.
         * <p>
         * Valid values are <code>OFF</code> , <code>ERROR</code> , and <code>INFO</code> . Choose <code>ERROR</code> to write only error-level entries to CloudWatch Logs, or choose <code>INFO</code> to include all <code>ERROR</code> events as well as extra informational events.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-methodsetting.html#cfn-apigateway-deployment-methodsetting-logginglevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-methodsetting.html#cfn-apigateway-deployment-methodsetting-logginglevel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLoggingLevel() {
            return null;
        }

        /**
         * Specifies whether Amazon CloudWatch metrics are enabled for this method.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-methodsetting.html#cfn-apigateway-deployment-methodsetting-metricsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-methodsetting.html#cfn-apigateway-deployment-methodsetting-metricsenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetricsEnabled() {
            return null;
        }

        /**
         * The resource path for this method.
         * <p>
         * Forward slashes ( <code>/</code> ) are encoded as <code>~1</code> and the initial slash must include a forward slash. For example, the path value <code>/resource/subresource</code> must be encoded as <code>/~1resource~1subresource</code> . To specify the root path, use only a slash ( <code>/</code> ).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-methodsetting.html#cfn-apigateway-deployment-methodsetting-resourcepath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-methodsetting.html#cfn-apigateway-deployment-methodsetting-resourcepath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourcePath() {
            return null;
        }

        /**
         * Specifies the throttling burst limit.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-methodsetting.html#cfn-apigateway-deployment-methodsetting-throttlingburstlimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-methodsetting.html#cfn-apigateway-deployment-methodsetting-throttlingburstlimit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThrottlingBurstLimit() {
            return null;
        }

        /**
         * Specifies the throttling rate limit.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-methodsetting.html#cfn-apigateway-deployment-methodsetting-throttlingratelimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-methodsetting.html#cfn-apigateway-deployment-methodsetting-throttlingratelimit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThrottlingRateLimit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MethodSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MethodSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MethodSettingProperty> {
            java.lang.Object cacheDataEncrypted;
            java.lang.Number cacheTtlInSeconds;
            java.lang.Object cachingEnabled;
            java.lang.Object dataTraceEnabled;
            java.lang.String httpMethod;
            java.lang.String loggingLevel;
            java.lang.Object metricsEnabled;
            java.lang.String resourcePath;
            java.lang.Number throttlingBurstLimit;
            java.lang.Number throttlingRateLimit;

            /**
             * Sets the value of {@link MethodSettingProperty#getCacheDataEncrypted}
             * @param cacheDataEncrypted Specifies whether the cached responses are encrypted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cacheDataEncrypted(java.lang.Boolean cacheDataEncrypted) {
                this.cacheDataEncrypted = cacheDataEncrypted;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getCacheDataEncrypted}
             * @param cacheDataEncrypted Specifies whether the cached responses are encrypted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cacheDataEncrypted(software.amazon.awscdk.IResolvable cacheDataEncrypted) {
                this.cacheDataEncrypted = cacheDataEncrypted;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getCacheTtlInSeconds}
             * @param cacheTtlInSeconds Specifies the time to live (TTL), in seconds, for cached responses.
             *                          The higher the TTL, the longer the response will be cached.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cacheTtlInSeconds(java.lang.Number cacheTtlInSeconds) {
                this.cacheTtlInSeconds = cacheTtlInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getCachingEnabled}
             * @param cachingEnabled Specifies whether responses should be cached and returned for requests.
             *                       A cache cluster must be enabled on the stage for responses to be cached.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cachingEnabled(java.lang.Boolean cachingEnabled) {
                this.cachingEnabled = cachingEnabled;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getCachingEnabled}
             * @param cachingEnabled Specifies whether responses should be cached and returned for requests.
             *                       A cache cluster must be enabled on the stage for responses to be cached.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cachingEnabled(software.amazon.awscdk.IResolvable cachingEnabled) {
                this.cachingEnabled = cachingEnabled;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getDataTraceEnabled}
             * @param dataTraceEnabled Specifies whether data trace logging is enabled for this method, which affects the log entries pushed to Amazon CloudWatch Logs.
             *                         This can be useful to troubleshoot APIs, but can result in logging sensitive data. We recommend that you don't enable this option for production APIs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTraceEnabled(java.lang.Boolean dataTraceEnabled) {
                this.dataTraceEnabled = dataTraceEnabled;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getDataTraceEnabled}
             * @param dataTraceEnabled Specifies whether data trace logging is enabled for this method, which affects the log entries pushed to Amazon CloudWatch Logs.
             *                         This can be useful to troubleshoot APIs, but can result in logging sensitive data. We recommend that you don't enable this option for production APIs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTraceEnabled(software.amazon.awscdk.IResolvable dataTraceEnabled) {
                this.dataTraceEnabled = dataTraceEnabled;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getHttpMethod}
             * @param httpMethod The HTTP method.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpMethod(java.lang.String httpMethod) {
                this.httpMethod = httpMethod;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getLoggingLevel}
             * @param loggingLevel Specifies the logging level for this method, which affects the log entries pushed to Amazon CloudWatch Logs.
             *                     Valid values are <code>OFF</code> , <code>ERROR</code> , and <code>INFO</code> . Choose <code>ERROR</code> to write only error-level entries to CloudWatch Logs, or choose <code>INFO</code> to include all <code>ERROR</code> events as well as extra informational events.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loggingLevel(java.lang.String loggingLevel) {
                this.loggingLevel = loggingLevel;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getMetricsEnabled}
             * @param metricsEnabled Specifies whether Amazon CloudWatch metrics are enabled for this method.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricsEnabled(java.lang.Boolean metricsEnabled) {
                this.metricsEnabled = metricsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getMetricsEnabled}
             * @param metricsEnabled Specifies whether Amazon CloudWatch metrics are enabled for this method.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricsEnabled(software.amazon.awscdk.IResolvable metricsEnabled) {
                this.metricsEnabled = metricsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getResourcePath}
             * @param resourcePath The resource path for this method.
             *                     Forward slashes ( <code>/</code> ) are encoded as <code>~1</code> and the initial slash must include a forward slash. For example, the path value <code>/resource/subresource</code> must be encoded as <code>/~1resource~1subresource</code> . To specify the root path, use only a slash ( <code>/</code> ).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourcePath(java.lang.String resourcePath) {
                this.resourcePath = resourcePath;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getThrottlingBurstLimit}
             * @param throttlingBurstLimit Specifies the throttling burst limit.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throttlingBurstLimit(java.lang.Number throttlingBurstLimit) {
                this.throttlingBurstLimit = throttlingBurstLimit;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getThrottlingRateLimit}
             * @param throttlingRateLimit Specifies the throttling rate limit.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throttlingRateLimit(java.lang.Number throttlingRateLimit) {
                this.throttlingRateLimit = throttlingRateLimit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MethodSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MethodSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MethodSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MethodSettingProperty {
            private final java.lang.Object cacheDataEncrypted;
            private final java.lang.Number cacheTtlInSeconds;
            private final java.lang.Object cachingEnabled;
            private final java.lang.Object dataTraceEnabled;
            private final java.lang.String httpMethod;
            private final java.lang.String loggingLevel;
            private final java.lang.Object metricsEnabled;
            private final java.lang.String resourcePath;
            private final java.lang.Number throttlingBurstLimit;
            private final java.lang.Number throttlingRateLimit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cacheDataEncrypted = software.amazon.jsii.Kernel.get(this, "cacheDataEncrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cacheTtlInSeconds = software.amazon.jsii.Kernel.get(this, "cacheTtlInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.cachingEnabled = software.amazon.jsii.Kernel.get(this, "cachingEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dataTraceEnabled = software.amazon.jsii.Kernel.get(this, "dataTraceEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.httpMethod = software.amazon.jsii.Kernel.get(this, "httpMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.loggingLevel = software.amazon.jsii.Kernel.get(this, "loggingLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metricsEnabled = software.amazon.jsii.Kernel.get(this, "metricsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourcePath = software.amazon.jsii.Kernel.get(this, "resourcePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.throttlingBurstLimit = software.amazon.jsii.Kernel.get(this, "throttlingBurstLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.throttlingRateLimit = software.amazon.jsii.Kernel.get(this, "throttlingRateLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cacheDataEncrypted = builder.cacheDataEncrypted;
                this.cacheTtlInSeconds = builder.cacheTtlInSeconds;
                this.cachingEnabled = builder.cachingEnabled;
                this.dataTraceEnabled = builder.dataTraceEnabled;
                this.httpMethod = builder.httpMethod;
                this.loggingLevel = builder.loggingLevel;
                this.metricsEnabled = builder.metricsEnabled;
                this.resourcePath = builder.resourcePath;
                this.throttlingBurstLimit = builder.throttlingBurstLimit;
                this.throttlingRateLimit = builder.throttlingRateLimit;
            }

            @Override
            public final java.lang.Object getCacheDataEncrypted() {
                return this.cacheDataEncrypted;
            }

            @Override
            public final java.lang.Number getCacheTtlInSeconds() {
                return this.cacheTtlInSeconds;
            }

            @Override
            public final java.lang.Object getCachingEnabled() {
                return this.cachingEnabled;
            }

            @Override
            public final java.lang.Object getDataTraceEnabled() {
                return this.dataTraceEnabled;
            }

            @Override
            public final java.lang.String getHttpMethod() {
                return this.httpMethod;
            }

            @Override
            public final java.lang.String getLoggingLevel() {
                return this.loggingLevel;
            }

            @Override
            public final java.lang.Object getMetricsEnabled() {
                return this.metricsEnabled;
            }

            @Override
            public final java.lang.String getResourcePath() {
                return this.resourcePath;
            }

            @Override
            public final java.lang.Number getThrottlingBurstLimit() {
                return this.throttlingBurstLimit;
            }

            @Override
            public final java.lang.Number getThrottlingRateLimit() {
                return this.throttlingRateLimit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCacheDataEncrypted() != null) {
                    data.set("cacheDataEncrypted", om.valueToTree(this.getCacheDataEncrypted()));
                }
                if (this.getCacheTtlInSeconds() != null) {
                    data.set("cacheTtlInSeconds", om.valueToTree(this.getCacheTtlInSeconds()));
                }
                if (this.getCachingEnabled() != null) {
                    data.set("cachingEnabled", om.valueToTree(this.getCachingEnabled()));
                }
                if (this.getDataTraceEnabled() != null) {
                    data.set("dataTraceEnabled", om.valueToTree(this.getDataTraceEnabled()));
                }
                if (this.getHttpMethod() != null) {
                    data.set("httpMethod", om.valueToTree(this.getHttpMethod()));
                }
                if (this.getLoggingLevel() != null) {
                    data.set("loggingLevel", om.valueToTree(this.getLoggingLevel()));
                }
                if (this.getMetricsEnabled() != null) {
                    data.set("metricsEnabled", om.valueToTree(this.getMetricsEnabled()));
                }
                if (this.getResourcePath() != null) {
                    data.set("resourcePath", om.valueToTree(this.getResourcePath()));
                }
                if (this.getThrottlingBurstLimit() != null) {
                    data.set("throttlingBurstLimit", om.valueToTree(this.getThrottlingBurstLimit()));
                }
                if (this.getThrottlingRateLimit() != null) {
                    data.set("throttlingRateLimit", om.valueToTree(this.getThrottlingRateLimit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigateway.CfnDeployment.MethodSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MethodSettingProperty.Jsii$Proxy that = (MethodSettingProperty.Jsii$Proxy) o;

                if (this.cacheDataEncrypted != null ? !this.cacheDataEncrypted.equals(that.cacheDataEncrypted) : that.cacheDataEncrypted != null) return false;
                if (this.cacheTtlInSeconds != null ? !this.cacheTtlInSeconds.equals(that.cacheTtlInSeconds) : that.cacheTtlInSeconds != null) return false;
                if (this.cachingEnabled != null ? !this.cachingEnabled.equals(that.cachingEnabled) : that.cachingEnabled != null) return false;
                if (this.dataTraceEnabled != null ? !this.dataTraceEnabled.equals(that.dataTraceEnabled) : that.dataTraceEnabled != null) return false;
                if (this.httpMethod != null ? !this.httpMethod.equals(that.httpMethod) : that.httpMethod != null) return false;
                if (this.loggingLevel != null ? !this.loggingLevel.equals(that.loggingLevel) : that.loggingLevel != null) return false;
                if (this.metricsEnabled != null ? !this.metricsEnabled.equals(that.metricsEnabled) : that.metricsEnabled != null) return false;
                if (this.resourcePath != null ? !this.resourcePath.equals(that.resourcePath) : that.resourcePath != null) return false;
                if (this.throttlingBurstLimit != null ? !this.throttlingBurstLimit.equals(that.throttlingBurstLimit) : that.throttlingBurstLimit != null) return false;
                return this.throttlingRateLimit != null ? this.throttlingRateLimit.equals(that.throttlingRateLimit) : that.throttlingRateLimit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cacheDataEncrypted != null ? this.cacheDataEncrypted.hashCode() : 0;
                result = 31 * result + (this.cacheTtlInSeconds != null ? this.cacheTtlInSeconds.hashCode() : 0);
                result = 31 * result + (this.cachingEnabled != null ? this.cachingEnabled.hashCode() : 0);
                result = 31 * result + (this.dataTraceEnabled != null ? this.dataTraceEnabled.hashCode() : 0);
                result = 31 * result + (this.httpMethod != null ? this.httpMethod.hashCode() : 0);
                result = 31 * result + (this.loggingLevel != null ? this.loggingLevel.hashCode() : 0);
                result = 31 * result + (this.metricsEnabled != null ? this.metricsEnabled.hashCode() : 0);
                result = 31 * result + (this.resourcePath != null ? this.resourcePath.hashCode() : 0);
                result = 31 * result + (this.throttlingBurstLimit != null ? this.throttlingBurstLimit.hashCode() : 0);
                result = 31 * result + (this.throttlingRateLimit != null ? this.throttlingRateLimit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>StageDescription</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html">AWS::ApiGateway::Deployment</a> resource that configures a deployment stage.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apigateway.*;
     * StageDescriptionProperty stageDescriptionProperty = StageDescriptionProperty.builder()
     *         .accessLogSetting(AccessLogSettingProperty.builder()
     *                 .destinationArn("destinationArn")
     *                 .format("format")
     *                 .build())
     *         .cacheClusterEnabled(false)
     *         .cacheClusterSize("cacheClusterSize")
     *         .cacheDataEncrypted(false)
     *         .cacheTtlInSeconds(123)
     *         .cachingEnabled(false)
     *         .canarySetting(CanarySettingProperty.builder()
     *                 .percentTraffic(123)
     *                 .stageVariableOverrides(Map.of(
     *                         "stageVariableOverridesKey", "stageVariableOverrides"))
     *                 .useStageCache(false)
     *                 .build())
     *         .clientCertificateId("clientCertificateId")
     *         .dataTraceEnabled(false)
     *         .description("description")
     *         .documentationVersion("documentationVersion")
     *         .loggingLevel("loggingLevel")
     *         .methodSettings(List.of(MethodSettingProperty.builder()
     *                 .cacheDataEncrypted(false)
     *                 .cacheTtlInSeconds(123)
     *                 .cachingEnabled(false)
     *                 .dataTraceEnabled(false)
     *                 .httpMethod("httpMethod")
     *                 .loggingLevel("loggingLevel")
     *                 .metricsEnabled(false)
     *                 .resourcePath("resourcePath")
     *                 .throttlingBurstLimit(123)
     *                 .throttlingRateLimit(123)
     *                 .build()))
     *         .metricsEnabled(false)
     *         .tags(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .throttlingBurstLimit(123)
     *         .throttlingRateLimit(123)
     *         .tracingEnabled(false)
     *         .variables(Map.of(
     *                 "variablesKey", "variables"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.CfnDeployment.StageDescriptionProperty")
    @software.amazon.jsii.Jsii.Proxy(StageDescriptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StageDescriptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies settings for logging access in this stage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-accesslogsetting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-accesslogsetting</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAccessLogSetting() {
            return null;
        }

        /**
         * Specifies whether a cache cluster is enabled for the stage.
         * <p>
         * To activate a method-level cache, set <code>CachingEnabled</code> to <code>true</code> for a method.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cacheclusterenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cacheclusterenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCacheClusterEnabled() {
            return null;
        }

        /**
         * The size of the stage's cache cluster.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/API_CreateStage.html#apigw-CreateStage-request-cacheClusterSize">cacheClusterSize</a> in the <em>API Gateway API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cacheclustersize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cacheclustersize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCacheClusterSize() {
            return null;
        }

        /**
         * Indicates whether the cached responses are encrypted.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachedataencrypted">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachedataencrypted</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCacheDataEncrypted() {
            return null;
        }

        /**
         * The time-to-live (TTL) period, in seconds, that specifies how long API Gateway caches responses.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachettlinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachettlinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCacheTtlInSeconds() {
            return null;
        }

        /**
         * Indicates whether responses are cached and returned for requests.
         * <p>
         * You must enable a cache cluster on the stage to cache responses. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-caching.html">Enable API Gateway Caching in a Stage to Enhance API Performance</a> in the <em>API Gateway Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachingenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachingenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCachingEnabled() {
            return null;
        }

        /**
         * Specifies settings for the canary deployment in this stage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-canarysetting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-canarysetting</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCanarySetting() {
            return null;
        }

        /**
         * The identifier of the client certificate that API Gateway uses to call your integration endpoints in the stage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-clientcertificateid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-clientcertificateid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClientCertificateId() {
            return null;
        }

        /**
         * Indicates whether data trace logging is enabled for methods in the stage.
         * <p>
         * API Gateway pushes these logs to Amazon CloudWatch Logs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-datatraceenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-datatraceenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataTraceEnabled() {
            return null;
        }

        /**
         * A description of the purpose of the stage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * The version identifier of the API documentation snapshot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-documentationversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-documentationversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDocumentationVersion() {
            return null;
        }

        /**
         * The logging level for this method.
         * <p>
         * For valid values, see the <code>loggingLevel</code> property of the <a href="https://docs.aws.amazon.com/apigateway/latest/api/API_MethodSetting.html">MethodSetting</a> resource in the <em>Amazon API Gateway API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-logginglevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-logginglevel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLoggingLevel() {
            return null;
        }

        /**
         * Configures settings for all of the stage's methods.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-methodsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-methodsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMethodSettings() {
            return null;
        }

        /**
         * Indicates whether Amazon CloudWatch metrics are enabled for methods in the stage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-metricsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-metricsenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetricsEnabled() {
            return null;
        }

        /**
         * An array of arbitrary tags (key-value pairs) to associate with the stage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-tags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return null;
        }

        /**
         * The target request burst rate limit.
         * <p>
         * This allows more requests through for a period of time than the target rate limit. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html">Manage API Request Throttling</a> in the <em>API Gateway Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-throttlingburstlimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-throttlingburstlimit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThrottlingBurstLimit() {
            return null;
        }

        /**
         * The target request steady-state rate limit.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html">Manage API Request Throttling</a> in the <em>API Gateway Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-throttlingratelimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-throttlingratelimit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThrottlingRateLimit() {
            return null;
        }

        /**
         * Specifies whether active tracing with X-ray is enabled for this stage.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-xray.html">Trace API Gateway API Execution with AWS X-Ray</a> in the <em>API Gateway Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-tracingenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-tracingenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTracingEnabled() {
            return null;
        }

        /**
         * A map that defines the stage variables.
         * <p>
         * Variable names must consist of alphanumeric characters, and the values must match the following regular expression: <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-variables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-variables</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVariables() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StageDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StageDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StageDescriptionProperty> {
            java.lang.Object accessLogSetting;
            java.lang.Object cacheClusterEnabled;
            java.lang.String cacheClusterSize;
            java.lang.Object cacheDataEncrypted;
            java.lang.Number cacheTtlInSeconds;
            java.lang.Object cachingEnabled;
            java.lang.Object canarySetting;
            java.lang.String clientCertificateId;
            java.lang.Object dataTraceEnabled;
            java.lang.String description;
            java.lang.String documentationVersion;
            java.lang.String loggingLevel;
            java.lang.Object methodSettings;
            java.lang.Object metricsEnabled;
            java.util.List<software.amazon.awscdk.CfnTag> tags;
            java.lang.Number throttlingBurstLimit;
            java.lang.Number throttlingRateLimit;
            java.lang.Object tracingEnabled;
            java.lang.Object variables;

            /**
             * Sets the value of {@link StageDescriptionProperty#getAccessLogSetting}
             * @param accessLogSetting Specifies settings for logging access in this stage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessLogSetting(software.amazon.awscdk.IResolvable accessLogSetting) {
                this.accessLogSetting = accessLogSetting;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getAccessLogSetting}
             * @param accessLogSetting Specifies settings for logging access in this stage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessLogSetting(software.amazon.awscdk.services.apigateway.CfnDeployment.AccessLogSettingProperty accessLogSetting) {
                this.accessLogSetting = accessLogSetting;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getCacheClusterEnabled}
             * @param cacheClusterEnabled Specifies whether a cache cluster is enabled for the stage.
             *                            To activate a method-level cache, set <code>CachingEnabled</code> to <code>true</code> for a method.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cacheClusterEnabled(java.lang.Boolean cacheClusterEnabled) {
                this.cacheClusterEnabled = cacheClusterEnabled;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getCacheClusterEnabled}
             * @param cacheClusterEnabled Specifies whether a cache cluster is enabled for the stage.
             *                            To activate a method-level cache, set <code>CachingEnabled</code> to <code>true</code> for a method.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cacheClusterEnabled(software.amazon.awscdk.IResolvable cacheClusterEnabled) {
                this.cacheClusterEnabled = cacheClusterEnabled;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getCacheClusterSize}
             * @param cacheClusterSize The size of the stage's cache cluster.
             *                         For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/API_CreateStage.html#apigw-CreateStage-request-cacheClusterSize">cacheClusterSize</a> in the <em>API Gateway API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cacheClusterSize(java.lang.String cacheClusterSize) {
                this.cacheClusterSize = cacheClusterSize;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getCacheDataEncrypted}
             * @param cacheDataEncrypted Indicates whether the cached responses are encrypted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cacheDataEncrypted(java.lang.Boolean cacheDataEncrypted) {
                this.cacheDataEncrypted = cacheDataEncrypted;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getCacheDataEncrypted}
             * @param cacheDataEncrypted Indicates whether the cached responses are encrypted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cacheDataEncrypted(software.amazon.awscdk.IResolvable cacheDataEncrypted) {
                this.cacheDataEncrypted = cacheDataEncrypted;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getCacheTtlInSeconds}
             * @param cacheTtlInSeconds The time-to-live (TTL) period, in seconds, that specifies how long API Gateway caches responses.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cacheTtlInSeconds(java.lang.Number cacheTtlInSeconds) {
                this.cacheTtlInSeconds = cacheTtlInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getCachingEnabled}
             * @param cachingEnabled Indicates whether responses are cached and returned for requests.
             *                       You must enable a cache cluster on the stage to cache responses. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-caching.html">Enable API Gateway Caching in a Stage to Enhance API Performance</a> in the <em>API Gateway Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cachingEnabled(java.lang.Boolean cachingEnabled) {
                this.cachingEnabled = cachingEnabled;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getCachingEnabled}
             * @param cachingEnabled Indicates whether responses are cached and returned for requests.
             *                       You must enable a cache cluster on the stage to cache responses. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-caching.html">Enable API Gateway Caching in a Stage to Enhance API Performance</a> in the <em>API Gateway Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cachingEnabled(software.amazon.awscdk.IResolvable cachingEnabled) {
                this.cachingEnabled = cachingEnabled;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getCanarySetting}
             * @param canarySetting Specifies settings for the canary deployment in this stage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder canarySetting(software.amazon.awscdk.IResolvable canarySetting) {
                this.canarySetting = canarySetting;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getCanarySetting}
             * @param canarySetting Specifies settings for the canary deployment in this stage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder canarySetting(software.amazon.awscdk.services.apigateway.CfnDeployment.CanarySettingProperty canarySetting) {
                this.canarySetting = canarySetting;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getClientCertificateId}
             * @param clientCertificateId The identifier of the client certificate that API Gateway uses to call your integration endpoints in the stage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientCertificateId(java.lang.String clientCertificateId) {
                this.clientCertificateId = clientCertificateId;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getDataTraceEnabled}
             * @param dataTraceEnabled Indicates whether data trace logging is enabled for methods in the stage.
             *                         API Gateway pushes these logs to Amazon CloudWatch Logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTraceEnabled(java.lang.Boolean dataTraceEnabled) {
                this.dataTraceEnabled = dataTraceEnabled;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getDataTraceEnabled}
             * @param dataTraceEnabled Indicates whether data trace logging is enabled for methods in the stage.
             *                         API Gateway pushes these logs to Amazon CloudWatch Logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTraceEnabled(software.amazon.awscdk.IResolvable dataTraceEnabled) {
                this.dataTraceEnabled = dataTraceEnabled;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getDescription}
             * @param description A description of the purpose of the stage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getDocumentationVersion}
             * @param documentationVersion The version identifier of the API documentation snapshot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentationVersion(java.lang.String documentationVersion) {
                this.documentationVersion = documentationVersion;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getLoggingLevel}
             * @param loggingLevel The logging level for this method.
             *                     For valid values, see the <code>loggingLevel</code> property of the <a href="https://docs.aws.amazon.com/apigateway/latest/api/API_MethodSetting.html">MethodSetting</a> resource in the <em>Amazon API Gateway API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loggingLevel(java.lang.String loggingLevel) {
                this.loggingLevel = loggingLevel;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getMethodSettings}
             * @param methodSettings Configures settings for all of the stage's methods.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder methodSettings(software.amazon.awscdk.IResolvable methodSettings) {
                this.methodSettings = methodSettings;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getMethodSettings}
             * @param methodSettings Configures settings for all of the stage's methods.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder methodSettings(java.util.List<? extends java.lang.Object> methodSettings) {
                this.methodSettings = methodSettings;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getMetricsEnabled}
             * @param metricsEnabled Indicates whether Amazon CloudWatch metrics are enabled for methods in the stage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricsEnabled(java.lang.Boolean metricsEnabled) {
                this.metricsEnabled = metricsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getMetricsEnabled}
             * @param metricsEnabled Indicates whether Amazon CloudWatch metrics are enabled for methods in the stage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricsEnabled(software.amazon.awscdk.IResolvable metricsEnabled) {
                this.metricsEnabled = metricsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getTags}
             * @param tags An array of arbitrary tags (key-value pairs) to associate with the stage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @SuppressWarnings("unchecked")
            public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
                this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getThrottlingBurstLimit}
             * @param throttlingBurstLimit The target request burst rate limit.
             *                             This allows more requests through for a period of time than the target rate limit. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html">Manage API Request Throttling</a> in the <em>API Gateway Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throttlingBurstLimit(java.lang.Number throttlingBurstLimit) {
                this.throttlingBurstLimit = throttlingBurstLimit;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getThrottlingRateLimit}
             * @param throttlingRateLimit The target request steady-state rate limit.
             *                            For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html">Manage API Request Throttling</a> in the <em>API Gateway Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throttlingRateLimit(java.lang.Number throttlingRateLimit) {
                this.throttlingRateLimit = throttlingRateLimit;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getTracingEnabled}
             * @param tracingEnabled Specifies whether active tracing with X-ray is enabled for this stage.
             *                       For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-xray.html">Trace API Gateway API Execution with AWS X-Ray</a> in the <em>API Gateway Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tracingEnabled(java.lang.Boolean tracingEnabled) {
                this.tracingEnabled = tracingEnabled;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getTracingEnabled}
             * @param tracingEnabled Specifies whether active tracing with X-ray is enabled for this stage.
             *                       For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-xray.html">Trace API Gateway API Execution with AWS X-Ray</a> in the <em>API Gateway Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tracingEnabled(software.amazon.awscdk.IResolvable tracingEnabled) {
                this.tracingEnabled = tracingEnabled;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getVariables}
             * @param variables A map that defines the stage variables.
             *                  Variable names must consist of alphanumeric characters, and the values must match the following regular expression: <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variables(java.util.Map<java.lang.String, java.lang.String> variables) {
                this.variables = variables;
                return this;
            }

            /**
             * Sets the value of {@link StageDescriptionProperty#getVariables}
             * @param variables A map that defines the stage variables.
             *                  Variable names must consist of alphanumeric characters, and the values must match the following regular expression: <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variables(software.amazon.awscdk.IResolvable variables) {
                this.variables = variables;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StageDescriptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StageDescriptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StageDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StageDescriptionProperty {
            private final java.lang.Object accessLogSetting;
            private final java.lang.Object cacheClusterEnabled;
            private final java.lang.String cacheClusterSize;
            private final java.lang.Object cacheDataEncrypted;
            private final java.lang.Number cacheTtlInSeconds;
            private final java.lang.Object cachingEnabled;
            private final java.lang.Object canarySetting;
            private final java.lang.String clientCertificateId;
            private final java.lang.Object dataTraceEnabled;
            private final java.lang.String description;
            private final java.lang.String documentationVersion;
            private final java.lang.String loggingLevel;
            private final java.lang.Object methodSettings;
            private final java.lang.Object metricsEnabled;
            private final java.util.List<software.amazon.awscdk.CfnTag> tags;
            private final java.lang.Number throttlingBurstLimit;
            private final java.lang.Number throttlingRateLimit;
            private final java.lang.Object tracingEnabled;
            private final java.lang.Object variables;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessLogSetting = software.amazon.jsii.Kernel.get(this, "accessLogSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cacheClusterEnabled = software.amazon.jsii.Kernel.get(this, "cacheClusterEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cacheClusterSize = software.amazon.jsii.Kernel.get(this, "cacheClusterSize", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cacheDataEncrypted = software.amazon.jsii.Kernel.get(this, "cacheDataEncrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cacheTtlInSeconds = software.amazon.jsii.Kernel.get(this, "cacheTtlInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.cachingEnabled = software.amazon.jsii.Kernel.get(this, "cachingEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.canarySetting = software.amazon.jsii.Kernel.get(this, "canarySetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.clientCertificateId = software.amazon.jsii.Kernel.get(this, "clientCertificateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataTraceEnabled = software.amazon.jsii.Kernel.get(this, "dataTraceEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.documentationVersion = software.amazon.jsii.Kernel.get(this, "documentationVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.loggingLevel = software.amazon.jsii.Kernel.get(this, "loggingLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.methodSettings = software.amazon.jsii.Kernel.get(this, "methodSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.metricsEnabled = software.amazon.jsii.Kernel.get(this, "metricsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
                this.throttlingBurstLimit = software.amazon.jsii.Kernel.get(this, "throttlingBurstLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.throttlingRateLimit = software.amazon.jsii.Kernel.get(this, "throttlingRateLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.tracingEnabled = software.amazon.jsii.Kernel.get(this, "tracingEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.variables = software.amazon.jsii.Kernel.get(this, "variables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessLogSetting = builder.accessLogSetting;
                this.cacheClusterEnabled = builder.cacheClusterEnabled;
                this.cacheClusterSize = builder.cacheClusterSize;
                this.cacheDataEncrypted = builder.cacheDataEncrypted;
                this.cacheTtlInSeconds = builder.cacheTtlInSeconds;
                this.cachingEnabled = builder.cachingEnabled;
                this.canarySetting = builder.canarySetting;
                this.clientCertificateId = builder.clientCertificateId;
                this.dataTraceEnabled = builder.dataTraceEnabled;
                this.description = builder.description;
                this.documentationVersion = builder.documentationVersion;
                this.loggingLevel = builder.loggingLevel;
                this.methodSettings = builder.methodSettings;
                this.metricsEnabled = builder.metricsEnabled;
                this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
                this.throttlingBurstLimit = builder.throttlingBurstLimit;
                this.throttlingRateLimit = builder.throttlingRateLimit;
                this.tracingEnabled = builder.tracingEnabled;
                this.variables = builder.variables;
            }

            @Override
            public final java.lang.Object getAccessLogSetting() {
                return this.accessLogSetting;
            }

            @Override
            public final java.lang.Object getCacheClusterEnabled() {
                return this.cacheClusterEnabled;
            }

            @Override
            public final java.lang.String getCacheClusterSize() {
                return this.cacheClusterSize;
            }

            @Override
            public final java.lang.Object getCacheDataEncrypted() {
                return this.cacheDataEncrypted;
            }

            @Override
            public final java.lang.Number getCacheTtlInSeconds() {
                return this.cacheTtlInSeconds;
            }

            @Override
            public final java.lang.Object getCachingEnabled() {
                return this.cachingEnabled;
            }

            @Override
            public final java.lang.Object getCanarySetting() {
                return this.canarySetting;
            }

            @Override
            public final java.lang.String getClientCertificateId() {
                return this.clientCertificateId;
            }

            @Override
            public final java.lang.Object getDataTraceEnabled() {
                return this.dataTraceEnabled;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.String getDocumentationVersion() {
                return this.documentationVersion;
            }

            @Override
            public final java.lang.String getLoggingLevel() {
                return this.loggingLevel;
            }

            @Override
            public final java.lang.Object getMethodSettings() {
                return this.methodSettings;
            }

            @Override
            public final java.lang.Object getMetricsEnabled() {
                return this.metricsEnabled;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
                return this.tags;
            }

            @Override
            public final java.lang.Number getThrottlingBurstLimit() {
                return this.throttlingBurstLimit;
            }

            @Override
            public final java.lang.Number getThrottlingRateLimit() {
                return this.throttlingRateLimit;
            }

            @Override
            public final java.lang.Object getTracingEnabled() {
                return this.tracingEnabled;
            }

            @Override
            public final java.lang.Object getVariables() {
                return this.variables;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccessLogSetting() != null) {
                    data.set("accessLogSetting", om.valueToTree(this.getAccessLogSetting()));
                }
                if (this.getCacheClusterEnabled() != null) {
                    data.set("cacheClusterEnabled", om.valueToTree(this.getCacheClusterEnabled()));
                }
                if (this.getCacheClusterSize() != null) {
                    data.set("cacheClusterSize", om.valueToTree(this.getCacheClusterSize()));
                }
                if (this.getCacheDataEncrypted() != null) {
                    data.set("cacheDataEncrypted", om.valueToTree(this.getCacheDataEncrypted()));
                }
                if (this.getCacheTtlInSeconds() != null) {
                    data.set("cacheTtlInSeconds", om.valueToTree(this.getCacheTtlInSeconds()));
                }
                if (this.getCachingEnabled() != null) {
                    data.set("cachingEnabled", om.valueToTree(this.getCachingEnabled()));
                }
                if (this.getCanarySetting() != null) {
                    data.set("canarySetting", om.valueToTree(this.getCanarySetting()));
                }
                if (this.getClientCertificateId() != null) {
                    data.set("clientCertificateId", om.valueToTree(this.getClientCertificateId()));
                }
                if (this.getDataTraceEnabled() != null) {
                    data.set("dataTraceEnabled", om.valueToTree(this.getDataTraceEnabled()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getDocumentationVersion() != null) {
                    data.set("documentationVersion", om.valueToTree(this.getDocumentationVersion()));
                }
                if (this.getLoggingLevel() != null) {
                    data.set("loggingLevel", om.valueToTree(this.getLoggingLevel()));
                }
                if (this.getMethodSettings() != null) {
                    data.set("methodSettings", om.valueToTree(this.getMethodSettings()));
                }
                if (this.getMetricsEnabled() != null) {
                    data.set("metricsEnabled", om.valueToTree(this.getMetricsEnabled()));
                }
                if (this.getTags() != null) {
                    data.set("tags", om.valueToTree(this.getTags()));
                }
                if (this.getThrottlingBurstLimit() != null) {
                    data.set("throttlingBurstLimit", om.valueToTree(this.getThrottlingBurstLimit()));
                }
                if (this.getThrottlingRateLimit() != null) {
                    data.set("throttlingRateLimit", om.valueToTree(this.getThrottlingRateLimit()));
                }
                if (this.getTracingEnabled() != null) {
                    data.set("tracingEnabled", om.valueToTree(this.getTracingEnabled()));
                }
                if (this.getVariables() != null) {
                    data.set("variables", om.valueToTree(this.getVariables()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigateway.CfnDeployment.StageDescriptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StageDescriptionProperty.Jsii$Proxy that = (StageDescriptionProperty.Jsii$Proxy) o;

                if (this.accessLogSetting != null ? !this.accessLogSetting.equals(that.accessLogSetting) : that.accessLogSetting != null) return false;
                if (this.cacheClusterEnabled != null ? !this.cacheClusterEnabled.equals(that.cacheClusterEnabled) : that.cacheClusterEnabled != null) return false;
                if (this.cacheClusterSize != null ? !this.cacheClusterSize.equals(that.cacheClusterSize) : that.cacheClusterSize != null) return false;
                if (this.cacheDataEncrypted != null ? !this.cacheDataEncrypted.equals(that.cacheDataEncrypted) : that.cacheDataEncrypted != null) return false;
                if (this.cacheTtlInSeconds != null ? !this.cacheTtlInSeconds.equals(that.cacheTtlInSeconds) : that.cacheTtlInSeconds != null) return false;
                if (this.cachingEnabled != null ? !this.cachingEnabled.equals(that.cachingEnabled) : that.cachingEnabled != null) return false;
                if (this.canarySetting != null ? !this.canarySetting.equals(that.canarySetting) : that.canarySetting != null) return false;
                if (this.clientCertificateId != null ? !this.clientCertificateId.equals(that.clientCertificateId) : that.clientCertificateId != null) return false;
                if (this.dataTraceEnabled != null ? !this.dataTraceEnabled.equals(that.dataTraceEnabled) : that.dataTraceEnabled != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.documentationVersion != null ? !this.documentationVersion.equals(that.documentationVersion) : that.documentationVersion != null) return false;
                if (this.loggingLevel != null ? !this.loggingLevel.equals(that.loggingLevel) : that.loggingLevel != null) return false;
                if (this.methodSettings != null ? !this.methodSettings.equals(that.methodSettings) : that.methodSettings != null) return false;
                if (this.metricsEnabled != null ? !this.metricsEnabled.equals(that.metricsEnabled) : that.metricsEnabled != null) return false;
                if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
                if (this.throttlingBurstLimit != null ? !this.throttlingBurstLimit.equals(that.throttlingBurstLimit) : that.throttlingBurstLimit != null) return false;
                if (this.throttlingRateLimit != null ? !this.throttlingRateLimit.equals(that.throttlingRateLimit) : that.throttlingRateLimit != null) return false;
                if (this.tracingEnabled != null ? !this.tracingEnabled.equals(that.tracingEnabled) : that.tracingEnabled != null) return false;
                return this.variables != null ? this.variables.equals(that.variables) : that.variables == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accessLogSetting != null ? this.accessLogSetting.hashCode() : 0;
                result = 31 * result + (this.cacheClusterEnabled != null ? this.cacheClusterEnabled.hashCode() : 0);
                result = 31 * result + (this.cacheClusterSize != null ? this.cacheClusterSize.hashCode() : 0);
                result = 31 * result + (this.cacheDataEncrypted != null ? this.cacheDataEncrypted.hashCode() : 0);
                result = 31 * result + (this.cacheTtlInSeconds != null ? this.cacheTtlInSeconds.hashCode() : 0);
                result = 31 * result + (this.cachingEnabled != null ? this.cachingEnabled.hashCode() : 0);
                result = 31 * result + (this.canarySetting != null ? this.canarySetting.hashCode() : 0);
                result = 31 * result + (this.clientCertificateId != null ? this.clientCertificateId.hashCode() : 0);
                result = 31 * result + (this.dataTraceEnabled != null ? this.dataTraceEnabled.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.documentationVersion != null ? this.documentationVersion.hashCode() : 0);
                result = 31 * result + (this.loggingLevel != null ? this.loggingLevel.hashCode() : 0);
                result = 31 * result + (this.methodSettings != null ? this.methodSettings.hashCode() : 0);
                result = 31 * result + (this.metricsEnabled != null ? this.metricsEnabled.hashCode() : 0);
                result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
                result = 31 * result + (this.throttlingBurstLimit != null ? this.throttlingBurstLimit.hashCode() : 0);
                result = 31 * result + (this.throttlingRateLimit != null ? this.throttlingRateLimit.hashCode() : 0);
                result = 31 * result + (this.tracingEnabled != null ? this.tracingEnabled.hashCode() : 0);
                result = 31 * result + (this.variables != null ? this.variables.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.CfnDeployment}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigateway.CfnDeployment> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigateway.CfnDeploymentProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigateway.CfnDeploymentProps.Builder();
        }

        /**
         * The string identifier of the associated RestApi.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-restapiid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-restapiid</a>
         * @param restApiId The string identifier of the associated RestApi. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApiId(final java.lang.String restApiId) {
            this.props.restApiId(restApiId);
            return this;
        }

        /**
         * The input configuration for a canary deployment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-deploymentcanarysettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-deploymentcanarysettings</a>
         * @param deploymentCanarySettings The input configuration for a canary deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentCanarySettings(final software.amazon.awscdk.IResolvable deploymentCanarySettings) {
            this.props.deploymentCanarySettings(deploymentCanarySettings);
            return this;
        }
        /**
         * The input configuration for a canary deployment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-deploymentcanarysettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-deploymentcanarysettings</a>
         * @param deploymentCanarySettings The input configuration for a canary deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentCanarySettings(final software.amazon.awscdk.services.apigateway.CfnDeployment.DeploymentCanarySettingsProperty deploymentCanarySettings) {
            this.props.deploymentCanarySettings(deploymentCanarySettings);
            return this;
        }

        /**
         * The description for the Deployment resource to create.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-description</a>
         * @param description The description for the Deployment resource to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The description of the Stage resource for the Deployment resource to create.
         * <p>
         * To specify a stage description, you must also provide a stage name.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-stagedescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-stagedescription</a>
         * @param stageDescription The description of the Stage resource for the Deployment resource to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageDescription(final software.amazon.awscdk.IResolvable stageDescription) {
            this.props.stageDescription(stageDescription);
            return this;
        }
        /**
         * The description of the Stage resource for the Deployment resource to create.
         * <p>
         * To specify a stage description, you must also provide a stage name.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-stagedescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-stagedescription</a>
         * @param stageDescription The description of the Stage resource for the Deployment resource to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageDescription(final software.amazon.awscdk.services.apigateway.CfnDeployment.StageDescriptionProperty stageDescription) {
            this.props.stageDescription(stageDescription);
            return this;
        }

        /**
         * The name of the Stage resource for the Deployment resource to create.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-stagename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-stagename</a>
         * @param stageName The name of the Stage resource for the Deployment resource to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageName(final java.lang.String stageName) {
            this.props.stageName(stageName);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.apigateway.CfnDeployment}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigateway.CfnDeployment build() {
            return new software.amazon.awscdk.services.apigateway.CfnDeployment(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
