package software.amazon.awscdk.services.apigatewayv2;

/**
 * Properties used to create the ApiMapping resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * IApi api;
 * DomainName domainName;
 * IStage stage;
 * ApiMappingProps apiMappingProps = ApiMappingProps.builder()
 *         .api(api)
 *         .domainName(domainName)
 *         // the properties below are optional
 *         .apiMappingKey("apiMappingKey")
 *         .stage(stage)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:12.066Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.ApiMappingProps")
@software.amazon.jsii.Jsii.Proxy(ApiMappingProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApiMappingProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Api to which this mapping is applied.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.IApi getApi();

    /**
     * custom domain name of the mapping target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.IDomainName getDomainName();

    /**
     * Api mapping key.
     * <p>
     * The path where this stage should be mapped to on the domain
     * <p>
     * Default: - undefined for the root path mapping.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getApiMappingKey() {
        return null;
    }

    /**
     * stage for the ApiMapping resource required for WebSocket API defaults to default stage of an HTTP API.
     * <p>
     * Default: - Default stage of the passed API for HTTP API, required for WebSocket API
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.IStage getStage() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ApiMappingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApiMappingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ApiMappingProps> {
        software.amazon.awscdk.services.apigatewayv2.IApi api;
        software.amazon.awscdk.services.apigatewayv2.IDomainName domainName;
        java.lang.String apiMappingKey;
        software.amazon.awscdk.services.apigatewayv2.IStage stage;

        /**
         * Sets the value of {@link ApiMappingProps#getApi}
         * @param api The Api to which this mapping is applied. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder api(software.amazon.awscdk.services.apigatewayv2.IApi api) {
            this.api = api;
            return this;
        }

        /**
         * Sets the value of {@link ApiMappingProps#getDomainName}
         * @param domainName custom domain name of the mapping target. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(software.amazon.awscdk.services.apigatewayv2.IDomainName domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link ApiMappingProps#getApiMappingKey}
         * @param apiMappingKey Api mapping key.
         *                      The path where this stage should be mapped to on the domain
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiMappingKey(java.lang.String apiMappingKey) {
            this.apiMappingKey = apiMappingKey;
            return this;
        }

        /**
         * Sets the value of {@link ApiMappingProps#getStage}
         * @param stage stage for the ApiMapping resource required for WebSocket API defaults to default stage of an HTTP API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stage(software.amazon.awscdk.services.apigatewayv2.IStage stage) {
            this.stage = stage;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApiMappingProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ApiMappingProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ApiMappingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApiMappingProps {
        private final software.amazon.awscdk.services.apigatewayv2.IApi api;
        private final software.amazon.awscdk.services.apigatewayv2.IDomainName domainName;
        private final java.lang.String apiMappingKey;
        private final software.amazon.awscdk.services.apigatewayv2.IStage stage;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.api = software.amazon.jsii.Kernel.get(this, "api", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IApi.class));
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IDomainName.class));
            this.apiMappingKey = software.amazon.jsii.Kernel.get(this, "apiMappingKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stage = software.amazon.jsii.Kernel.get(this, "stage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IStage.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.api = java.util.Objects.requireNonNull(builder.api, "api is required");
            this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
            this.apiMappingKey = builder.apiMappingKey;
            this.stage = builder.stage;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.IApi getApi() {
            return this.api;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.IDomainName getDomainName() {
            return this.domainName;
        }

        @Override
        public final java.lang.String getApiMappingKey() {
            return this.apiMappingKey;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.IStage getStage() {
            return this.stage;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("api", om.valueToTree(this.getApi()));
            data.set("domainName", om.valueToTree(this.getDomainName()));
            if (this.getApiMappingKey() != null) {
                data.set("apiMappingKey", om.valueToTree(this.getApiMappingKey()));
            }
            if (this.getStage() != null) {
                data.set("stage", om.valueToTree(this.getStage()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.ApiMappingProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApiMappingProps.Jsii$Proxy that = (ApiMappingProps.Jsii$Proxy) o;

            if (!api.equals(that.api)) return false;
            if (!domainName.equals(that.domainName)) return false;
            if (this.apiMappingKey != null ? !this.apiMappingKey.equals(that.apiMappingKey) : that.apiMappingKey != null) return false;
            return this.stage != null ? this.stage.equals(that.stage) : that.stage == null;
        }

        @Override
        public final int hashCode() {
            int result = this.api.hashCode();
            result = 31 * result + (this.domainName.hashCode());
            result = 31 * result + (this.apiMappingKey != null ? this.apiMappingKey.hashCode() : 0);
            result = 31 * result + (this.stage != null ? this.stage.hashCode() : 0);
            return result;
        }
    }
}
