package software.amazon.awscdk.services.apigatewayv2;

/**
 * Properties for defining a <code>CfnApi</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * Object body;
 * CfnApiProps cfnApiProps = CfnApiProps.builder()
 *         .apiKeySelectionExpression("apiKeySelectionExpression")
 *         .basePath("basePath")
 *         .body(body)
 *         .bodyS3Location(BodyS3LocationProperty.builder()
 *                 .bucket("bucket")
 *                 .etag("etag")
 *                 .key("key")
 *                 .version("version")
 *                 .build())
 *         .corsConfiguration(CorsProperty.builder()
 *                 .allowCredentials(false)
 *                 .allowHeaders(List.of("allowHeaders"))
 *                 .allowMethods(List.of("allowMethods"))
 *                 .allowOrigins(List.of("allowOrigins"))
 *                 .exposeHeaders(List.of("exposeHeaders"))
 *                 .maxAge(123)
 *                 .build())
 *         .credentialsArn("credentialsArn")
 *         .description("description")
 *         .disableExecuteApiEndpoint(false)
 *         .disableSchemaValidation(false)
 *         .failOnWarnings(false)
 *         .ipAddressType("ipAddressType")
 *         .name("name")
 *         .protocolType("protocolType")
 *         .routeKey("routeKey")
 *         .routeSelectionExpression("routeSelectionExpression")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .target("target")
 *         .version("version")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:12.077Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.CfnApiProps")
@software.amazon.jsii.Jsii.Proxy(CfnApiProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnApiProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * An API key selection expression.
     * <p>
     * Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-apikeyselectionexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-apikeyselectionexpression</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getApiKeySelectionExpression() {
        return null;
    }

    /**
     * Specifies how to interpret the base path of the API during import.
     * <p>
     * Valid values are <code>ignore</code> , <code>prepend</code> , and <code>split</code> . The default value is <code>ignore</code> . To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api-basePath.html">Set the OpenAPI basePath Property</a> . Supported only for HTTP APIs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-basepath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-basepath</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBasePath() {
        return null;
    }

    /**
     * The OpenAPI definition.
     * <p>
     * Supported only for HTTP APIs. To import an HTTP API, you must specify a <code>Body</code> or <code>BodyS3Location</code> . If you specify a <code>Body</code> or <code>BodyS3Location</code> , don't specify CloudFormation resources such as <code>AWS::ApiGatewayV2::Authorizer</code> or <code>AWS::ApiGatewayV2::Route</code> . API Gateway doesn't support the combination of OpenAPI and CloudFormation resources.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-body">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-body</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBody() {
        return null;
    }

    /**
     * The S3 location of an OpenAPI definition.
     * <p>
     * Supported only for HTTP APIs. To import an HTTP API, you must specify a <code>Body</code> or <code>BodyS3Location</code> . If you specify a <code>Body</code> or <code>BodyS3Location</code> , don't specify CloudFormation resources such as <code>AWS::ApiGatewayV2::Authorizer</code> or <code>AWS::ApiGatewayV2::Route</code> . API Gateway doesn't support the combination of OpenAPI and CloudFormation resources.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-bodys3location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-bodys3location</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBodyS3Location() {
        return null;
    }

    /**
     * A CORS configuration.
     * <p>
     * Supported only for HTTP APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html">Configuring CORS</a> for more information.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-corsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-corsconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCorsConfiguration() {
        return null;
    }

    /**
     * This property is part of quick create.
     * <p>
     * It specifies the credentials required for the integration, if any. For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify <code>arn:aws:iam::*:user/*</code> . To use resource-based permissions on supported AWS services, specify <code>null</code> . Currently, this property is not used for HTTP integrations. Supported only for HTTP APIs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-credentialsarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-credentialsarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCredentialsArn() {
        return null;
    }

    /**
     * The description of the API.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint.
     * <p>
     * By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-disableexecuteapiendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-disableexecuteapiendpoint</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDisableExecuteApiEndpoint() {
        return null;
    }

    /**
     * Avoid validating models when creating a deployment.
     * <p>
     * Supported only for WebSocket APIs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-disableschemavalidation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-disableschemavalidation</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDisableSchemaValidation() {
        return null;
    }

    /**
     * Specifies whether to rollback the API creation when a warning is encountered.
     * <p>
     * By default, API creation continues if a warning is encountered.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-failonwarnings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-failonwarnings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFailOnWarnings() {
        return null;
    }

    /**
     * The IP address types that can invoke the API.
     * <p>
     * Use <code>ipv4</code> to allow only IPv4 addresses to invoke your API, or use <code>dualstack</code> to allow both IPv4 and IPv6 addresses to invoke your API.
     * <p>
     * Don’t use IP address type for an HTTP API based on an OpenAPI specification. Instead, specify the IP address type in the OpenAPI specification.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-ipaddresstype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-ipaddresstype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpAddressType() {
        return null;
    }

    /**
     * The name of the API.
     * <p>
     * Required unless you specify an OpenAPI definition for <code>Body</code> or <code>S3BodyLocation</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The API protocol.
     * <p>
     * Valid values are <code>WEBSOCKET</code> or <code>HTTP</code> . Required unless you specify an OpenAPI definition for <code>Body</code> or <code>S3BodyLocation</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-protocoltype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-protocoltype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProtocolType() {
        return null;
    }

    /**
     * This property is part of quick create.
     * <p>
     * If you don't specify a <code>routeKey</code> , a default route of <code>$default</code> is created. The <code>$default</code> route acts as a catch-all for any request made to your API, for a particular stage. The <code>$default</code> route key can't be modified. You can add routes after creating the API, and you can update the route keys of additional routes. Supported only for HTTP APIs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-routekey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-routekey</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRouteKey() {
        return null;
    }

    /**
     * The route selection expression for the API.
     * <p>
     * For HTTP APIs, the <code>routeSelectionExpression</code> must be <code>${request.method} ${request.path}</code> . If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-routeselectionexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-routeselectionexpression</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRouteSelectionExpression() {
        return null;
    }

    /**
     * The collection of tags.
     * <p>
     * Each tag element is associated with a given resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * This property is part of quick create.
     * <p>
     * Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes. For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY, respectively. Supported only for HTTP APIs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-target">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-target</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTarget() {
        return null;
    }

    /**
     * A version identifier for the API.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-version">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#cfn-apigatewayv2-api-version</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnApiProps> {
        java.lang.String apiKeySelectionExpression;
        java.lang.String basePath;
        java.lang.Object body;
        java.lang.Object bodyS3Location;
        java.lang.Object corsConfiguration;
        java.lang.String credentialsArn;
        java.lang.String description;
        java.lang.Object disableExecuteApiEndpoint;
        java.lang.Object disableSchemaValidation;
        java.lang.Object failOnWarnings;
        java.lang.String ipAddressType;
        java.lang.String name;
        java.lang.String protocolType;
        java.lang.String routeKey;
        java.lang.String routeSelectionExpression;
        java.util.Map<java.lang.String, java.lang.String> tags;
        java.lang.String target;
        java.lang.String version;

        /**
         * Sets the value of {@link CfnApiProps#getApiKeySelectionExpression}
         * @param apiKeySelectionExpression An API key selection expression.
         *                                  Supported only for WebSocket APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions">API Key Selection Expressions</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeySelectionExpression(java.lang.String apiKeySelectionExpression) {
            this.apiKeySelectionExpression = apiKeySelectionExpression;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getBasePath}
         * @param basePath Specifies how to interpret the base path of the API during import.
         *                 Valid values are <code>ignore</code> , <code>prepend</code> , and <code>split</code> . The default value is <code>ignore</code> . To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api-basePath.html">Set the OpenAPI basePath Property</a> . Supported only for HTTP APIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder basePath(java.lang.String basePath) {
            this.basePath = basePath;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getBody}
         * @param body The OpenAPI definition.
         *             Supported only for HTTP APIs. To import an HTTP API, you must specify a <code>Body</code> or <code>BodyS3Location</code> . If you specify a <code>Body</code> or <code>BodyS3Location</code> , don't specify CloudFormation resources such as <code>AWS::ApiGatewayV2::Authorizer</code> or <code>AWS::ApiGatewayV2::Route</code> . API Gateway doesn't support the combination of OpenAPI and CloudFormation resources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder body(java.lang.Object body) {
            this.body = body;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getBodyS3Location}
         * @param bodyS3Location The S3 location of an OpenAPI definition.
         *                       Supported only for HTTP APIs. To import an HTTP API, you must specify a <code>Body</code> or <code>BodyS3Location</code> . If you specify a <code>Body</code> or <code>BodyS3Location</code> , don't specify CloudFormation resources such as <code>AWS::ApiGatewayV2::Authorizer</code> or <code>AWS::ApiGatewayV2::Route</code> . API Gateway doesn't support the combination of OpenAPI and CloudFormation resources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bodyS3Location(software.amazon.awscdk.IResolvable bodyS3Location) {
            this.bodyS3Location = bodyS3Location;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getBodyS3Location}
         * @param bodyS3Location The S3 location of an OpenAPI definition.
         *                       Supported only for HTTP APIs. To import an HTTP API, you must specify a <code>Body</code> or <code>BodyS3Location</code> . If you specify a <code>Body</code> or <code>BodyS3Location</code> , don't specify CloudFormation resources such as <code>AWS::ApiGatewayV2::Authorizer</code> or <code>AWS::ApiGatewayV2::Route</code> . API Gateway doesn't support the combination of OpenAPI and CloudFormation resources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bodyS3Location(software.amazon.awscdk.services.apigatewayv2.CfnApi.BodyS3LocationProperty bodyS3Location) {
            this.bodyS3Location = bodyS3Location;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getCorsConfiguration}
         * @param corsConfiguration A CORS configuration.
         *                          Supported only for HTTP APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html">Configuring CORS</a> for more information.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder corsConfiguration(software.amazon.awscdk.IResolvable corsConfiguration) {
            this.corsConfiguration = corsConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getCorsConfiguration}
         * @param corsConfiguration A CORS configuration.
         *                          Supported only for HTTP APIs. See <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html">Configuring CORS</a> for more information.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder corsConfiguration(software.amazon.awscdk.services.apigatewayv2.CfnApi.CorsProperty corsConfiguration) {
            this.corsConfiguration = corsConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getCredentialsArn}
         * @param credentialsArn This property is part of quick create.
         *                       It specifies the credentials required for the integration, if any. For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify <code>arn:aws:iam::*:user/*</code> . To use resource-based permissions on supported AWS services, specify <code>null</code> . Currently, this property is not used for HTTP integrations. Supported only for HTTP APIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentialsArn(java.lang.String credentialsArn) {
            this.credentialsArn = credentialsArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getDescription}
         * @param description The description of the API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getDisableExecuteApiEndpoint}
         * @param disableExecuteApiEndpoint Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint.
         *                                  By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableExecuteApiEndpoint(java.lang.Boolean disableExecuteApiEndpoint) {
            this.disableExecuteApiEndpoint = disableExecuteApiEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getDisableExecuteApiEndpoint}
         * @param disableExecuteApiEndpoint Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint.
         *                                  By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableExecuteApiEndpoint(software.amazon.awscdk.IResolvable disableExecuteApiEndpoint) {
            this.disableExecuteApiEndpoint = disableExecuteApiEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getDisableSchemaValidation}
         * @param disableSchemaValidation Avoid validating models when creating a deployment.
         *                                Supported only for WebSocket APIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableSchemaValidation(java.lang.Boolean disableSchemaValidation) {
            this.disableSchemaValidation = disableSchemaValidation;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getDisableSchemaValidation}
         * @param disableSchemaValidation Avoid validating models when creating a deployment.
         *                                Supported only for WebSocket APIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableSchemaValidation(software.amazon.awscdk.IResolvable disableSchemaValidation) {
            this.disableSchemaValidation = disableSchemaValidation;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getFailOnWarnings}
         * @param failOnWarnings Specifies whether to rollback the API creation when a warning is encountered.
         *                       By default, API creation continues if a warning is encountered.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failOnWarnings(java.lang.Boolean failOnWarnings) {
            this.failOnWarnings = failOnWarnings;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getFailOnWarnings}
         * @param failOnWarnings Specifies whether to rollback the API creation when a warning is encountered.
         *                       By default, API creation continues if a warning is encountered.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failOnWarnings(software.amazon.awscdk.IResolvable failOnWarnings) {
            this.failOnWarnings = failOnWarnings;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getIpAddressType}
         * @param ipAddressType The IP address types that can invoke the API.
         *                      Use <code>ipv4</code> to allow only IPv4 addresses to invoke your API, or use <code>dualstack</code> to allow both IPv4 and IPv6 addresses to invoke your API.
         *                      <p>
         *                      Don’t use IP address type for an HTTP API based on an OpenAPI specification. Instead, specify the IP address type in the OpenAPI specification.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddressType(java.lang.String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getName}
         * @param name The name of the API.
         *             Required unless you specify an OpenAPI definition for <code>Body</code> or <code>S3BodyLocation</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getProtocolType}
         * @param protocolType The API protocol.
         *                     Valid values are <code>WEBSOCKET</code> or <code>HTTP</code> . Required unless you specify an OpenAPI definition for <code>Body</code> or <code>S3BodyLocation</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocolType(java.lang.String protocolType) {
            this.protocolType = protocolType;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getRouteKey}
         * @param routeKey This property is part of quick create.
         *                 If you don't specify a <code>routeKey</code> , a default route of <code>$default</code> is created. The <code>$default</code> route acts as a catch-all for any request made to your API, for a particular stage. The <code>$default</code> route key can't be modified. You can add routes after creating the API, and you can update the route keys of additional routes. Supported only for HTTP APIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeKey(java.lang.String routeKey) {
            this.routeKey = routeKey;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getRouteSelectionExpression}
         * @param routeSelectionExpression The route selection expression for the API.
         *                                 For HTTP APIs, the <code>routeSelectionExpression</code> must be <code>${request.method} ${request.path}</code> . If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeSelectionExpression(java.lang.String routeSelectionExpression) {
            this.routeSelectionExpression = routeSelectionExpression;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getTags}
         * @param tags The collection of tags.
         *             Each tag element is associated with a given resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getTarget}
         * @param target This property is part of quick create.
         *               Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes. For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY, respectively. Supported only for HTTP APIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(java.lang.String target) {
            this.target = target;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiProps#getVersion}
         * @param version A version identifier for the API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(java.lang.String version) {
            this.version = version;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnApiProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnApiProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnApiProps {
        private final java.lang.String apiKeySelectionExpression;
        private final java.lang.String basePath;
        private final java.lang.Object body;
        private final java.lang.Object bodyS3Location;
        private final java.lang.Object corsConfiguration;
        private final java.lang.String credentialsArn;
        private final java.lang.String description;
        private final java.lang.Object disableExecuteApiEndpoint;
        private final java.lang.Object disableSchemaValidation;
        private final java.lang.Object failOnWarnings;
        private final java.lang.String ipAddressType;
        private final java.lang.String name;
        private final java.lang.String protocolType;
        private final java.lang.String routeKey;
        private final java.lang.String routeSelectionExpression;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final java.lang.String target;
        private final java.lang.String version;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiKeySelectionExpression = software.amazon.jsii.Kernel.get(this, "apiKeySelectionExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.basePath = software.amazon.jsii.Kernel.get(this, "basePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.body = software.amazon.jsii.Kernel.get(this, "body", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.bodyS3Location = software.amazon.jsii.Kernel.get(this, "bodyS3Location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.corsConfiguration = software.amazon.jsii.Kernel.get(this, "corsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.credentialsArn = software.amazon.jsii.Kernel.get(this, "credentialsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.disableExecuteApiEndpoint = software.amazon.jsii.Kernel.get(this, "disableExecuteApiEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.disableSchemaValidation = software.amazon.jsii.Kernel.get(this, "disableSchemaValidation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.failOnWarnings = software.amazon.jsii.Kernel.get(this, "failOnWarnings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ipAddressType = software.amazon.jsii.Kernel.get(this, "ipAddressType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.protocolType = software.amazon.jsii.Kernel.get(this, "protocolType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.routeKey = software.amazon.jsii.Kernel.get(this, "routeKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.routeSelectionExpression = software.amazon.jsii.Kernel.get(this, "routeSelectionExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiKeySelectionExpression = builder.apiKeySelectionExpression;
            this.basePath = builder.basePath;
            this.body = builder.body;
            this.bodyS3Location = builder.bodyS3Location;
            this.corsConfiguration = builder.corsConfiguration;
            this.credentialsArn = builder.credentialsArn;
            this.description = builder.description;
            this.disableExecuteApiEndpoint = builder.disableExecuteApiEndpoint;
            this.disableSchemaValidation = builder.disableSchemaValidation;
            this.failOnWarnings = builder.failOnWarnings;
            this.ipAddressType = builder.ipAddressType;
            this.name = builder.name;
            this.protocolType = builder.protocolType;
            this.routeKey = builder.routeKey;
            this.routeSelectionExpression = builder.routeSelectionExpression;
            this.tags = builder.tags;
            this.target = builder.target;
            this.version = builder.version;
        }

        @Override
        public final java.lang.String getApiKeySelectionExpression() {
            return this.apiKeySelectionExpression;
        }

        @Override
        public final java.lang.String getBasePath() {
            return this.basePath;
        }

        @Override
        public final java.lang.Object getBody() {
            return this.body;
        }

        @Override
        public final java.lang.Object getBodyS3Location() {
            return this.bodyS3Location;
        }

        @Override
        public final java.lang.Object getCorsConfiguration() {
            return this.corsConfiguration;
        }

        @Override
        public final java.lang.String getCredentialsArn() {
            return this.credentialsArn;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getDisableExecuteApiEndpoint() {
            return this.disableExecuteApiEndpoint;
        }

        @Override
        public final java.lang.Object getDisableSchemaValidation() {
            return this.disableSchemaValidation;
        }

        @Override
        public final java.lang.Object getFailOnWarnings() {
            return this.failOnWarnings;
        }

        @Override
        public final java.lang.String getIpAddressType() {
            return this.ipAddressType;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getProtocolType() {
            return this.protocolType;
        }

        @Override
        public final java.lang.String getRouteKey() {
            return this.routeKey;
        }

        @Override
        public final java.lang.String getRouteSelectionExpression() {
            return this.routeSelectionExpression;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTarget() {
            return this.target;
        }

        @Override
        public final java.lang.String getVersion() {
            return this.version;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getApiKeySelectionExpression() != null) {
                data.set("apiKeySelectionExpression", om.valueToTree(this.getApiKeySelectionExpression()));
            }
            if (this.getBasePath() != null) {
                data.set("basePath", om.valueToTree(this.getBasePath()));
            }
            if (this.getBody() != null) {
                data.set("body", om.valueToTree(this.getBody()));
            }
            if (this.getBodyS3Location() != null) {
                data.set("bodyS3Location", om.valueToTree(this.getBodyS3Location()));
            }
            if (this.getCorsConfiguration() != null) {
                data.set("corsConfiguration", om.valueToTree(this.getCorsConfiguration()));
            }
            if (this.getCredentialsArn() != null) {
                data.set("credentialsArn", om.valueToTree(this.getCredentialsArn()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDisableExecuteApiEndpoint() != null) {
                data.set("disableExecuteApiEndpoint", om.valueToTree(this.getDisableExecuteApiEndpoint()));
            }
            if (this.getDisableSchemaValidation() != null) {
                data.set("disableSchemaValidation", om.valueToTree(this.getDisableSchemaValidation()));
            }
            if (this.getFailOnWarnings() != null) {
                data.set("failOnWarnings", om.valueToTree(this.getFailOnWarnings()));
            }
            if (this.getIpAddressType() != null) {
                data.set("ipAddressType", om.valueToTree(this.getIpAddressType()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getProtocolType() != null) {
                data.set("protocolType", om.valueToTree(this.getProtocolType()));
            }
            if (this.getRouteKey() != null) {
                data.set("routeKey", om.valueToTree(this.getRouteKey()));
            }
            if (this.getRouteSelectionExpression() != null) {
                data.set("routeSelectionExpression", om.valueToTree(this.getRouteSelectionExpression()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTarget() != null) {
                data.set("target", om.valueToTree(this.getTarget()));
            }
            if (this.getVersion() != null) {
                data.set("version", om.valueToTree(this.getVersion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.CfnApiProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnApiProps.Jsii$Proxy that = (CfnApiProps.Jsii$Proxy) o;

            if (this.apiKeySelectionExpression != null ? !this.apiKeySelectionExpression.equals(that.apiKeySelectionExpression) : that.apiKeySelectionExpression != null) return false;
            if (this.basePath != null ? !this.basePath.equals(that.basePath) : that.basePath != null) return false;
            if (this.body != null ? !this.body.equals(that.body) : that.body != null) return false;
            if (this.bodyS3Location != null ? !this.bodyS3Location.equals(that.bodyS3Location) : that.bodyS3Location != null) return false;
            if (this.corsConfiguration != null ? !this.corsConfiguration.equals(that.corsConfiguration) : that.corsConfiguration != null) return false;
            if (this.credentialsArn != null ? !this.credentialsArn.equals(that.credentialsArn) : that.credentialsArn != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.disableExecuteApiEndpoint != null ? !this.disableExecuteApiEndpoint.equals(that.disableExecuteApiEndpoint) : that.disableExecuteApiEndpoint != null) return false;
            if (this.disableSchemaValidation != null ? !this.disableSchemaValidation.equals(that.disableSchemaValidation) : that.disableSchemaValidation != null) return false;
            if (this.failOnWarnings != null ? !this.failOnWarnings.equals(that.failOnWarnings) : that.failOnWarnings != null) return false;
            if (this.ipAddressType != null ? !this.ipAddressType.equals(that.ipAddressType) : that.ipAddressType != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.protocolType != null ? !this.protocolType.equals(that.protocolType) : that.protocolType != null) return false;
            if (this.routeKey != null ? !this.routeKey.equals(that.routeKey) : that.routeKey != null) return false;
            if (this.routeSelectionExpression != null ? !this.routeSelectionExpression.equals(that.routeSelectionExpression) : that.routeSelectionExpression != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.target != null ? !this.target.equals(that.target) : that.target != null) return false;
            return this.version != null ? this.version.equals(that.version) : that.version == null;
        }

        @Override
        public final int hashCode() {
            int result = this.apiKeySelectionExpression != null ? this.apiKeySelectionExpression.hashCode() : 0;
            result = 31 * result + (this.basePath != null ? this.basePath.hashCode() : 0);
            result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
            result = 31 * result + (this.bodyS3Location != null ? this.bodyS3Location.hashCode() : 0);
            result = 31 * result + (this.corsConfiguration != null ? this.corsConfiguration.hashCode() : 0);
            result = 31 * result + (this.credentialsArn != null ? this.credentialsArn.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.disableExecuteApiEndpoint != null ? this.disableExecuteApiEndpoint.hashCode() : 0);
            result = 31 * result + (this.disableSchemaValidation != null ? this.disableSchemaValidation.hashCode() : 0);
            result = 31 * result + (this.failOnWarnings != null ? this.failOnWarnings.hashCode() : 0);
            result = 31 * result + (this.ipAddressType != null ? this.ipAddressType.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.protocolType != null ? this.protocolType.hashCode() : 0);
            result = 31 * result + (this.routeKey != null ? this.routeKey.hashCode() : 0);
            result = 31 * result + (this.routeSelectionExpression != null ? this.routeSelectionExpression.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            return result;
        }
    }
}
