package software.amazon.awscdk.services.apigatewayv2;

/**
 * Properties for defining a <code>CfnIntegration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * Object requestParameters;
 * Object requestTemplates;
 * Object responseParameters;
 * CfnIntegrationProps cfnIntegrationProps = CfnIntegrationProps.builder()
 *         .apiId("apiId")
 *         .integrationType("integrationType")
 *         // the properties below are optional
 *         .connectionId("connectionId")
 *         .connectionType("connectionType")
 *         .contentHandlingStrategy("contentHandlingStrategy")
 *         .credentialsArn("credentialsArn")
 *         .description("description")
 *         .integrationMethod("integrationMethod")
 *         .integrationSubtype("integrationSubtype")
 *         .integrationUri("integrationUri")
 *         .passthroughBehavior("passthroughBehavior")
 *         .payloadFormatVersion("payloadFormatVersion")
 *         .requestParameters(requestParameters)
 *         .requestTemplates(requestTemplates)
 *         .responseParameters(responseParameters)
 *         .templateSelectionExpression("templateSelectionExpression")
 *         .timeoutInMillis(123)
 *         .tlsConfig(TlsConfigProperty.builder()
 *                 .serverNameToVerify("serverNameToVerify")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:12.104Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.CfnIntegrationProps")
@software.amazon.jsii.Jsii.Proxy(CfnIntegrationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnIntegrationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The API identifier.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-apiid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-apiid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApiId();

    /**
     * The integration type of an integration. One of the following:.
     * <p>
     * <code>AWS</code> : for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.
     * <p>
     * <code>AWS_PROXY</code> : for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.
     * <p>
     * <code>HTTP</code> : for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.
     * <p>
     * <code>HTTP_PROXY</code> : for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an <code>HTTP_PROXY</code> integration.
     * <p>
     * <code>MOCK</code> : for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-integrationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-integrationtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIntegrationType();

    /**
     * The ID of the VPC link for a private integration.
     * <p>
     * Supported only for HTTP APIs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-connectionid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-connectionid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConnectionId() {
        return null;
    }

    /**
     * The type of the network connection to the integration endpoint.
     * <p>
     * Specify <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and resources in a VPC. The default value is <code>INTERNET</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-connectiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-connectiontype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConnectionType() {
        return null;
    }

    /**
     * Supported only for WebSocket APIs.
     * <p>
     * Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code> , with the following behaviors:
     * <p>
     * <code>CONVERT_TO_BINARY</code> : Converts a response payload from a Base64-encoded string to the corresponding binary blob.
     * <p>
     * <code>CONVERT_TO_TEXT</code> : Converts a response payload from a binary blob to a Base64-encoded string.
     * <p>
     * If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-contenthandlingstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-contenthandlingstrategy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getContentHandlingStrategy() {
        return null;
    }

    /**
     * Specifies the credentials required for the integration, if any.
     * <p>
     * For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string <code>arn:aws:iam::*:user/*</code> . To use resource-based permissions on supported AWS services, don't specify this parameter.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-credentialsarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-credentialsarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCredentialsArn() {
        return null;
    }

    /**
     * The description of the integration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Specifies the integration's HTTP method type.
     * <p>
     * For WebSocket APIs, if you use a Lambda integration, you must set the integration method to <code>POST</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-integrationmethod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-integrationmethod</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIntegrationMethod() {
        return null;
    }

    /**
     * Supported only for HTTP API <code>AWS_PROXY</code> integrations.
     * <p>
     * Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-integrationsubtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-integrationsubtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIntegrationSubtype() {
        return null;
    }

    /**
     * For a Lambda integration, specify the URI of a Lambda function.
     * <p>
     * For an HTTP integration, specify a fully-qualified URL.
     * <p>
     * For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses <code>DiscoverInstances</code> to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a> . For private integrations, all resources must be owned by the same AWS account .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-integrationuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-integrationuri</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIntegrationUri() {
        return null;
    }

    /**
     * Specifies the pass-through behavior for incoming requests based on the <code>Content-Type</code> header in the request, and the available mapping templates specified as the <code>requestTemplates</code> property on the <code>Integration</code> resource.
     * <p>
     * There are three valid values: <code>WHEN_NO_MATCH</code> , <code>WHEN_NO_TEMPLATES</code> , and <code>NEVER</code> . Supported only for WebSocket APIs.
     * <p>
     * <code>WHEN_NO_MATCH</code> passes the request body for unmapped content types through to the integration backend without transformation.
     * <p>
     * <code>NEVER</code> rejects unmapped content types with an <code>HTTP 415 Unsupported Media Type</code> response.
     * <p>
     * <code>WHEN_NO_TEMPLATES</code> allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same <code>HTTP 415 Unsupported Media Type</code> response.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-passthroughbehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-passthroughbehavior</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPassthroughBehavior() {
        return null;
    }

    /**
     * Specifies the format of the payload sent to an integration.
     * <p>
     * Required for HTTP APIs. For HTTP APIs, supported values for Lambda proxy integrations are <code>1.0</code> and <code>2.0</code> . For all other integrations, <code>1.0</code> is the only supported value. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html">Working with AWS Lambda proxy integrations for HTTP APIs</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-payloadformatversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-payloadformatversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPayloadFormatVersion() {
        return null;
    }

    /**
     * For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend.
     * <p>
     * The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of <code>method.request. {location} . {name}</code> , where <code>{location}</code> is <code>querystring</code> , <code>path</code> , or <code>header</code> ; and <code>{name}</code> must be a valid and unique method request parameter name.
     * <p>
     * For HTTP API integrations with a specified <code>integrationSubtype</code> , request parameters are a key-value map specifying parameters that are passed to <code>AWS_PROXY</code> integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a> .
     * <p>
     * For HTTP API integrations without a specified <code>integrationSubtype</code> request parameters are a key-value map specifying how to transform HTTP requests before sending them to the backend. The key should follow the pattern <action>:&lt;header|querystring|path&gt;.<location> where action can be <code>append</code> , <code>overwrite</code> or <code>remove</code> . For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-requestparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-requestparameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRequestParameters() {
        return null;
    }

    /**
     * Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client.
     * <p>
     * The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-requesttemplates">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-requesttemplates</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRequestTemplates() {
        return null;
    }

    /**
     * Supported only for HTTP APIs.
     * <p>
     * You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. The value is of type <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-integration-responseparameterlist.html"><code>ResponseParameterList</code></a> . To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-responseparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-responseparameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getResponseParameters() {
        return null;
    }

    /**
     * The template selection expression for the integration.
     * <p>
     * Supported only for WebSocket APIs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-templateselectionexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-templateselectionexpression</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTemplateSelectionExpression() {
        return null;
    }

    /**
     * Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs.
     * <p>
     * The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-timeoutinmillis">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-timeoutinmillis</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutInMillis() {
        return null;
    }

    /**
     * The TLS configuration for a private integration.
     * <p>
     * If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-tlsconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html#cfn-apigatewayv2-integration-tlsconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTlsConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnIntegrationProps> {
        java.lang.String apiId;
        java.lang.String integrationType;
        java.lang.String connectionId;
        java.lang.String connectionType;
        java.lang.String contentHandlingStrategy;
        java.lang.String credentialsArn;
        java.lang.String description;
        java.lang.String integrationMethod;
        java.lang.String integrationSubtype;
        java.lang.String integrationUri;
        java.lang.String passthroughBehavior;
        java.lang.String payloadFormatVersion;
        java.lang.Object requestParameters;
        java.lang.Object requestTemplates;
        java.lang.Object responseParameters;
        java.lang.String templateSelectionExpression;
        java.lang.Number timeoutInMillis;
        java.lang.Object tlsConfig;

        /**
         * Sets the value of {@link CfnIntegrationProps#getApiId}
         * @param apiId The API identifier. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiId(java.lang.String apiId) {
            this.apiId = apiId;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getIntegrationType}
         * @param integrationType The integration type of an integration. One of the following:. This parameter is required.
         *                        <code>AWS</code> : for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.
         *                        <p>
         *                        <code>AWS_PROXY</code> : for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.
         *                        <p>
         *                        <code>HTTP</code> : for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.
         *                        <p>
         *                        <code>HTTP_PROXY</code> : for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an <code>HTTP_PROXY</code> integration.
         *                        <p>
         *                        <code>MOCK</code> : for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationType(java.lang.String integrationType) {
            this.integrationType = integrationType;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getConnectionId}
         * @param connectionId The ID of the VPC link for a private integration.
         *                     Supported only for HTTP APIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionId(java.lang.String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getConnectionType}
         * @param connectionType The type of the network connection to the integration endpoint.
         *                       Specify <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and resources in a VPC. The default value is <code>INTERNET</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionType(java.lang.String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getContentHandlingStrategy}
         * @param contentHandlingStrategy Supported only for WebSocket APIs.
         *                                Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code> , with the following behaviors:
         *                                <p>
         *                                <code>CONVERT_TO_BINARY</code> : Converts a response payload from a Base64-encoded string to the corresponding binary blob.
         *                                <p>
         *                                <code>CONVERT_TO_TEXT</code> : Converts a response payload from a binary blob to a Base64-encoded string.
         *                                <p>
         *                                If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentHandlingStrategy(java.lang.String contentHandlingStrategy) {
            this.contentHandlingStrategy = contentHandlingStrategy;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getCredentialsArn}
         * @param credentialsArn Specifies the credentials required for the integration, if any.
         *                       For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string <code>arn:aws:iam::*:user/*</code> . To use resource-based permissions on supported AWS services, don't specify this parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentialsArn(java.lang.String credentialsArn) {
            this.credentialsArn = credentialsArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getDescription}
         * @param description The description of the integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getIntegrationMethod}
         * @param integrationMethod Specifies the integration's HTTP method type.
         *                          For WebSocket APIs, if you use a Lambda integration, you must set the integration method to <code>POST</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationMethod(java.lang.String integrationMethod) {
            this.integrationMethod = integrationMethod;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getIntegrationSubtype}
         * @param integrationSubtype Supported only for HTTP API <code>AWS_PROXY</code> integrations.
         *                           Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationSubtype(java.lang.String integrationSubtype) {
            this.integrationSubtype = integrationSubtype;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getIntegrationUri}
         * @param integrationUri For a Lambda integration, specify the URI of a Lambda function.
         *                       For an HTTP integration, specify a fully-qualified URL.
         *                       <p>
         *                       For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses <code>DiscoverInstances</code> to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a> . For private integrations, all resources must be owned by the same AWS account .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationUri(java.lang.String integrationUri) {
            this.integrationUri = integrationUri;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getPassthroughBehavior}
         * @param passthroughBehavior Specifies the pass-through behavior for incoming requests based on the <code>Content-Type</code> header in the request, and the available mapping templates specified as the <code>requestTemplates</code> property on the <code>Integration</code> resource.
         *                            There are three valid values: <code>WHEN_NO_MATCH</code> , <code>WHEN_NO_TEMPLATES</code> , and <code>NEVER</code> . Supported only for WebSocket APIs.
         *                            <p>
         *                            <code>WHEN_NO_MATCH</code> passes the request body for unmapped content types through to the integration backend without transformation.
         *                            <p>
         *                            <code>NEVER</code> rejects unmapped content types with an <code>HTTP 415 Unsupported Media Type</code> response.
         *                            <p>
         *                            <code>WHEN_NO_TEMPLATES</code> allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same <code>HTTP 415 Unsupported Media Type</code> response.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder passthroughBehavior(java.lang.String passthroughBehavior) {
            this.passthroughBehavior = passthroughBehavior;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getPayloadFormatVersion}
         * @param payloadFormatVersion Specifies the format of the payload sent to an integration.
         *                             Required for HTTP APIs. For HTTP APIs, supported values for Lambda proxy integrations are <code>1.0</code> and <code>2.0</code> . For all other integrations, <code>1.0</code> is the only supported value. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html">Working with AWS Lambda proxy integrations for HTTP APIs</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder payloadFormatVersion(java.lang.String payloadFormatVersion) {
            this.payloadFormatVersion = payloadFormatVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getRequestParameters}
         * @param requestParameters For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend.
         *                          The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of <code>method.request. {location} . {name}</code> , where <code>{location}</code> is <code>querystring</code> , <code>path</code> , or <code>header</code> ; and <code>{name}</code> must be a valid and unique method request parameter name.
         *                          <p>
         *                          For HTTP API integrations with a specified <code>integrationSubtype</code> , request parameters are a key-value map specifying parameters that are passed to <code>AWS_PROXY</code> integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a> .
         *                          <p>
         *                          For HTTP API integrations without a specified <code>integrationSubtype</code> request parameters are a key-value map specifying how to transform HTTP requests before sending them to the backend. The key should follow the pattern <action>:&lt;header|querystring|path&gt;.<location> where action can be <code>append</code> , <code>overwrite</code> or <code>remove</code> . For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestParameters(java.lang.Object requestParameters) {
            this.requestParameters = requestParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getRequestTemplates}
         * @param requestTemplates Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client.
         *                         The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestTemplates(java.lang.Object requestTemplates) {
            this.requestTemplates = requestTemplates;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getResponseParameters}
         * @param responseParameters Supported only for HTTP APIs.
         *                           You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. The value is of type <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-integration-responseparameterlist.html"><code>ResponseParameterList</code></a> . To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseParameters(java.lang.Object responseParameters) {
            this.responseParameters = responseParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getTemplateSelectionExpression}
         * @param templateSelectionExpression The template selection expression for the integration.
         *                                    Supported only for WebSocket APIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateSelectionExpression(java.lang.String templateSelectionExpression) {
            this.templateSelectionExpression = templateSelectionExpression;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getTimeoutInMillis}
         * @param timeoutInMillis Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs.
         *                        The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeoutInMillis(java.lang.Number timeoutInMillis) {
            this.timeoutInMillis = timeoutInMillis;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getTlsConfig}
         * @param tlsConfig The TLS configuration for a private integration.
         *                  If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tlsConfig(software.amazon.awscdk.IResolvable tlsConfig) {
            this.tlsConfig = tlsConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getTlsConfig}
         * @param tlsConfig The TLS configuration for a private integration.
         *                  If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tlsConfig(software.amazon.awscdk.services.apigatewayv2.CfnIntegration.TlsConfigProperty tlsConfig) {
            this.tlsConfig = tlsConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnIntegrationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnIntegrationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnIntegrationProps {
        private final java.lang.String apiId;
        private final java.lang.String integrationType;
        private final java.lang.String connectionId;
        private final java.lang.String connectionType;
        private final java.lang.String contentHandlingStrategy;
        private final java.lang.String credentialsArn;
        private final java.lang.String description;
        private final java.lang.String integrationMethod;
        private final java.lang.String integrationSubtype;
        private final java.lang.String integrationUri;
        private final java.lang.String passthroughBehavior;
        private final java.lang.String payloadFormatVersion;
        private final java.lang.Object requestParameters;
        private final java.lang.Object requestTemplates;
        private final java.lang.Object responseParameters;
        private final java.lang.String templateSelectionExpression;
        private final java.lang.Number timeoutInMillis;
        private final java.lang.Object tlsConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiId = software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.integrationType = software.amazon.jsii.Kernel.get(this, "integrationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connectionId = software.amazon.jsii.Kernel.get(this, "connectionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connectionType = software.amazon.jsii.Kernel.get(this, "connectionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.contentHandlingStrategy = software.amazon.jsii.Kernel.get(this, "contentHandlingStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.credentialsArn = software.amazon.jsii.Kernel.get(this, "credentialsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.integrationMethod = software.amazon.jsii.Kernel.get(this, "integrationMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.integrationSubtype = software.amazon.jsii.Kernel.get(this, "integrationSubtype", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.integrationUri = software.amazon.jsii.Kernel.get(this, "integrationUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.passthroughBehavior = software.amazon.jsii.Kernel.get(this, "passthroughBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.payloadFormatVersion = software.amazon.jsii.Kernel.get(this, "payloadFormatVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.requestParameters = software.amazon.jsii.Kernel.get(this, "requestParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.requestTemplates = software.amazon.jsii.Kernel.get(this, "requestTemplates", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.responseParameters = software.amazon.jsii.Kernel.get(this, "responseParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.templateSelectionExpression = software.amazon.jsii.Kernel.get(this, "templateSelectionExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.timeoutInMillis = software.amazon.jsii.Kernel.get(this, "timeoutInMillis", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tlsConfig = software.amazon.jsii.Kernel.get(this, "tlsConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiId = java.util.Objects.requireNonNull(builder.apiId, "apiId is required");
            this.integrationType = java.util.Objects.requireNonNull(builder.integrationType, "integrationType is required");
            this.connectionId = builder.connectionId;
            this.connectionType = builder.connectionType;
            this.contentHandlingStrategy = builder.contentHandlingStrategy;
            this.credentialsArn = builder.credentialsArn;
            this.description = builder.description;
            this.integrationMethod = builder.integrationMethod;
            this.integrationSubtype = builder.integrationSubtype;
            this.integrationUri = builder.integrationUri;
            this.passthroughBehavior = builder.passthroughBehavior;
            this.payloadFormatVersion = builder.payloadFormatVersion;
            this.requestParameters = builder.requestParameters;
            this.requestTemplates = builder.requestTemplates;
            this.responseParameters = builder.responseParameters;
            this.templateSelectionExpression = builder.templateSelectionExpression;
            this.timeoutInMillis = builder.timeoutInMillis;
            this.tlsConfig = builder.tlsConfig;
        }

        @Override
        public final java.lang.String getApiId() {
            return this.apiId;
        }

        @Override
        public final java.lang.String getIntegrationType() {
            return this.integrationType;
        }

        @Override
        public final java.lang.String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final java.lang.String getConnectionType() {
            return this.connectionType;
        }

        @Override
        public final java.lang.String getContentHandlingStrategy() {
            return this.contentHandlingStrategy;
        }

        @Override
        public final java.lang.String getCredentialsArn() {
            return this.credentialsArn;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getIntegrationMethod() {
            return this.integrationMethod;
        }

        @Override
        public final java.lang.String getIntegrationSubtype() {
            return this.integrationSubtype;
        }

        @Override
        public final java.lang.String getIntegrationUri() {
            return this.integrationUri;
        }

        @Override
        public final java.lang.String getPassthroughBehavior() {
            return this.passthroughBehavior;
        }

        @Override
        public final java.lang.String getPayloadFormatVersion() {
            return this.payloadFormatVersion;
        }

        @Override
        public final java.lang.Object getRequestParameters() {
            return this.requestParameters;
        }

        @Override
        public final java.lang.Object getRequestTemplates() {
            return this.requestTemplates;
        }

        @Override
        public final java.lang.Object getResponseParameters() {
            return this.responseParameters;
        }

        @Override
        public final java.lang.String getTemplateSelectionExpression() {
            return this.templateSelectionExpression;
        }

        @Override
        public final java.lang.Number getTimeoutInMillis() {
            return this.timeoutInMillis;
        }

        @Override
        public final java.lang.Object getTlsConfig() {
            return this.tlsConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("apiId", om.valueToTree(this.getApiId()));
            data.set("integrationType", om.valueToTree(this.getIntegrationType()));
            if (this.getConnectionId() != null) {
                data.set("connectionId", om.valueToTree(this.getConnectionId()));
            }
            if (this.getConnectionType() != null) {
                data.set("connectionType", om.valueToTree(this.getConnectionType()));
            }
            if (this.getContentHandlingStrategy() != null) {
                data.set("contentHandlingStrategy", om.valueToTree(this.getContentHandlingStrategy()));
            }
            if (this.getCredentialsArn() != null) {
                data.set("credentialsArn", om.valueToTree(this.getCredentialsArn()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getIntegrationMethod() != null) {
                data.set("integrationMethod", om.valueToTree(this.getIntegrationMethod()));
            }
            if (this.getIntegrationSubtype() != null) {
                data.set("integrationSubtype", om.valueToTree(this.getIntegrationSubtype()));
            }
            if (this.getIntegrationUri() != null) {
                data.set("integrationUri", om.valueToTree(this.getIntegrationUri()));
            }
            if (this.getPassthroughBehavior() != null) {
                data.set("passthroughBehavior", om.valueToTree(this.getPassthroughBehavior()));
            }
            if (this.getPayloadFormatVersion() != null) {
                data.set("payloadFormatVersion", om.valueToTree(this.getPayloadFormatVersion()));
            }
            if (this.getRequestParameters() != null) {
                data.set("requestParameters", om.valueToTree(this.getRequestParameters()));
            }
            if (this.getRequestTemplates() != null) {
                data.set("requestTemplates", om.valueToTree(this.getRequestTemplates()));
            }
            if (this.getResponseParameters() != null) {
                data.set("responseParameters", om.valueToTree(this.getResponseParameters()));
            }
            if (this.getTemplateSelectionExpression() != null) {
                data.set("templateSelectionExpression", om.valueToTree(this.getTemplateSelectionExpression()));
            }
            if (this.getTimeoutInMillis() != null) {
                data.set("timeoutInMillis", om.valueToTree(this.getTimeoutInMillis()));
            }
            if (this.getTlsConfig() != null) {
                data.set("tlsConfig", om.valueToTree(this.getTlsConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.CfnIntegrationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnIntegrationProps.Jsii$Proxy that = (CfnIntegrationProps.Jsii$Proxy) o;

            if (!apiId.equals(that.apiId)) return false;
            if (!integrationType.equals(that.integrationType)) return false;
            if (this.connectionId != null ? !this.connectionId.equals(that.connectionId) : that.connectionId != null) return false;
            if (this.connectionType != null ? !this.connectionType.equals(that.connectionType) : that.connectionType != null) return false;
            if (this.contentHandlingStrategy != null ? !this.contentHandlingStrategy.equals(that.contentHandlingStrategy) : that.contentHandlingStrategy != null) return false;
            if (this.credentialsArn != null ? !this.credentialsArn.equals(that.credentialsArn) : that.credentialsArn != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.integrationMethod != null ? !this.integrationMethod.equals(that.integrationMethod) : that.integrationMethod != null) return false;
            if (this.integrationSubtype != null ? !this.integrationSubtype.equals(that.integrationSubtype) : that.integrationSubtype != null) return false;
            if (this.integrationUri != null ? !this.integrationUri.equals(that.integrationUri) : that.integrationUri != null) return false;
            if (this.passthroughBehavior != null ? !this.passthroughBehavior.equals(that.passthroughBehavior) : that.passthroughBehavior != null) return false;
            if (this.payloadFormatVersion != null ? !this.payloadFormatVersion.equals(that.payloadFormatVersion) : that.payloadFormatVersion != null) return false;
            if (this.requestParameters != null ? !this.requestParameters.equals(that.requestParameters) : that.requestParameters != null) return false;
            if (this.requestTemplates != null ? !this.requestTemplates.equals(that.requestTemplates) : that.requestTemplates != null) return false;
            if (this.responseParameters != null ? !this.responseParameters.equals(that.responseParameters) : that.responseParameters != null) return false;
            if (this.templateSelectionExpression != null ? !this.templateSelectionExpression.equals(that.templateSelectionExpression) : that.templateSelectionExpression != null) return false;
            if (this.timeoutInMillis != null ? !this.timeoutInMillis.equals(that.timeoutInMillis) : that.timeoutInMillis != null) return false;
            return this.tlsConfig != null ? this.tlsConfig.equals(that.tlsConfig) : that.tlsConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.apiId.hashCode();
            result = 31 * result + (this.integrationType.hashCode());
            result = 31 * result + (this.connectionId != null ? this.connectionId.hashCode() : 0);
            result = 31 * result + (this.connectionType != null ? this.connectionType.hashCode() : 0);
            result = 31 * result + (this.contentHandlingStrategy != null ? this.contentHandlingStrategy.hashCode() : 0);
            result = 31 * result + (this.credentialsArn != null ? this.credentialsArn.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.integrationMethod != null ? this.integrationMethod.hashCode() : 0);
            result = 31 * result + (this.integrationSubtype != null ? this.integrationSubtype.hashCode() : 0);
            result = 31 * result + (this.integrationUri != null ? this.integrationUri.hashCode() : 0);
            result = 31 * result + (this.passthroughBehavior != null ? this.passthroughBehavior.hashCode() : 0);
            result = 31 * result + (this.payloadFormatVersion != null ? this.payloadFormatVersion.hashCode() : 0);
            result = 31 * result + (this.requestParameters != null ? this.requestParameters.hashCode() : 0);
            result = 31 * result + (this.requestTemplates != null ? this.requestTemplates.hashCode() : 0);
            result = 31 * result + (this.responseParameters != null ? this.responseParameters.hashCode() : 0);
            result = 31 * result + (this.templateSelectionExpression != null ? this.templateSelectionExpression.hashCode() : 0);
            result = 31 * result + (this.timeoutInMillis != null ? this.timeoutInMillis.hashCode() : 0);
            result = 31 * result + (this.tlsConfig != null ? this.tlsConfig.hashCode() : 0);
            return result;
        }
    }
}
