package software.amazon.awscdk.services.apigatewayv2;

/**
 * Supported CORS HTTP methods.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * HttpApi.Builder.create(this, "HttpProxyApi")
 *         .corsPreflight(CorsPreflightOptions.builder()
 *                 .allowHeaders(List.of("Authorization"))
 *                 .allowMethods(List.of(CorsHttpMethod.GET, CorsHttpMethod.HEAD, CorsHttpMethod.OPTIONS, CorsHttpMethod.POST))
 *                 .allowOrigins(List.of("*"))
 *                 .maxAge(Duration.days(10))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:12.118Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.CorsHttpMethod")
public enum CorsHttpMethod {
    /**
     * HTTP ANY.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ANY,
    /**
     * HTTP DELETE.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DELETE,
    /**
     * HTTP GET.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GET,
    /**
     * HTTP HEAD.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HEAD,
    /**
     * HTTP OPTIONS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OPTIONS,
    /**
     * HTTP PATCH.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PATCH,
    /**
     * HTTP POST.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    POST,
    /**
     * HTTP PUT.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PUT,
}
