package software.amazon.awscdk.services.apigatewayv2;

/**
 * Config returned back as a result of the bind.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * IntegrationCredentials integrationCredentials;
 * ParameterMapping parameterMapping;
 * PayloadFormatVersion payloadFormatVersion;
 * HttpRouteIntegrationConfig httpRouteIntegrationConfig = HttpRouteIntegrationConfig.builder()
 *         .payloadFormatVersion(payloadFormatVersion)
 *         .type(HttpIntegrationType.HTTP_PROXY)
 *         // the properties below are optional
 *         .connectionId("connectionId")
 *         .connectionType(HttpConnectionType.VPC_LINK)
 *         .credentials(integrationCredentials)
 *         .method(HttpMethod.ANY)
 *         .parameterMapping(parameterMapping)
 *         .secureServerName("secureServerName")
 *         .subtype(HttpIntegrationSubtype.EVENTBRIDGE_PUT_EVENTS)
 *         .timeout(Duration.minutes(30))
 *         .uri("uri")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:12.145Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.HttpRouteIntegrationConfig")
@software.amazon.jsii.Jsii.Proxy(HttpRouteIntegrationConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HttpRouteIntegrationConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Payload format version in the case of lambda proxy integration.
     * <p>
     * Default: - undefined
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion getPayloadFormatVersion();

    /**
     * Integration type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpIntegrationType getType();

    /**
     * The ID of the VPC link for a private integration.
     * <p>
     * Supported only for HTTP APIs.
     * <p>
     * Default: - undefined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConnectionId() {
        return null;
    }

    /**
     * The type of the network connection to the integration endpoint.
     * <p>
     * Default: HttpConnectionType.INTERNET
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.HttpConnectionType getConnectionType() {
        return null;
    }

    /**
     * The credentials with which to invoke the integration.
     * <p>
     * Default: - no credentials, use resource-based permissions on supported AWS services
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.IntegrationCredentials getCredentials() {
        return null;
    }

    /**
     * The HTTP method that must be used to invoke the underlying proxy.
     * <p>
     * Required for <code>HttpIntegrationType.HTTP_PROXY</code>
     * <p>
     * Default: - undefined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.HttpMethod getMethod() {
        return null;
    }

    /**
     * Specifies how to transform HTTP requests before sending them to the backend.
     * <p>
     * Default: undefined requests are sent to the backend unmodified
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.ParameterMapping getParameterMapping() {
        return null;
    }

    /**
     * Specifies the server name to verified by HTTPS when calling the backend integration.
     * <p>
     * Default: undefined private integration traffic will use HTTP protocol
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-integration-tlsconfig.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-integration-tlsconfig.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecureServerName() {
        return null;
    }

    /**
     * Integration subtype.
     * <p>
     * Default: - none, required if no `integrationUri` is defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.HttpIntegrationSubtype getSubtype() {
        return null;
    }

    /**
     * The maximum amount of time an integration will run before it returns without a response.
     * <p>
     * Must be between 50 milliseconds and 29 seconds.
     * <p>
     * Default: Duration.seconds(29)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTimeout() {
        return null;
    }

    /**
     * Integration URI.
     * <p>
     * Default: - none, required if no `integrationSubtype` is defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUri() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HttpRouteIntegrationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HttpRouteIntegrationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HttpRouteIntegrationConfig> {
        software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion payloadFormatVersion;
        software.amazon.awscdk.services.apigatewayv2.HttpIntegrationType type;
        java.lang.String connectionId;
        software.amazon.awscdk.services.apigatewayv2.HttpConnectionType connectionType;
        software.amazon.awscdk.services.apigatewayv2.IntegrationCredentials credentials;
        software.amazon.awscdk.services.apigatewayv2.HttpMethod method;
        software.amazon.awscdk.services.apigatewayv2.ParameterMapping parameterMapping;
        java.lang.String secureServerName;
        software.amazon.awscdk.services.apigatewayv2.HttpIntegrationSubtype subtype;
        software.amazon.awscdk.Duration timeout;
        java.lang.String uri;

        /**
         * Sets the value of {@link HttpRouteIntegrationConfig#getPayloadFormatVersion}
         * @param payloadFormatVersion Payload format version in the case of lambda proxy integration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder payloadFormatVersion(software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion payloadFormatVersion) {
            this.payloadFormatVersion = payloadFormatVersion;
            return this;
        }

        /**
         * Sets the value of {@link HttpRouteIntegrationConfig#getType}
         * @param type Integration type. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(software.amazon.awscdk.services.apigatewayv2.HttpIntegrationType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link HttpRouteIntegrationConfig#getConnectionId}
         * @param connectionId The ID of the VPC link for a private integration.
         *                     Supported only for HTTP APIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionId(java.lang.String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        /**
         * Sets the value of {@link HttpRouteIntegrationConfig#getConnectionType}
         * @param connectionType The type of the network connection to the integration endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionType(software.amazon.awscdk.services.apigatewayv2.HttpConnectionType connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        /**
         * Sets the value of {@link HttpRouteIntegrationConfig#getCredentials}
         * @param credentials The credentials with which to invoke the integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentials(software.amazon.awscdk.services.apigatewayv2.IntegrationCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        /**
         * Sets the value of {@link HttpRouteIntegrationConfig#getMethod}
         * @param method The HTTP method that must be used to invoke the underlying proxy.
         *               Required for <code>HttpIntegrationType.HTTP_PROXY</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder method(software.amazon.awscdk.services.apigatewayv2.HttpMethod method) {
            this.method = method;
            return this;
        }

        /**
         * Sets the value of {@link HttpRouteIntegrationConfig#getParameterMapping}
         * @param parameterMapping Specifies how to transform HTTP requests before sending them to the backend.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterMapping(software.amazon.awscdk.services.apigatewayv2.ParameterMapping parameterMapping) {
            this.parameterMapping = parameterMapping;
            return this;
        }

        /**
         * Sets the value of {@link HttpRouteIntegrationConfig#getSecureServerName}
         * @param secureServerName Specifies the server name to verified by HTTPS when calling the backend integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secureServerName(java.lang.String secureServerName) {
            this.secureServerName = secureServerName;
            return this;
        }

        /**
         * Sets the value of {@link HttpRouteIntegrationConfig#getSubtype}
         * @param subtype Integration subtype.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subtype(software.amazon.awscdk.services.apigatewayv2.HttpIntegrationSubtype subtype) {
            this.subtype = subtype;
            return this;
        }

        /**
         * Sets the value of {@link HttpRouteIntegrationConfig#getTimeout}
         * @param timeout The maximum amount of time an integration will run before it returns without a response.
         *                Must be between 50 milliseconds and 29 seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link HttpRouteIntegrationConfig#getUri}
         * @param uri Integration URI.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder uri(java.lang.String uri) {
            this.uri = uri;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HttpRouteIntegrationConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HttpRouteIntegrationConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HttpRouteIntegrationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpRouteIntegrationConfig {
        private final software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion payloadFormatVersion;
        private final software.amazon.awscdk.services.apigatewayv2.HttpIntegrationType type;
        private final java.lang.String connectionId;
        private final software.amazon.awscdk.services.apigatewayv2.HttpConnectionType connectionType;
        private final software.amazon.awscdk.services.apigatewayv2.IntegrationCredentials credentials;
        private final software.amazon.awscdk.services.apigatewayv2.HttpMethod method;
        private final software.amazon.awscdk.services.apigatewayv2.ParameterMapping parameterMapping;
        private final java.lang.String secureServerName;
        private final software.amazon.awscdk.services.apigatewayv2.HttpIntegrationSubtype subtype;
        private final software.amazon.awscdk.Duration timeout;
        private final java.lang.String uri;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.payloadFormatVersion = software.amazon.jsii.Kernel.get(this, "payloadFormatVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpIntegrationType.class));
            this.connectionId = software.amazon.jsii.Kernel.get(this, "connectionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connectionType = software.amazon.jsii.Kernel.get(this, "connectionType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpConnectionType.class));
            this.credentials = software.amazon.jsii.Kernel.get(this, "credentials", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IntegrationCredentials.class));
            this.method = software.amazon.jsii.Kernel.get(this, "method", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpMethod.class));
            this.parameterMapping = software.amazon.jsii.Kernel.get(this, "parameterMapping", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.ParameterMapping.class));
            this.secureServerName = software.amazon.jsii.Kernel.get(this, "secureServerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subtype = software.amazon.jsii.Kernel.get(this, "subtype", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpIntegrationSubtype.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.uri = software.amazon.jsii.Kernel.get(this, "uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.payloadFormatVersion = java.util.Objects.requireNonNull(builder.payloadFormatVersion, "payloadFormatVersion is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.connectionId = builder.connectionId;
            this.connectionType = builder.connectionType;
            this.credentials = builder.credentials;
            this.method = builder.method;
            this.parameterMapping = builder.parameterMapping;
            this.secureServerName = builder.secureServerName;
            this.subtype = builder.subtype;
            this.timeout = builder.timeout;
            this.uri = builder.uri;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion getPayloadFormatVersion() {
            return this.payloadFormatVersion;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.HttpIntegrationType getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.HttpConnectionType getConnectionType() {
            return this.connectionType;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.IntegrationCredentials getCredentials() {
            return this.credentials;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.HttpMethod getMethod() {
            return this.method;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.ParameterMapping getParameterMapping() {
            return this.parameterMapping;
        }

        @Override
        public final java.lang.String getSecureServerName() {
            return this.secureServerName;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.HttpIntegrationSubtype getSubtype() {
            return this.subtype;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public final java.lang.String getUri() {
            return this.uri;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("payloadFormatVersion", om.valueToTree(this.getPayloadFormatVersion()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getConnectionId() != null) {
                data.set("connectionId", om.valueToTree(this.getConnectionId()));
            }
            if (this.getConnectionType() != null) {
                data.set("connectionType", om.valueToTree(this.getConnectionType()));
            }
            if (this.getCredentials() != null) {
                data.set("credentials", om.valueToTree(this.getCredentials()));
            }
            if (this.getMethod() != null) {
                data.set("method", om.valueToTree(this.getMethod()));
            }
            if (this.getParameterMapping() != null) {
                data.set("parameterMapping", om.valueToTree(this.getParameterMapping()));
            }
            if (this.getSecureServerName() != null) {
                data.set("secureServerName", om.valueToTree(this.getSecureServerName()));
            }
            if (this.getSubtype() != null) {
                data.set("subtype", om.valueToTree(this.getSubtype()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getUri() != null) {
                data.set("uri", om.valueToTree(this.getUri()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.HttpRouteIntegrationConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HttpRouteIntegrationConfig.Jsii$Proxy that = (HttpRouteIntegrationConfig.Jsii$Proxy) o;

            if (!payloadFormatVersion.equals(that.payloadFormatVersion)) return false;
            if (!type.equals(that.type)) return false;
            if (this.connectionId != null ? !this.connectionId.equals(that.connectionId) : that.connectionId != null) return false;
            if (this.connectionType != null ? !this.connectionType.equals(that.connectionType) : that.connectionType != null) return false;
            if (this.credentials != null ? !this.credentials.equals(that.credentials) : that.credentials != null) return false;
            if (this.method != null ? !this.method.equals(that.method) : that.method != null) return false;
            if (this.parameterMapping != null ? !this.parameterMapping.equals(that.parameterMapping) : that.parameterMapping != null) return false;
            if (this.secureServerName != null ? !this.secureServerName.equals(that.secureServerName) : that.secureServerName != null) return false;
            if (this.subtype != null ? !this.subtype.equals(that.subtype) : that.subtype != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            return this.uri != null ? this.uri.equals(that.uri) : that.uri == null;
        }

        @Override
        public final int hashCode() {
            int result = this.payloadFormatVersion.hashCode();
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.connectionId != null ? this.connectionId.hashCode() : 0);
            result = 31 * result + (this.connectionType != null ? this.connectionType.hashCode() : 0);
            result = 31 * result + (this.credentials != null ? this.credentials.hashCode() : 0);
            result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
            result = 31 * result + (this.parameterMapping != null ? this.parameterMapping.hashCode() : 0);
            result = 31 * result + (this.secureServerName != null ? this.secureServerName.hashCode() : 0);
            result = 31 * result + (this.subtype != null ? this.subtype.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
            return result;
        }
    }
}
