package software.amazon.awscdk.services.applicationautoscaling;

/**
 * The service that supports Application AutoScaling.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ScalableTarget shardsScalableTarget = ScalableTarget.Builder.create(this, "ElastiCacheRedisShardsScalableTarget")
 *         .serviceNamespace(ServiceNamespace.ELASTICACHE)
 *         .scalableDimension("elasticache:replication-group:NodeGroups")
 *         .minCapacity(2)
 *         .maxCapacity(10)
 *         .resourceId("replication-group/main-cluster")
 *         .build();
 * shardsScalableTarget.scaleToTrackMetric("ElastiCacheRedisShardsCPUUtilization", BasicTargetTrackingScalingPolicyProps.builder()
 *         .targetValue(20)
 *         .predefinedMetric(PredefinedMetric.ELASTICACHE_PRIMARY_ENGINE_CPU_UTILIZATION)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:12.466Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.ServiceNamespace")
public enum ServiceNamespace {
    /**
     * Elastic Container Service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ECS,
    /**
     * Elastic Map Reduce.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ELASTIC_MAP_REDUCE,
    /**
     * Elastic Compute Cloud.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EC2,
    /**
     * App Stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    APPSTREAM,
    /**
     * Dynamo DB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DYNAMODB,
    /**
     * Relational Database Service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RDS,
    /**
     * SageMaker.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SAGEMAKER,
    /**
     * Custom Resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CUSTOM_RESOURCE,
    /**
     * Lambda.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LAMBDA,
    /**
     * Comprehend.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPREHEND,
    /**
     * Kafka.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    KAFKA,
    /**
     * ElastiCache.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ELASTICACHE,
    /**
     * Neptune.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NEPTUNE,
    /**
     * Cassandra.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CASSANDRA,
    /**
     * Workspaces.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WORKSPACES,
}
