package software.amazon.awscdk.services.appmesh;

/**
 * Configuration for Envoy Access Logging Format for mesh endpoints.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Mesh mesh;
 * Service service;
 * VirtualNode node = VirtualNode.Builder.create(this, "node")
 *         .mesh(mesh)
 *         .serviceDiscovery(ServiceDiscovery.cloudMap(service))
 *         .listeners(List.of(VirtualNodeListener.http(HttpVirtualNodeListenerOptions.builder()
 *                 .port(8080)
 *                 .healthCheck(HealthCheck.http(HttpHealthCheckOptions.builder()
 *                         .healthyThreshold(3)
 *                         .interval(Duration.seconds(5))
 *                         .path("/ping")
 *                         .timeout(Duration.seconds(2))
 *                         .unhealthyThreshold(2)
 *                         .build()))
 *                 .timeout(HttpTimeout.builder()
 *                         .idle(Duration.seconds(5))
 *                         .build())
 *                 .build())))
 *         .backendDefaults(BackendDefaults.builder()
 *                 .tlsClientPolicy(TlsClientPolicy.builder()
 *                         .validation(TlsValidation.builder()
 *                                 .trust(TlsValidationTrust.file("/keys/local_cert_chain.pem"))
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .accessLog(AccessLog.fromFilePath("/dev/stdout", LoggingFormat.fromJson(Map.of("testKey1", "testValue1", "testKey2", "testValue2"))))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:12.693Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.LoggingFormat")
public abstract class LoggingFormat extends software.amazon.jsii.JsiiObject {

    protected LoggingFormat(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LoggingFormat(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected LoggingFormat() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Generate logging format from json key pairs.
     * <p>
     * @param jsonLoggingFormat This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.LoggingFormat fromJson(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> jsonLoggingFormat) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.LoggingFormat.class, "fromJson", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.LoggingFormat.class), new Object[] { java.util.Objects.requireNonNull(jsonLoggingFormat, "jsonLoggingFormat is required") });
    }

    /**
     * Generate logging format from text pattern.
     * <p>
     * @param text This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.LoggingFormat fromText(final @org.jetbrains.annotations.NotNull java.lang.String text) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.LoggingFormat.class, "fromText", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.LoggingFormat.class), new Object[] { java.util.Objects.requireNonNull(text, "text is required") });
    }

    /**
     * Called when the Access Log Format is initialized.
     * <p>
     * Can be used to enforce
     * mutual exclusivity with future properties
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.LoggingFormatConfig bind();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appmesh.LoggingFormat {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Called when the Access Log Format is initialized.
         * <p>
         * Can be used to enforce
         * mutual exclusivity with future properties
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.LoggingFormatConfig bind() {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.LoggingFormatConfig.class));
        }
    }
}
