package software.amazon.awscdk.services.batch;

/**
 * The DNS Policy for the pod used by the Job Definition.
 * <p>
 * @see <a href="https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy">https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:13.435Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.DnsPolicy")
public enum DnsPolicy {
    /**
     * The Pod inherits the name resolution configuration from the node that the Pods run on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DEFAULT,
    /**
     * Any DNS query that does not match the configured cluster domain suffix, such as <code>"www.kubernetes.io"</code>, is forwarded to an upstream nameserver by the DNS server. Cluster administrators may have extra stub-domain and upstream DNS servers configured.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CLUSTER_FIRST,
    /**
     * For Pods running with <code>hostNetwork</code>, you should explicitly set its DNS policy to <code>CLUSTER_FIRST_WITH_HOST_NET</code>.
     * <p>
     * Otherwise, Pods running with <code>hostNetwork</code> and <code>CLUSTER_FIRST</code> will fallback to the behavior of the <code>DEFAULT</code> policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CLUSTER_FIRST_WITH_HOST_NET,
}
