package software.amazon.awscdk.services.batch;

/**
 * Options for configuring an EfsVolume.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IFileSystem myFileSystem;
 * Role myJobRole;
 * myFileSystem.grantRead(myJobRole);
 * EcsJobDefinition jobDefn = EcsJobDefinition.Builder.create(this, "JobDefn")
 *         .container(EcsEc2ContainerDefinition.Builder.create(this, "containerDefn")
 *                 .image(ContainerImage.fromRegistry("public.ecr.aws/amazonlinux/amazonlinux:latest"))
 *                 .memory(Size.mebibytes(2048))
 *                 .cpu(256)
 *                 .volumes(List.of(EcsVolume.efs(EfsVolumeOptions.builder()
 *                         .name("myVolume")
 *                         .fileSystem(myFileSystem)
 *                         .containerPath("/Volumes/myVolume")
 *                         .useJobRole(true)
 *                         .build())))
 *                 .jobRole(myJobRole)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:13.444Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.EfsVolumeOptions")
@software.amazon.jsii.Jsii.Proxy(EfsVolumeOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EfsVolumeOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.batch.EcsVolumeOptions {

    /**
     * The EFS File System that supports this volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.IFileSystem getFileSystem();

    /**
     * The Amazon EFS access point ID to use.
     * <p>
     * If an access point is specified, <code>rootDirectory</code> must either be omitted or set to <code>/</code>
     * which enforces the path set on the EFS access point.
     * If an access point is used, <code>enableTransitEncryption</code> must be <code>true</code>.
     * <p>
     * Default: - no accessPointId
     * <p>
     * @see <a href="https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html">https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAccessPointId() {
        return null;
    }

    /**
     * Enables encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/efs/latest/ug/encryption-in-transit.html">https://docs.aws.amazon.com/efs/latest/ug/encryption-in-transit.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableTransitEncryption() {
        return null;
    }

    /**
     * The directory within the Amazon EFS file system to mount as the root directory inside the host.
     * <p>
     * If this parameter is omitted, the root of the Amazon EFS volume is used instead.
     * Specifying <code>/</code> has the same effect as omitting this parameter.
     * The maximum length is 4,096 characters.
     * <p>
     * Default: - root of the EFS File System
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRootDirectory() {
        return null;
    }

    /**
     * The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server.
     * <p>
     * The value must be between 0 and 65,535.
     * <p>
     * Default: - chosen by the EFS Mount Helper
     * <p>
     * @see <a href="https://docs.aws.amazon.com/efs/latest/ug/efs-mount-helper.html">https://docs.aws.amazon.com/efs/latest/ug/efs-mount-helper.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getTransitEncryptionPort() {
        return null;
    }

    /**
     * Whether or not to use the AWS Batch job IAM role defined in a job definition when mounting the Amazon EFS file system.
     * <p>
     * If specified, <code>enableTransitEncryption</code> must be <code>true</code>.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/efs-volumes.html#efs-volume-accesspoints">https://docs.aws.amazon.com/batch/latest/userguide/efs-volumes.html#efs-volume-accesspoints</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUseJobRole() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EfsVolumeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EfsVolumeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EfsVolumeOptions> {
        software.amazon.awscdk.services.efs.IFileSystem fileSystem;
        java.lang.String accessPointId;
        java.lang.Boolean enableTransitEncryption;
        java.lang.String rootDirectory;
        java.lang.Number transitEncryptionPort;
        java.lang.Boolean useJobRole;
        java.lang.String containerPath;
        java.lang.String name;
        java.lang.Boolean readonly;

        /**
         * Sets the value of {@link EfsVolumeOptions#getFileSystem}
         * @param fileSystem The EFS File System that supports this volume. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystem(software.amazon.awscdk.services.efs.IFileSystem fileSystem) {
            this.fileSystem = fileSystem;
            return this;
        }

        /**
         * Sets the value of {@link EfsVolumeOptions#getAccessPointId}
         * @param accessPointId The Amazon EFS access point ID to use.
         *                      If an access point is specified, <code>rootDirectory</code> must either be omitted or set to <code>/</code>
         *                      which enforces the path set on the EFS access point.
         *                      If an access point is used, <code>enableTransitEncryption</code> must be <code>true</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessPointId(java.lang.String accessPointId) {
            this.accessPointId = accessPointId;
            return this;
        }

        /**
         * Sets the value of {@link EfsVolumeOptions#getEnableTransitEncryption}
         * @param enableTransitEncryption Enables encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableTransitEncryption(java.lang.Boolean enableTransitEncryption) {
            this.enableTransitEncryption = enableTransitEncryption;
            return this;
        }

        /**
         * Sets the value of {@link EfsVolumeOptions#getRootDirectory}
         * @param rootDirectory The directory within the Amazon EFS file system to mount as the root directory inside the host.
         *                      If this parameter is omitted, the root of the Amazon EFS volume is used instead.
         *                      Specifying <code>/</code> has the same effect as omitting this parameter.
         *                      The maximum length is 4,096 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rootDirectory(java.lang.String rootDirectory) {
            this.rootDirectory = rootDirectory;
            return this;
        }

        /**
         * Sets the value of {@link EfsVolumeOptions#getTransitEncryptionPort}
         * @param transitEncryptionPort The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server.
         *                              The value must be between 0 and 65,535.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitEncryptionPort(java.lang.Number transitEncryptionPort) {
            this.transitEncryptionPort = transitEncryptionPort;
            return this;
        }

        /**
         * Sets the value of {@link EfsVolumeOptions#getUseJobRole}
         * @param useJobRole Whether or not to use the AWS Batch job IAM role defined in a job definition when mounting the Amazon EFS file system.
         *                   If specified, <code>enableTransitEncryption</code> must be <code>true</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useJobRole(java.lang.Boolean useJobRole) {
            this.useJobRole = useJobRole;
            return this;
        }

        /**
         * Sets the value of {@link EfsVolumeOptions#getContainerPath}
         * @param containerPath the path on the container where this volume is mounted. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerPath(java.lang.String containerPath) {
            this.containerPath = containerPath;
            return this;
        }

        /**
         * Sets the value of {@link EfsVolumeOptions#getName}
         * @param name the name of this volume. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link EfsVolumeOptions#getReadonly}
         * @param readonly if set, the container will have readonly access to the volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readonly(java.lang.Boolean readonly) {
            this.readonly = readonly;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EfsVolumeOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EfsVolumeOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EfsVolumeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EfsVolumeOptions {
        private final software.amazon.awscdk.services.efs.IFileSystem fileSystem;
        private final java.lang.String accessPointId;
        private final java.lang.Boolean enableTransitEncryption;
        private final java.lang.String rootDirectory;
        private final java.lang.Number transitEncryptionPort;
        private final java.lang.Boolean useJobRole;
        private final java.lang.String containerPath;
        private final java.lang.String name;
        private final java.lang.Boolean readonly;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.fileSystem = software.amazon.jsii.Kernel.get(this, "fileSystem", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.IFileSystem.class));
            this.accessPointId = software.amazon.jsii.Kernel.get(this, "accessPointId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enableTransitEncryption = software.amazon.jsii.Kernel.get(this, "enableTransitEncryption", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.rootDirectory = software.amazon.jsii.Kernel.get(this, "rootDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.transitEncryptionPort = software.amazon.jsii.Kernel.get(this, "transitEncryptionPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.useJobRole = software.amazon.jsii.Kernel.get(this, "useJobRole", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.containerPath = software.amazon.jsii.Kernel.get(this, "containerPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.readonly = software.amazon.jsii.Kernel.get(this, "readonly", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.fileSystem = java.util.Objects.requireNonNull(builder.fileSystem, "fileSystem is required");
            this.accessPointId = builder.accessPointId;
            this.enableTransitEncryption = builder.enableTransitEncryption;
            this.rootDirectory = builder.rootDirectory;
            this.transitEncryptionPort = builder.transitEncryptionPort;
            this.useJobRole = builder.useJobRole;
            this.containerPath = java.util.Objects.requireNonNull(builder.containerPath, "containerPath is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.readonly = builder.readonly;
        }

        @Override
        public final software.amazon.awscdk.services.efs.IFileSystem getFileSystem() {
            return this.fileSystem;
        }

        @Override
        public final java.lang.String getAccessPointId() {
            return this.accessPointId;
        }

        @Override
        public final java.lang.Boolean getEnableTransitEncryption() {
            return this.enableTransitEncryption;
        }

        @Override
        public final java.lang.String getRootDirectory() {
            return this.rootDirectory;
        }

        @Override
        public final java.lang.Number getTransitEncryptionPort() {
            return this.transitEncryptionPort;
        }

        @Override
        public final java.lang.Boolean getUseJobRole() {
            return this.useJobRole;
        }

        @Override
        public final java.lang.String getContainerPath() {
            return this.containerPath;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Boolean getReadonly() {
            return this.readonly;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("fileSystem", om.valueToTree(this.getFileSystem()));
            if (this.getAccessPointId() != null) {
                data.set("accessPointId", om.valueToTree(this.getAccessPointId()));
            }
            if (this.getEnableTransitEncryption() != null) {
                data.set("enableTransitEncryption", om.valueToTree(this.getEnableTransitEncryption()));
            }
            if (this.getRootDirectory() != null) {
                data.set("rootDirectory", om.valueToTree(this.getRootDirectory()));
            }
            if (this.getTransitEncryptionPort() != null) {
                data.set("transitEncryptionPort", om.valueToTree(this.getTransitEncryptionPort()));
            }
            if (this.getUseJobRole() != null) {
                data.set("useJobRole", om.valueToTree(this.getUseJobRole()));
            }
            data.set("containerPath", om.valueToTree(this.getContainerPath()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getReadonly() != null) {
                data.set("readonly", om.valueToTree(this.getReadonly()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.EfsVolumeOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EfsVolumeOptions.Jsii$Proxy that = (EfsVolumeOptions.Jsii$Proxy) o;

            if (!fileSystem.equals(that.fileSystem)) return false;
            if (this.accessPointId != null ? !this.accessPointId.equals(that.accessPointId) : that.accessPointId != null) return false;
            if (this.enableTransitEncryption != null ? !this.enableTransitEncryption.equals(that.enableTransitEncryption) : that.enableTransitEncryption != null) return false;
            if (this.rootDirectory != null ? !this.rootDirectory.equals(that.rootDirectory) : that.rootDirectory != null) return false;
            if (this.transitEncryptionPort != null ? !this.transitEncryptionPort.equals(that.transitEncryptionPort) : that.transitEncryptionPort != null) return false;
            if (this.useJobRole != null ? !this.useJobRole.equals(that.useJobRole) : that.useJobRole != null) return false;
            if (!containerPath.equals(that.containerPath)) return false;
            if (!name.equals(that.name)) return false;
            return this.readonly != null ? this.readonly.equals(that.readonly) : that.readonly == null;
        }

        @Override
        public final int hashCode() {
            int result = this.fileSystem.hashCode();
            result = 31 * result + (this.accessPointId != null ? this.accessPointId.hashCode() : 0);
            result = 31 * result + (this.enableTransitEncryption != null ? this.enableTransitEncryption.hashCode() : 0);
            result = 31 * result + (this.rootDirectory != null ? this.rootDirectory.hashCode() : 0);
            result = 31 * result + (this.transitEncryptionPort != null ? this.transitEncryptionPort.hashCode() : 0);
            result = 31 * result + (this.useJobRole != null ? this.useJobRole.hashCode() : 0);
            result = 31 * result + (this.containerPath.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.readonly != null ? this.readonly.hashCode() : 0);
            return result;
        }
    }
}
