package software.amazon.awscdk.services.batch;

/**
 * Options for configuring an ECS HostVolume.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.batch.*;
 * HostVolumeOptions hostVolumeOptions = HostVolumeOptions.builder()
 *         .containerPath("containerPath")
 *         .name("name")
 *         // the properties below are optional
 *         .hostPath("hostPath")
 *         .readonly(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:13.470Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.HostVolumeOptions")
@software.amazon.jsii.Jsii.Proxy(HostVolumeOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HostVolumeOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.batch.EcsVolumeOptions {

    /**
     * The path on the host machine this container will have access to.
     * <p>
     * Default: - Docker will choose the host path.
     * The data may not persist after the containers that use it stop running.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHostPath() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HostVolumeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HostVolumeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HostVolumeOptions> {
        java.lang.String hostPath;
        java.lang.String containerPath;
        java.lang.String name;
        java.lang.Boolean readonly;

        /**
         * Sets the value of {@link HostVolumeOptions#getHostPath}
         * @param hostPath The path on the host machine this container will have access to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostPath(java.lang.String hostPath) {
            this.hostPath = hostPath;
            return this;
        }

        /**
         * Sets the value of {@link HostVolumeOptions#getContainerPath}
         * @param containerPath the path on the container where this volume is mounted. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerPath(java.lang.String containerPath) {
            this.containerPath = containerPath;
            return this;
        }

        /**
         * Sets the value of {@link HostVolumeOptions#getName}
         * @param name the name of this volume. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link HostVolumeOptions#getReadonly}
         * @param readonly if set, the container will have readonly access to the volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readonly(java.lang.Boolean readonly) {
            this.readonly = readonly;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HostVolumeOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HostVolumeOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HostVolumeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HostVolumeOptions {
        private final java.lang.String hostPath;
        private final java.lang.String containerPath;
        private final java.lang.String name;
        private final java.lang.Boolean readonly;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.hostPath = software.amazon.jsii.Kernel.get(this, "hostPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.containerPath = software.amazon.jsii.Kernel.get(this, "containerPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.readonly = software.amazon.jsii.Kernel.get(this, "readonly", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.hostPath = builder.hostPath;
            this.containerPath = java.util.Objects.requireNonNull(builder.containerPath, "containerPath is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.readonly = builder.readonly;
        }

        @Override
        public final java.lang.String getHostPath() {
            return this.hostPath;
        }

        @Override
        public final java.lang.String getContainerPath() {
            return this.containerPath;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Boolean getReadonly() {
            return this.readonly;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getHostPath() != null) {
                data.set("hostPath", om.valueToTree(this.getHostPath()));
            }
            data.set("containerPath", om.valueToTree(this.getContainerPath()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getReadonly() != null) {
                data.set("readonly", om.valueToTree(this.getReadonly()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.HostVolumeOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HostVolumeOptions.Jsii$Proxy that = (HostVolumeOptions.Jsii$Proxy) o;

            if (this.hostPath != null ? !this.hostPath.equals(that.hostPath) : that.hostPath != null) return false;
            if (!containerPath.equals(that.containerPath)) return false;
            if (!name.equals(that.name)) return false;
            return this.readonly != null ? this.readonly.equals(that.readonly) : that.readonly == null;
        }

        @Override
        public final int hashCode() {
            int result = this.hostPath != null ? this.hostPath.hashCode() : 0;
            result = 31 * result + (this.containerPath.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.readonly != null ? this.readonly.hashCode() : 0);
            return result;
        }
    }
}
