package software.amazon.awscdk.services.batch;

/**
 * Props to configure a JobQueue.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IVpc vpc;
 * EcsJobDefinition ecsJob = EcsJobDefinition.Builder.create(this, "JobDefn")
 *         .container(EcsEc2ContainerDefinition.Builder.create(this, "containerDefn")
 *                 .image(ContainerImage.fromRegistry("public.ecr.aws/amazonlinux/amazonlinux:latest"))
 *                 .memory(Size.mebibytes(2048))
 *                 .cpu(256)
 *                 .build())
 *         .build();
 * JobQueue queue = JobQueue.Builder.create(this, "JobQueue")
 *         .computeEnvironments(List.of(OrderedComputeEnvironment.builder()
 *                 .computeEnvironment(ManagedEc2EcsComputeEnvironment.Builder.create(this, "managedEc2CE")
 *                         .vpc(vpc)
 *                         .build())
 *                 .order(1)
 *                 .build()))
 *         .priority(10)
 *         .build();
 * User user = new User(this, "MyUser");
 * ecsJob.grantSubmitJob(user, queue);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:13.501Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.JobQueueProps")
@software.amazon.jsii.Jsii.Proxy(JobQueueProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface JobQueueProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The set of compute environments mapped to a job queue and their order relative to each other.
     * <p>
     * The job scheduler uses this parameter to determine which compute environment runs a specific job.
     * Compute environments must be in the VALID state before you can associate them with a job queue.
     * You can associate up to three compute environments with a job queue.
     * All of the compute environments must be either EC2 (EC2 or SPOT) or Fargate (FARGATE or FARGATE_SPOT);
     * EC2 and Fargate compute environments can't be mixed.
     * <p>
     * <em>Note</em>: All compute environments that are associated with a job queue must share the same architecture.
     * AWS Batch doesn't support mixing compute environment architecture types in a single job queue.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.batch.OrderedComputeEnvironment> getComputeEnvironments() {
        return null;
    }

    /**
     * If the job queue is enabled, it is able to accept jobs.
     * <p>
     * Otherwise, new jobs can't be added to the queue, but jobs already in the queue can finish.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnabled() {
        return null;
    }

    /**
     * The name of the job queue.
     * <p>
     * It can be up to 128 letters long.
     * It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_)
     * <p>
     * Default: - no name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getJobQueueName() {
        return null;
    }

    /**
     * The set of actions that AWS Batch perform on jobs that remain at the head of the job queue in the specified state longer than specified times.
     * <p>
     * Default: - no actions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.batch.JobStateTimeLimitAction> getJobStateTimeLimitActions() {
        return null;
    }

    /**
     * The priority of the job queue.
     * <p>
     * Job queues with a higher priority are evaluated first when associated with the same compute environment.
     * Priority is determined in descending order.
     * For example, a job queue with a priority of 10 is given scheduling preference over a job queue with a priority of 1.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
        return null;
    }

    /**
     * The SchedulingPolicy for this JobQueue.
     * <p>
     * Instructs the Scheduler how to schedule different jobs.
     * <p>
     * Default: - no scheduling policy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.ISchedulingPolicy getSchedulingPolicy() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link JobQueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link JobQueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<JobQueueProps> {
        java.util.List<software.amazon.awscdk.services.batch.OrderedComputeEnvironment> computeEnvironments;
        java.lang.Boolean enabled;
        java.lang.String jobQueueName;
        java.util.List<software.amazon.awscdk.services.batch.JobStateTimeLimitAction> jobStateTimeLimitActions;
        java.lang.Number priority;
        software.amazon.awscdk.services.batch.ISchedulingPolicy schedulingPolicy;

        /**
         * Sets the value of {@link JobQueueProps#getComputeEnvironments}
         * @param computeEnvironments The set of compute environments mapped to a job queue and their order relative to each other.
         *                            The job scheduler uses this parameter to determine which compute environment runs a specific job.
         *                            Compute environments must be in the VALID state before you can associate them with a job queue.
         *                            You can associate up to three compute environments with a job queue.
         *                            All of the compute environments must be either EC2 (EC2 or SPOT) or Fargate (FARGATE or FARGATE_SPOT);
         *                            EC2 and Fargate compute environments can't be mixed.
         *                            <p>
         *                            <em>Note</em>: All compute environments that are associated with a job queue must share the same architecture.
         *                            AWS Batch doesn't support mixing compute environment architecture types in a single job queue.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder computeEnvironments(java.util.List<? extends software.amazon.awscdk.services.batch.OrderedComputeEnvironment> computeEnvironments) {
            this.computeEnvironments = (java.util.List<software.amazon.awscdk.services.batch.OrderedComputeEnvironment>)computeEnvironments;
            return this;
        }

        /**
         * Sets the value of {@link JobQueueProps#getEnabled}
         * @param enabled If the job queue is enabled, it is able to accept jobs.
         *                Otherwise, new jobs can't be added to the queue, but jobs already in the queue can finish.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link JobQueueProps#getJobQueueName}
         * @param jobQueueName The name of the job queue.
         *                     It can be up to 128 letters long.
         *                     It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobQueueName(java.lang.String jobQueueName) {
            this.jobQueueName = jobQueueName;
            return this;
        }

        /**
         * Sets the value of {@link JobQueueProps#getJobStateTimeLimitActions}
         * @param jobStateTimeLimitActions The set of actions that AWS Batch perform on jobs that remain at the head of the job queue in the specified state longer than specified times.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder jobStateTimeLimitActions(java.util.List<? extends software.amazon.awscdk.services.batch.JobStateTimeLimitAction> jobStateTimeLimitActions) {
            this.jobStateTimeLimitActions = (java.util.List<software.amazon.awscdk.services.batch.JobStateTimeLimitAction>)jobStateTimeLimitActions;
            return this;
        }

        /**
         * Sets the value of {@link JobQueueProps#getPriority}
         * @param priority The priority of the job queue.
         *                 Job queues with a higher priority are evaluated first when associated with the same compute environment.
         *                 Priority is determined in descending order.
         *                 For example, a job queue with a priority of 10 is given scheduling preference over a job queue with a priority of 1.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Sets the value of {@link JobQueueProps#getSchedulingPolicy}
         * @param schedulingPolicy The SchedulingPolicy for this JobQueue.
         *                         Instructs the Scheduler how to schedule different jobs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedulingPolicy(software.amazon.awscdk.services.batch.ISchedulingPolicy schedulingPolicy) {
            this.schedulingPolicy = schedulingPolicy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link JobQueueProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public JobQueueProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link JobQueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JobQueueProps {
        private final java.util.List<software.amazon.awscdk.services.batch.OrderedComputeEnvironment> computeEnvironments;
        private final java.lang.Boolean enabled;
        private final java.lang.String jobQueueName;
        private final java.util.List<software.amazon.awscdk.services.batch.JobStateTimeLimitAction> jobStateTimeLimitActions;
        private final java.lang.Number priority;
        private final software.amazon.awscdk.services.batch.ISchedulingPolicy schedulingPolicy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.computeEnvironments = software.amazon.jsii.Kernel.get(this, "computeEnvironments", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.OrderedComputeEnvironment.class)));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.jobQueueName = software.amazon.jsii.Kernel.get(this, "jobQueueName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.jobStateTimeLimitActions = software.amazon.jsii.Kernel.get(this, "jobStateTimeLimitActions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.JobStateTimeLimitAction.class)));
            this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.schedulingPolicy = software.amazon.jsii.Kernel.get(this, "schedulingPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.ISchedulingPolicy.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.computeEnvironments = (java.util.List<software.amazon.awscdk.services.batch.OrderedComputeEnvironment>)builder.computeEnvironments;
            this.enabled = builder.enabled;
            this.jobQueueName = builder.jobQueueName;
            this.jobStateTimeLimitActions = (java.util.List<software.amazon.awscdk.services.batch.JobStateTimeLimitAction>)builder.jobStateTimeLimitActions;
            this.priority = builder.priority;
            this.schedulingPolicy = builder.schedulingPolicy;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.batch.OrderedComputeEnvironment> getComputeEnvironments() {
            return this.computeEnvironments;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.lang.String getJobQueueName() {
            return this.jobQueueName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.batch.JobStateTimeLimitAction> getJobStateTimeLimitActions() {
            return this.jobStateTimeLimitActions;
        }

        @Override
        public final java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        public final software.amazon.awscdk.services.batch.ISchedulingPolicy getSchedulingPolicy() {
            return this.schedulingPolicy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getComputeEnvironments() != null) {
                data.set("computeEnvironments", om.valueToTree(this.getComputeEnvironments()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getJobQueueName() != null) {
                data.set("jobQueueName", om.valueToTree(this.getJobQueueName()));
            }
            if (this.getJobStateTimeLimitActions() != null) {
                data.set("jobStateTimeLimitActions", om.valueToTree(this.getJobStateTimeLimitActions()));
            }
            if (this.getPriority() != null) {
                data.set("priority", om.valueToTree(this.getPriority()));
            }
            if (this.getSchedulingPolicy() != null) {
                data.set("schedulingPolicy", om.valueToTree(this.getSchedulingPolicy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.JobQueueProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            JobQueueProps.Jsii$Proxy that = (JobQueueProps.Jsii$Proxy) o;

            if (this.computeEnvironments != null ? !this.computeEnvironments.equals(that.computeEnvironments) : that.computeEnvironments != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.jobQueueName != null ? !this.jobQueueName.equals(that.jobQueueName) : that.jobQueueName != null) return false;
            if (this.jobStateTimeLimitActions != null ? !this.jobStateTimeLimitActions.equals(that.jobStateTimeLimitActions) : that.jobStateTimeLimitActions != null) return false;
            if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) return false;
            return this.schedulingPolicy != null ? this.schedulingPolicy.equals(that.schedulingPolicy) : that.schedulingPolicy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.computeEnvironments != null ? this.computeEnvironments.hashCode() : 0;
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.jobQueueName != null ? this.jobQueueName.hashCode() : 0);
            result = 31 * result + (this.jobStateTimeLimitActions != null ? this.jobStateTimeLimitActions.hashCode() : 0);
            result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
            result = 31 * result + (this.schedulingPolicy != null ? this.schedulingPolicy.hashCode() : 0);
            return result;
        }
    }
}
